/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SuspiciousLiteralUnderscoreInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("suspicious.literal.underscore.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/SuspiciousLiteralUnderscoreInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("suspicious.literal.underscore.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/SuspiciousLiteralUnderscoreInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SuspiciousLiteralUnderscoreVisitor();
    }

    private static class SuspiciousLiteralUnderscoreVisitor
    extends BaseInspectionVisitor {
        private SuspiciousLiteralUnderscoreVisitor() {
        }

        @Override
        public void visitLiteralExpression(PsiLiteralExpression expression) {
            super.visitLiteralExpression(expression);
            PsiType type = expression.getType();
            if (!(PsiType.SHORT.equals(type) || PsiType.INT.equals(type) || PsiType.LONG.equals(type) || PsiType.FLOAT.equals(type) || PsiType.DOUBLE.equals(type))) {
                return;
            }
            String text = expression.getText();
            if (text.startsWith("0") && !text.startsWith("0.")) {
                return;
            }
            if (!text.contains("_")) {
                return;
            }
            boolean underscore = false;
            boolean group = false;
            boolean dot = false;
            int digit = 0;
            int index = StringUtil.indexOfAny(text, "fledFLED");
            int length = index > 0 ? index : text.length();
            for (int i2 = 0; i2 < length; ++i2) {
                char c = text.charAt(i2);
                if (c == '_' || c == '.') {
                    if (underscore) {
                        return;
                    }
                    underscore = true;
                    if (digit != 3 && group || digit > 3) {
                        this.registerErrorAtOffset((PsiElement)expression, i2 - digit, digit, new Object[0]);
                    }
                    group = true;
                    digit = 0;
                    if (c != '.') continue;
                    dot = true;
                    continue;
                }
                if (Character.isDigit(c)) {
                    underscore = false;
                    ++digit;
                    continue;
                }
                return;
            }
            if (dot ? digit > 3 : digit != 3) {
                this.registerErrorAtOffset((PsiElement)expression, length - digit, digit, new Object[0]);
            }
        }
    }
}

