/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionalIsPresentInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance("#" + OptionalIsPresentInspection.class.getName());
    private static final OptionalIfPresentCase[] CASES = new OptionalIfPresentCase[]{new ReturnCase(), new AssignmentCase(), new ConsumerCase()};

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/OptionalIsPresentInspection", "buildVisitor"));
        }
        if (!PsiUtil.isLanguageLevel8OrHigher(holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/OptionalIsPresentInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitIfStatement(PsiIfStatement statement) {
                PsiVariable optionalVariable;
                super.visitIfStatement(statement);
                PsiExpression condition = PsiUtil.skipParenthesizedExprDown(statement.getCondition());
                if (condition == null) {
                    return;
                }
                boolean invert = false;
                PsiExpression strippedCondition = condition;
                if (BoolUtils.isNegation(condition)) {
                    strippedCondition = BoolUtils.getNegated(condition);
                    invert = true;
                }
                if ((optionalVariable = OptionalIsPresentInspection.extractOptionalFromIfPresentCheck(strippedCondition)) == null) {
                    return;
                }
                PsiStatement thenStatement = OptionalIsPresentInspection.extractThenStatement(statement, invert);
                PsiStatement elseStatement = OptionalIsPresentInspection.extractElseStatement(statement, invert);
                for (OptionalIfPresentCase scenario : CASES) {
                    String replacementName = scenario.getReplacementName(optionalVariable, thenStatement, elseStatement);
                    if (replacementName == null) continue;
                    holder.registerProblem((PsiElement)condition, "Can be replaced with " + replacementName, new OptionalIfPresentFix(scenario, replacementName));
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/OptionalIsPresentInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static boolean isRaw(PsiVariable variable) {
        PsiType type = variable.getType();
        return type instanceof PsiClassType && ((PsiClassType)type).isRaw();
    }

    @Nullable
    private static PsiStatement extractThenStatement(PsiIfStatement ifStatement, boolean invert) {
        if (invert) {
            return OptionalIsPresentInspection.extractElseStatement(ifStatement, false);
        }
        return ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
    }

    private static PsiStatement extractElseStatement(PsiIfStatement ifStatement, boolean invert) {
        PsiElement nextElement;
        PsiStatement thenStatement;
        if (invert) {
            return OptionalIsPresentInspection.extractThenStatement(ifStatement, false);
        }
        PsiStatement statement = ControlFlowUtils.stripBraces(ifStatement.getElseBranch());
        if (statement == null && (thenStatement = OptionalIsPresentInspection.extractThenStatement(ifStatement, false)) instanceof PsiReturnStatement && (nextElement = PsiTreeUtil.skipSiblingsForward(ifStatement, PsiComment.class, PsiWhiteSpace.class)) instanceof PsiStatement) {
            statement = ControlFlowUtils.stripBraces((PsiStatement)nextElement);
        }
        return statement;
    }

    @Contract(value="null -> null")
    static PsiVariable extractOptionalFromIfPresentCheck(PsiExpression expression) {
        if (!(expression instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
        if (call.getArgumentList().getExpressions().length != 0) {
            return null;
        }
        if (!"isPresent".equals(call.getMethodExpression().getReferenceName())) {
            return null;
        }
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null || !"java.util.Optional".equals(containingClass.getQualifiedName())) {
            return null;
        }
        PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
        if (!(qualifier instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement element = ((PsiReferenceExpression)qualifier).resolve();
        if (!(element instanceof PsiVariable) || OptionalIsPresentInspection.isRaw((PsiVariable)element)) {
            return null;
        }
        return (PsiVariable)element;
    }

    @Contract(value="null, _ -> false")
    static boolean isOptionalGetCall(PsiElement element, PsiVariable variable) {
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)element;
        if (call.getArgumentList().getExpressions().length != 0) {
            return false;
        }
        if (!"get".equals(call.getMethodExpression().getReferenceName())) {
            return false;
        }
        PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
        if (!(qualifier instanceof PsiReferenceExpression)) {
            return false;
        }
        return ((PsiReferenceExpression)qualifier).resolve() == variable;
    }

    @Contract(value="null, _ -> false")
    static boolean isOptionalLambdaCandidate(PsiExpression lambdaCandidate, PsiVariable optionalVariable) {
        if (lambdaCandidate == null) {
            return false;
        }
        if (!ExceptionUtil.getThrownCheckedExceptions(lambdaCandidate).isEmpty()) {
            return false;
        }
        return PsiTreeUtil.processElements(lambdaCandidate, e -> {
            if (!(e instanceof PsiReferenceExpression)) {
                return true;
            }
            PsiElement element = ((PsiReferenceExpression)e).resolve();
            if (!(element instanceof PsiVariable)) {
                return true;
            }
            return element == optionalVariable ? OptionalIsPresentInspection.isOptionalGetCall(e.getParent().getParent(), optionalVariable) : HighlightControlFlowUtil.isEffectivelyFinal((PsiVariable)element, lambdaCandidate, null);
        });
    }

    @NotNull
    static String generateMapIfNeeded(PsiElementFactory factory, PsiVariable optionalVariable, PsiExpression trueValue) {
        String name = optionalVariable.getName();
        LOG.assertTrue(name != null);
        if (OptionalIsPresentInspection.isOptionalGetCall(trueValue, optionalVariable)) {
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/OptionalIsPresentInspection", "generateMapIfNeeded"));
            }
            return string;
        }
        String string = name + ".map(" + OptionalIsPresentInspection.generateOptionalLambda(factory, optionalVariable, trueValue) + ")";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/OptionalIsPresentInspection", "generateMapIfNeeded"));
        }
        return string;
    }

    @NotNull
    static String generateOptionalLambda(PsiElementFactory factory, PsiVariable optionalVariable, PsiExpression trueValue) {
        PsiType type = optionalVariable.getType();
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance(trueValue.getProject());
        SuggestedNameInfo info = javaCodeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, null, type);
        if (info.names.length == 0) {
            info = javaCodeStyleManager.suggestVariableName(VariableKind.PARAMETER, "value", null, type);
        }
        String paramName = javaCodeStyleManager.suggestUniqueVariableName((SuggestedNameInfo)info, (PsiElement)trueValue, (boolean)true).names[0];
        PsiElement copy = trueValue.copy();
        for (PsiElement getCall : PsiTreeUtil.collectElements(copy, e -> OptionalIsPresentInspection.isOptionalGetCall(e, optionalVariable))) {
            getCall.replace(factory.createIdentifier(paramName));
        }
        String string = paramName + "->" + copy.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/OptionalIsPresentInspection", "generateOptionalLambda"));
        }
        return string;
    }

    static class ConsumerCase
    implements OptionalIfPresentCase {
        ConsumerCase() {
        }

        @Override
        public String getReplacementName(PsiVariable optionalVariable, PsiStatement trueStatement, PsiStatement falseStatement) {
            if (falseStatement != null && !(falseStatement instanceof PsiEmptyStatement)) {
                return null;
            }
            if (!(trueStatement instanceof PsiExpressionStatement)) {
                return null;
            }
            PsiExpression expression = ((PsiExpressionStatement)trueStatement).getExpression();
            if (!OptionalIsPresentInspection.isOptionalLambdaCandidate(expression, optionalVariable)) {
                return null;
            }
            return "ifPresent()";
        }

        @Override
        public String generateReplacement(PsiElementFactory factory, PsiVariable optionalVariable, PsiStatement trueStatement, PsiStatement falseStatement) {
            PsiExpression expression = ((PsiExpressionStatement)trueStatement).getExpression();
            return optionalVariable.getName() + ".ifPresent(" + OptionalIsPresentInspection.generateOptionalLambda(factory, optionalVariable, expression) + ");";
        }
    }

    static class AssignmentCase
    implements OptionalIfPresentCase {
        AssignmentCase() {
        }

        @Override
        public String getReplacementName(PsiVariable optionalVariable, PsiStatement trueStatement, PsiStatement falseStatement) {
            String mapPart;
            PsiAssignmentExpression trueAssignment = ExpressionUtils.getAssignment(trueStatement);
            PsiAssignmentExpression falseAssignment = ExpressionUtils.getAssignment(falseStatement);
            if (trueAssignment == null || falseAssignment == null || !EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(trueAssignment.getLExpression(), falseAssignment.getLExpression()) || !OptionalIsPresentInspection.isOptionalLambdaCandidate(trueAssignment.getRExpression(), optionalVariable)) {
                return null;
            }
            String string = mapPart = OptionalIsPresentInspection.isOptionalGetCall(trueAssignment.getRExpression(), optionalVariable) ? "" : "map().";
            if (ExpressionUtils.isSimpleExpression(falseAssignment.getRExpression())) {
                return mapPart + "orElse()";
            }
            if (LambdaGenerationUtil.canBeUncheckedLambda(falseAssignment.getRExpression())) {
                return mapPart + "orElseGet()";
            }
            return null;
        }

        @Override
        public String generateReplacement(PsiElementFactory factory, PsiVariable optionalVariable, PsiStatement trueStatement, PsiStatement falseStatement) {
            PsiAssignmentExpression trueAssignment = ExpressionUtils.getAssignment(trueStatement);
            PsiAssignmentExpression falseAssignment = ExpressionUtils.getAssignment(falseStatement);
            LOG.assertTrue(trueAssignment != null);
            LOG.assertTrue(falseAssignment != null);
            PsiExpression lValue = trueAssignment.getLExpression();
            PsiExpression trueValue = trueAssignment.getRExpression();
            PsiExpression falseValue = falseAssignment.getRExpression();
            LOG.assertTrue(falseValue != null);
            String trueBranch = OptionalIsPresentInspection.generateMapIfNeeded(factory, optionalVariable, trueValue);
            String falseBranch = ExpressionUtils.isSimpleExpression(falseValue) ? "orElse(" + falseValue.getText() + ")" : "orElseGet(() -> " + falseValue.getText() + ")";
            return lValue.getText() + " = " + trueBranch + "." + falseBranch + ";";
        }
    }

    static class ReturnCase
    implements OptionalIfPresentCase {
        ReturnCase() {
        }

        @Override
        public String getReplacementName(PsiVariable optionalVariable, PsiStatement trueStatement, PsiStatement falseStatement) {
            if (!(trueStatement instanceof PsiReturnStatement) || !(falseStatement instanceof PsiReturnStatement)) {
                return null;
            }
            PsiExpression falseValue = ((PsiReturnStatement)falseStatement).getReturnValue();
            if (!ExpressionUtils.isSimpleExpression(falseValue)) {
                return null;
            }
            PsiExpression trueValue = ((PsiReturnStatement)trueStatement).getReturnValue();
            if (!OptionalIsPresentInspection.isOptionalLambdaCandidate(trueValue, optionalVariable)) {
                return null;
            }
            return OptionalIsPresentInspection.isOptionalGetCall(trueValue, optionalVariable) ? "orElse()" : "map().orElse()";
        }

        @Override
        public String generateReplacement(PsiElementFactory factory, PsiVariable optionalVariable, PsiStatement trueStatement, PsiStatement falseStatement) {
            PsiExpression trueValue = ((PsiReturnStatement)trueStatement).getReturnValue();
            PsiExpression falseValue = ((PsiReturnStatement)falseStatement).getReturnValue();
            LOG.assertTrue(trueValue != null);
            LOG.assertTrue(falseValue != null);
            String trueBranch = OptionalIsPresentInspection.generateMapIfNeeded(factory, optionalVariable, trueValue);
            return "return " + trueBranch + ".orElse(" + falseValue.getText() + ");";
        }
    }

    static interface OptionalIfPresentCase {
        public String getReplacementName(PsiVariable var1, PsiStatement var2, PsiStatement var3);

        default public boolean isApplicable(PsiVariable optionalVariable, PsiStatement trueStatement, PsiStatement falseStatement) {
            return this.getReplacementName(optionalVariable, trueStatement, falseStatement) != null;
        }

        public String generateReplacement(PsiElementFactory var1, PsiVariable var2, PsiStatement var3, PsiStatement var4);
    }

    static class OptionalIfPresentFix
    implements LocalQuickFix {
        private final OptionalIfPresentCase myScenario;
        private final String myReplacementName;

        public OptionalIfPresentFix(OptionalIfPresentCase scenario, String replacementName) {
            this.myScenario = scenario;
            this.myReplacementName = replacementName;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = "Replace Optional.isPresent() condition with " + this.myReplacementName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/OptionalIsPresentInspection$OptionalIfPresentFix", "getName"));
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace Optional.isPresent() condition with functional style expression" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/OptionalIsPresentInspection$OptionalIfPresentFix", "getFamilyName"));
            }
            return "Replace Optional.isPresent() condition with functional style expression";
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiStatement elseStatement;
            PsiVariable optionalVariable;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/OptionalIsPresentInspection$OptionalIfPresentFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/OptionalIsPresentInspection$OptionalIfPresentFix", "applyFix"));
            }
            PsiElement element = descriptor.getStartElement();
            if (!(element instanceof PsiExpression)) {
                return;
            }
            PsiIfStatement statement = PsiTreeUtil.getParentOfType(element, PsiIfStatement.class);
            if (statement == null) {
                return;
            }
            PsiExpression condition = (PsiExpression)element;
            boolean invert = false;
            if (BoolUtils.isNegation(condition)) {
                condition = BoolUtils.getNegated(condition);
                invert = true;
            }
            if ((optionalVariable = OptionalIsPresentInspection.extractOptionalFromIfPresentCheck(condition)) == null) {
                return;
            }
            PsiStatement thenStatement = OptionalIsPresentInspection.extractThenStatement(statement, invert);
            if (!this.myScenario.isApplicable(optionalVariable, thenStatement, elseStatement = OptionalIsPresentInspection.extractElseStatement(statement, invert))) {
                return;
            }
            if (!FileModificationService.getInstance().preparePsiElementForWrite(element.getContainingFile())) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(project);
            PsiElement parent = statement.getParent();
            ((StreamEx)((StreamEx)StreamEx.of((Object[])new PsiStatement[]{statement, thenStatement, elseStatement}).nonNull()).flatCollection(st -> PsiTreeUtil.findChildrenOfType(st, PsiComment.class)).distinct()).forEach(comment -> {
                parent.addBefore((PsiElement)comment, statement);
                comment.delete();
            });
            String replacement = this.myScenario.generateReplacement(factory, optionalVariable, thenStatement, elseStatement);
            if (thenStatement != null && !PsiTreeUtil.isAncestor(statement, thenStatement, true)) {
                thenStatement.delete();
            }
            if (elseStatement != null && !PsiTreeUtil.isAncestor(statement, elseStatement, true)) {
                elseStatement.delete();
            }
            PsiElement result = statement.replace(factory.createStatementFromText(replacement, statement));
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
            CodeStyleManager.getInstance(project).reformat(result);
        }
    }
}

