/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class MigrateToStreamFix
implements LocalQuickFix {
    MigrateToStreamFix() {
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/MigrateToStreamFix", "getName"));
        }
        return string;
    }

    @Override
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/streamMigration/MigrateToStreamFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/streamMigration/MigrateToStreamFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        if (element instanceof PsiForeachStatement) {
            PsiForeachStatement foreachStatement = (PsiForeachStatement)element;
            PsiStatement body = foreachStatement.getBody();
            PsiExpression iteratedValue = foreachStatement.getIteratedValue();
            if (body != null && iteratedValue != null) {
                PsiParameter parameter = foreachStatement.getIterationParameter();
                StreamApiMigrationInspection.TerminalBlock tb = StreamApiMigrationInspection.TerminalBlock.from(parameter, body);
                if (!FileModificationService.getInstance().preparePsiElementForWrite(foreachStatement)) {
                    return;
                }
                PsiElement result = this.migrate(project, descriptor, foreachStatement, iteratedValue, body, tb);
                if (result != null) {
                    MigrateToStreamFix.simplifyAndFormat(project, result);
                }
            }
        }
    }

    abstract PsiElement migrate(@NotNull Project var1, @NotNull ProblemDescriptor var2, @NotNull PsiForeachStatement var3, @NotNull PsiExpression var4, @NotNull PsiStatement var5, @NotNull StreamApiMigrationInspection.TerminalBlock var6);

    static PsiElement replaceWithNumericAddition(@NotNull Project project, PsiForeachStatement foreachStatement, PsiVariable var, StringBuilder builder, PsiType expressionType) {
        PsiExpression initializer;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/streamMigration/MigrateToStreamFix", "replaceWithNumericAddition"));
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(project);
        MigrateToStreamFix.restoreComments(foreachStatement, foreachStatement.getBody());
        StreamApiMigrationInspection.InitializerUsageStatus status = StreamApiMigrationInspection.getInitializerUsageStatus(var, foreachStatement);
        if (status != StreamApiMigrationInspection.InitializerUsageStatus.UNKNOWN && ExpressionUtils.isZero(initializer = var.getInitializer())) {
            PsiType type = var.getType();
            String replacement = (type.equals(expressionType) ? "" : "(" + type.getCanonicalText() + ") ") + builder;
            return MigrateToStreamFix.replaceInitializer(foreachStatement, var, initializer, replacement, status);
        }
        return foreachStatement.replace(elementFactory.createStatementFromText(var.getName() + "+=" + builder + ";", foreachStatement));
    }

    static PsiElement replaceInitializer(PsiForeachStatement foreachStatement, PsiVariable var, PsiExpression initializer, String replacement, StreamApiMigrationInspection.InitializerUsageStatus status) {
        Project project = foreachStatement.getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(project);
        if (status == StreamApiMigrationInspection.InitializerUsageStatus.DECLARED_JUST_BEFORE) {
            initializer.replace(elementFactory.createExpressionFromText(replacement, foreachStatement));
            MigrateToStreamFix.removeLoop(foreachStatement);
            return var;
        }
        if (status == StreamApiMigrationInspection.InitializerUsageStatus.AT_WANTED_PLACE_ONLY) {
            initializer.delete();
        }
        return foreachStatement.replace(elementFactory.createStatementFromText(var.getName() + " = " + replacement + ";", foreachStatement));
    }

    static void simplifyAndFormat(@NotNull Project project, PsiElement result) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/streamMigration/MigrateToStreamFix", "simplifyAndFormat"));
        }
        if (result == null) {
            return;
        }
        LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
        CodeStyleManager.getInstance(project).reformat(JavaCodeStyleManager.getInstance(project).shortenClassReferences(result));
    }

    static void restoreComments(PsiForeachStatement foreachStatement, PsiStatement body) {
        PsiElement parent = foreachStatement.getParent();
        for (PsiElement psiElement : PsiTreeUtil.findChildrenOfType(body, PsiComment.class)) {
            parent.addBefore(psiElement, foreachStatement);
        }
    }

    @NotNull
    static StringBuilder generateStream(PsiExpression iteratedValue, @Nullable StreamApiMigrationInspection.Operation lastOperation) {
        StringBuilder stringBuilder = MigrateToStreamFix.generateStream(iteratedValue, lastOperation, false);
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/MigrateToStreamFix", "generateStream"));
        }
        return stringBuilder;
    }

    @NotNull
    static StringBuilder generateStream(PsiExpression iteratedValue, @Nullable StreamApiMigrationInspection.Operation lastOperation, boolean noStreamForEmpty) {
        StringBuilder buffer = new StringBuilder();
        PsiType iteratedValueType = iteratedValue.getType();
        if (iteratedValueType instanceof PsiArrayType) {
            buffer.append("java.util.Arrays.stream(").append(iteratedValue.getText()).append(")");
        } else {
            buffer.append(MigrateToStreamFix.getIteratedValueText(iteratedValue));
            if (!noStreamForEmpty || lastOperation != null) {
                buffer.append(".stream()");
            }
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory(iteratedValue.getProject());
        List replacements = StreamEx.iterate((Object)lastOperation, Objects::nonNull, StreamApiMigrationInspection.Operation::getPreviousOp).map(op -> op.createReplacement(factory)).toList();
        ListIterator it = replacements.listIterator(replacements.size());
        while (it.hasPrevious()) {
            buffer.append((String)it.previous());
        }
        StringBuilder stringBuilder = buffer;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/MigrateToStreamFix", "generateStream"));
        }
        return stringBuilder;
    }

    static String getIteratedValueText(PsiExpression iteratedValue) {
        return iteratedValue instanceof PsiCallExpression || iteratedValue instanceof PsiReferenceExpression || iteratedValue instanceof PsiQualifiedExpression || iteratedValue instanceof PsiParenthesizedExpression ? iteratedValue.getText() : "(" + iteratedValue.getText() + ")";
    }

    static void removeLoop(@NotNull PsiForeachStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInspection/streamMigration/MigrateToStreamFix", "removeLoop"));
        }
        PsiElement parent = statement.getParent();
        if (parent instanceof PsiLabeledStatement) {
            parent.delete();
        } else {
            statement.delete();
        }
    }
}

