/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.streamMigration.MigrateToStreamFix;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ReplaceWithCollectFix
extends MigrateToStreamFix {
    private static final Logger LOG = Logger.getInstance(ReplaceWithCollectFix.class);
    final String myMethodName;

    protected ReplaceWithCollectFix(String methodName) {
        this.myMethodName = methodName;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = "Replace with " + this.myMethodName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/ReplaceWithCollectFix", "getFamilyName"));
        }
        return string;
    }

    @Nullable
    PsiType getAddedElementType(PsiMethodCallExpression call) {
        JavaResolveResult resolveResult = call.resolveMethodGenerics();
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length != 1) {
            return null;
        }
        return resolveResult.getSubstitutor().substitute(parameters[0].getType());
    }

    @Override
    PsiElement migrate(@NotNull Project project, @NotNull ProblemDescriptor descriptor, @NotNull PsiForeachStatement foreachStatement, @NotNull PsiExpression iteratedValue, @NotNull PsiStatement body, @NotNull StreamApiMigrationInspection.TerminalBlock tb) {
        StreamApiMigrationInspection.InitializerUsageStatus status;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/streamMigration/ReplaceWithCollectFix", "migrate"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/streamMigration/ReplaceWithCollectFix", "migrate"));
        }
        if (foreachStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foreachStatement", "com/intellij/codeInspection/streamMigration/ReplaceWithCollectFix", "migrate"));
        }
        if (iteratedValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iteratedValue", "com/intellij/codeInspection/streamMigration/ReplaceWithCollectFix", "migrate"));
        }
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/intellij/codeInspection/streamMigration/ReplaceWithCollectFix", "migrate"));
        }
        if (tb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tb", "com/intellij/codeInspection/streamMigration/ReplaceWithCollectFix", "migrate"));
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(project);
        PsiType iteratedValueType = iteratedValue.getType();
        PsiMethodCallExpression methodCallExpression = tb.getSingleMethodCall();
        if (methodCallExpression == null) {
            return null;
        }
        ReplaceWithCollectFix.restoreComments(foreachStatement, body);
        if (!tb.hasOperations() && StreamApiMigrationInspection.isAddAllCall(tb)) {
            PsiExpression qualifierExpression = methodCallExpression.getMethodExpression().getQualifierExpression();
            String qualifierText = qualifierExpression != null ? qualifierExpression.getText() : "";
            String collectionText = iteratedValueType instanceof PsiArrayType ? "java.util.Arrays.asList(" + iteratedValue.getText() + ")" : ReplaceWithCollectFix.getIteratedValueText(iteratedValue);
            String callText = StringUtil.getQualifiedName(qualifierText, "addAll(" + collectionText + ");");
            return foreachStatement.replace(elementFactory.createStatementFromText(callText, foreachStatement));
        }
        PsiExpression itemToAdd = methodCallExpression.getArgumentList().getExpressions()[0];
        PsiType addedType = this.getAddedElementType(methodCallExpression);
        if (addedType == null) {
            addedType = itemToAdd.getType();
        }
        StringBuilder builder = ReplaceWithCollectFix.generateStream(iteratedValue, new StreamApiMigrationInspection.MapOp(tb.getLastOperation(), itemToAdd, tb.getVariable(), addedType));
        PsiExpression qualifierExpression = methodCallExpression.getMethodExpression().getQualifierExpression();
        PsiLocalVariable variable = StreamApiMigrationInspection.extractCollectionVariable(qualifierExpression);
        if (variable != null && (status = StreamApiMigrationInspection.getInitializerUsageStatus(variable, foreachStatement)) != StreamApiMigrationInspection.InitializerUsageStatus.UNKNOWN) {
            String replacement;
            PsiType type;
            PsiExpression initializer = variable.getInitializer();
            LOG.assertTrue(initializer != null);
            PsiMethodCallExpression toArrayExpression = StreamApiMigrationInspection.extractToArrayExpression(foreachStatement, methodCallExpression);
            if (toArrayExpression != null && (type = initializer.getType()) instanceof PsiClassType && (replacement = StreamApiMigrationInspection.COLLECTION_TO_ARRAY.get(((PsiClassType)type).rawType().getCanonicalText())) != null) {
                builder.append(".").append(replacement);
                PsiExpression[] args = toArrayExpression.getArgumentList().getExpressions();
                if (args.length == 0) {
                    builder.append("()");
                } else {
                    if (args.length != 1 || !(args[0] instanceof PsiNewExpression)) {
                        return null;
                    }
                    PsiNewExpression newArray = (PsiNewExpression)args[0];
                    PsiType arrayType = newArray.getType();
                    if (arrayType == null) {
                        return null;
                    }
                    String name = arrayType.getCanonicalText();
                    builder.append('(').append(name).append("::new)");
                }
                PsiElement result = toArrayExpression.replace(elementFactory.createExpressionFromText(builder.toString(), toArrayExpression));
                ReplaceWithCollectFix.removeLoop(foreachStatement);
                if (status != StreamApiMigrationInspection.InitializerUsageStatus.AT_WANTED_PLACE) {
                    variable.delete();
                }
                return result;
            }
            String callText = builder.append(".collect(java.util.stream.Collectors.").append(ReplaceWithCollectFix.createInitializerReplacementText(qualifierExpression.getType(), initializer)).append(")").toString();
            return ReplaceWithCollectFix.replaceInitializer(foreachStatement, variable, initializer, callText, status);
        }
        String qualifierText = qualifierExpression != null ? qualifierExpression.getText() + "." : "";
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(project);
        SuggestedNameInfo suggestedNameInfo = codeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, null, null, addedType, false);
        if (suggestedNameInfo.names.length == 0) {
            suggestedNameInfo = codeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, "item", null, itemToAdd.getType(), false);
        }
        String varName = codeStyleManager.suggestUniqueVariableName((SuggestedNameInfo)suggestedNameInfo, (PsiElement)methodCallExpression, (boolean)false).names[0];
        PsiExpression forEachBody = elementFactory.createExpressionFromText(qualifierText + "add(" + varName + ")", qualifierExpression);
        String callText = builder.append(".forEach(").append(varName).append("->").append(forEachBody.getText()).append(");").toString();
        return foreachStatement.replace(elementFactory.createStatementFromText(callText, foreachStatement));
    }

    private static String createInitializerReplacementText(PsiType varType, PsiExpression initializer) {
        PsiClassType rawVarType;
        PsiType initializerType = initializer.getType();
        PsiClassType rawType = initializerType instanceof PsiClassType ? ((PsiClassType)initializerType).rawType() : null;
        PsiClassType psiClassType = rawVarType = varType instanceof PsiClassType ? ((PsiClassType)varType).rawType() : null;
        if (rawType != null && rawVarType != null && rawType.equalsToText("java.util.ArrayList") && (rawVarType.equalsToText("java.util.List") || rawVarType.equalsToText("java.util.Collection"))) {
            return "toList()";
        }
        if (rawType != null && rawVarType != null && rawType.equalsToText("java.util.HashSet") && (rawVarType.equalsToText("java.util.Set") || rawVarType.equalsToText("java.util.Collection"))) {
            return "toSet()";
        }
        if (rawType != null) {
            return "toCollection(" + rawType.getClassName() + "::new)";
        }
        return "toCollection(() -> " + initializer.getText() + ")";
    }
}

