/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.streamMigration.MigrateToStreamFix;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

class ReplaceWithFindFirstFix
extends MigrateToStreamFix {
    ReplaceWithFindFirstFix() {
    }

    @Override
    @NotNull
    public String getFamilyName() {
        if ("Replace with findFirst()" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/ReplaceWithFindFirstFix", "getFamilyName"));
        }
        return "Replace with findFirst()";
    }

    @Override
    PsiElement migrate(@NotNull Project project, @NotNull ProblemDescriptor descriptor, @NotNull PsiForeachStatement foreachStatement, @NotNull PsiExpression iteratedValue, @NotNull PsiStatement body, @NotNull StreamApiMigrationInspection.TerminalBlock tb) {
        PsiExpression initializer;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/streamMigration/ReplaceWithFindFirstFix", "migrate"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/streamMigration/ReplaceWithFindFirstFix", "migrate"));
        }
        if (foreachStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foreachStatement", "com/intellij/codeInspection/streamMigration/ReplaceWithFindFirstFix", "migrate"));
        }
        if (iteratedValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iteratedValue", "com/intellij/codeInspection/streamMigration/ReplaceWithFindFirstFix", "migrate"));
        }
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/intellij/codeInspection/streamMigration/ReplaceWithFindFirstFix", "migrate"));
        }
        if (tb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tb", "com/intellij/codeInspection/streamMigration/ReplaceWithFindFirstFix", "migrate"));
        }
        PsiStatement statement = tb.getSingleStatement();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(project);
        String stream = ReplaceWithFindFirstFix.generateStream(iteratedValue, tb.getLastOperation()).append(".findFirst()").toString();
        if (statement instanceof PsiReturnStatement) {
            PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
            PsiExpression value = returnStatement.getReturnValue();
            if (value == null) {
                return null;
            }
            PsiReturnStatement nextReturnStatement = StreamApiMigrationInspection.getNextReturnStatement(foreachStatement);
            if (nextReturnStatement == null) {
                return null;
            }
            PsiExpression orElseExpression = nextReturnStatement.getReturnValue();
            if (!ExpressionUtils.isSimpleExpression(orElseExpression)) {
                return null;
            }
            stream = ReplaceWithFindFirstFix.generateOptionalUnwrap(stream, tb, value, orElseExpression, null);
            ReplaceWithFindFirstFix.restoreComments(foreachStatement, body);
            if (nextReturnStatement.getParent() == foreachStatement.getParent()) {
                nextReturnStatement.delete();
            }
            return foreachStatement.replace(elementFactory.createStatementFromText("return " + stream + ";", foreachStatement));
        }
        PsiStatement[] statements = tb.getStatements();
        if (statements.length != 2) {
            return null;
        }
        PsiAssignmentExpression assignment = ExpressionUtils.getAssignment(statements[0]);
        if (assignment == null) {
            if (!(statements[0] instanceof PsiExpressionStatement)) {
                return null;
            }
            PsiExpression expression = ((PsiExpressionStatement)statements[0]).getExpression();
            ReplaceWithFindFirstFix.restoreComments(foreachStatement, body);
            return foreachStatement.replace(elementFactory.createStatementFromText(stream + ".ifPresent(" + LambdaUtil.createLambda(tb.getVariable(), expression) + ");", foreachStatement));
        }
        PsiExpression lValue = assignment.getLExpression();
        if (!(lValue instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement element = ((PsiReferenceExpression)lValue).resolve();
        if (!(element instanceof PsiVariable)) {
            return null;
        }
        PsiVariable var = (PsiVariable)element;
        PsiExpression value = assignment.getRExpression();
        if (value == null) {
            return null;
        }
        ReplaceWithFindFirstFix.restoreComments(foreachStatement, body);
        StreamApiMigrationInspection.InitializerUsageStatus status = StreamApiMigrationInspection.getInitializerUsageStatus(var, foreachStatement);
        if (status != StreamApiMigrationInspection.InitializerUsageStatus.UNKNOWN && (initializer = var.getInitializer()) != null) {
            String replacementText = ReplaceWithFindFirstFix.generateOptionalUnwrap(stream, tb, value, initializer, var.getType());
            return ReplaceWithFindFirstFix.replaceInitializer(foreachStatement, var, initializer, replacementText, status);
        }
        return foreachStatement.replace(elementFactory.createStatementFromText(var.getName() + " = " + ReplaceWithFindFirstFix.generateOptionalUnwrap(stream, tb, value, lValue, var.getType()) + ";", foreachStatement));
    }

    private static String generateOptionalUnwrap(String stream, @NotNull StreamApiMigrationInspection.TerminalBlock tb, PsiExpression trueExpression, PsiExpression falseExpression, PsiType targetType) {
        if (tb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tb", "com/intellij/codeInspection/streamMigration/ReplaceWithFindFirstFix", "generateOptionalUnwrap"));
        }
        PsiVariable var = tb.getVariable();
        if (!StreamApiMigrationInspection.isIdentityMapping(var, trueExpression)) {
            PsiTypeCastExpression castExpression;
            PsiTypeElement castType;
            if (trueExpression instanceof PsiTypeCastExpression && ExpressionUtils.isNullLiteral(falseExpression) && (castType = (castExpression = (PsiTypeCastExpression)trueExpression).getCastType()) != null && StreamApiMigrationInspection.isIdentityMapping(var, castExpression.getOperand())) {
                return "(" + castType.getText() + ")" + stream + ".orElse(null)";
            }
            if (ExpressionUtils.isLiteral(falseExpression, Boolean.FALSE) && PsiType.BOOLEAN.equals(trueExpression.getType())) {
                return stream + ".filter(" + LambdaUtil.createLambda(var, trueExpression) + ").isPresent()";
            }
            if (trueExpression instanceof PsiConditionalExpression) {
                PsiConditionalExpression condition = (PsiConditionalExpression)trueExpression;
                if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(falseExpression, condition.getElseExpression())) {
                    return ReplaceWithFindFirstFix.generateOptionalUnwrap(stream + ".filter(" + LambdaUtil.createLambda(var, condition.getCondition()) + ")", tb, condition.getThenExpression(), falseExpression, targetType);
                }
            }
            trueExpression = targetType == null ? trueExpression : ExpressionUtils.convertInitializerToNormalExpression(trueExpression, targetType);
            stream = stream + ".map(" + LambdaUtil.createLambda(var, trueExpression) + ")";
        }
        stream = stream + ".orElse(" + falseExpression.getText() + ")";
        return stream;
    }
}

