/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.streamMigration.MigrateToStreamFix;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

class ReplaceWithMatchFix
extends MigrateToStreamFix {
    private static final Logger LOG = Logger.getInstance("#" + ReplaceWithMatchFix.class.getName());
    private final String myMethodName;

    public ReplaceWithMatchFix(String methodName) {
        this.myMethodName = methodName;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = "Replace with " + this.myMethodName + "()";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/ReplaceWithMatchFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    PsiElement migrate(@NotNull Project project, @NotNull ProblemDescriptor descriptor, @NotNull PsiForeachStatement foreachStatement, @NotNull PsiExpression iteratedValue, @NotNull PsiStatement body, @NotNull StreamApiMigrationInspection.TerminalBlock tb) {
        PsiStatement[] statements;
        PsiReturnStatement returnStatement;
        PsiExpression value;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/streamMigration/ReplaceWithMatchFix", "migrate"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/streamMigration/ReplaceWithMatchFix", "migrate"));
        }
        if (foreachStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foreachStatement", "com/intellij/codeInspection/streamMigration/ReplaceWithMatchFix", "migrate"));
        }
        if (iteratedValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iteratedValue", "com/intellij/codeInspection/streamMigration/ReplaceWithMatchFix", "migrate"));
        }
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/intellij/codeInspection/streamMigration/ReplaceWithMatchFix", "migrate"));
        }
        if (tb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tb", "com/intellij/codeInspection/streamMigration/ReplaceWithMatchFix", "migrate"));
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(project);
        if (tb.getSingleStatement() instanceof PsiReturnStatement && (ExpressionUtils.isLiteral(value = (returnStatement = (PsiReturnStatement)tb.getSingleStatement()).getReturnValue(), Boolean.TRUE) || ExpressionUtils.isLiteral(value, Boolean.FALSE))) {
            boolean foundResult = (Boolean)((PsiLiteralExpression)value).getValue();
            PsiReturnStatement nextReturnStatement = StreamApiMigrationInspection.getNextReturnStatement(foreachStatement);
            if (nextReturnStatement != null && ExpressionUtils.isLiteral(nextReturnStatement.getReturnValue(), !foundResult)) {
                String methodName = foundResult ? "anyMatch" : "noneMatch";
                String streamText = ReplaceWithMatchFix.generateStream(iteratedValue, tb.getLastOperation()).toString();
                streamText = ReplaceWithMatchFix.addTerminalOperation(streamText, methodName, foreachStatement, tb);
                ReplaceWithMatchFix.restoreComments(foreachStatement, body);
                if (nextReturnStatement.getParent() == foreachStatement.getParent()) {
                    nextReturnStatement.delete();
                }
                return foreachStatement.replace(elementFactory.createStatementFromText("return " + streamText + ";", foreachStatement));
            }
        }
        if (!((statements = tb.getStatements()).length == 1 || statements.length == 2 && ControlFlowUtils.statementBreaksLoop(statements[1], foreachStatement))) {
            return null;
        }
        ReplaceWithMatchFix.restoreComments(foreachStatement, body);
        String streamText = ReplaceWithMatchFix.generateStream(iteratedValue, tb.getLastOperation()).toString();
        streamText = ReplaceWithMatchFix.addTerminalOperation(streamText, "anyMatch", foreachStatement, tb);
        PsiStatement statement = statements[0];
        PsiAssignmentExpression assignment = ExpressionUtils.getAssignment(statement);
        if (assignment != null) {
            PsiExpression lValue = assignment.getLExpression();
            PsiExpression rValue = assignment.getRExpression();
            if (!(lValue instanceof PsiReferenceExpression) || rValue == null) {
                return null;
            }
            PsiElement maybeVar = ((PsiReferenceExpression)lValue).resolve();
            if (maybeVar instanceof PsiVariable) {
                PsiVariable var = (PsiVariable)maybeVar;
                PsiExpression initializer = var.getInitializer();
                StreamApiMigrationInspection.InitializerUsageStatus status = StreamApiMigrationInspection.getInitializerUsageStatus(var, foreachStatement);
                if (initializer != null && status != StreamApiMigrationInspection.InitializerUsageStatus.UNKNOWN) {
                    String replacement = ExpressionUtils.isLiteral(initializer, Boolean.FALSE) && ExpressionUtils.isLiteral(rValue, Boolean.TRUE) ? streamText : (ExpressionUtils.isLiteral(initializer, Boolean.TRUE) && ExpressionUtils.isLiteral(rValue, Boolean.FALSE) ? "!" + streamText : streamText + "?" + rValue.getText() + ":" + initializer.getText());
                    return ReplaceWithMatchFix.replaceInitializer(foreachStatement, var, initializer, replacement, status);
                }
            }
        }
        String replacement = "if(" + streamText + "){" + statement.getText() + "}";
        return foreachStatement.replace(elementFactory.createStatementFromText(replacement, foreachStatement));
    }

    private static String addTerminalOperation(String origStream, String methodName, @NotNull PsiElement contextElement, @NotNull StreamApiMigrationInspection.TerminalBlock tb) {
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/codeInspection/streamMigration/ReplaceWithMatchFix", "addTerminalOperation"));
        }
        if (tb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tb", "com/intellij/codeInspection/streamMigration/ReplaceWithMatchFix", "addTerminalOperation"));
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(contextElement.getProject());
        PsiExpression stream = elementFactory.createExpressionFromText(origStream, contextElement);
        LOG.assertTrue(stream instanceof PsiMethodCallExpression);
        PsiElement nameElement = ((PsiMethodCallExpression)stream).getMethodExpression().getReferenceNameElement();
        if (nameElement != null && nameElement.getText().equals("filter")) {
            PsiLambdaExpression lambda2;
            PsiElement lambdaBody;
            PsiExpression[] expressions;
            if (methodName.equals("noneMatch") && (expressions = ((PsiMethodCallExpression)stream).getArgumentList().getExpressions()).length == 1 && expressions[0] instanceof PsiLambdaExpression && (lambdaBody = (lambda2 = (PsiLambdaExpression)expressions[0]).getBody()) instanceof PsiExpression && BoolUtils.isNegation((PsiExpression)lambdaBody)) {
                PsiExpression negated = BoolUtils.getNegated((PsiExpression)lambdaBody);
                LOG.assertTrue(negated != null, lambdaBody.getText());
                lambdaBody.replace(negated);
                methodName = "allMatch";
            }
            nameElement.replace(elementFactory.createIdentifier(methodName));
            return stream.getText();
        }
        return origStream + "." + methodName + "(" + tb.getVariable().getName() + " -> true)";
    }
}

