/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.streamMigration.ReplaceWithCollectFix;
import com.intellij.codeInspection.streamMigration.ReplaceWithCountFix;
import com.intellij.codeInspection.streamMigration.ReplaceWithFindFirstFix;
import com.intellij.codeInspection.streamMigration.ReplaceWithForeachCallFix;
import com.intellij.codeInspection.streamMigration.ReplaceWithMatchFix;
import com.intellij.codeInspection.streamMigration.ReplaceWithSumFix;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntArrayList;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamApiMigrationInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance("#" + StreamApiMigrationInspection.class.getName());
    static final Map<String, String> COLLECTION_TO_ARRAY = EntryStream.of((Object)"java.util.ArrayList", (Object)"toArray", (Object)"java.util.LinkedList", (Object)"toArray", (Object)"java.util.HashSet", (Object)"distinct().toArray", (Object)"java.util.LinkedHashSet", (Object)"distinct().toArray", (Object)"java.util.TreeSet", (Object)"distinct().sorted().toArray").toMap();
    public boolean REPLACE_TRIVIAL_FOREACH;
    public boolean SUGGEST_FOREACH;
    private HighlightDisplayKey myKey;

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel(this);
        panel.addCheckbox("Suggest to replace with forEach or forEachOrdered", "SUGGEST_FOREACH");
        panel.addCheckbox("Replace trivial foreach statements", "REPLACE_TRIVIAL_FOREACH");
        return panel;
    }

    @Override
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.LANGUAGE_LEVEL_SPECIFIC_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("foreach loop can be collapsed with Stream API" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection", "getDisplayName"));
        }
        return "foreach loop can be collapsed with Stream API";
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String getShortName() {
        if ("Convert2streamapi" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection", "getShortName"));
        }
        return "Convert2streamapi";
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection", "buildVisitor"));
        }
        if (!PsiUtil.isLanguageLevel8OrHigher(holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        StreamApiMigrationVisitor streamApiMigrationVisitor = new StreamApiMigrationVisitor(holder, isOnTheFly);
        if (streamApiMigrationVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection", "buildVisitor"));
        }
        return streamApiMigrationVisitor;
    }

    @Contract(value="_, null -> false")
    static boolean isVariableReferenced(PsiVariable variable, PsiExpression value) {
        return value != null && ReferencesSearch.search(variable, new LocalSearchScope(value)).findFirst() != null;
    }

    static boolean isReferencedInOperations(PsiElement element, TerminalBlock tb) {
        return ReferencesSearch.search(element, new LocalSearchScope((PsiElement[])tb.intermediateExpressions().toArray(PsiElement[]::new))).findFirst() != null;
    }

    @Nullable
    static PsiReturnStatement getNextReturnStatement(PsiStatement statement) {
        PsiElement nextStatement = PsiTreeUtil.skipSiblingsForward(statement, PsiWhiteSpace.class, PsiComment.class);
        if (nextStatement instanceof PsiReturnStatement) {
            return (PsiReturnStatement)nextStatement;
        }
        PsiElement parent = statement.getParent();
        if (parent instanceof PsiCodeBlock) {
            PsiStatement[] statements = ((PsiCodeBlock)parent).getStatements();
            if (statements.length == 0 || statements[statements.length - 1] != statement) {
                return null;
            }
            if (!((parent = parent.getParent()) instanceof PsiBlockStatement)) {
                return null;
            }
            parent = parent.getParent();
        }
        if (parent instanceof PsiIfStatement) {
            return StreamApiMigrationInspection.getNextReturnStatement((PsiStatement)parent);
        }
        return null;
    }

    @Contract(value="null, null -> true; null, !null -> false")
    private static boolean sameReference(PsiExpression expr1, PsiExpression expr2) {
        if (expr1 == null && expr2 == null) {
            return true;
        }
        if (!(expr1 instanceof PsiReferenceExpression) || !(expr2 instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression ref1 = (PsiReferenceExpression)expr1;
        PsiReferenceExpression ref2 = (PsiReferenceExpression)expr2;
        return Objects.equals(ref1.getReferenceName(), ref2.getReferenceName()) && StreamApiMigrationInspection.sameReference(ref1.getQualifierExpression(), ref2.getQualifierExpression());
    }

    @Nullable
    static PsiExpression extractAddend(PsiAssignmentExpression assignment) {
        PsiBinaryExpression binOp;
        if (JavaTokenType.PLUSEQ.equals(assignment.getOperationTokenType())) {
            return assignment.getRExpression();
        }
        if (JavaTokenType.EQ.equals(assignment.getOperationTokenType()) && assignment.getRExpression() instanceof PsiBinaryExpression && JavaTokenType.PLUS.equals((binOp = (PsiBinaryExpression)assignment.getRExpression()).getOperationTokenType())) {
            if (StreamApiMigrationInspection.sameReference(binOp.getLOperand(), assignment.getLExpression())) {
                return binOp.getROperand();
            }
            if (StreamApiMigrationInspection.sameReference(binOp.getROperand(), assignment.getLExpression())) {
                return binOp.getLOperand();
            }
        }
        return null;
    }

    @Nullable
    static PsiVariable extractAccumulator(PsiAssignmentExpression assignment) {
        PsiBinaryExpression binOp;
        if (!(assignment.getLExpression() instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression lExpr = (PsiReferenceExpression)assignment.getLExpression();
        PsiElement accumulator = lExpr.resolve();
        if (!(accumulator instanceof PsiVariable)) {
            return null;
        }
        PsiVariable var = (PsiVariable)accumulator;
        if (JavaTokenType.PLUSEQ.equals(assignment.getOperationTokenType())) {
            return var;
        }
        if (JavaTokenType.EQ.equals(assignment.getOperationTokenType()) && assignment.getRExpression() instanceof PsiBinaryExpression && JavaTokenType.PLUS.equals((binOp = (PsiBinaryExpression)assignment.getRExpression()).getOperationTokenType())) {
            PsiExpression left = binOp.getLOperand();
            PsiExpression right = binOp.getROperand();
            if (StreamApiMigrationInspection.sameReference(left, lExpr) || StreamApiMigrationInspection.sameReference(right, lExpr)) {
                return var;
            }
        }
        return null;
    }

    @Contract(value="null -> null")
    static PsiExpression extractIncrementedLValue(PsiExpression expression) {
        PsiAssignmentExpression assignment;
        if (expression instanceof PsiPostfixExpression) {
            if (JavaTokenType.PLUSPLUS.equals(((PsiPostfixExpression)expression).getOperationTokenType())) {
                return ((PsiPostfixExpression)expression).getOperand();
            }
        } else if (expression instanceof PsiPrefixExpression) {
            if (JavaTokenType.PLUSPLUS.equals(((PsiPrefixExpression)expression).getOperationTokenType())) {
                return ((PsiPrefixExpression)expression).getOperand();
            }
        } else if (expression instanceof PsiAssignmentExpression && ExpressionUtils.isLiteral(StreamApiMigrationInspection.extractAddend(assignment = (PsiAssignmentExpression)expression), 1)) {
            return assignment.getLExpression();
        }
        return null;
    }

    @Nullable
    private static PsiLocalVariable getIncrementedVariable(TerminalBlock tb, List<PsiVariable> variables) {
        if (variables.size() != 1) {
            return null;
        }
        PsiExpression operand = StreamApiMigrationInspection.extractIncrementedLValue(tb.getSingleExpression(PsiExpression.class));
        if (!(operand instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement element = ((PsiReferenceExpression)operand).resolve();
        if (!(element instanceof PsiLocalVariable) || !variables.contains(element) || StreamApiMigrationInspection.isReferencedInOperations(element, tb)) {
            return null;
        }
        return (PsiLocalVariable)element;
    }

    @Nullable
    private static PsiVariable getAccumulatedVariable(TerminalBlock tb, List<PsiVariable> variables) {
        if (variables.size() != 1) {
            return null;
        }
        PsiAssignmentExpression assignment = tb.getSingleExpression(PsiAssignmentExpression.class);
        if (assignment == null) {
            return null;
        }
        PsiVariable var = StreamApiMigrationInspection.extractAccumulator(assignment);
        if (var == null || !variables.contains(var)) {
            return null;
        }
        if (!(var.getType() instanceof PsiPrimitiveType) || var.getType().equalsToText("float")) {
            return null;
        }
        if (StreamApiMigrationInspection.isReferencedInOperations(var, tb)) {
            return null;
        }
        PsiExpression addend = StreamApiMigrationInspection.extractAddend(assignment);
        LOG.assertTrue(addend != null);
        if (ReferencesSearch.search(var, new LocalSearchScope(addend)).findFirst() != null) {
            return null;
        }
        return var;
    }

    static boolean isAddAllCall(TerminalBlock tb) {
        PsiVariable variable = tb.getVariable();
        PsiMethodCallExpression methodCallExpression = tb.getSingleMethodCall();
        LOG.assertTrue(methodCallExpression != null);
        return StreamApiMigrationInspection.isIdentityMapping(variable, methodCallExpression.getArgumentList().getExpressions()[0]);
    }

    private static boolean isCollectCall(TerminalBlock tb) {
        PsiMethodCallExpression methodCallExpression = tb.getSingleMethodCall();
        if (methodCallExpression != null) {
            PsiClass enclosingClass;
            PsiElement resolve;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            PsiClass qualifierClass = null;
            if (qualifierExpression instanceof PsiReferenceExpression) {
                if (ReferencesSearch.search(tb.getVariable(), new LocalSearchScope(qualifierExpression)).findFirst() != null) {
                    return false;
                }
                resolve = ((PsiReferenceExpression)qualifierExpression).resolve();
                if (resolve instanceof PsiVariable && ReferencesSearch.search(resolve, new LocalSearchScope(methodCallExpression.getArgumentList())).findFirst() != null) {
                    return false;
                }
                qualifierClass = PsiUtil.resolveClassInType(qualifierExpression.getType());
            } else if (qualifierExpression == null && PsiUtil.getEnclosingStaticElement(methodCallExpression, enclosingClass = PsiTreeUtil.getParentOfType((PsiElement)methodCallExpression, PsiClass.class)) == null) {
                qualifierClass = enclosingClass;
            }
            if (qualifierClass != null && InheritanceUtil.isInheritor(qualifierClass, false, "java.util.Collection")) {
                PsiExpression[] args;
                if (tb.intermediateExpressions().anyMatch(expression -> StreamApiMigrationInspection.isExpressionDependsOnUpdatedCollections(expression, qualifierExpression))) {
                    return false;
                }
                resolve = methodExpression.resolve();
                if (resolve instanceof PsiMethod && "add".equals(((PsiMethod)resolve).getName()) && ((PsiMethod)resolve).getParameterList().getParametersCount() == 1 && (args = methodCallExpression.getArgumentList().getExpressions()).length == 1) {
                    if (args[0] instanceof PsiCallExpression) {
                        PsiMethod method = ((PsiCallExpression)args[0]).resolveMethod();
                        return method != null && !method.hasTypeParameters() && !StreamApiMigrationInspection.isThrowsCompatible(method);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isExpressionDependsOnUpdatedCollections(PsiExpression condition, PsiExpression qualifierExpression) {
        PsiElement collection;
        PsiElement psiElement = collection = qualifierExpression instanceof PsiReferenceExpression ? ((PsiReferenceExpression)qualifierExpression).resolve() : null;
        if (collection != null) {
            return ReferencesSearch.search(collection, new LocalSearchScope(condition)).findFirst() != null;
        }
        final boolean[] dependsOnCollection = new boolean[]{false};
        condition.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                super.visitMethodCallExpression(expression);
                PsiExpression callQualifier = expression.getMethodExpression().getQualifierExpression();
                if (callQualifier == null || callQualifier instanceof PsiThisExpression && ((PsiThisExpression)callQualifier).getQualifier() == null || callQualifier instanceof PsiSuperExpression && ((PsiSuperExpression)callQualifier).getQualifier() == null) {
                    dependsOnCollection[0] = true;
                }
            }

            @Override
            public void visitThisExpression(PsiThisExpression expression) {
                super.visitThisExpression(expression);
                if (expression.getQualifier() == null && expression.getParent() instanceof PsiExpressionList) {
                    dependsOnCollection[0] = true;
                }
            }

            @Override
            public void visitClass(PsiClass aClass) {
            }

            @Override
            public void visitLambdaExpression(PsiLambdaExpression expression) {
            }
        });
        return dependsOnCollection[0];
    }

    private static boolean isTrivial(PsiStatement body, PsiParameter parameter) {
        PsiExpression candidate = new LambdaCanBeMethodReferenceInspection().canBeMethodReferenceProblem(body instanceof PsiBlockStatement ? ((PsiBlockStatement)body).getCodeBlock() : body, new PsiParameter[]{parameter}, StreamApiMigrationInspection.createDefaultConsumerType(parameter.getProject(), parameter), null);
        if (!(candidate instanceof PsiCallExpression)) {
            return true;
        }
        PsiMethod method = ((PsiCallExpression)candidate).resolveMethod();
        return method != null && StreamApiMigrationInspection.isThrowsCompatible(method);
    }

    static boolean isSupported(PsiType type) {
        if (type instanceof PsiPrimitiveType) {
            return type.equals(PsiType.INT) || type.equals(PsiType.LONG) || type.equals(PsiType.DOUBLE);
        }
        return true;
    }

    private static boolean isThrowsCompatible(PsiMethod method) {
        return ContainerUtil.find(method.getThrowsList().getReferencedTypes(), type -> !ExceptionUtil.isUncheckedException(type)) != null;
    }

    @Contract(value="_, null -> false")
    static boolean isIdentityMapping(PsiVariable variable, PsiExpression mapperCall) {
        return mapperCall instanceof PsiReferenceExpression && ((PsiReferenceExpression)mapperCall).resolve() == variable;
    }

    @Nullable
    private static PsiClassType createDefaultConsumerType(Project project, PsiVariable variable) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
        PsiClass consumerClass = psiFacade.findClass("java.util.function.Consumer", GlobalSearchScope.allScope(project));
        return consumerClass != null ? psiFacade.getElementFactory().createType(consumerClass, variable.getType()) : null;
    }

    @Contract(value="null -> null")
    static PsiLocalVariable extractCollectionVariable(PsiExpression qualifierExpression) {
        PsiExpressionList argumentList;
        PsiLocalVariable var;
        PsiExpression initializer;
        PsiElement resolve;
        if (qualifierExpression instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)qualifierExpression).resolve()) instanceof PsiLocalVariable && (initializer = (var = (PsiLocalVariable)resolve).getInitializer()) instanceof PsiNewExpression && (argumentList = ((PsiNewExpression)initializer).getArgumentList()) != null && argumentList.getExpressions().length == 0) {
            return var;
        }
        return null;
    }

    static InitializerUsageStatus getInitializerUsageStatus(PsiVariable var, PsiStatement nextStatement) {
        ControlFlow controlFlow;
        if (!(var instanceof PsiLocalVariable) || var.getInitializer() == null) {
            return InitializerUsageStatus.UNKNOWN;
        }
        if (StreamApiMigrationInspection.isDeclarationJustBefore(var, nextStatement)) {
            return InitializerUsageStatus.DECLARED_JUST_BEFORE;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)var, PsiLambdaExpression.class, PsiMethod.class) != PsiTreeUtil.getParentOfType((PsiElement)nextStatement, PsiLambdaExpression.class, PsiMethod.class)) {
            return InitializerUsageStatus.UNKNOWN;
        }
        PsiElement block = PsiUtil.getVariableCodeBlock(var, null);
        if (block == null) {
            return InitializerUsageStatus.UNKNOWN;
        }
        try {
            controlFlow = ControlFlowFactory.getInstance(nextStatement.getProject()).getControlFlow(block, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
        }
        catch (AnalysisCanceledException ignored) {
            return InitializerUsageStatus.UNKNOWN;
        }
        int start = controlFlow.getEndOffset(var.getInitializer()) + 1;
        int stop = controlFlow.getStartOffset(nextStatement);
        if (ControlFlowUtil.isVariableReferencedBetween(controlFlow, start, stop, var)) {
            return InitializerUsageStatus.UNKNOWN;
        }
        if (!ControlFlowUtil.isValueUsedWithoutVisitingStop(controlFlow, start, stop, var)) {
            return InitializerUsageStatus.AT_WANTED_PLACE_ONLY;
        }
        return var.hasModifierProperty("final") ? InitializerUsageStatus.UNKNOWN : InitializerUsageStatus.AT_WANTED_PLACE;
    }

    static boolean isDeclarationJustBefore(PsiVariable var, PsiStatement nextStatement) {
        PsiElement[] elements;
        PsiElement declaration = var.getParent();
        PsiElement nextStatementParent = nextStatement.getParent();
        if (nextStatementParent instanceof PsiLabeledStatement) {
            nextStatement = (PsiStatement)nextStatementParent;
        }
        return declaration instanceof PsiDeclarationStatement && ArrayUtil.getLastElement(elements = ((PsiDeclarationStatement)declaration).getDeclaredElements()) == var && nextStatement.equals(PsiTreeUtil.skipSiblingsForward(declaration, PsiWhiteSpace.class, PsiComment.class));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    static PsiMethodCallExpression extractToArrayExpression(PsiForeachStatement statement, PsiMethodCallExpression expression) {
        PsiExpression toArrayCandidate;
        PsiElement nextElement = PsiTreeUtil.skipSiblingsForward(statement, PsiComment.class, PsiWhiteSpace.class);
        if (nextElement instanceof PsiReturnStatement) {
            toArrayCandidate = ((PsiReturnStatement)nextElement).getReturnValue();
        } else {
            PsiAssignmentExpression assignment = ExpressionUtils.getAssignment(nextElement);
            if (assignment != null) {
                toArrayCandidate = assignment.getRExpression();
            } else {
                if (!(nextElement instanceof PsiDeclarationStatement)) return null;
                PsiElement[] elements = ((PsiDeclarationStatement)nextElement).getDeclaredElements();
                if (elements.length != 1 || !(elements[0] instanceof PsiLocalVariable)) return null;
                toArrayCandidate = ((PsiLocalVariable)elements[0]).getInitializer();
            }
        }
        if (!(toArrayCandidate instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)toArrayCandidate;
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        if (!"toArray".equals(methodExpression.getReferenceName())) {
            return null;
        }
        PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
        if (!(qualifierExpression instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiLocalVariable collectionVariable = StreamApiMigrationInspection.extractCollectionVariable(expression.getMethodExpression().getQualifierExpression());
        if (collectionVariable == null || ((PsiReferenceExpression)qualifierExpression).resolve() != collectionVariable) {
            return null;
        }
        PsiExpression initializer = collectionVariable.getInitializer();
        if (initializer == null) {
            return null;
        }
        PsiType type = initializer.getType();
        if (!(type instanceof PsiClassType) || !COLLECTION_TO_ARRAY.containsKey(((PsiClassType)type).rawType().getCanonicalText())) {
            return null;
        }
        if (!(nextElement instanceof PsiReturnStatement) && !ReferencesSearch.search(collectionVariable, collectionVariable.getUseScope()).forEach(ref -> ref.getElement() == collectionVariable || PsiTreeUtil.isAncestor(statement, ref.getElement(), false) || PsiTreeUtil.isAncestor(toArrayCandidate, ref.getElement(), false))) {
            return null;
        }
        PsiExpression[] args = call.getArgumentList().getExpressions();
        if (args.length == 0) {
            return call;
        }
        if (args.length != 1 || !(args[0] instanceof PsiNewExpression)) {
            return null;
        }
        PsiNewExpression newArray = (PsiNewExpression)args[0];
        PsiExpression[] dimensions = newArray.getArrayDimensions();
        if (dimensions.length != 1) {
            return null;
        }
        if (ExpressionUtils.isLiteral(dimensions[0], 0)) {
            return call;
        }
        if (!(dimensions[0] instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression maybeSizeCall = (PsiMethodCallExpression)dimensions[0];
        if (maybeSizeCall.getArgumentList().getExpressions().length != 0) {
            return null;
        }
        PsiReferenceExpression maybeSizeExpression = maybeSizeCall.getMethodExpression();
        if ("size".equals(maybeSizeExpression.getReferenceName()) && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(qualifierExpression, maybeSizeExpression.getQualifierExpression())) return call;
        return null;
    }

    static class TerminalBlock {
        @Nullable
        private final Operation myPreviousOp;
        @NotNull
        private final PsiVariable myVariable;
        @NotNull
        private final PsiStatement[] myStatements;

        private TerminalBlock(@Nullable Operation previousOp, @NotNull PsiVariable variable, PsiStatement ... statements) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$TerminalBlock", "<init>"));
            }
            if (statements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statements", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$TerminalBlock", "<init>"));
            }
            this.myVariable = variable;
            while (true) {
                if (statements.length == 1 && statements[0] instanceof PsiBlockStatement) {
                    statements = ((PsiBlockStatement)statements[0]).getCodeBlock().getStatements();
                    continue;
                }
                if (statements.length != 1 || !(statements[0] instanceof PsiLabeledStatement)) break;
                statements = new PsiStatement[]{((PsiLabeledStatement)statements[0]).getStatement()};
            }
            this.myStatements = statements;
            this.myPreviousOp = previousOp;
        }

        int getStartOffset(ControlFlow cf) {
            return cf.getStartOffset(this.myStatements[0]);
        }

        int getEndOffset(ControlFlow cf) {
            return cf.getEndOffset(this.myStatements[this.myStatements.length - 1]);
        }

        PsiStatement getSingleStatement() {
            return this.myStatements.length == 1 ? this.myStatements[0] : null;
        }

        @NotNull
        PsiStatement[] getStatements() {
            if (this.myStatements == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$TerminalBlock", "getStatements"));
            }
            return this.myStatements;
        }

        @Nullable
        <T extends PsiExpression> T getSingleExpression(Class<T> wantedType) {
            PsiExpression expression;
            PsiStatement statement = this.getSingleStatement();
            if (statement instanceof PsiExpressionStatement && wantedType.isInstance(expression = ((PsiExpressionStatement)statement).getExpression())) {
                return (T)((PsiExpression)wantedType.cast(expression));
            }
            return null;
        }

        @Nullable
        PsiMethodCallExpression getSingleMethodCall() {
            return this.getSingleExpression(PsiMethodCallExpression.class);
        }

        @Nullable
        private TerminalBlock extractFilter() {
            PsiStatement first;
            PsiIfStatement ifStatement;
            if (this.getSingleStatement() instanceof PsiIfStatement && (ifStatement = (PsiIfStatement)this.getSingleStatement()).getElseBranch() == null && ifStatement.getCondition() != null) {
                return new TerminalBlock(new FilterOp(this.myPreviousOp, ifStatement.getCondition(), this.myVariable, false), this.myVariable, ifStatement.getThenBranch());
            }
            if (this.myStatements.length >= 1 && (first = this.myStatements[0]) instanceof PsiIfStatement) {
                PsiStatement[] statements;
                PsiIfStatement ifStatement2 = (PsiIfStatement)first;
                if (ifStatement2.getCondition() == null) {
                    return null;
                }
                PsiStatement branch = ifStatement2.getThenBranch();
                if (branch instanceof PsiBlockStatement && (statements = ((PsiBlockStatement)branch).getCodeBlock().getStatements()).length == 1) {
                    branch = statements[0];
                }
                if (!(branch instanceof PsiContinueStatement) || ((PsiContinueStatement)branch).getLabelIdentifier() != null) {
                    return null;
                }
                if (ifStatement2.getElseBranch() != null) {
                    statements = (PsiStatement[])this.myStatements.clone();
                    statements[0] = ifStatement2.getElseBranch();
                } else {
                    statements = Arrays.copyOfRange(this.myStatements, 1, this.myStatements.length);
                }
                return new TerminalBlock(new FilterOp(this.myPreviousOp, ifStatement2.getCondition(), this.myVariable, true), this.myVariable, statements);
            }
            return null;
        }

        @Nullable
        TerminalBlock extractOperation() {
            PsiLocalVariable declaredVar;
            PsiElement element;
            PsiDeclarationStatement decl;
            PsiElement[] elements;
            PsiStatement first;
            TerminalBlock withFilter = this.extractFilter();
            if (withFilter != null) {
                return withFilter;
            }
            if (this.getSingleStatement() instanceof PsiForeachStatement) {
                if (this.myVariable.getType() instanceof PsiPrimitiveType) {
                    return null;
                }
                PsiForeachStatement foreachStatement = (PsiForeachStatement)this.getSingleStatement();
                PsiExpression iteratedValue = foreachStatement.getIteratedValue();
                PsiStatement body = foreachStatement.getBody();
                if (iteratedValue != null && body != null) {
                    PsiType iteratedValueType = iteratedValue.getType();
                    FlatMapOp op = null;
                    if (iteratedValueType instanceof PsiArrayType) {
                        if (!StreamApiMigrationInspection.isSupported(((PsiArrayType)iteratedValueType).getComponentType())) {
                            return null;
                        }
                        op = new ArrayFlatMapOp(this.myPreviousOp, iteratedValue, this.myVariable, foreachStatement);
                    } else {
                        PsiClass iteratorClass = PsiUtil.resolveClassInClassTypeOnly(iteratedValueType);
                        PsiClass collectionClass = JavaPsiFacade.getInstance(body.getProject()).findClass("java.util.Collection", foreachStatement.getResolveScope());
                        if (collectionClass != null && InheritanceUtil.isInheritorOrSelf(iteratorClass, collectionClass, true)) {
                            op = new FlatMapOp(this.myPreviousOp, iteratedValue, this.myVariable, foreachStatement);
                        }
                    }
                    if (op != null) {
                        PsiElement[] statements;
                        PsiStatement lastStatement;
                        TerminalBlock withFlatMap = new TerminalBlock(op, foreachStatement.getIterationParameter(), body);
                        if (ReferencesSearch.search(this.myVariable, new LocalSearchScope(body)).findFirst() == null) {
                            return withFlatMap;
                        }
                        TerminalBlock withFlatMapFilter = withFlatMap.extractFilter();
                        if (withFlatMapFilter != null && !withFlatMapFilter.isEmpty() && (lastStatement = (statements = withFlatMapFilter.getStatements())[statements.length - 1]) instanceof PsiBreakStatement && op.breaksMe((PsiBreakStatement)lastStatement) && ReferencesSearch.search(withFlatMapFilter.getVariable(), new LocalSearchScope(statements)).findFirst() == null) {
                            return new TerminalBlock(new CompoundFilterOp((FilterOp)withFlatMapFilter.getLastOperation(), op), this.myVariable, (PsiStatement[])Arrays.copyOfRange(statements, 0, statements.length - 1));
                        }
                    }
                }
            }
            if (this.myStatements.length >= 1 && (first = this.myStatements[0]) instanceof PsiDeclarationStatement && (elements = (decl = (PsiDeclarationStatement)first).getDeclaredElements()).length == 1 && (element = elements[0]) instanceof PsiLocalVariable && StreamApiMigrationInspection.isSupported((declaredVar = (PsiLocalVariable)element).getType())) {
                PsiExpression initializer = declaredVar.getInitializer();
                PsiElement[] leftOver = Arrays.copyOfRange(this.myStatements, 1, this.myStatements.length);
                if (initializer != null && ReferencesSearch.search(this.myVariable, new LocalSearchScope(leftOver)).findFirst() == null) {
                    MapOp op = new MapOp(this.myPreviousOp, initializer, this.myVariable, declaredVar.getType());
                    return new TerminalBlock(op, declaredVar, (PsiStatement[])leftOver);
                }
            }
            return null;
        }

        @Nullable
        public Operation getLastOperation() {
            return this.myPreviousOp;
        }

        @NotNull
        TerminalBlock extractOperations() {
            TerminalBlock terminalBlock = StreamEx.iterate((Object)this, Objects::nonNull, TerminalBlock::extractOperation).reduce((a, b) -> b).orElse(this);
            if (terminalBlock == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$TerminalBlock", "extractOperations"));
            }
            return terminalBlock;
        }

        @NotNull
        public PsiVariable getVariable() {
            PsiVariable psiVariable = this.myVariable;
            if (psiVariable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$TerminalBlock", "getVariable"));
            }
            return psiVariable;
        }

        public boolean hasOperations() {
            return this.myPreviousOp != null;
        }

        public boolean isEmpty() {
            return this.myStatements.length == 0;
        }

        @NotNull
        private StreamEx<Operation> operations() {
            StreamEx streamEx = StreamEx.iterate((Object)this.myPreviousOp, Objects::nonNull, Operation::getPreviousOp);
            if (streamEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$TerminalBlock", "operations"));
            }
            return streamEx;
        }

        public Collection<Operation> getOperations() {
            ArrayDeque<Operation> ops = new ArrayDeque<Operation>();
            this.operations().forEach(ops::addFirst);
            return ops;
        }

        public StreamEx<PsiExpression> intermediateExpressions() {
            return this.operations().flatMap(Operation::expressions);
        }

        public PsiElement convertToElement(PsiElementFactory factory) {
            if (this.myStatements.length == 1) {
                return this.myStatements[0];
            }
            PsiCodeBlock block = factory.createCodeBlock();
            for (PsiStatement statement : this.myStatements) {
                block.add(statement);
            }
            return block;
        }

        @NotNull
        public static TerminalBlock from(PsiVariable variable, PsiStatement statement) {
            TerminalBlock terminalBlock = new TerminalBlock(null, variable, statement).extractOperations();
            if (terminalBlock == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$TerminalBlock", "from"));
            }
            return terminalBlock;
        }
    }

    static class ArrayFlatMapOp
    extends FlatMapOp {
        ArrayFlatMapOp(@Nullable Operation previousOp, PsiExpression expression, PsiVariable variable, PsiLoopStatement loop) {
            super(previousOp, expression, variable, loop);
        }

        @Override
        public String createReplacement(PsiElementFactory factory) {
            PsiType componentType;
            String operation = "flatMap";
            PsiType type = this.myExpression.getType();
            if (type instanceof PsiArrayType && (componentType = ((PsiArrayType)type).getComponentType()) instanceof PsiPrimitiveType) {
                if (componentType.equals(PsiType.INT)) {
                    operation = "flatMapToInt";
                } else if (componentType.equals(PsiType.LONG)) {
                    operation = "flatMapToLong";
                } else if (componentType.equals(PsiType.DOUBLE)) {
                    operation = "flatMapToDouble";
                }
            }
            return "." + operation + "(" + this.myVariable.getName() + " -> " + this.getStreamExpression() + ")";
        }

        @Override
        @NotNull
        String getStreamExpression() {
            String string = "java.util.Arrays.stream(" + this.myExpression.getText() + ")";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$ArrayFlatMapOp", "getStreamExpression"));
            }
            return string;
        }
    }

    static class FlatMapOp
    extends Operation {
        private final PsiLoopStatement myLoop;

        FlatMapOp(@Nullable Operation previousOp, PsiExpression expression, PsiVariable variable, PsiLoopStatement loop) {
            super(previousOp, expression, variable);
            this.myLoop = loop;
        }

        @Override
        public String createReplacement(PsiElementFactory factory) {
            return ".flatMap(" + this.myVariable.getName() + " -> " + this.getStreamExpression() + ")";
        }

        @NotNull
        String getStreamExpression() {
            String string = this.myExpression.getText() + ".stream()";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$FlatMapOp", "getStreamExpression"));
            }
            return string;
        }

        boolean breaksMe(PsiBreakStatement statement) {
            return statement.findExitedStatement() == this.myLoop;
        }
    }

    static class MapOp
    extends Operation {
        @Nullable
        private final PsiType myType;

        MapOp(@Nullable Operation previousOp, PsiExpression expression, PsiVariable variable, @Nullable PsiType targetType) {
            super(previousOp, expression, variable);
            this.myType = targetType;
        }

        @Override
        public String createReplacement(PsiElementFactory factory) {
            if (StreamApiMigrationInspection.isIdentityMapping(this.myVariable, this.myExpression)) {
                if (!(this.myType instanceof PsiPrimitiveType)) {
                    return this.myVariable.getType() instanceof PsiPrimitiveType ? ".boxed()" : "";
                }
                if (this.myType.equals(this.myVariable.getType())) {
                    return "";
                }
                if (PsiType.LONG.equals(this.myType) && PsiType.INT.equals(this.myVariable.getType())) {
                    return ".asLongStream()";
                }
                if (PsiType.DOUBLE.equals(this.myType) && (PsiType.LONG.equals(this.myVariable.getType()) || PsiType.INT.equals(this.myVariable.getType()))) {
                    return ".asDoubleStream()";
                }
            }
            String operationName = "map";
            if (this.myType instanceof PsiPrimitiveType) {
                if (!this.myType.equals(this.myVariable.getType())) {
                    if (PsiType.INT.equals(this.myType)) {
                        operationName = "mapToInt";
                    } else if (PsiType.LONG.equals(this.myType)) {
                        operationName = "mapToLong";
                    } else if (PsiType.DOUBLE.equals(this.myType)) {
                        operationName = "mapToDouble";
                    }
                }
            } else if (this.myVariable.getType() instanceof PsiPrimitiveType) {
                operationName = "mapToObj";
            }
            PsiExpression expression = this.myType == null ? this.myExpression : ExpressionUtils.convertInitializerToNormalExpression(this.myExpression, this.myType);
            return "." + operationName + "(" + LambdaUtil.createLambda(this.myVariable, expression) + ")";
        }
    }

    static class CompoundFilterOp
    extends FilterOp {
        private final FlatMapOp myFlatMapOp;
        private final PsiVariable myMatchVariable;

        CompoundFilterOp(FilterOp source, FlatMapOp flatMapOp) {
            super(flatMapOp.myPreviousOp, source.getExpression(), flatMapOp.myVariable, source.myNegated);
            this.myMatchVariable = source.myVariable;
            this.myFlatMapOp = flatMapOp;
        }

        @Override
        PsiExpression makeIntermediateExpression(PsiElementFactory factory) {
            return factory.createExpressionFromText(this.myFlatMapOp.getStreamExpression() + ".anyMatch(" + LambdaUtil.createLambda(this.myMatchVariable, this.myExpression) + ")", this.myExpression);
        }

        @Override
        StreamEx<PsiExpression> expressions() {
            return StreamEx.of((Object[])new PsiExpression[]{this.myExpression, this.myFlatMapOp.myExpression});
        }
    }

    static class FilterOp
    extends Operation {
        private final boolean myNegated;

        FilterOp(@Nullable Operation previousOp, PsiExpression condition, PsiVariable variable, boolean negated) {
            super(previousOp, condition, variable);
            this.myNegated = negated;
        }

        public boolean isNegated() {
            return this.myNegated;
        }

        @Override
        public String createReplacement(PsiElementFactory factory) {
            PsiExpression intermediate = this.makeIntermediateExpression(factory);
            PsiExpression expression = this.myNegated ? factory.createExpressionFromText(BoolUtils.getNegatedExpressionText(intermediate), this.myExpression) : intermediate;
            return ".filter(" + LambdaUtil.createLambda(this.myVariable, expression) + ")";
        }

        PsiExpression makeIntermediateExpression(PsiElementFactory factory) {
            return this.myExpression;
        }
    }

    static abstract class Operation {
        final PsiExpression myExpression;
        final PsiVariable myVariable;
        @Nullable
        final Operation myPreviousOp;

        protected Operation(@Nullable Operation previousOp, PsiExpression expression, PsiVariable variable) {
            this.myExpression = expression;
            this.myVariable = variable;
            this.myPreviousOp = previousOp;
        }

        public PsiVariable getVariable() {
            return this.myVariable;
        }

        @Nullable
        public Operation getPreviousOp() {
            return this.myPreviousOp;
        }

        PsiExpression getExpression() {
            return this.myExpression;
        }

        StreamEx<PsiExpression> expressions() {
            return StreamEx.of((Object)this.myExpression);
        }

        abstract String createReplacement(PsiElementFactory var1);
    }

    private class StreamApiMigrationVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;
        private final boolean myIsOnTheFly;

        public StreamApiMigrationVisitor(ProblemsHolder holder, boolean isOnTheFly) {
            this.myHolder = holder;
            this.myIsOnTheFly = isOnTheFly;
        }

        @Override
        public void visitForeachStatement(PsiForeachStatement statement) {
            ControlFlow controlFlow;
            boolean isArray;
            super.visitForeachStatement(statement);
            PsiExpression iteratedValue = statement.getIteratedValue();
            PsiStatement body = statement.getBody();
            if (iteratedValue == null || body == null) {
                return;
            }
            PsiType iteratedValueType = iteratedValue.getType();
            PsiClass iteratorClass = PsiUtil.resolveClassInClassTypeOnly(iteratedValueType);
            PsiClass collectionClass = null;
            if (iteratedValueType instanceof PsiArrayType) {
                if (!StreamApiMigrationInspection.isSupported(((PsiArrayType)iteratedValueType).getComponentType())) {
                    return;
                }
                isArray = true;
            } else {
                collectionClass = JavaPsiFacade.getInstance(body.getProject()).findClass("java.util.Collection", statement.getResolveScope());
                if (collectionClass != null && InheritanceUtil.isInheritorOrSelf(iteratorClass, collectionClass, true)) {
                    isArray = false;
                } else {
                    return;
                }
            }
            if (!ExceptionUtil.getThrownCheckedExceptions(body).isEmpty()) {
                return;
            }
            TerminalBlock tb = TerminalBlock.from(statement.getIterationParameter(), body);
            if (tb.isEmpty()) {
                return;
            }
            try {
                controlFlow = ControlFlowFactory.getInstance(this.myHolder.getProject()).getControlFlow(body, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
            }
            catch (AnalysisCanceledException ignored) {
                return;
            }
            Collection<PsiStatement> exitPoints = ControlFlowUtil.findExitPointsAndStatements(controlFlow, tb.getStartOffset(controlFlow), tb.getEndOffset(controlFlow), new IntArrayList(), PsiContinueStatement.class, PsiBreakStatement.class, PsiReturnStatement.class, PsiThrowStatement.class);
            int startOffset = controlFlow.getStartOffset(body);
            int endOffset = controlFlow.getEndOffset(body);
            List nonFinalVariables = ((StreamEx)StreamEx.of(ControlFlowUtil.getUsedVariables(controlFlow, startOffset, endOffset)).remove(variable -> HighlightControlFlowUtil.isEffectivelyFinal(variable, body, null))).toList();
            if (exitPoints.isEmpty()) {
                if (StreamApiMigrationInspection.getIncrementedVariable(tb, nonFinalVariables) != null) {
                    this.registerProblem(statement, "count", new ReplaceWithCountFix());
                }
                if (StreamApiMigrationInspection.getAccumulatedVariable(tb, nonFinalVariables) != null) {
                    this.registerProblem(statement, "sum", new ReplaceWithSumFix());
                }
                if (!nonFinalVariables.isEmpty()) {
                    return;
                }
                if ((isArray || !this.isRawSubstitution(iteratedValueType, collectionClass)) && StreamApiMigrationInspection.isCollectCall(tb)) {
                    String methodName;
                    boolean addAll;
                    boolean bl = addAll = !tb.hasOperations() && StreamApiMigrationInspection.isAddAllCall(tb);
                    if (addAll) {
                        methodName = "addAll";
                    } else {
                        PsiMethodCallExpression methodCallExpression = tb.getSingleMethodCall();
                        if (this.canCollect(statement, methodCallExpression)) {
                            methodName = StreamApiMigrationInspection.extractToArrayExpression(statement, methodCallExpression) != null ? "toArray" : "collect";
                        } else {
                            if (!StreamApiMigrationInspection.this.SUGGEST_FOREACH) {
                                return;
                            }
                            methodName = "forEach";
                        }
                    }
                    this.registerProblem(statement, methodName, new ReplaceWithCollectFix(methodName));
                } else if (StreamApiMigrationInspection.this.SUGGEST_FOREACH && (tb.hasOperations() || !isArray && (StreamApiMigrationInspection.this.REPLACE_TRIVIAL_FOREACH || !StreamApiMigrationInspection.isTrivial(body, statement.getIterationParameter())))) {
                    ReplaceWithForeachCallFix forEachFix = new ReplaceWithForeachCallFix("forEach");
                    LocalQuickFix[] fixes = new LocalQuickFix[]{forEachFix};
                    if (tb.hasOperations()) {
                        fixes = new LocalQuickFix[]{forEachFix, new ReplaceWithForeachCallFix("forEachOrdered")};
                    }
                    this.registerProblem(statement, "forEach", fixes);
                }
            } else {
                if (!tb.hasOperations() && !StreamApiMigrationInspection.this.REPLACE_TRIVIAL_FOREACH) {
                    return;
                }
                if (nonFinalVariables.isEmpty() && tb.getSingleStatement() instanceof PsiReturnStatement) {
                    this.handleSingleReturn(statement, tb);
                }
                if (tb.intermediateExpressions().flatCollection(expr -> PsiTreeUtil.collectElementsOfType(expr, PsiReferenceExpression.class)).map(PsiReference::resolve).anyMatch(nonFinalVariables::contains)) {
                    return;
                }
                PsiElement[] statements = tb.getStatements();
                if (statements.length == 2) {
                    PsiStatement breakStatement = statements[1];
                    if (!ControlFlowUtils.statementBreaksLoop(breakStatement, statement)) {
                        return;
                    }
                    if (ReferencesSearch.search(tb.getVariable(), new LocalSearchScope(statements)).findFirst() == null && exitPoints.size() == 1 && exitPoints.contains(breakStatement)) {
                        this.registerProblem(statement, "anyMatch", new ReplaceWithMatchFix("anyMatch"));
                        return;
                    }
                    if (nonFinalVariables.isEmpty() && statements[0] instanceof PsiExpressionStatement) {
                        this.registerProblem(statement, "findFirst", new ReplaceWithFindFirstFix());
                    } else if (nonFinalVariables.size() == 1) {
                        PsiAssignmentExpression assignment = ExpressionUtils.getAssignment(statements[0]);
                        if (assignment == null) {
                            return;
                        }
                        PsiExpression lValue = assignment.getLExpression();
                        if (!(lValue instanceof PsiReferenceExpression)) {
                            return;
                        }
                        PsiElement var = ((PsiReferenceExpression)lValue).resolve();
                        if (!(var instanceof PsiVariable) || !nonFinalVariables.contains(var)) {
                            return;
                        }
                        PsiExpression rValue = assignment.getRExpression();
                        if (rValue == null || StreamApiMigrationInspection.isVariableReferenced((PsiVariable)var, rValue)) {
                            return;
                        }
                        if (tb.getVariable().getType() instanceof PsiPrimitiveType && !StreamApiMigrationInspection.isIdentityMapping(tb.getVariable(), rValue)) {
                            return;
                        }
                        this.registerProblem(statement, "findFirst", new ReplaceWithFindFirstFix());
                    }
                }
            }
        }

        boolean canCollect(PsiForeachStatement statement, PsiMethodCallExpression methodCallExpression) {
            if (methodCallExpression == null) {
                return false;
            }
            PsiLocalVariable variable = StreamApiMigrationInspection.extractCollectionVariable(methodCallExpression.getMethodExpression().getQualifierExpression());
            if (variable == null) {
                return false;
            }
            return StreamApiMigrationInspection.getInitializerUsageStatus(variable, statement) != InitializerUsageStatus.UNKNOWN;
        }

        void handleSingleReturn(PsiForeachStatement statement, TerminalBlock tb) {
            PsiReturnStatement returnStatement = (PsiReturnStatement)tb.getSingleStatement();
            PsiExpression value = returnStatement.getReturnValue();
            PsiReturnStatement nextReturnStatement = StreamApiMigrationInspection.getNextReturnStatement(statement);
            if (nextReturnStatement != null && (ExpressionUtils.isLiteral(value, Boolean.TRUE) || ExpressionUtils.isLiteral(value, Boolean.FALSE))) {
                boolean foundResult = (Boolean)((PsiLiteralExpression)value).getValue();
                if (ExpressionUtils.isLiteral(nextReturnStatement.getReturnValue(), !foundResult)) {
                    String methodName;
                    if (foundResult) {
                        methodName = "anyMatch";
                    } else {
                        methodName = "noneMatch";
                        Operation lastOp = tb.getLastOperation();
                        if (lastOp instanceof FilterOp && ((FilterOp)lastOp).isNegated() ^ BoolUtils.isNegation(lastOp.getExpression())) {
                            methodName = "allMatch";
                        }
                    }
                    this.registerProblem(statement, methodName, new ReplaceWithMatchFix(methodName));
                    return;
                }
            }
            if (!StreamApiMigrationInspection.isVariableReferenced(tb.getVariable(), value)) {
                Operation lastOp = tb.getLastOperation();
                if (!StreamApiMigrationInspection.this.REPLACE_TRIVIAL_FOREACH && lastOp == null || lastOp instanceof FilterOp && lastOp.getPreviousOp() == null) {
                    return;
                }
                this.registerProblem(statement, "anyMatch", new ReplaceWithMatchFix("anyMatch"));
            }
            if (nextReturnStatement != null && ExpressionUtils.isSimpleExpression(nextReturnStatement.getReturnValue()) && (!(tb.getVariable().getType() instanceof PsiPrimitiveType) || StreamApiMigrationInspection.isIdentityMapping(tb.getVariable(), value))) {
                this.registerProblem(statement, "findFirst", new ReplaceWithFindFirstFix());
            }
        }

        private boolean isRawSubstitution(PsiType iteratedValueType, PsiClass collectionClass) {
            return iteratedValueType instanceof PsiClassType && PsiUtil.isRawSubstitutor(collectionClass, TypeConversionUtil.getSuperClassSubstitutor(collectionClass, (PsiClassType)iteratedValueType));
        }

        @NotNull
        private TextRange getRange(PsiForeachStatement statement) {
            boolean wholeStatement = false;
            if (this.myIsOnTheFly) {
                if (StreamApiMigrationInspection.this.myKey == null) {
                    StreamApiMigrationInspection.this.myKey = HighlightDisplayKey.find(StreamApiMigrationInspection.this.getShortName());
                }
                if (StreamApiMigrationInspection.this.myKey != null) {
                    InspectionProfile profile = InspectionProjectProfileManager.getInstance(statement.getProject()).getCurrentProfile();
                    HighlightDisplayLevel level = profile.getErrorLevel(StreamApiMigrationInspection.this.myKey, statement);
                    wholeStatement = HighlightDisplayLevel.DO_NOT_SHOW.equals(level);
                }
            }
            PsiExpression iteratedValue = statement.getIteratedValue();
            LOG.assertTrue(iteratedValue != null);
            PsiJavaToken rParenth = statement.getRParenth();
            if (wholeStatement && rParenth != null) {
                TextRange textRange = new TextRange(statement.getTextOffset(), rParenth.getTextOffset() + 1);
                if (textRange == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$StreamApiMigrationVisitor", "getRange"));
                }
                return textRange;
            }
            TextRange textRange = iteratedValue.getTextRange();
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$StreamApiMigrationVisitor", "getRange"));
            }
            return textRange;
        }

        private void registerProblem(PsiForeachStatement statement, String methodName, LocalQuickFix ... fixes) {
            PsiExpression iteratedValue = statement.getIteratedValue();
            LOG.assertTrue(iteratedValue != null);
            this.myHolder.registerProblem((PsiElement)statement, this.getRange(statement).shiftRight(-statement.getTextOffset()), "Can be replaced with '" + methodName + "' call", fixes);
        }
    }

    static enum InitializerUsageStatus {
        DECLARED_JUST_BEFORE,
        AT_WANTED_PLACE_ONLY,
        AT_WANTED_PLACE,
        UNKNOWN;

    }
}

