/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.CallInstruction;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.Instruction;
import com.intellij.psi.controlFlow.InstructionKey;
import com.intellij.psi.controlFlow.ReadVariableInstruction;
import com.intellij.psi.controlFlow.ReturnInstruction;
import com.intellij.psi.controlFlow.WriteVariableInstruction;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.containers.Queue;
import com.intellij.util.containers.Stack;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefUseUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.defUse.DefUseUtil");
    private static final ControlFlowPolicy ourPolicy = new ControlFlowPolicy(){

        @Override
        public PsiVariable getUsedVariable(@NotNull PsiReferenceExpression refExpr) {
            if (refExpr == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refExpr", "com/intellij/psi/controlFlow/DefUseUtil$3", "getUsedVariable"));
            }
            if (refExpr.isQualified()) {
                return null;
            }
            PsiElement refElement = refExpr.resolve();
            if (refElement instanceof PsiLocalVariable || refElement instanceof PsiParameter) {
                return (PsiVariable)refElement;
            }
            return null;
        }

        @Override
        public boolean isParameterAccepted(@NotNull PsiParameter psiParameter) {
            if (psiParameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiParameter", "com/intellij/psi/controlFlow/DefUseUtil$3", "isParameterAccepted"));
            }
            return true;
        }

        @Override
        public boolean isLocalVariableAccepted(@NotNull PsiLocalVariable psiVariable) {
            if (psiVariable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiVariable", "com/intellij/psi/controlFlow/DefUseUtil$3", "isLocalVariableAccepted"));
            }
            return true;
        }
    };

    private DefUseUtil() {
    }

    @Nullable
    public static List<Info> getUnusedDefs(PsiCodeBlock body, Set<PsiVariable> outUsedVariables) {
        ControlFlow flow;
        if (body == null) {
            return null;
        }
        try {
            flow = ControlFlowFactory.getInstance(body.getProject()).getControlFlow(body, ourPolicy);
        }
        catch (AnalysisCanceledException e) {
            return null;
        }
        List<Instruction> instructions = flow.getInstructions();
        if (LOG.isDebugEnabled()) {
            LOG.debug(flow.toString());
        }
        THashSet assignedVariables = new THashSet();
        THashSet readVariables = new THashSet();
        for (int i2 = 0; i2 < instructions.size(); ++i2) {
            Instruction instruction = instructions.get(i2);
            ProgressManager.checkCanceled();
            if (instruction instanceof WriteVariableInstruction) {
                WriteVariableInstruction writeInstruction = (WriteVariableInstruction)instruction;
                PsiElement context = flow.getElement(i2);
                context = PsiTreeUtil.getParentOfType(context, PsiStatement.class, false);
                PsiVariable psiVariable = writeInstruction.variable;
                if (context == null || context instanceof PsiDeclarationStatement && psiVariable.getInitializer() == null) continue;
                assignedVariables.add(psiVariable);
                continue;
            }
            if (!(instruction instanceof ReadVariableInstruction)) continue;
            ReadVariableInstruction readInstruction = (ReadVariableInstruction)instruction;
            readVariables.add(readInstruction.variable);
        }
        Map<InstructionKey, InstructionState> stateMap = DefUseUtil.getStates(instructions);
        Object[] states = stateMap.values().toArray(new InstructionState[0]);
        Arrays.sort(states);
        BitSet usefulWrites = new BitSet(instructions.size());
        Queue<Object> queue = new Queue<Object>(8);
        for (int i3 = states.length - 1; i3 >= 0; --i3) {
            Object outerState = states[i3];
            if (((InstructionState)outerState).isVisited()) continue;
            ((InstructionState)outerState).touch();
            for (PsiVariable psiVariable : assignedVariables) {
                if (!(psiVariable instanceof PsiField)) continue;
                ((InstructionState)outerState).addUsed(psiVariable);
            }
            queue.addLast(outerState);
            while (!queue.isEmpty()) {
                ProgressManager.checkCanceled();
                InstructionState state = (InstructionState)queue.pullFirst();
                state.markVisited();
                InstructionKey key = state.getInstructionKey();
                if (key.getOffset() < instructions.size()) {
                    Instruction instruction = instructions.get(key.getOffset());
                    if (instruction instanceof WriteVariableInstruction) {
                        WriteVariableInstruction writeInstruction = (WriteVariableInstruction)instruction;
                        PsiVariable psiVariable = writeInstruction.variable;
                        outUsedVariables.add(psiVariable);
                        if (state.removeUsed(psiVariable)) {
                            usefulWrites.set(key.getOffset());
                        }
                    } else if (instruction instanceof ReadVariableInstruction) {
                        ReadVariableInstruction readInstruction = (ReadVariableInstruction)instruction;
                        state.addUsed(readInstruction.variable);
                        outUsedVariables.add(readInstruction.variable);
                    } else {
                        state.touch();
                    }
                }
                List<InstructionKey> backwardTraces = state.getBackwardTraces();
                for (InstructionKey prevKeys : backwardTraces) {
                    InstructionState prevState = stateMap.get(prevKeys);
                    if (prevState == null || prevState.contains(state)) continue;
                    prevState.addUsedFrom(state);
                    queue.addLast(prevState);
                }
            }
        }
        ArrayList<Info> unusedDefs = new ArrayList<Info>();
        for (int i4 = 0; i4 < instructions.size(); ++i4) {
            Instruction instruction = instructions.get(i4);
            if (!(instruction instanceof WriteVariableInstruction)) continue;
            WriteVariableInstruction writeInstruction = (WriteVariableInstruction)instruction;
            if (usefulWrites.get(i4)) continue;
            Object context = PsiTreeUtil.getNonStrictParentOfType(flow.getElement(i4), PsiStatement.class, PsiAssignmentExpression.class, PsiPostfixExpression.class, PsiPrefixExpression.class);
            PsiVariable psiVariable = writeInstruction.variable;
            if (context == null || context instanceof PsiTryStatement) continue;
            if (context instanceof PsiDeclarationStatement && psiVariable.getInitializer() == null) {
                if (assignedVariables.contains(psiVariable)) continue;
                unusedDefs.add(new Info(psiVariable, (PsiElement)context, false));
                continue;
            }
            unusedDefs.add(new Info(psiVariable, (PsiElement)context, readVariables.contains(psiVariable)));
        }
        return unusedDefs;
    }

    @NotNull
    public static PsiElement[] getDefs(PsiCodeBlock body, final PsiVariable def, PsiElement ref) {
        PsiElement[] psiElementArray;
        try {
            RefsDefs refsDefs = new RefsDefs(body){
                private final IntArrayList[] myBackwardTraces;
                {
                    super(body);
                    this.myBackwardTraces = DefUseUtil.getBackwardTraces(this.instructions);
                }

                @Override
                protected int nNext(int index) {
                    return this.myBackwardTraces[index].size();
                }

                @Override
                protected int getNext(int index, int no) {
                    return this.myBackwardTraces[index].get(no);
                }

                @Override
                protected boolean defs() {
                    return true;
                }

                @Override
                protected void processInstruction(final Set<PsiElement> res, Instruction instruction, int index) {
                    if (instruction instanceof WriteVariableInstruction) {
                        WriteVariableInstruction instructionW = (WriteVariableInstruction)instruction;
                        if (instructionW.variable == def) {
                            PsiElement element = this.flow.getElement(index);
                            element.accept(new JavaRecursiveElementWalkingVisitor(){

                                @Override
                                public void visitReferenceExpression(PsiReferenceExpression ref) {
                                    if (PsiUtil.isAccessedForWriting(ref) && ref.resolve() == def) {
                                        res.add(ref);
                                    }
                                }

                                @Override
                                public void visitVariable(PsiVariable var) {
                                    if (var == def && (var instanceof PsiParameter || var.hasInitializer())) {
                                        res.add(var);
                                    }
                                }
                            });
                        }
                    }
                }
            };
            psiElementArray = refsDefs.get(def, ref);
        }
        catch (AnalysisCanceledException e) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/DefUseUtil", "getDefs"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/DefUseUtil", "getDefs"));
        }
        return psiElementArray;
    }

    @NotNull
    public static PsiElement[] getRefs(PsiCodeBlock body, final PsiVariable def, PsiElement ref) {
        PsiElement[] psiElementArray;
        try {
            RefsDefs refsDefs = new RefsDefs(body){

                @Override
                protected int nNext(int index) {
                    return ((Instruction)this.instructions.get(index)).nNext();
                }

                @Override
                protected int getNext(int index, int no) {
                    return ((Instruction)this.instructions.get(index)).getNext(index, no);
                }

                @Override
                protected boolean defs() {
                    return false;
                }

                @Override
                protected void processInstruction(final Set<PsiElement> res, Instruction instruction, int index) {
                    if (instruction instanceof ReadVariableInstruction) {
                        ReadVariableInstruction instructionR = (ReadVariableInstruction)instruction;
                        if (instructionR.variable == def) {
                            PsiElement element = this.flow.getElement(index);
                            element.accept(new JavaRecursiveElementWalkingVisitor(){

                                @Override
                                public void visitReferenceExpression(PsiReferenceExpression ref) {
                                    if (ref.resolve() == def) {
                                        res.add(ref);
                                    }
                                }
                            });
                        }
                    }
                }
            };
            psiElementArray = refsDefs.get(def, ref);
        }
        catch (AnalysisCanceledException e) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/DefUseUtil", "getRefs"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/DefUseUtil", "getRefs"));
        }
        return psiElementArray;
    }

    private static IntArrayList[] getBackwardTraces(List<Instruction> instructions) {
        int i2;
        IntArrayList[] states = new IntArrayList[instructions.size()];
        for (i2 = 0; i2 < states.length; ++i2) {
            states[i2] = new IntArrayList();
        }
        for (i2 = 0; i2 < instructions.size(); ++i2) {
            Instruction instruction = instructions.get(i2);
            for (int j = 0; j != instruction.nNext(); ++j) {
                int next = instruction.getNext(i2, j);
                if (next >= states.length) continue;
                states[next].add(i2);
            }
        }
        return states;
    }

    private static Map<InstructionKey, InstructionState> getStates(List<Instruction> instructions) {
        class Walker {
            private final Map<InstructionKey, InstructionState> myStates;
            private final 1WalkThroughStack myWalkThroughStack;
            final /* synthetic */ List val$instructions;

            Walker(List list) {
                this.val$instructions = list;
                this.myStates = new THashMap(this.val$instructions.size());
                class WalkThroughStack {
                    private final Stack<InstructionKey> myFrom;
                    private final Stack<InstructionKey> myNext;

                    WalkThroughStack(int size) {
                        if (size < 2) {
                            size = 2;
                        }
                        this.myFrom = new Stack(size);
                        this.myNext = new Stack(size);
                    }

                    void push(InstructionKey fromKey, InstructionKey nextKey) {
                        this.myFrom.push(fromKey);
                        this.myNext.push(nextKey);
                    }

                    InstructionKey peekFrom() {
                        return this.myFrom.peek();
                    }

                    InstructionKey popNext() {
                        this.myFrom.pop();
                        return this.myNext.pop();
                    }

                    boolean isEmpty() {
                        return this.myFrom.isEmpty();
                    }
                }
                this.myWalkThroughStack = new WalkThroughStack(this.val$instructions.size() / 2);
            }

            Map<InstructionKey, InstructionState> walk() {
                InstructionKey startKey = InstructionKey.create(0);
                this.myStates.put(startKey, new InstructionState(startKey));
                this.myWalkThroughStack.push(InstructionKey.create(-1), startKey);
                THashSet visited = new THashSet(this.val$instructions.size());
                while (!this.myWalkThroughStack.isEmpty()) {
                    InstructionKey fromKey = this.myWalkThroughStack.peekFrom();
                    InstructionKey nextKey = this.myWalkThroughStack.popNext();
                    this.addBackwardTrace(fromKey, nextKey);
                    if (visited.contains(nextKey)) continue;
                    this.visit(nextKey);
                    visited.add(nextKey);
                }
                return this.myStates;
            }

            private void visit(InstructionKey fromKey) {
                if (fromKey.getOffset() >= this.val$instructions.size()) {
                    return;
                }
                Instruction instruction = (Instruction)this.val$instructions.get(fromKey.getOffset());
                if (instruction instanceof CallInstruction) {
                    int nextOffset = ((CallInstruction)instruction).offset;
                    LOG.assertTrue(nextOffset != 0);
                    int returnOffset = fromKey.getOffset() + 1;
                    InstructionKey nextKey = fromKey.push(nextOffset, returnOffset);
                    this.myWalkThroughStack.push(fromKey, nextKey);
                } else if (instruction instanceof ReturnInstruction) {
                    int overriddenOffset = ((ReturnInstruction)instruction).offset;
                    InstructionKey nextKey = fromKey.pop(overriddenOffset);
                    this.myWalkThroughStack.push(fromKey, nextKey);
                } else {
                    for (int no = 0; no != instruction.nNext(); ++no) {
                        int nextOffset = instruction.getNext(fromKey.getOffset(), no);
                        InstructionKey nextKey = fromKey.next(nextOffset);
                        this.myWalkThroughStack.push(fromKey, nextKey);
                    }
                }
            }

            private void addBackwardTrace(InstructionKey fromKey, InstructionKey nextKey) {
                if (fromKey.getOffset() >= 0 && nextKey.getOffset() < this.val$instructions.size()) {
                    InstructionState state = this.myStates.get(nextKey);
                    if (state == null) {
                        state = new InstructionState(nextKey);
                        this.myStates.put(nextKey, state);
                    }
                    state.addBackwardTrace(fromKey);
                }
            }
        }
        return new Walker(instructions).walk();
    }

    private static abstract class RefsDefs {
        final List<Instruction> instructions;
        final ControlFlow flow;
        final PsiCodeBlock body;

        protected abstract int nNext(int var1);

        protected abstract int getNext(int var1, int var2);

        protected RefsDefs(PsiCodeBlock body) throws AnalysisCanceledException {
            this.body = body;
            this.flow = ControlFlowFactory.getInstance(body.getProject()).getControlFlow(body, ourPolicy);
            this.instructions = this.flow.getInstructions();
        }

        protected abstract void processInstruction(Set<PsiElement> var1, Instruction var2, int var3);

        protected abstract boolean defs();

        @NotNull
        private PsiElement[] get(PsiVariable def, PsiElement refOrDef) {
            int elem;
            if (this.body == null) {
                if (PsiElement.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/DefUseUtil$RefsDefs", "get"));
                }
                return PsiElement.EMPTY_ARRAY;
            }
            final boolean[] visited = new boolean[this.instructions.size() + 1];
            visited[visited.length - 1] = true;
            int n = elem = this.defs() ? this.flow.getStartOffset(refOrDef) : this.flow.getEndOffset(refOrDef);
            if (elem == -1 && def instanceof PsiParameter) {
                elem = 0;
            }
            if (elem != -1) {
                if (!this.defs() && this.instructions.get(elem) instanceof ReadVariableInstruction) {
                    LOG.assertTrue(this.nNext(elem) == 1);
                    LOG.assertTrue(this.getNext(elem, 0) == elem + 1);
                    ++elem;
                }
                THashSet res = new THashSet();
                class Inner {
                    final /* synthetic */ Set val$res;
                    final /* synthetic */ PsiVariable val$def;

                    Inner() {
                        this.val$res = set;
                        this.val$def = psiVariable;
                    }

                    void traverse(int index) {
                        visited[index] = true;
                        if (RefsDefs.this.defs()) {
                            Instruction instruction = RefsDefs.this.instructions.get(index);
                            RefsDefs.this.processInstruction(this.val$res, instruction, index);
                            if (instruction instanceof WriteVariableInstruction) {
                                WriteVariableInstruction instructionW = (WriteVariableInstruction)instruction;
                                if (instructionW.variable == this.val$def) {
                                    return;
                                }
                            }
                            if (index == 0 && this.val$def instanceof PsiParameter) {
                                this.val$res.add(this.val$def.getNameIdentifier());
                            }
                        }
                        int nNext = RefsDefs.this.nNext(index);
                        for (int i2 = 0; i2 < nNext; ++i2) {
                            int prev = RefsDefs.this.getNext(index, i2);
                            if (visited[prev]) continue;
                            if (!RefsDefs.this.defs()) {
                                Instruction instruction = RefsDefs.this.instructions.get(prev);
                                if (instruction instanceof WriteVariableInstruction) {
                                    WriteVariableInstruction instructionW = (WriteVariableInstruction)instruction;
                                    if (instructionW.variable == this.val$def) {
                                        continue;
                                    }
                                } else {
                                    RefsDefs.this.processInstruction(this.val$res, instruction, prev);
                                }
                            }
                            this.traverse(prev);
                        }
                    }
                }
                new Inner().traverse(elem);
                PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray((Collection<? extends PsiElement>)res);
                if (psiElementArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/DefUseUtil$RefsDefs", "get"));
                }
                return psiElementArray;
            }
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/DefUseUtil$RefsDefs", "get"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
    }

    private static class InstructionState
    implements Comparable<InstructionState> {
        private Set<PsiVariable> myUsed;
        private final InstructionKey myInstructionKey;
        private final List<InstructionKey> myBackwardTraces;
        private boolean myIsVisited;

        public InstructionState(@NotNull InstructionKey instructionKey) {
            if (instructionKey == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instructionKey", "com/intellij/psi/controlFlow/DefUseUtil$InstructionState", "<init>"));
            }
            this.myInstructionKey = instructionKey;
            this.myBackwardTraces = new ArrayList<InstructionKey>(2);
            this.myUsed = null;
        }

        public void addBackwardTrace(InstructionKey key) {
            this.myBackwardTraces.add(key);
        }

        public List<InstructionKey> getBackwardTraces() {
            return this.myBackwardTraces;
        }

        public InstructionKey getInstructionKey() {
            return this.myInstructionKey;
        }

        void addUsed(PsiVariable psiVariable) {
            this.touch();
            this.myUsed.add(psiVariable);
        }

        boolean removeUsed(PsiVariable psiVariable) {
            this.touch();
            return this.myUsed.remove(psiVariable);
        }

        private void touch() {
            if (this.myUsed == null) {
                this.myUsed = new THashSet();
            }
        }

        public void addUsedFrom(InstructionState state) {
            this.touch();
            this.myUsed.addAll(state.myUsed);
        }

        public boolean contains(InstructionState state) {
            return this.myUsed != null && state.myUsed != null && this.myUsed.containsAll(state.myUsed);
        }

        public void markVisited() {
            this.myIsVisited = true;
        }

        public boolean isVisited() {
            return this.myIsVisited;
        }

        @Override
        public int compareTo(@NotNull InstructionState other) {
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/psi/controlFlow/DefUseUtil$InstructionState", "compareTo"));
            }
            return this.myInstructionKey.compareTo(other.myInstructionKey);
        }

        public String toString() {
            return this.myInstructionKey + " " + this.myBackwardTraces + (this.myIsVisited ? "(v)" : "(n)") + " " + (this.myUsed != null ? this.myUsed : "-");
        }
    }

    public static class Info {
        private final PsiVariable myVariable;
        private final PsiElement myContext;
        private final boolean myIsRead;

        public Info(PsiVariable variable, PsiElement context, boolean read) {
            this.myVariable = variable;
            this.myContext = context;
            this.myIsRead = read;
        }

        public PsiVariable getVariable() {
            return this.myVariable;
        }

        public PsiElement getContext() {
            return this.myContext;
        }

        public boolean isRead() {
            return this.myIsRead;
        }
    }
}

