/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file.impl;

import com.intellij.ProjectTopics;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.impl.java.stubs.index.JavaFullClassNameIndex;
import com.intellij.psi.impl.java.stubs.index.JavaModuleNameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class JavaFileManagerImpl
implements JavaFileManager,
Disposable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.file.impl.JavaFileManagerImpl");
    private final PsiManagerEx myManager;
    private volatile Set<String> myNontrivialPackagePrefixes;
    private boolean myDisposed;
    private final PackageIndex myPackageIndex;

    public JavaFileManagerImpl(Project project) {
        this.myManager = PsiManagerEx.getInstanceEx(project);
        this.myPackageIndex = PackageIndex.getInstance(this.myManager.getProject());
        project.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, new ModuleRootAdapter(){

            @Override
            public void rootsChanged(ModuleRootEvent event) {
                JavaFileManagerImpl.this.myNontrivialPackagePrefixes = null;
            }
        });
    }

    @Override
    public void dispose() {
        this.myDisposed = true;
    }

    @Override
    @Nullable
    public PsiPackage findPackage(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "findPackage"));
        }
        Query<VirtualFile> dirs = this.myPackageIndex.getDirsByPackageName(packageName, true);
        if (dirs.findFirst() == null) {
            return null;
        }
        return new PsiPackageImpl(this.myManager, packageName);
    }

    @Override
    @NotNull
    public PsiClass[] findClasses(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "findClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "findClasses"));
        }
        List<Pair<PsiClass, VirtualFile>> result = this.doFindClasses(qName, scope);
        int count = result.size();
        if (count == 0) {
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "findClasses"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        if (count == 1) {
            PsiClass[] psiClassArray = new PsiClass[]{result.get(0).getFirst()};
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "findClasses"));
            }
            return psiClassArray;
        }
        ContainerUtil.quickSort(result, (o1, o2) -> {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "lambda$findClasses$0"));
            }
            return scope.compare((VirtualFile)o2.getSecond(), (VirtualFile)o1.getSecond());
        });
        PsiClass[] psiClassArray = (PsiClass[])result.stream().map(p -> (PsiClass)p.getFirst()).toArray(PsiClass[]::new);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "findClasses"));
        }
        return psiClassArray;
    }

    @NotNull
    private List<Pair<PsiClass, VirtualFile>> doFindClasses(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "doFindClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "doFindClasses"));
        }
        Collection<PsiClass> classes = JavaFullClassNameIndex.getInstance().get(qName.hashCode(), this.myManager.getProject(), scope);
        if (classes.isEmpty()) {
            List<Pair<PsiClass, VirtualFile>> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "doFindClasses"));
            }
            return list;
        }
        ArrayList<Pair<PsiClass, VirtualFile>> result = new ArrayList<Pair<PsiClass, VirtualFile>>(classes.size());
        for (PsiClass aClass : classes) {
            String qualifiedName = aClass.getQualifiedName();
            if (qualifiedName == null || !qualifiedName.equals(qName)) continue;
            PsiFile file = aClass.getContainingFile();
            if (file == null) {
                throw new AssertionError((Object)("No file for class: " + aClass + " of " + aClass.getClass()));
            }
            boolean valid = file.isValid();
            VirtualFile vFile = file.getVirtualFile();
            if (!valid) {
                LOG.error("Invalid file " + file + "; virtualFile:" + vFile + (vFile != null && !vFile.isValid() ? " (invalid)" : "") + "; id=" + (vFile == null ? 0 : ((VirtualFileWithId)((Object)vFile)).getId()), new PsiInvalidElementAccessException(aClass));
                continue;
            }
            if (!this.hasAcceptablePackage(vFile)) continue;
            result.add(Pair.create(aClass, vFile));
        }
        ArrayList<Pair<PsiClass, VirtualFile>> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "doFindClasses"));
        }
        return arrayList;
    }

    @Override
    @Nullable
    public PsiClass findClass(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "findClass"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "findClass"));
        }
        LOG.assertTrue(!this.myDisposed);
        VirtualFile bestFile = null;
        PsiClass bestClass = null;
        List<Pair<PsiClass, VirtualFile>> result = this.doFindClasses(qName, scope);
        for (int i2 = 0; i2 < result.size(); ++i2) {
            Pair<PsiClass, VirtualFile> pair = result.get(i2);
            VirtualFile vFile = pair.getSecond();
            if (bestFile != null && scope.compare(vFile, bestFile) <= 0) continue;
            bestFile = vFile;
            bestClass = pair.getFirst();
        }
        return bestClass;
    }

    private boolean hasAcceptablePackage(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "hasAcceptablePackage"));
        }
        if (vFile.getFileType() == JavaClassFileType.INSTANCE) {
            VirtualFile root = ProjectRootManager.getInstance(this.myManager.getProject()).getFileIndex().getClassRootForFile(vFile);
            PsiNameHelper nameHelper = PsiNameHelper.getInstance(this.myManager.getProject());
            for (VirtualFile parent = vFile.getParent(); parent != null && !Comparing.equal(parent, root); parent = parent.getParent()) {
                if (nameHelper.isIdentifier(parent.getName())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @NotNull
    public Collection<String> getNonTrivialPackagePrefixes() {
        Set<String> names = this.myNontrivialPackagePrefixes;
        if (names == null) {
            names = new HashSet<String>();
            ProjectRootManager rootManager = ProjectRootManager.getInstance(this.myManager.getProject());
            List<VirtualFile> sourceRoots = rootManager.getModuleSourceRoots(JavaModuleSourceRootTypes.SOURCES);
            ProjectFileIndex fileIndex = rootManager.getFileIndex();
            for (VirtualFile sourceRoot : sourceRoots) {
                String packageName;
                if (!sourceRoot.isDirectory() || (packageName = fileIndex.getPackageNameByDirectory(sourceRoot)) == null || packageName.isEmpty()) continue;
                names.add(packageName);
            }
            this.myNontrivialPackagePrefixes = names;
        }
        Set<String> set = names;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "getNonTrivialPackagePrefixes"));
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<PsiJavaModule> findModules(@NotNull String moduleName, @NotNull GlobalSearchScope scope) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "findModules"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "findModules"));
        }
        Collection<PsiJavaModule> collection = JavaModuleNameIndex.getInstance().get(moduleName, this.myManager.getProject(), scope);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "findModules"));
        }
        return collection;
    }
}

