/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.SingletonSet;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.containers.ConcurrentHashSet;
import com.intellij.util.containers.ConcurrentIntObjectHashMap;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ConcurrentLongObjectHashMap;
import com.intellij.util.containers.ConcurrentLongObjectMap;
import com.intellij.util.containers.ConcurrentSoftHashMap;
import com.intellij.util.containers.ConcurrentSoftKeySoftValueHashMap;
import com.intellij.util.containers.ConcurrentSoftValueHashMap;
import com.intellij.util.containers.ConcurrentSoftValueIntObjectHashMap;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import com.intellij.util.containers.ConcurrentWeakKeySoftValueHashMap;
import com.intellij.util.containers.ConcurrentWeakKeyWeakValueHashMap;
import com.intellij.util.containers.ConcurrentWeakValueHashMap;
import com.intellij.util.containers.ConcurrentWeakValueIntObjectHashMap;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.EmptyIterable;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.LockFreeCopyOnWriteArrayList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SequenceIterator;
import com.intellij.util.containers.Stack;
import com.intellij.util.containers.WeakKeySoftValueHashMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import gnu.trove.TObjectHashingStrategy;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerUtil
extends ContainerUtilRt {
    private static final int INSERTION_SORT_THRESHOLD = 10;
    private static final int DEFAULT_CONCURRENCY_LEVEL = Math.min(16, Runtime.getRuntime().availableProcessors());
    private static final ConcurrentMapFactory V8_MAP_FACTORY = new ConcurrentMapFactory(){

        @Override
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap() {
            ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
            if (concurrentHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$20", "createMap"));
            }
            return concurrentHashMap;
        }

        @Override
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(int initialCapacity) {
            ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap(initialCapacity);
            if (concurrentHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$20", "createMap"));
            }
            return concurrentHashMap;
        }

        @Override
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(@NotNull TObjectHashingStrategy<T> hashStrategy) {
            if (hashStrategy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashStrategy", "com/intellij/util/containers/ContainerUtil$20", "createMap"));
            }
            ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap(hashStrategy);
            if (concurrentHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$20", "createMap"));
            }
            return concurrentHashMap;
        }

        @Override
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
            ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
            if (concurrentHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$20", "createMap"));
            }
            return concurrentHashMap;
        }

        @Override
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<T> hashingStrategy) {
            if (hashingStrategy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/containers/ContainerUtil$20", "createMap"));
            }
            ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
            if (concurrentHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$20", "createMap"));
            }
            return concurrentHashMap;
        }
    };
    private static final ConcurrentMapFactory PLATFORM_MAP_FACTORY = new ConcurrentMapFactory(){

        @Override
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap() {
            ConcurrentMap<T, V> concurrentMap = this.createMap(16, 0.75f, DEFAULT_CONCURRENCY_LEVEL);
            if (concurrentMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$21", "createMap"));
            }
            return concurrentMap;
        }

        @Override
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(int initialCapacity) {
            java.util.concurrent.ConcurrentHashMap concurrentHashMap = new java.util.concurrent.ConcurrentHashMap(initialCapacity);
            if (concurrentHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$21", "createMap"));
            }
            return concurrentHashMap;
        }

        @Override
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(@NotNull TObjectHashingStrategy<T> hashingStrategy) {
            if (hashingStrategy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/containers/ContainerUtil$21", "createMap"));
            }
            if (hashingStrategy != ContainerUtil.canonicalStrategy()) {
                throw new UnsupportedOperationException("Custom hashStrategy is not supported in java.util.concurrent.ConcurrentHashMap");
            }
            ConcurrentMap<T, V> concurrentMap = this.createMap();
            if (concurrentMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$21", "createMap"));
            }
            return concurrentMap;
        }

        @Override
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
            java.util.concurrent.ConcurrentHashMap concurrentHashMap = new java.util.concurrent.ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
            if (concurrentHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$21", "createMap"));
            }
            return concurrentHashMap;
        }

        @Override
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<T> hashingStrategy) {
            if (hashingStrategy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/containers/ContainerUtil$21", "createMap"));
            }
            if (hashingStrategy != ContainerUtil.canonicalStrategy()) {
                throw new UnsupportedOperationException("Custom hashStrategy is not supported in java.util.concurrent.ConcurrentHashMap");
            }
            ConcurrentMap<T, V> concurrentMap = this.createMap(initialCapacity, loadFactor, concurrencyLevel);
            if (concurrentMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$21", "createMap"));
            }
            return concurrentMap;
        }
    };
    private static final ConcurrentMapFactory CHM_FACTORY = SystemInfo.isOracleJvm || SystemInfo.isSunJvm || SystemInfo.isAppleJvm || ContainerUtil.isAtLeastJava7() ? V8_MAP_FACTORY : PLATFORM_MAP_FACTORY;

    @NotNull
    @Contract(pure=true)
    public static <T> T[] ar(T ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtil", "ar"));
        }
        if (elements == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "ar"));
        }
        return elements;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> HashMap<K, V> newHashMap() {
        HashMap hashMap = ContainerUtilRt.newHashMap();
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newHashMap"));
        }
        return hashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> HashMap<K, V> newHashMap(@NotNull Map<? extends K, ? extends V> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/util/containers/ContainerUtil", "newHashMap"));
        }
        HashMap<? extends K, ? extends V> hashMap = ContainerUtilRt.newHashMap(map);
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newHashMap"));
        }
        return hashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> newHashMap(@NotNull Pair<K, ? extends V> first, Pair<K, ? extends V> ... entries) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/util/containers/ContainerUtil", "newHashMap"));
        }
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entries", "com/intellij/util/containers/ContainerUtil", "newHashMap"));
        }
        Map<K, ? extends V> map = ContainerUtilRt.newHashMap(first, entries);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newHashMap"));
        }
        return map;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> newHashMap(@NotNull List<K> keys, @NotNull List<V> values) {
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/util/containers/ContainerUtil", "newHashMap"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/util/containers/ContainerUtil", "newHashMap"));
        }
        Map<K, V> map = ContainerUtilRt.newHashMap(keys, values);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newHashMap"));
        }
        return map;
    }

    @NotNull
    @Contract(pure=true)
    public static <K extends Comparable, V> TreeMap<K, V> newTreeMap() {
        TreeMap treeMap = ContainerUtilRt.newTreeMap();
        if (treeMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newTreeMap"));
        }
        return treeMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K extends Comparable, V> TreeMap<K, V> newTreeMap(@NotNull Map<K, V> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/util/containers/ContainerUtil", "newTreeMap"));
        }
        TreeMap<K, V> treeMap = ContainerUtilRt.newTreeMap(map);
        if (treeMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newTreeMap"));
        }
        return treeMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        LinkedHashMap linkedHashMap = ContainerUtilRt.newLinkedHashMap();
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newLinkedHashMap"));
        }
        return linkedHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(int capacity) {
        LinkedHashMap linkedHashMap = ContainerUtilRt.newLinkedHashMap(capacity);
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newLinkedHashMap"));
        }
        return linkedHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(@NotNull Map<K, V> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/util/containers/ContainerUtil", "newLinkedHashMap"));
        }
        LinkedHashMap<K, V> linkedHashMap = ContainerUtilRt.newLinkedHashMap(map);
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newLinkedHashMap"));
        }
        return linkedHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(@NotNull Pair<K, V> first, Pair<K, V> ... entries) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/util/containers/ContainerUtil", "newLinkedHashMap"));
        }
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entries", "com/intellij/util/containers/ContainerUtil", "newLinkedHashMap"));
        }
        LinkedHashMap<K, V> linkedHashMap = ContainerUtilRt.newLinkedHashMap(first, entries);
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newLinkedHashMap"));
        }
        return linkedHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> THashMap<K, V> newTroveMap() {
        THashMap tHashMap = new THashMap();
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newTroveMap"));
        }
        return tHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> THashMap<K, V> newTroveMap(@NotNull TObjectHashingStrategy<K> strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/util/containers/ContainerUtil", "newTroveMap"));
        }
        THashMap tHashMap = new THashMap(strategy);
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newTroveMap"));
        }
        return tHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K extends Enum<K>, V> EnumMap<K, V> newEnumMap(@NotNull Class<K> keyType) {
        if (keyType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyType", "com/intellij/util/containers/ContainerUtil", "newEnumMap"));
        }
        EnumMap enumMap = new EnumMap(keyType);
        if (enumMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newEnumMap"));
        }
        return enumMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TObjectHashingStrategy<T> canonicalStrategy() {
        TObjectHashingStrategy tObjectHashingStrategy = TObjectHashingStrategy.CANONICAL;
        if (tObjectHashingStrategy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "canonicalStrategy"));
        }
        return tObjectHashingStrategy;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TObjectHashingStrategy<T> identityStrategy() {
        TObjectHashingStrategy tObjectHashingStrategy = TObjectHashingStrategy.IDENTITY;
        if (tObjectHashingStrategy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "identityStrategy"));
        }
        return tObjectHashingStrategy;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> IdentityHashMap<K, V> newIdentityHashMap() {
        IdentityHashMap identityHashMap = new IdentityHashMap();
        if (identityHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newIdentityHashMap"));
        }
        return identityHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedList<T> newLinkedList() {
        LinkedList linkedList = ContainerUtilRt.newLinkedList();
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newLinkedList"));
        }
        return linkedList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedList<T> newLinkedList(T ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtil", "newLinkedList"));
        }
        LinkedList<T> linkedList = ContainerUtilRt.newLinkedList(elements);
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newLinkedList"));
        }
        return linkedList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedList<T> newLinkedList(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtil", "newLinkedList"));
        }
        LinkedList<? extends T> linkedList = ContainerUtilRt.newLinkedList(elements);
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newLinkedList"));
        }
        return linkedList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ArrayList<T> newArrayList() {
        ArrayList arrayList = ContainerUtilRt.newArrayList();
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newArrayList"));
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> ArrayList<E> newArrayList(E ... array) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/containers/ContainerUtil", "newArrayList"));
        }
        ArrayList<E> arrayList = ContainerUtilRt.newArrayList(array);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newArrayList"));
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> ArrayList<E> newArrayList(@NotNull Iterable<? extends E> iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/util/containers/ContainerUtil", "newArrayList"));
        }
        ArrayList<? extends E> arrayList = ContainerUtilRt.newArrayList(iterable);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newArrayList"));
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ArrayList<T> newArrayListWithCapacity(int size) {
        ArrayList arrayList = ContainerUtilRt.newArrayListWithCapacity(size);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newArrayListWithCapacity"));
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> newArrayList(final @NotNull T[] elements, final int start, final int end) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtil", "newArrayList"));
        }
        if (start < 0 || start > end || end > elements.length) {
            throw new IllegalArgumentException("start:" + start + " end:" + end + " length:" + elements.length);
        }
        AbstractList abstractList = new AbstractList<T>(){
            private final int size;
            {
                this.size = end - start;
            }

            @Override
            public T get(int index) {
                if (index < 0 || index >= this.size) {
                    throw new IndexOutOfBoundsException("index:" + index + " size:" + this.size);
                }
                return elements[start + index];
            }

            @Override
            public int size() {
                return this.size;
            }
        };
        if (abstractList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newArrayList"));
        }
        return abstractList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> newUnmodifiableList(List<? extends T> originalList) {
        int size = originalList.size();
        if (size == 0) {
            List<T> list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newUnmodifiableList"));
            }
            return list;
        }
        if (size == 1) {
            List<T> list = Collections.singletonList(originalList.get(0));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newUnmodifiableList"));
            }
            return list;
        }
        List<? extends T> list = Collections.unmodifiableList(ContainerUtil.newArrayList(originalList));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newUnmodifiableList"));
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> newSmartList() {
        SmartList smartList = new SmartList();
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newSmartList"));
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> newSmartList(T element) {
        SmartList<T> smartList = new SmartList<T>(element);
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newSmartList"));
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> newSmartList(T ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtil", "newSmartList"));
        }
        SmartList<T> smartList = new SmartList<T>(elements);
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newSmartList"));
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> HashSet<T> newHashSet() {
        HashSet hashSet = ContainerUtilRt.newHashSet();
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newHashSet"));
        }
        return hashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> HashSet<T> newHashSet(int initialCapacity) {
        HashSet hashSet = ContainerUtilRt.newHashSet(initialCapacity);
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newHashSet"));
        }
        return hashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> HashSet<T> newHashSet(T ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtil", "newHashSet"));
        }
        HashSet<T> hashSet = ContainerUtilRt.newHashSet(elements);
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newHashSet"));
        }
        return hashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> HashSet<T> newHashSet(@NotNull Iterable<? extends T> iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/util/containers/ContainerUtil", "newHashSet"));
        }
        HashSet<? extends T> hashSet = ContainerUtilRt.newHashSet(iterable);
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newHashSet"));
        }
        return hashSet;
    }

    @NotNull
    public static <T> HashSet<T> newHashSet(@NotNull Iterator<? extends T> iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/util/containers/ContainerUtil", "newHashSet"));
        }
        HashSet<? extends T> hashSet = ContainerUtilRt.newHashSet(iterator);
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newHashSet"));
        }
        return hashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> newHashOrEmptySet(@Nullable Iterable<? extends T> iterable) {
        boolean empty = iterable == null || iterable instanceof Collection && ((Collection)iterable).isEmpty();
        Set<Object> set = empty ? Collections.emptySet() : ContainerUtilRt.newHashSet(iterable);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newHashOrEmptySet"));
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedHashSet<T> newLinkedHashSet() {
        LinkedHashSet linkedHashSet = ContainerUtilRt.newLinkedHashSet();
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newLinkedHashSet"));
        }
        return linkedHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedHashSet<T> newLinkedHashSet(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtil", "newLinkedHashSet"));
        }
        LinkedHashSet<? extends T> linkedHashSet = ContainerUtilRt.newLinkedHashSet(elements);
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newLinkedHashSet"));
        }
        return linkedHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedHashSet<T> newLinkedHashSet(T ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtil", "newLinkedHashSet"));
        }
        LinkedHashSet<T> linkedHashSet = ContainerUtilRt.newLinkedHashSet(elements);
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newLinkedHashSet"));
        }
        return linkedHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet() {
        THashSet tHashSet = new THashSet();
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newTroveSet"));
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(@NotNull TObjectHashingStrategy<T> strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/util/containers/ContainerUtil", "newTroveSet"));
        }
        THashSet tHashSet = new THashSet(strategy);
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newTroveSet"));
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(T ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtil", "newTroveSet"));
        }
        THashSet<T> tHashSet = ContainerUtil.newTroveSet(Arrays.asList(elements));
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newTroveSet"));
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(@NotNull TObjectHashingStrategy<T> strategy, T ... elements) {
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/util/containers/ContainerUtil", "newTroveSet"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtil", "newTroveSet"));
        }
        THashSet tHashSet = new THashSet(Arrays.asList(elements), strategy);
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newTroveSet"));
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(@NotNull TObjectHashingStrategy<T> strategy, @NotNull Collection<T> elements) {
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/util/containers/ContainerUtil", "newTroveSet"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtil", "newTroveSet"));
        }
        THashSet tHashSet = new THashSet(elements, strategy);
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newTroveSet"));
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(@NotNull Collection<T> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtil", "newTroveSet"));
        }
        THashSet tHashSet = new THashSet(elements);
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newTroveSet"));
        }
        return tHashSet;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    @Contract(pure=true)
    public static <K> THashSet<K> newIdentityTroveSet() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:73)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @NotNull
    @Contract(pure=true)
    public static <K> THashSet<K> newIdentityTroveSet(int initialCapacity) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:73)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @NotNull
    @Contract(pure=true)
    public static <K> THashSet<K> newIdentityTroveSet(@NotNull Collection<K> collection) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:73)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @NotNull
    @Contract(pure=true)
    public static <K, V> THashMap<K, V> newIdentityTroveMap() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:73)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TreeSet<T> newTreeSet() {
        TreeSet treeSet = ContainerUtilRt.newTreeSet();
        if (treeSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newTreeSet"));
        }
        return treeSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TreeSet<T> newTreeSet(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtil", "newTreeSet"));
        }
        TreeSet<? extends T> treeSet = ContainerUtilRt.newTreeSet(elements);
        if (treeSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newTreeSet"));
        }
        return treeSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TreeSet<T> newTreeSet(T ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtil", "newTreeSet"));
        }
        TreeSet<T> treeSet = ContainerUtilRt.newTreeSet(elements);
        if (treeSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newTreeSet"));
        }
        return treeSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TreeSet<T> newTreeSet(@Nullable Comparator<? super T> comparator) {
        TreeSet<? super T> treeSet = ContainerUtilRt.newTreeSet(comparator);
        if (treeSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newTreeSet"));
        }
        return treeSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> newConcurrentSet() {
        ConcurrentHashSet concurrentHashSet = new ConcurrentHashSet();
        if (concurrentHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newConcurrentSet"));
        }
        return concurrentHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> newConcurrentSet(@NotNull TObjectHashingStrategy<T> hashStrategy) {
        if (hashStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashStrategy", "com/intellij/util/containers/ContainerUtil", "newConcurrentSet"));
        }
        ConcurrentHashSet<T> concurrentHashSet = new ConcurrentHashSet<T>(hashStrategy);
        if (concurrentHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newConcurrentSet"));
        }
        return concurrentHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> newConcurrentMap() {
        ConcurrentMap concurrentMap = CHM_FACTORY.createMap();
        if (concurrentMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newConcurrentMap"));
        }
        return concurrentMap;
    }

    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> newConcurrentMap(@NotNull TObjectHashingStrategy<K> hashStrategy) {
        if (hashStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashStrategy", "com/intellij/util/containers/ContainerUtil", "newConcurrentMap"));
        }
        return CHM_FACTORY.createMap(hashStrategy);
    }

    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> newConcurrentMap(int initialCapacity) {
        return CHM_FACTORY.createMap(initialCapacity);
    }

    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> newConcurrentMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<K> hashStrategy) {
        if (hashStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashStrategy", "com/intellij/util/containers/ContainerUtil", "newConcurrentMap"));
        }
        return CHM_FACTORY.createMap(initialCapacity, loadFactor, concurrencyLevel, hashStrategy);
    }

    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> newConcurrentMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return CHM_FACTORY.createMap(initialCapacity, loadFactor, concurrencyLevel);
    }

    @NotNull
    @Contract(pure=true)
    public static <E> List<E> reverse(final @NotNull List<E> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtil", "reverse"));
        }
        if (elements.isEmpty()) {
            List list = ContainerUtilRt.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "reverse"));
            }
            return list;
        }
        AbstractList abstractList = new AbstractList<E>(){

            @Override
            public E get(int index) {
                return elements.get(elements.size() - 1 - index);
            }

            @Override
            public int size() {
                return elements.size();
            }
        };
        if (abstractList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "reverse"));
        }
        return abstractList;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> union(@NotNull Map<? extends K, ? extends V> map, @NotNull Map<? extends K, ? extends V> map2) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/util/containers/ContainerUtil", "union"));
        }
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map2", "com/intellij/util/containers/ContainerUtil", "union"));
        }
        THashMap result = new THashMap(map.size() + map2.size());
        result.putAll(map);
        result.putAll(map2);
        THashMap tHashMap = result;
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "union"));
        }
        return tHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> union(@NotNull Set<T> set, @NotNull Set<T> set2) {
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/util/containers/ContainerUtil", "union"));
        }
        if (set2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set2", "com/intellij/util/containers/ContainerUtil", "union"));
        }
        THashSet result = new THashSet(set.size() + set2.size());
        result.addAll(set);
        result.addAll(set2);
        THashSet tHashSet = result;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "union"));
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> Set<E> immutableSet(E ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtil", "immutableSet"));
        }
        switch (elements.length) {
            case 0: {
                Set set = Collections.emptySet();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "immutableSet"));
                }
                return set;
            }
            case 1: {
                Set<E> set = Collections.singleton(elements[0]);
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "immutableSet"));
                }
                return set;
            }
        }
        Set set = Collections.unmodifiableSet(new THashSet(Arrays.asList(elements)));
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "immutableSet"));
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> ImmutableList<E> immutableList(E ... array) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/containers/ContainerUtil", "immutableList"));
        }
        ImmutableListBackedByArray immutableListBackedByArray = new ImmutableListBackedByArray(array);
        if (immutableListBackedByArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "immutableList"));
        }
        return immutableListBackedByArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> ImmutableList<E> immutableList(@NotNull List<E> list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ContainerUtil", "immutableList"));
        }
        ImmutableListBackedByList immutableListBackedByList = new ImmutableListBackedByList(list);
        if (immutableListBackedByList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "immutableList"));
        }
        return immutableListBackedByList;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ImmutableMapBuilder<K, V> immutableMapBuilder() {
        ImmutableMapBuilder immutableMapBuilder = new ImmutableMapBuilder();
        if (immutableMapBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "immutableMapBuilder"));
        }
        return immutableMapBuilder;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> groupBy(@NotNull Iterable<V> collection, @NotNull NullableFunction<V, K> grouper) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "groupBy"));
        }
        if (grouper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grouper", "com/intellij/util/containers/ContainerUtil", "groupBy"));
        }
        MultiMap<K, V> result = MultiMap.createLinked();
        for (V data : collection) {
            K key = grouper.fun(data);
            if (key == null) continue;
            result.putValue(key, data);
        }
        if (!result.isEmpty() && result.keySet().iterator().next() instanceof Comparable) {
            KeyOrderedMultiMap keyOrderedMultiMap = new KeyOrderedMultiMap(result);
            if (keyOrderedMultiMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "groupBy"));
            }
            return keyOrderedMultiMap;
        }
        MultiMap<K, V> multiMap = result;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "groupBy"));
        }
        return multiMap;
    }

    @Contract(pure=true)
    public static <T> T getOrElse(@NotNull List<T> elements, int i2, T defaultValue) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtil", "getOrElse"));
        }
        return elements.size() > i2 ? elements.get(i2) : defaultValue;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> intersection(@NotNull Map<K, V> map1, @NotNull Map<K, V> map2) {
        if (map1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map1", "com/intellij/util/containers/ContainerUtil", "intersection"));
        }
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map2", "com/intellij/util/containers/ContainerUtil", "intersection"));
        }
        HashMap res = ContainerUtil.newHashMap();
        HashSet<K> keys = ContainerUtil.newHashSet();
        keys.addAll(map1.keySet());
        keys.addAll(map2.keySet());
        for (Object k : keys) {
            V v2;
            V v1 = map1.get(k);
            if (v1 != (v2 = map2.get(k)) && (v1 == null || !v1.equals(v2))) continue;
            res.put(k, v1);
        }
        HashMap hashMap = res;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "intersection"));
        }
        return hashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, Couple<V>> diff(@NotNull Map<K, V> map1, @NotNull Map<K, V> map2) {
        if (map1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map1", "com/intellij/util/containers/ContainerUtil", "diff"));
        }
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map2", "com/intellij/util/containers/ContainerUtil", "diff"));
        }
        HashMap res = ContainerUtil.newHashMap();
        HashSet<K> keys = ContainerUtil.newHashSet();
        keys.addAll(map1.keySet());
        keys.addAll(map2.keySet());
        for (Object k : keys) {
            V v2;
            V v1 = map1.get(k);
            if (v1 == (v2 = map2.get(k)) || v1 != null && v1.equals(v2)) continue;
            res.put(k, Couple.of(v1, v2));
        }
        HashMap hashMap = res;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "diff"));
        }
        return hashMap;
    }

    public static <T> boolean processSortedListsInOrder(@NotNull List<T> list1, @NotNull List<T> list2, @NotNull Comparator<? super T> comparator, boolean mergeEqualItems, @NotNull Processor<T> processor) {
        if (list1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list1", "com/intellij/util/containers/ContainerUtil", "processSortedListsInOrder"));
        }
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list2", "com/intellij/util/containers/ContainerUtil", "processSortedListsInOrder"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/util/containers/ContainerUtil", "processSortedListsInOrder"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/containers/ContainerUtil", "processSortedListsInOrder"));
        }
        int index1 = 0;
        int index2 = 0;
        while (index1 < list1.size() || index2 < list2.size()) {
            T e;
            if (index1 >= list1.size()) {
                e = list2.get(index2++);
            } else if (index2 >= list2.size()) {
                e = list1.get(index1++);
            } else {
                T element2;
                T element1 = list1.get(index1);
                int c = comparator.compare(element1, element2 = list2.get(index2));
                if (c <= 0) {
                    e = element1;
                    ++index1;
                } else {
                    e = element2;
                    ++index2;
                }
                if (c == 0 && !mergeEqualItems) {
                    if (!processor.process(e)) {
                        return false;
                    }
                    ++index2;
                    e = element2;
                }
            }
            if (processor.process(e)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> mergeSortedLists(@NotNull List<T> list1, @NotNull List<T> list2, @NotNull Comparator<? super T> comparator, boolean mergeEqualItems) {
        if (list1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list1", "com/intellij/util/containers/ContainerUtil", "mergeSortedLists"));
        }
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list2", "com/intellij/util/containers/ContainerUtil", "mergeSortedLists"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/util/containers/ContainerUtil", "mergeSortedLists"));
        }
        final ArrayList result = new ArrayList(list1.size() + list2.size());
        ContainerUtil.processSortedListsInOrder(list1, list2, comparator, mergeEqualItems, new Processor<T>(){

            @Override
            public boolean process(T t) {
                result.add(t);
                return true;
            }
        });
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "mergeSortedLists"));
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> mergeSortedArrays(@NotNull T[] list1, @NotNull T[] list2, @NotNull Comparator<? super T> comparator, boolean mergeEqualItems, @Nullable Processor<? super T> filter) {
        if (list1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list1", "com/intellij/util/containers/ContainerUtil", "mergeSortedArrays"));
        }
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list2", "com/intellij/util/containers/ContainerUtil", "mergeSortedArrays"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/util/containers/ContainerUtil", "mergeSortedArrays"));
        }
        int index1 = 0;
        int index2 = 0;
        ArrayList<T> result = new ArrayList<T>(list1.length + list2.length);
        while (index1 < list1.length || index2 < list2.length) {
            T t;
            if (index1 >= list1.length) {
                t = list2[index2++];
                if (filter != null && !filter.process(t)) continue;
                result.add(t);
                continue;
            }
            if (index2 >= list2.length) {
                t = list1[index1++];
                if (filter != null && !filter.process(t)) continue;
                result.add(t);
                continue;
            }
            T element1 = list1[index1];
            if (filter != null && !filter.process(element1)) {
                ++index1;
                continue;
            }
            T element2 = list2[index2];
            if (filter != null && !filter.process(element2)) {
                ++index2;
                continue;
            }
            int c = comparator.compare(element1, element2);
            if (c < 0) {
                result.add(element1);
                ++index1;
                continue;
            }
            if (c > 0) {
                result.add(element2);
                ++index2;
                continue;
            }
            result.add(element1);
            if (!mergeEqualItems) {
                result.add(element2);
            }
            ++index1;
            ++index2;
        }
        ArrayList<T> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "mergeSortedArrays"));
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> subList(@NotNull List<T> list, int from) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ContainerUtil", "subList"));
        }
        List<T> list2 = list.subList(from, list.size());
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "subList"));
        }
        return list2;
    }

    public static <T> void addAll(@NotNull Collection<T> collection, @NotNull Iterable<? extends T> appendix) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "addAll"));
        }
        if (appendix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appendix", "com/intellij/util/containers/ContainerUtil", "addAll"));
        }
        ContainerUtil.addAll(collection, appendix.iterator());
    }

    public static <T> void addAll(@NotNull Collection<T> collection, @NotNull Iterator<? extends T> iterator) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "addAll"));
        }
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/util/containers/ContainerUtil", "addAll"));
        }
        while (iterator.hasNext()) {
            T o = iterator.next();
            collection.add(o);
        }
    }

    public static <T> void addAllNotNull(@NotNull Collection<T> collection, @NotNull Iterable<? extends T> elements) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "addAllNotNull"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtil", "addAllNotNull"));
        }
        ContainerUtil.addAllNotNull(collection, elements.iterator());
    }

    public static <T> void addAllNotNull(@NotNull Collection<T> collection, @NotNull Iterator<? extends T> elements) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "addAllNotNull"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtil", "addAllNotNull"));
        }
        while (elements.hasNext()) {
            T o = elements.next();
            if (o == null) continue;
            collection.add(o);
        }
    }

    @NotNull
    public static <T> List<T> collect(@NotNull Iterator<T> iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/util/containers/ContainerUtil", "collect"));
        }
        if (!iterator.hasNext()) {
            List<T> list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "collect"));
            }
            return list;
        }
        ArrayList list = new ArrayList();
        ContainerUtil.addAll(list, iterator);
        ArrayList arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "collect"));
        }
        return arrayList;
    }

    @NotNull
    public static <T> Set<T> collectSet(@NotNull Iterator<T> iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/util/containers/ContainerUtil", "collectSet"));
        }
        if (!iterator.hasNext()) {
            Set set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "collectSet"));
            }
            return set;
        }
        HashSet<T> hashSet = ContainerUtil.newHashSet();
        ContainerUtil.addAll(hashSet, iterator);
        HashSet<T> hashSet2 = hashSet;
        if (hashSet2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "collectSet"));
        }
        return hashSet2;
    }

    @NotNull
    public static <K, V> Map<K, V> newMapFromKeys(@NotNull Iterator<K> keys, @NotNull Convertor<K, V> valueConvertor) {
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/util/containers/ContainerUtil", "newMapFromKeys"));
        }
        if (valueConvertor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueConvertor", "com/intellij/util/containers/ContainerUtil", "newMapFromKeys"));
        }
        HashMap<K, V> map = ContainerUtil.newHashMap();
        while (keys.hasNext()) {
            K key = keys.next();
            map.put(key, valueConvertor.convert(key));
        }
        HashMap<K, V> hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newMapFromKeys"));
        }
        return hashMap;
    }

    @NotNull
    public static <K, V> Map<K, V> newMapFromValues(@NotNull Iterator<V> values, @NotNull Convertor<V, K> keyConvertor) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/util/containers/ContainerUtil", "newMapFromValues"));
        }
        if (keyConvertor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyConvertor", "com/intellij/util/containers/ContainerUtil", "newMapFromValues"));
        }
        HashMap<K, V> map = ContainerUtil.newHashMap();
        ContainerUtil.fillMapWithValues(map, values, keyConvertor);
        HashMap<K, V> hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newMapFromValues"));
        }
        return hashMap;
    }

    public static <K, V> void fillMapWithValues(@NotNull Map<K, V> map, @NotNull Iterator<V> values, @NotNull Convertor<V, K> keyConvertor) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/util/containers/ContainerUtil", "fillMapWithValues"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/util/containers/ContainerUtil", "fillMapWithValues"));
        }
        if (keyConvertor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyConvertor", "com/intellij/util/containers/ContainerUtil", "fillMapWithValues"));
        }
        while (values.hasNext()) {
            V value = values.next();
            map.put(keyConvertor.convert(value), value);
        }
    }

    @NotNull
    public static <K, V> Map<K, Set<V>> classify(@NotNull Iterator<V> iterator, @NotNull Convertor<V, K> keyConvertor) {
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/util/containers/ContainerUtil", "classify"));
        }
        if (keyConvertor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyConvertor", "com/intellij/util/containers/ContainerUtil", "classify"));
        }
        LinkedHashMap<K, LinkedHashSet<V>> hashMap = new LinkedHashMap<K, LinkedHashSet<V>>();
        while (iterator.hasNext()) {
            V value = iterator.next();
            K key = keyConvertor.convert(value);
            LinkedHashSet<V> set = (LinkedHashSet<V>)hashMap.get(key);
            if (set == null) {
                set = new LinkedHashSet<V>();
                hashMap.put(key, set);
            }
            set.add(value);
        }
        LinkedHashMap<K, LinkedHashSet<V>> linkedHashMap = hashMap;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "classify"));
        }
        return linkedHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterator<T> emptyIterator() {
        EmptyIterator emptyIterator = EmptyIterator.getInstance();
        if (emptyIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "emptyIterator"));
        }
        return emptyIterator;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> emptyIterable() {
        EmptyIterable emptyIterable = EmptyIterable.getInstance();
        if (emptyIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "emptyIterable"));
        }
        return emptyIterable;
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T find(@NotNull T[] array, @NotNull Condition<? super T> condition) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/containers/ContainerUtil", "find"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/ContainerUtil", "find"));
        }
        for (T element : array) {
            if (!condition.value(element)) continue;
            return element;
        }
        return null;
    }

    public static <T> boolean process(@NotNull Iterable<? extends T> iterable, @NotNull Processor<T> processor) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/util/containers/ContainerUtil", "process"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/containers/ContainerUtil", "process"));
        }
        for (T t : iterable) {
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(@NotNull List<? extends T> list, @NotNull Processor<T> processor) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ContainerUtil", "process"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/containers/ContainerUtil", "process"));
        }
        int size = list.size();
        for (int i2 = 0; i2 < size; ++i2) {
            T t = list.get(i2);
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(@NotNull T[] iterable, @NotNull Processor<? super T> processor) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/util/containers/ContainerUtil", "process"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/containers/ContainerUtil", "process"));
        }
        for (T t : iterable) {
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(@NotNull Iterator<T> iterator, @NotNull Processor<? super T> processor) {
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/util/containers/ContainerUtil", "process"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/containers/ContainerUtil", "process"));
        }
        while (iterator.hasNext()) {
            if (processor.process(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Nullable
    @Contract(pure=true)
    public static <T, V extends T> V find(@NotNull Iterable<V> iterable, @NotNull Condition<T> condition) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/util/containers/ContainerUtil", "find"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/ContainerUtil", "find"));
        }
        return ContainerUtil.find(iterable.iterator(), condition);
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T find(@NotNull Iterable<? extends T> iterable, final @NotNull T equalTo) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/util/containers/ContainerUtil", "find"));
        }
        if (equalTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "equalTo", "com/intellij/util/containers/ContainerUtil", "find"));
        }
        return (T)ContainerUtil.find(iterable, new Condition<T>(){

            @Override
            public boolean value(T object) {
                return equalTo == object || equalTo.equals(object);
            }
        });
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T find(@NotNull Iterator<? extends T> iterator, final @NotNull T equalTo) {
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/util/containers/ContainerUtil", "find"));
        }
        if (equalTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "equalTo", "com/intellij/util/containers/ContainerUtil", "find"));
        }
        return ContainerUtil.find(iterator, new Condition<T>(){

            @Override
            public boolean value(T object) {
                return equalTo == object || equalTo.equals(object);
            }
        });
    }

    @Nullable
    public static <T, V extends T> V find(@NotNull Iterator<V> iterator, @NotNull Condition<T> condition) {
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/util/containers/ContainerUtil", "find"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/ContainerUtil", "find"));
        }
        while (iterator.hasNext()) {
            V value = iterator.next();
            if (!condition.value(value)) continue;
            return value;
        }
        return null;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, KEY, VALUE> Map<KEY, VALUE> map2Map(@NotNull T[] collection, @NotNull Function<T, Pair<KEY, VALUE>> mapper) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "map2Map"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/util/containers/ContainerUtil", "map2Map"));
        }
        Map<KEY, VALUE> map = ContainerUtil.map2Map(Arrays.asList(collection), mapper);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "map2Map"));
        }
        return map;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, KEY, VALUE> Map<KEY, VALUE> map2Map(@NotNull Collection<? extends T> collection, @NotNull Function<T, Pair<KEY, VALUE>> mapper) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "map2Map"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/util/containers/ContainerUtil", "map2Map"));
        }
        THashMap set = new THashMap(collection.size());
        for (T t : collection) {
            Pair<KEY, VALUE> pair = mapper.fun(t);
            set.put(pair.first, pair.second);
        }
        THashMap tHashMap = set;
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "map2Map"));
        }
        return tHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, KEY, VALUE> Map<KEY, VALUE> map2MapNotNull(@NotNull T[] collection, @NotNull Function<T, Pair<KEY, VALUE>> mapper) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "map2MapNotNull"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/util/containers/ContainerUtil", "map2MapNotNull"));
        }
        Map<KEY, VALUE> map = ContainerUtil.map2MapNotNull(Arrays.asList(collection), mapper);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "map2MapNotNull"));
        }
        return map;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, KEY, VALUE> Map<KEY, VALUE> map2MapNotNull(@NotNull Collection<? extends T> collection, @NotNull Function<T, Pair<KEY, VALUE>> mapper) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "map2MapNotNull"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/util/containers/ContainerUtil", "map2MapNotNull"));
        }
        THashMap set = new THashMap(collection.size());
        for (T t : collection) {
            Pair<KEY, VALUE> pair = mapper.fun(t);
            if (pair == null) continue;
            set.put(pair.first, pair.second);
        }
        THashMap tHashMap = set;
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "map2MapNotNull"));
        }
        return tHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <KEY, VALUE> Map<KEY, VALUE> map2Map(@NotNull Collection<Pair<KEY, VALUE>> collection) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "map2Map"));
        }
        THashMap result = new THashMap(collection.size());
        for (Pair<KEY, VALUE> pair : collection) {
            result.put(pair.first, pair.second);
        }
        THashMap tHashMap = result;
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "map2Map"));
        }
        return tHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Object[] map2Array(@NotNull T[] array, @NotNull Function<T, Object> mapper) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        Object[] objectArray = ContainerUtil.map2Array(array, Object.class, mapper);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Object[] map2Array(@NotNull Collection<T> array, @NotNull Function<T, Object> mapper) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        Object[] objectArray = ContainerUtil.map2Array(array, Object.class, mapper);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] map2Array(@NotNull T[] array, @NotNull Class<? super V> aClass, @NotNull Function<T, V> mapper) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        V[] VArray = ContainerUtil.map2Array(Arrays.asList(array), aClass, mapper);
        if (VArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        return VArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] map2Array(@NotNull Collection<? extends T> collection, @NotNull Class<? super V> aClass, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        List<V> list = ContainerUtil.map2List(collection, mapper);
        Object[] array = (Object[])Array.newInstance(aClass, list.size());
        Object[] objectArray = list.toArray(array);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] map2Array(@NotNull Collection<? extends T> collection, @NotNull V[] to, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        V[] VArray = ContainerUtil.map2List(collection, mapper).toArray(to);
        if (VArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        return VArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> filter(@NotNull T[] collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "filter"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/ContainerUtil", "filter"));
        }
        List<? super T> list = ContainerUtil.findAll(collection, condition);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "filter"));
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] filter(@NotNull int[] collection, @NotNull TIntProcedure condition) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "filter"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/ContainerUtil", "filter"));
        }
        TIntArrayList result = new TIntArrayList();
        for (int t : collection) {
            if (!condition.execute(t)) continue;
            result.add(t);
        }
        int[] nArray = result.isEmpty() ? ArrayUtil.EMPTY_INT_ARRAY : result.toNativeArray();
        if (nArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "filter"));
        }
        return nArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> findAll(@NotNull T[] collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "findAll"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/ContainerUtil", "findAll"));
        }
        SmartList<T> result = new SmartList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result.add(t);
        }
        SmartList<T> smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "findAll"));
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> filter(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "filter"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/ContainerUtil", "filter"));
        }
        List<? super T> list = ContainerUtil.findAll(collection, condition);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "filter"));
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> filter(@NotNull Map<K, ? extends V> map, @NotNull Condition<? super K> keyFilter) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/util/containers/ContainerUtil", "filter"));
        }
        if (keyFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyFilter", "com/intellij/util/containers/ContainerUtil", "filter"));
        }
        HashMap<K, V> result = ContainerUtil.newHashMap();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!keyFilter.value(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        HashMap<K, V> hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "filter"));
        }
        return hashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> findAll(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "findAll"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/ContainerUtil", "findAll"));
        }
        if (collection.isEmpty()) {
            List<T> list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "findAll"));
            }
            return list;
        }
        SmartList<T> result = new SmartList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result.add(t);
        }
        SmartList<T> smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "findAll"));
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> skipNulls(@NotNull Collection<? extends T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "skipNulls"));
        }
        List<Object> list = ContainerUtil.findAll(collection, Condition.NOT_NULL);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "skipNulls"));
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> findAll(@NotNull T[] collection, @NotNull Class<V> instanceOf) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "findAll"));
        }
        if (instanceOf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceOf", "com/intellij/util/containers/ContainerUtil", "findAll"));
        }
        List<V> list = ContainerUtil.findAll(Arrays.asList(collection), instanceOf);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "findAll"));
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] findAllAsArray(@NotNull T[] collection, @NotNull Class<V> instanceOf) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "findAllAsArray"));
        }
        if (instanceOf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceOf", "com/intellij/util/containers/ContainerUtil", "findAllAsArray"));
        }
        List<V> list = ContainerUtil.findAll(Arrays.asList(collection), instanceOf);
        Object[] array = (Object[])Array.newInstance(instanceOf, list.size());
        Object[] objectArray = list.toArray(array);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "findAllAsArray"));
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] findAllAsArray(@NotNull Collection<? extends T> collection, @NotNull Class<V> instanceOf) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "findAllAsArray"));
        }
        if (instanceOf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceOf", "com/intellij/util/containers/ContainerUtil", "findAllAsArray"));
        }
        List<V> list = ContainerUtil.findAll(collection, instanceOf);
        Object[] array = (Object[])Array.newInstance(instanceOf, list.size());
        Object[] objectArray = list.toArray(array);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "findAllAsArray"));
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] findAllAsArray(@NotNull T[] collection, @NotNull Condition<? super T> instanceOf) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "findAllAsArray"));
        }
        if (instanceOf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceOf", "com/intellij/util/containers/ContainerUtil", "findAllAsArray"));
        }
        List<Object> list = ContainerUtil.findAll(collection, instanceOf);
        if (list.size() == collection.length) {
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "findAllAsArray"));
            }
            return collection;
        }
        Object[] array = (Object[])Array.newInstance(collection.getClass().getComponentType(), list.size());
        Object[] objectArray = list.toArray(array);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "findAllAsArray"));
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> findAll(@NotNull Collection<? extends T> collection, @NotNull Class<V> instanceOf) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "findAll"));
        }
        if (instanceOf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceOf", "com/intellij/util/containers/ContainerUtil", "findAll"));
        }
        SmartList<T> result = new SmartList<T>();
        for (T t : collection) {
            if (!instanceOf.isInstance(t)) continue;
            T v = t;
            result.add(v);
        }
        SmartList<T> smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "findAll"));
        }
        return smartList;
    }

    public static <T> void removeDuplicates(@NotNull Collection<T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "removeDuplicates"));
        }
        HashSet<T> collected = ContainerUtil.newHashSet();
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (!collected.contains(t)) {
                collected.add(t);
                continue;
            }
            iterator.remove();
        }
    }

    @NotNull
    @Contract(pure=true)
    public static Map<String, String> stringMap(String ... keyValues) {
        if (keyValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyValues", "com/intellij/util/containers/ContainerUtil", "stringMap"));
        }
        HashMap<String, String> result = ContainerUtil.newHashMap();
        for (int i2 = 0; i2 < keyValues.length - 1; i2 += 2) {
            result.put(keyValues[i2], keyValues[i2 + 1]);
        }
        HashMap<String, String> hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "stringMap"));
        }
        return hashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterator<T> iterate(@NotNull T[] array) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/containers/ContainerUtil", "iterate"));
        }
        Iterator iterator = array.length == 0 ? EmptyIterator.getInstance() : Arrays.asList(array).iterator();
        if (iterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "iterate"));
        }
        return iterator;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterator<T> iterate(final @NotNull Enumeration<T> enumeration) {
        if (enumeration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumeration", "com/intellij/util/containers/ContainerUtil", "iterate"));
        }
        Iterator iterator = new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public T next() {
                return enumeration.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        if (iterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "iterate"));
        }
        return iterator;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> iterate(@NotNull T[] arrays, @NotNull Condition<? super T> condition) {
        if (arrays == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrays", "com/intellij/util/containers/ContainerUtil", "iterate"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/ContainerUtil", "iterate"));
        }
        Iterable<? super T> iterable = ContainerUtil.iterate(Arrays.asList(arrays), condition);
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "iterate"));
        }
        return iterable;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> iterate(final @NotNull Collection<? extends T> collection, final @NotNull Condition<? super T> condition) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "iterate"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/ContainerUtil", "iterate"));
        }
        if (collection.isEmpty()) {
            Iterable<T> iterable = ContainerUtil.emptyIterable();
            if (iterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "iterate"));
            }
            return iterable;
        }
        Iterable iterable = new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                Iterator iterator = new Iterator<T>(){
                    private final Iterator<? extends T> impl;
                    private T next;
                    {
                        this.impl = collection.iterator();
                        this.next = this.findNext();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public T next() {
                        Object result = this.next;
                        this.next = this.findNext();
                        return result;
                    }

                    @Nullable
                    private T findNext() {
                        while (this.impl.hasNext()) {
                            Object each = this.impl.next();
                            if (!condition.value(each)) continue;
                            return each;
                        }
                        return null;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
                if (iterator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$7", "iterator"));
                }
                return iterator;
            }
        };
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "iterate"));
        }
        return iterable;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> iterateBackward(final @NotNull List<? extends T> list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ContainerUtil", "iterateBackward"));
        }
        Iterable iterable = new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                Iterator iterator = new Iterator<T>(){
                    private final ListIterator<? extends T> it;
                    {
                        this.it = list.listIterator(list.size());
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasPrevious();
                    }

                    @Override
                    public T next() {
                        return this.it.previous();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
                if (iterator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$8", "iterator"));
                }
                return iterator;
            }
        };
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "iterateBackward"));
        }
        return iterable;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, E> Iterable<Pair<T, E>> zip(final @NotNull Iterable<T> iterable1, final @NotNull Iterable<E> iterable2) {
        if (iterable1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable1", "com/intellij/util/containers/ContainerUtil", "zip"));
        }
        if (iterable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable2", "com/intellij/util/containers/ContainerUtil", "zip"));
        }
        Iterable iterable = new Iterable<Pair<T, E>>(){

            @Override
            public Iterator<Pair<T, E>> iterator() {
                return new Iterator<Pair<T, E>>(){
                    private final Iterator<T> i1;
                    private final Iterator<E> i2;
                    {
                        this.i1 = iterable1.iterator();
                        this.i2 = iterable2.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i1.hasNext() && this.i2.hasNext();
                    }

                    @Override
                    public Pair<T, E> next() {
                        return Pair.create(this.i1.next(), this.i2.next());
                    }

                    @Override
                    public void remove() {
                        this.i1.remove();
                        this.i2.remove();
                    }
                };
            }
        };
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "zip"));
        }
        return iterable;
    }

    public static <E> void swapElements(@NotNull List<E> list, int index1, int index2) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ContainerUtil", "swapElements"));
        }
        E e1 = list.get(index1);
        E e2 = list.get(index2);
        list.set(index1, e2);
        list.set(index2, e1);
    }

    @NotNull
    public static <T> List<T> collect(@NotNull Iterator<?> iterator, @NotNull FilteringIterator.InstanceOf<T> instanceOf) {
        List list;
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/util/containers/ContainerUtil", "collect"));
        }
        if (instanceOf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceOf", "com/intellij/util/containers/ContainerUtil", "collect"));
        }
        List list2 = list = ContainerUtil.collect(FilteringIterator.create(iterator, instanceOf));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "collect"));
        }
        return list2;
    }

    public static <T> void addAll(@NotNull Collection<T> collection, @NotNull Enumeration<? extends T> enumeration) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "addAll"));
        }
        if (enumeration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumeration", "com/intellij/util/containers/ContainerUtil", "addAll"));
        }
        while (enumeration.hasMoreElements()) {
            T element = enumeration.nextElement();
            collection.add(element);
        }
    }

    @NotNull
    public static <T, A extends T, C extends Collection<T>> C addAll(@NotNull C collection, A ... elements) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "addAll"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtil", "addAll"));
        }
        for (A element : elements) {
            collection.add(element);
        }
        C c = collection;
        if (c == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "addAll"));
        }
        return c;
    }

    @NotNull
    public static <T, A extends T, C extends Collection<T>> C addAllNotNull(@NotNull C collection, A ... elements) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "addAllNotNull"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtil", "addAllNotNull"));
        }
        for (A element : elements) {
            if (element == null) continue;
            collection.add(element);
        }
        C c = collection;
        if (c == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "addAllNotNull"));
        }
        return c;
    }

    public static <T> boolean removeAll(@NotNull Collection<T> collection, T ... elements) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "removeAll"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtil", "removeAll"));
        }
        boolean modified = false;
        for (T element : elements) {
            modified |= collection.remove(element);
        }
        return modified;
    }

    public static <T> boolean retainAll(@NotNull Collection<T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "retainAll"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/ContainerUtil", "retainAll"));
        }
        boolean modified = false;
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            T next = iterator.next();
            if (condition.value(next)) continue;
            iterator.remove();
            modified = true;
        }
        return modified;
    }

    @Contract(pure=true)
    public static <T, U extends T> U findInstance(@NotNull Iterable<T> iterable, @NotNull Class<U> aClass) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/util/containers/ContainerUtil", "findInstance"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/containers/ContainerUtil", "findInstance"));
        }
        return ContainerUtil.findInstance(iterable.iterator(), aClass);
    }

    public static <T, U extends T> U findInstance(@NotNull Iterator<T> iterator, @NotNull Class<U> aClass) {
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/util/containers/ContainerUtil", "findInstance"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/containers/ContainerUtil", "findInstance"));
        }
        return (U)ContainerUtil.find(iterator, FilteringIterator.instanceOf(aClass));
    }

    @Nullable
    @Contract(pure=true)
    public static <T, U extends T> U findInstance(@NotNull T[] array, @NotNull Class<U> aClass) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/containers/ContainerUtil", "findInstance"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/containers/ContainerUtil", "findInstance"));
        }
        return ContainerUtil.findInstance(Arrays.asList(array), aClass);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<T> concat(@NotNull V[] array, @NotNull Function<V, Collection<? extends T>> fun) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/containers/ContainerUtil", "concat"));
        }
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "com/intellij/util/containers/ContainerUtil", "concat"));
        }
        List<? extends T> list = ContainerUtil.concat(Arrays.asList(array), fun);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "concat"));
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> concat(@NotNull Iterable<? extends Collection<T>> list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ContainerUtil", "concat"));
        }
        ArrayList result = new ArrayList();
        for (Collection<T> ts : list) {
            result.addAll(ts);
        }
        List list2 = result.isEmpty() ? Collections.emptyList() : result;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "concat"));
        }
        return list2;
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    public static <T> List<T> concat(boolean appendTail, @NotNull List<? extends T> list, T ... values) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ContainerUtil", "concat"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/util/containers/ContainerUtil", "concat"));
        }
        List<? extends T> list2 = appendTail ? ContainerUtil.concat(list, ContainerUtil.list(values)) : ContainerUtil.concat(ContainerUtil.list(values), list);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "concat"));
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> append(@NotNull List<? extends T> list, T ... values) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ContainerUtil", "append"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/util/containers/ContainerUtil", "append"));
        }
        List<? extends T> list2 = ContainerUtil.concat(list, ContainerUtil.list(values));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "append"));
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> prepend(@NotNull List<? extends T> list, T ... values) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ContainerUtil", "prepend"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/util/containers/ContainerUtil", "prepend"));
        }
        List<? extends T> list2 = ContainerUtil.concat(ContainerUtil.list(values), list);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "prepend"));
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> concat(final @NotNull List<? extends T> list1, final @NotNull List<? extends T> list2) {
        if (list1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list1", "com/intellij/util/containers/ContainerUtil", "concat"));
        }
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list2", "com/intellij/util/containers/ContainerUtil", "concat"));
        }
        if (list1.isEmpty() && list2.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "concat"));
            }
            return list;
        }
        if (list1.isEmpty()) {
            List<T> list = list2;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "concat"));
            }
            return list;
        }
        if (list2.isEmpty()) {
            List<T> list = list1;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "concat"));
            }
            return list;
        }
        final int size1 = list1.size();
        final int size = size1 + list2.size();
        AbstractList abstractList = new AbstractList<T>(){

            @Override
            public T get(int index) {
                if (index < size1) {
                    return list1.get(index);
                }
                return list2.get(index - size1);
            }

            @Override
            public int size() {
                return size;
            }
        };
        if (abstractList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "concat"));
        }
        return abstractList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> concat(final Iterable<? extends T> ... iterables) {
        if (iterables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterables", "com/intellij/util/containers/ContainerUtil", "concat"));
        }
        Iterable iterable = new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                Iterator i2;
                Iterator[] iterators = new Iterator[iterables.length];
                for (int i3 = 0; i3 < iterables.length; ++i3) {
                    Iterable iterable = iterables[i3];
                    iterators[i3] = iterable.iterator();
                }
                Iterator iterator = i2 = ContainerUtil.concatIterators(iterators);
                if (iterator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$11", "iterator"));
                }
                return iterator;
            }
        };
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "concat"));
        }
        return iterable;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterator<T> concatIterators(Iterator<T> ... iterators) {
        if (iterators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterators", "com/intellij/util/containers/ContainerUtil", "concatIterators"));
        }
        SequenceIterator<T> sequenceIterator = new SequenceIterator<T>(iterators);
        if (sequenceIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "concatIterators"));
        }
        return sequenceIterator;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterator<T> concatIterators(@NotNull Collection<Iterator<T>> iterators) {
        if (iterators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterators", "com/intellij/util/containers/ContainerUtil", "concatIterators"));
        }
        SequenceIterator<T> sequenceIterator = new SequenceIterator<T>(iterators);
        if (sequenceIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "concatIterators"));
        }
        return sequenceIterator;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> concat(final T[] ... iterables) {
        if (iterables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterables", "com/intellij/util/containers/ContainerUtil", "concat"));
        }
        Iterable iterable = new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                Iterator i2;
                Iterator[] iterators = new Iterator[iterables.length];
                for (int i3 = 0; i3 < iterables.length; ++i3) {
                    Object[] iterable = iterables[i3];
                    iterators[i3] = ContainerUtil.iterate(iterable);
                }
                Iterator iterator = i2 = ContainerUtil.concatIterators(iterators);
                if (iterator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$12", "iterator"));
                }
                return iterator;
            }
        };
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "concat"));
        }
        return iterable;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> concat(final List<? extends T> ... lists) {
        if (lists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lists", "com/intellij/util/containers/ContainerUtil", "concat"));
        }
        int size = 0;
        for (List<T> list : lists) {
            size += list.size();
        }
        if (size == 0) {
            List<T> list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "concat"));
            }
            return list;
        }
        final int finalSize = size;
        AbstractList abstractList = new AbstractList<T>(){

            @Override
            public T get(int index) {
                if (index >= 0 && index < finalSize) {
                    int from = 0;
                    for (List each : lists) {
                        if (from <= index && index < from + each.size()) {
                            return each.get(index - from);
                        }
                        from += each.size();
                    }
                    if (from != finalSize) {
                        throw new ConcurrentModificationException("The list has changed. Its size was " + finalSize + "; now it's " + from);
                    }
                }
                throw new IndexOutOfBoundsException("index: " + index + "size: " + this.size());
            }

            @Override
            public int size() {
                return finalSize;
            }
        };
        if (abstractList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "concat"));
        }
        return abstractList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> concat(@NotNull List<List<? extends T>> lists) {
        if (lists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lists", "com/intellij/util/containers/ContainerUtil", "concat"));
        }
        List[] array = lists.toArray(new List[lists.size()]);
        List<T> list = ContainerUtil.concat(array);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "concat"));
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<T> concat(@NotNull Iterable<? extends V> list, @NotNull Function<V, Collection<? extends T>> listGenerator) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ContainerUtil", "concat"));
        }
        if (listGenerator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listGenerator", "com/intellij/util/containers/ContainerUtil", "concat"));
        }
        ArrayList<T> result = new ArrayList<T>();
        for (V v : list) {
            result.addAll(listGenerator.fun(v));
        }
        List<T> list2 = result.isEmpty() ? ContainerUtil.emptyList() : result;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "concat"));
        }
        return list2;
    }

    @Contract(pure=true)
    public static <T> boolean intersects(@NotNull Collection<? extends T> collection1, @NotNull Collection<? extends T> collection2) {
        if (collection1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection1", "com/intellij/util/containers/ContainerUtil", "intersects"));
        }
        if (collection2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection2", "com/intellij/util/containers/ContainerUtil", "intersects"));
        }
        if (collection1.size() <= collection2.size()) {
            for (T t : collection1) {
                if (!collection2.contains(t)) continue;
                return true;
            }
        } else {
            for (T t : collection2) {
                if (!collection1.contains(t)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Collection<T> intersection(@NotNull Collection<? extends T> collection1, @NotNull Collection<? extends T> collection2) {
        if (collection1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection1", "com/intellij/util/containers/ContainerUtil", "intersection"));
        }
        if (collection2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection2", "com/intellij/util/containers/ContainerUtil", "intersection"));
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T t : collection1) {
            if (!collection2.contains(t)) continue;
            result.add(t);
        }
        List<T> list = result.isEmpty() ? ContainerUtil.emptyList() : result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "intersection"));
        }
        return list;
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T getFirstItem(@Nullable Collection<T> items) {
        return ContainerUtil.getFirstItem(items, null);
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T getFirstItem(@Nullable List<T> items) {
        return items == null || items.isEmpty() ? null : (T)items.get(0);
    }

    @Contract(pure=true)
    public static <T> T getFirstItem(@Nullable Collection<T> items, @Nullable T defaultResult) {
        return items == null || items.isEmpty() ? defaultResult : items.iterator().next();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> getFirstItems(@NotNull List<T> items, int maxItems) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/util/containers/ContainerUtil", "getFirstItems"));
        }
        List<T> list = items.subList(0, Math.min(maxItems, items.size()));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "getFirstItems"));
        }
        return list;
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T iterateAndGetLastItem(@NotNull Iterable<T> items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/util/containers/ContainerUtil", "iterateAndGetLastItem"));
        }
        Iterator<T> itr = items.iterator();
        T res = null;
        while (itr.hasNext()) {
            res = itr.next();
        }
        return res;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, U> Iterator<U> mapIterator(final @NotNull Iterator<T> iterator, final @NotNull Function<T, U> mapper) {
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/util/containers/ContainerUtil", "mapIterator"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/util/containers/ContainerUtil", "mapIterator"));
        }
        Iterator iterator2 = new Iterator<U>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public U next() {
                return mapper.fun(iterator.next());
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
        if (iterator2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "mapIterator"));
        }
        return iterator2;
    }

    @Nullable
    @Contract(pure=true)
    public static <T, L extends List<T>> T getLastItem(@Nullable L list, @Nullable T def) {
        return ContainerUtil.isEmpty(list) ? def : list.get(list.size() - 1);
    }

    @Nullable
    @Contract(pure=true)
    public static <T, L extends List<T>> T getLastItem(@Nullable L list) {
        return ContainerUtil.getLastItem(list, null);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Collection<T> subtract(@NotNull Collection<T> from, @NotNull Collection<T> what) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/util/containers/ContainerUtil", "subtract"));
        }
        if (what == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "com/intellij/util/containers/ContainerUtil", "subtract"));
        }
        HashSet<T> set = ContainerUtil.newHashSet(from);
        set.removeAll(what);
        Collection<T> collection = set.isEmpty() ? ContainerUtil.emptyList() : set;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "subtract"));
        }
        return collection;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] toArray(@Nullable Collection<T> c, @NotNull ArrayFactory<T> factory) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/util/containers/ContainerUtil", "toArray"));
        }
        T[] TArray = c != null ? c.toArray(factory.create(c.size())) : factory.create(0);
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "toArray"));
        }
        return TArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] toArray(@NotNull Collection<? extends T> c1, @NotNull Collection<? extends T> c2, @NotNull ArrayFactory<T> factory) {
        if (c1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c1", "com/intellij/util/containers/ContainerUtil", "toArray"));
        }
        if (c2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c2", "com/intellij/util/containers/ContainerUtil", "toArray"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/util/containers/ContainerUtil", "toArray"));
        }
        T[] TArray = ArrayUtil.mergeCollections(c1, c2, factory);
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "toArray"));
        }
        return TArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] mergeCollectionsToArray(@NotNull Collection<? extends T> c1, @NotNull Collection<? extends T> c2, @NotNull ArrayFactory<T> factory) {
        if (c1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c1", "com/intellij/util/containers/ContainerUtil", "mergeCollectionsToArray"));
        }
        if (c2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c2", "com/intellij/util/containers/ContainerUtil", "mergeCollectionsToArray"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/util/containers/ContainerUtil", "mergeCollectionsToArray"));
        }
        T[] TArray = ArrayUtil.mergeCollections(c1, c2, factory);
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "mergeCollectionsToArray"));
        }
        return TArray;
    }

    public static <T extends Comparable<T>> void sort(@NotNull List<T> list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ContainerUtil", "sort"));
        }
        int size = list.size();
        if (size < 2) {
            return;
        }
        if (size == 2) {
            Comparable t1;
            Comparable t0 = (Comparable)list.get(0);
            if (t0.compareTo(t1 = (Comparable)list.get(1)) > 0) {
                list.set(0, t1);
                list.set(1, t0);
            }
        } else if (size < 10) {
            for (int i2 = 0; i2 < size; ++i2) {
                for (int j = 0; j < i2; ++j) {
                    Comparable tj;
                    Comparable ti = (Comparable)list.get(i2);
                    if (ti.compareTo(tj = (Comparable)list.get(j)) >= 0) continue;
                    list.set(i2, tj);
                    list.set(j, ti);
                }
            }
        } else {
            Collections.sort(list);
        }
    }

    public static <T> void sort(@NotNull List<T> list, @NotNull Comparator<? super T> comparator) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ContainerUtil", "sort"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/util/containers/ContainerUtil", "sort"));
        }
        int size = list.size();
        if (size < 2) {
            return;
        }
        if (size == 2) {
            T t1;
            T t0 = list.get(0);
            if (comparator.compare(t0, t1 = list.get(1)) > 0) {
                list.set(0, t1);
                list.set(1, t0);
            }
        } else if (size < 10) {
            for (int i2 = 0; i2 < size; ++i2) {
                for (int j = 0; j < i2; ++j) {
                    T tj;
                    T ti = list.get(i2);
                    if (comparator.compare(ti, tj = list.get(j)) >= 0) continue;
                    list.set(i2, tj);
                    list.set(j, ti);
                }
            }
        } else {
            Collections.sort(list, comparator);
        }
    }

    public static <T extends Comparable<T>> void sort(@NotNull T[] a) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/intellij/util/containers/ContainerUtil", "sort"));
        }
        int size = a.length;
        if (size < 2) {
            return;
        }
        if (size == 2) {
            T t0 = a[0];
            T t1 = a[1];
            if (t0.compareTo(t1) > 0) {
                a[0] = t1;
                a[1] = t0;
            }
        } else if (size < 10) {
            for (int i2 = 0; i2 < size; ++i2) {
                for (int j = 0; j < i2; ++j) {
                    T ti = a[i2];
                    T tj = a[j];
                    if (ti.compareTo(tj) >= 0) continue;
                    a[i2] = tj;
                    a[j] = ti;
                }
            }
        } else {
            Arrays.sort(a);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> sorted(@NotNull Collection<T> list, @NotNull Comparator<? super T> comparator) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ContainerUtil", "sorted"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/util/containers/ContainerUtil", "sorted"));
        }
        List<? super T> list2 = ContainerUtil.sorted(list, comparator);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "sorted"));
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> sorted(@NotNull Iterable<T> list, @NotNull Comparator<? super T> comparator) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ContainerUtil", "sorted"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/util/containers/ContainerUtil", "sorted"));
        }
        ArrayList<T> sorted = ContainerUtil.newArrayList(list);
        ContainerUtil.sort(sorted, comparator);
        ArrayList<T> arrayList = sorted;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "sorted"));
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T extends Comparable<? super T>> List<T> sorted(@NotNull Collection<T> list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ContainerUtil", "sorted"));
        }
        List<T> list2 = ContainerUtil.sorted(list, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o1.compareTo(o2);
            }
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "sorted"));
        }
        return list2;
    }

    public static <T> void sort(@NotNull T[] a, @NotNull Comparator<T> comparator) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/intellij/util/containers/ContainerUtil", "sort"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/util/containers/ContainerUtil", "sort"));
        }
        int size = a.length;
        if (size < 2) {
            return;
        }
        if (size == 2) {
            T t0 = a[0];
            T t1 = a[1];
            if (comparator.compare(t0, t1) > 0) {
                a[0] = t1;
                a[1] = t0;
            }
        } else if (size < 10) {
            for (int i2 = 0; i2 < size; ++i2) {
                for (int j = 0; j < i2; ++j) {
                    T ti = a[i2];
                    T tj = a[j];
                    if (comparator.compare(ti, tj) >= 0) continue;
                    a[i2] = tj;
                    a[j] = ti;
                }
            }
        } else {
            Arrays.sort(a, comparator);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map(@NotNull Iterable<? extends T> iterable, @NotNull Function<T, V> mapping) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/util/containers/ContainerUtil", "map"));
        }
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/util/containers/ContainerUtil", "map"));
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T t : iterable) {
            result.add(mapping.fun(t));
        }
        List<T> list = result.isEmpty() ? ContainerUtil.emptyList() : result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "map"));
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map(@NotNull Collection<? extends T> iterable, @NotNull Function<T, V> mapping) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/util/containers/ContainerUtil", "map"));
        }
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/util/containers/ContainerUtil", "map"));
        }
        if (iterable.isEmpty()) {
            List<T> list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "map"));
            }
            return list;
        }
        ArrayList<V> result = new ArrayList<V>(iterable.size());
        for (T t : iterable) {
            result.add(mapping.fun(t));
        }
        ArrayList<V> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "map"));
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> mapNotNull(@NotNull T[] array, @NotNull Function<T, V> mapping) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/containers/ContainerUtil", "mapNotNull"));
        }
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/util/containers/ContainerUtil", "mapNotNull"));
        }
        List<V> list = ContainerUtil.mapNotNull(Arrays.asList(array), mapping);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "mapNotNull"));
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] mapNotNull(@NotNull T[] array, @NotNull Function<T, V> mapping, @NotNull V[] emptyArray) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/containers/ContainerUtil", "mapNotNull"));
        }
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/util/containers/ContainerUtil", "mapNotNull"));
        }
        if (emptyArray == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "emptyArray", "com/intellij/util/containers/ContainerUtil", "mapNotNull"));
        }
        ArrayList<V> result = new ArrayList<V>(array.length);
        for (T t : array) {
            V v = mapping.fun(t);
            if (v == null) continue;
            result.add(v);
        }
        if (result.isEmpty()) {
            assert (emptyArray.length == 0) : "You must pass an empty array";
            if (emptyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "mapNotNull"));
            }
            return emptyArray;
        }
        V[] VArray = result.toArray(emptyArray);
        if (VArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "mapNotNull"));
        }
        return VArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> mapNotNull(@NotNull Iterable<? extends T> iterable, @NotNull Function<T, V> mapping) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/util/containers/ContainerUtil", "mapNotNull"));
        }
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/util/containers/ContainerUtil", "mapNotNull"));
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T t : iterable) {
            V o = mapping.fun(t);
            if (o == null) continue;
            result.add(o);
        }
        List<T> list = result.isEmpty() ? ContainerUtil.emptyList() : result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "mapNotNull"));
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> mapNotNull(@NotNull Collection<? extends T> iterable, @NotNull Function<T, V> mapping) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/util/containers/ContainerUtil", "mapNotNull"));
        }
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/util/containers/ContainerUtil", "mapNotNull"));
        }
        if (iterable.isEmpty()) {
            List<T> list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "mapNotNull"));
            }
            return list;
        }
        ArrayList<T> result = new ArrayList<T>(iterable.size());
        for (T t : iterable) {
            V o = mapping.fun(t);
            if (o == null) continue;
            result.add(o);
        }
        List<T> list = result.isEmpty() ? ContainerUtil.emptyList() : result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "mapNotNull"));
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> packNullables(T ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtil", "packNullables"));
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T element : elements) {
            ContainerUtil.addIfNotNull(list, element);
        }
        List<T> list2 = list.isEmpty() ? ContainerUtil.emptyList() : list;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "packNullables"));
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map(@NotNull T[] array, @NotNull Function<T, V> mapping) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/containers/ContainerUtil", "map"));
        }
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/util/containers/ContainerUtil", "map"));
        }
        ArrayList<T> result = new ArrayList<T>(array.length);
        for (T t : array) {
            result.add(mapping.fun(t));
        }
        List<T> list = result.isEmpty() ? ContainerUtil.emptyList() : result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "map"));
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] map(@NotNull T[] arr, @NotNull Function<T, V> mapping, @NotNull V[] emptyArray) {
        if (arr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arr", "com/intellij/util/containers/ContainerUtil", "map"));
        }
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/util/containers/ContainerUtil", "map"));
        }
        if (emptyArray == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "emptyArray", "com/intellij/util/containers/ContainerUtil", "map"));
        }
        if (arr.length == 0) {
            assert (emptyArray.length == 0) : "You must pass an empty array";
            if (emptyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "map"));
            }
            return emptyArray;
        }
        ArrayList<V> result = new ArrayList<V>(arr.length);
        for (T t : arr) {
            result.add(mapping.fun(t));
        }
        V[] VArray = result.toArray(emptyArray);
        if (VArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "map"));
        }
        return VArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> set(T ... items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/util/containers/ContainerUtil", "set"));
        }
        HashSet<T> hashSet = ContainerUtil.newHashSet(items);
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "set"));
        }
        return hashSet;
    }

    public static <K, V> void putIfNotNull(K key, @Nullable V value, @NotNull Map<K, V> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/containers/ContainerUtil", "putIfNotNull"));
        }
        if (value != null) {
            result.put(key, value);
        }
    }

    public static <K, V> void putIfNotNull(K key, @Nullable Collection<? extends V> value, @NotNull MultiMap<K, V> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/containers/ContainerUtil", "putIfNotNull"));
        }
        if (value != null) {
            result.putValues(key, value);
        }
    }

    public static <K, V> void putIfNotNull(K key, @Nullable V value, @NotNull MultiMap<K, V> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/containers/ContainerUtil", "putIfNotNull"));
        }
        if (value != null) {
            result.putValue(key, value);
        }
    }

    public static <T> void add(final T element, final @NotNull Collection<T> result, @NotNull Disposable parentDisposable) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/containers/ContainerUtil", "add"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/util/containers/ContainerUtil", "add"));
        }
        if (result.add(element)) {
            Disposer.register(parentDisposable, new Disposable(){

                @Override
                public void dispose() {
                    result.remove(element);
                }
            });
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> createMaybeSingletonList(@Nullable T element) {
        List<T> list = element == null ? ContainerUtil.emptyList() : Collections.singletonList(element);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createMaybeSingletonList"));
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> createMaybeSingletonSet(@Nullable T element) {
        Set set = element == null ? Collections.emptySet() : Collections.singleton(element);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createMaybeSingletonSet"));
        }
        return set;
    }

    @NotNull
    public static <T, V> V getOrCreate(@NotNull Map<T, V> result, T key, @NotNull V defaultValue) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/containers/ContainerUtil", "getOrCreate"));
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "com/intellij/util/containers/ContainerUtil", "getOrCreate"));
        }
        V value = result.get(key);
        if (value == null) {
            value = defaultValue;
            result.put(key, value);
        }
        V v = value;
        if (v == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "getOrCreate"));
        }
        return v;
    }

    public static <T, V> V getOrCreate(@NotNull Map<T, V> result, T key, @NotNull Factory<V> factory) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/containers/ContainerUtil", "getOrCreate"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/util/containers/ContainerUtil", "getOrCreate"));
        }
        V value = result.get(key);
        if (value == null) {
            value = factory.create();
            result.put(key, value);
        }
        return value;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V getOrElse(@NotNull Map<T, V> result, T key, @NotNull V defValue) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/containers/ContainerUtil", "getOrElse"));
        }
        if (defValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defValue", "com/intellij/util/containers/ContainerUtil", "getOrElse"));
        }
        V value = result.get(key);
        V v = value == null ? defValue : value;
        if (v == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "getOrElse"));
        }
        return v;
    }

    @Contract(pure=true)
    public static <T> boolean and(@NotNull T[] iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/util/containers/ContainerUtil", "and"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/ContainerUtil", "and"));
        }
        return ContainerUtil.and(Arrays.asList(iterable), condition);
    }

    @Contract(pure=true)
    public static <T> boolean and(@NotNull Iterable<T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/util/containers/ContainerUtil", "and"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/ContainerUtil", "and"));
        }
        for (T t : iterable) {
            if (condition.value(t)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> boolean exists(@NotNull T[] iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/util/containers/ContainerUtil", "exists"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/ContainerUtil", "exists"));
        }
        return ContainerUtil.or(Arrays.asList(iterable), condition);
    }

    @Contract(pure=true)
    public static <T> boolean exists(@NotNull Iterable<T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/util/containers/ContainerUtil", "exists"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/ContainerUtil", "exists"));
        }
        return ContainerUtil.or(iterable, condition);
    }

    @Contract(pure=true)
    public static <T> boolean or(@NotNull T[] iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/util/containers/ContainerUtil", "or"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/ContainerUtil", "or"));
        }
        return ContainerUtil.or(Arrays.asList(iterable), condition);
    }

    @Contract(pure=true)
    public static <T> boolean or(@NotNull Iterable<T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/util/containers/ContainerUtil", "or"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/ContainerUtil", "or"));
        }
        for (T t : iterable) {
            if (!condition.value(t)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> unfold(@Nullable T t, @NotNull NullableFunction<T, T> next) {
        if (next == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/util/containers/ContainerUtil", "unfold"));
        }
        if (t == null) {
            List<T> list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "unfold"));
            }
            return list;
        }
        ArrayList<T> list = new ArrayList<T>();
        while (t != null) {
            list.add(t);
            t = next.fun(t);
        }
        ArrayList<T> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "unfold"));
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> dropTail(@NotNull List<T> items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/util/containers/ContainerUtil", "dropTail"));
        }
        List<T> list = items.subList(0, items.size() - 1);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "dropTail"));
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> list(T ... items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/util/containers/ContainerUtil", "list"));
        }
        List<T> list = Arrays.asList(items);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "list"));
        }
        return list;
    }

    public static <T> void quickSort(@NotNull List<T> list, @NotNull Comparator<? super T> comparator) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ContainerUtil", "quickSort"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/util/containers/ContainerUtil", "quickSort"));
        }
        ContainerUtil.quickSort(list, comparator, 0, list.size());
    }

    private static <T> void quickSort(@NotNull List<T> x, @NotNull Comparator<? super T> comparator, int off, int len) {
        int c;
        int a;
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/intellij/util/containers/ContainerUtil", "quickSort"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/util/containers/ContainerUtil", "quickSort"));
        }
        if (len < 7) {
            for (int i2 = off; i2 < len + off; ++i2) {
                for (int j = i2; j > off && comparator.compare(x.get(j), x.get(j - 1)) < 0; --j) {
                    ContainerUtil.swapElements(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = ContainerUtil.med3(x, comparator, l, l + s, l + 2 * s);
                m = ContainerUtil.med3(x, comparator, m - s, m, m + s);
                n = ContainerUtil.med3(x, comparator, n - 2 * s, n - s, n);
            }
            m = ContainerUtil.med3(x, comparator, l, m, n);
        }
        T v = x.get(m);
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && comparator.compare(x.get(b), v) <= 0) {
                if (comparator.compare(x.get(b), v) == 0) {
                    ContainerUtil.swapElements(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && comparator.compare(v, x.get(c)) <= 0) {
                if (comparator.compare(x.get(c), v) == 0) {
                    ContainerUtil.swapElements(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ContainerUtil.swapElements(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        ContainerUtil.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        ContainerUtil.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            ContainerUtil.quickSort(x, comparator, off, s);
        }
        if ((s = d - c) > 1) {
            ContainerUtil.quickSort(x, comparator, n - s, s);
        }
    }

    private static <T> int med3(@NotNull List<T> x, Comparator<? super T> comparator, int a, int b, int c) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/intellij/util/containers/ContainerUtil", "med3"));
        }
        return comparator.compare(x.get(a), x.get(b)) < 0 ? (comparator.compare(x.get(b), x.get(c)) < 0 ? b : (comparator.compare(x.get(a), x.get(c)) < 0 ? c : a)) : (comparator.compare(x.get(c), x.get(b)) < 0 ? b : (comparator.compare(x.get(c), x.get(a)) < 0 ? c : a));
    }

    private static <T> void vecswap(List<T> x, int a, int b, int n) {
        int i2 = 0;
        while (i2 < n) {
            ContainerUtil.swapElements(x, a, b);
            ++i2;
            ++a;
            ++b;
        }
    }

    public static void mergeSortedArrays(@NotNull TIntArrayList x1, @NotNull TIntArrayList y1, @NotNull TIntArrayList x2, @NotNull TIntArrayList y2) {
        if (x1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x1", "com/intellij/util/containers/ContainerUtil", "mergeSortedArrays"));
        }
        if (y1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "y1", "com/intellij/util/containers/ContainerUtil", "mergeSortedArrays"));
        }
        if (x2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x2", "com/intellij/util/containers/ContainerUtil", "mergeSortedArrays"));
        }
        if (y2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "y2", "com/intellij/util/containers/ContainerUtil", "mergeSortedArrays"));
        }
        TIntArrayList newX = new TIntArrayList();
        TIntArrayList newY = new TIntArrayList();
        int i2 = 0;
        int j = 0;
        while (i2 < x1.size() && j < x2.size()) {
            if (x1.get(i2) < x2.get(j) || x1.get(i2) == x2.get(j) && y1.get(i2) < y2.get(j)) {
                newX.add(x1.get(i2));
                newY.add(y1.get(i2));
                ++i2;
                continue;
            }
            if (x1.get(i2) > x2.get(j) || x1.get(i2) == x2.get(j) && y1.get(i2) > y2.get(j)) {
                newX.add(x2.get(j));
                newY.add(y2.get(j));
                ++j;
                continue;
            }
            newX.add(x1.get(i2));
            newY.add(y1.get(i2));
            ++i2;
            ++j;
        }
        while (i2 < x1.size()) {
            newX.add(x1.get(i2));
            newY.add(y1.get(i2));
            ++i2;
        }
        while (j < x2.size()) {
            newX.add(x2.get(j));
            newY.add(y2.get(j));
            ++j;
        }
        x1.clear();
        y1.clear();
        x1.add(newX.toNativeArray());
        y1.add(newY.toNativeArray());
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> singleton(T o, @NotNull TObjectHashingStrategy<T> strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/util/containers/ContainerUtil", "singleton"));
        }
        Set<T> set = strategy == TObjectHashingStrategy.CANONICAL ? new SingletonSet<T>(o) : SingletonSet.withCustomStrategy(o, strategy);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "singleton"));
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> List<E> flatten(@NotNull Collection<E>[] collections) {
        if (collections == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collections", "com/intellij/util/containers/ContainerUtil", "flatten"));
        }
        List<E> list = ContainerUtil.flatten(Arrays.asList(collections));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "flatten"));
        }
        return list;
    }

    @NotNull
    public static <T> List<T> removeDuplicatesFromSorted(@NotNull List<T> list, @NotNull Comparator<? super T> comparator) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ContainerUtil", "removeDuplicatesFromSorted"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/util/containers/ContainerUtil", "removeDuplicatesFromSorted"));
        }
        Object prev = null;
        ArrayList<T> result = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            int cmp;
            T t = list.get(i2);
            if (t == null) {
                throw new IllegalArgumentException("get(" + i2 + ") = null");
            }
            int n = cmp = prev == null ? -1 : comparator.compare(prev, t);
            if (cmp < 0) {
                if (result != null) {
                    result.add(t);
                }
            } else if (cmp == 0) {
                if (result == null) {
                    result = new ArrayList<T>(list.size());
                    result.addAll(list.subList(0, i2));
                }
            } else {
                throw new IllegalArgumentException("List must be sorted but get(" + (i2 - 1) + ")=" + list.get(i2 - 1) + " > get(" + i2 + ")=" + t);
            }
            prev = t;
        }
        List<T> list2 = result == null ? list : result;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "removeDuplicatesFromSorted"));
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> List<E> flatten(@NotNull Iterable<? extends Collection<E>> collections) {
        if (collections == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collections", "com/intellij/util/containers/ContainerUtil", "flatten"));
        }
        ArrayList result = new ArrayList();
        for (Collection<E> list : collections) {
            result.addAll(list);
        }
        List list = result.isEmpty() ? ContainerUtil.emptyList() : result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "flatten"));
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> List<E> flattenIterables(@NotNull Iterable<? extends Iterable<E>> collections) {
        if (collections == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collections", "com/intellij/util/containers/ContainerUtil", "flattenIterables"));
        }
        ArrayList result = new ArrayList();
        for (Iterable<E> list : collections) {
            for (E e : list) {
                result.add(e);
            }
        }
        List list = result.isEmpty() ? ContainerUtil.emptyList() : result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "flattenIterables"));
        }
        return list;
    }

    @NotNull
    public static <K, V> V[] convert(@NotNull K[] from, @NotNull V[] to, @NotNull Function<K, V> fun) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/util/containers/ContainerUtil", "convert"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/util/containers/ContainerUtil", "convert"));
        }
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "com/intellij/util/containers/ContainerUtil", "convert"));
        }
        if (to.length < from.length) {
            Object[] array = (Object[])Array.newInstance(to.getClass().getComponentType(), from.length);
            to = array;
        }
        for (int i2 = 0; i2 < from.length; ++i2) {
            to[i2] = fun.fun(from[i2]);
        }
        if (to == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "convert"));
        }
        return to;
    }

    @Contract(pure=true)
    public static <T> boolean containsIdentity(@NotNull Iterable<T> list, T element) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ContainerUtil", "containsIdentity"));
        }
        for (T t : list) {
            if (t != element) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static <T> int indexOfIdentity(@NotNull List<T> list, T element) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ContainerUtil", "indexOfIdentity"));
        }
        int listSize = list.size();
        for (int i2 = 0; i2 < listSize; ++i2) {
            if (list.get(i2) != element) continue;
            return i2;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> boolean equalsIdentity(@NotNull List<T> list1, @NotNull List<T> list2) {
        if (list1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list1", "com/intellij/util/containers/ContainerUtil", "equalsIdentity"));
        }
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list2", "com/intellij/util/containers/ContainerUtil", "equalsIdentity"));
        }
        int listSize = list1.size();
        if (list2.size() != listSize) {
            return false;
        }
        for (int i2 = 0; i2 < listSize; ++i2) {
            if (list1.get(i2) == list2.get(i2)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> int indexOf(@NotNull List<T> list, @NotNull Condition<? super T> condition) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ContainerUtil", "indexOf"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/ContainerUtil", "indexOf"));
        }
        int listSize = list.size();
        for (int i2 = 0; i2 < listSize; ++i2) {
            T t = list.get(i2);
            if (!condition.value(t)) continue;
            return i2;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> int lastIndexOf(@NotNull List<T> list, @NotNull Condition<? super T> condition) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ContainerUtil", "lastIndexOf"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/ContainerUtil", "lastIndexOf"));
        }
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            T t = list.get(i2);
            if (!condition.value(t)) continue;
            return i2;
        }
        return -1;
    }

    @Nullable
    @Contract(pure=true)
    public static <T, U extends T> U findLastInstance(@NotNull List<T> list, final @NotNull Class<U> clazz) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ContainerUtil", "findLastInstance"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/util/containers/ContainerUtil", "findLastInstance"));
        }
        int i2 = ContainerUtil.lastIndexOf(list, new Condition<T>(){

            @Override
            public boolean value(T t) {
                return clazz.isInstance(t);
            }
        });
        return i2 < 0 ? null : (U)list.get(i2);
    }

    @Contract(pure=true)
    public static <T, U extends T> int lastIndexOfInstance(@NotNull List<T> list, final @NotNull Class<U> clazz) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ContainerUtil", "lastIndexOfInstance"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/util/containers/ContainerUtil", "lastIndexOfInstance"));
        }
        return ContainerUtil.lastIndexOf(list, new Condition<T>(){

            @Override
            public boolean value(T t) {
                return clazz.isInstance(t);
            }
        });
    }

    @Contract(pure=true)
    public static <T> int indexOf(@NotNull List<T> list, final @NotNull T object) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ContainerUtil", "indexOf"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/util/containers/ContainerUtil", "indexOf"));
        }
        return ContainerUtil.indexOf(list, new Condition<T>(){

            @Override
            public boolean value(T t) {
                return t.equals(object);
            }
        });
    }

    @NotNull
    @Contract(pure=true)
    public static <A, B> Map<B, A> reverseMap(@NotNull Map<A, B> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/util/containers/ContainerUtil", "reverseMap"));
        }
        HashMap<B, A> result = ContainerUtil.newHashMap();
        for (Map.Entry<A, B> entry : map.entrySet()) {
            result.put(entry.getValue(), entry.getKey());
        }
        HashMap<B, A> hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "reverseMap"));
        }
        return hashMap;
    }

    @Contract(pure=true)
    public static <T> boolean processRecursively(T root, @NotNull PairProcessor<T, List<T>> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/containers/ContainerUtil", "processRecursively"));
        }
        LinkedList<T> list = new LinkedList<T>();
        list.add(root);
        while (!list.isEmpty()) {
            Object o = list.removeFirst();
            if (processor.process(o, list)) continue;
            return false;
        }
        return true;
    }

    @Contract(value="null -> null; !null -> !null")
    public static <T> List<T> trimToSize(@Nullable List<T> list) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Stack<T> newStack() {
        Stack stack = ContainerUtilRt.newStack();
        if (stack == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newStack"));
        }
        return stack;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Stack<T> newStack(@NotNull Collection<T> initial) {
        if (initial == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initial", "com/intellij/util/containers/ContainerUtil", "newStack"));
        }
        Stack<T> stack = ContainerUtilRt.newStack(initial);
        if (stack == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newStack"));
        }
        return stack;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Stack<T> newStack(T ... initial) {
        if (initial == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initial", "com/intellij/util/containers/ContainerUtil", "newStack"));
        }
        Stack<T> stack = ContainerUtilRt.newStack(initial);
        if (stack == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newStack"));
        }
        return stack;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> emptyList() {
        List list = ContainerUtilRt.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "emptyList"));
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> CopyOnWriteArrayList<T> createEmptyCOWList() {
        CopyOnWriteArrayList copyOnWriteArrayList = ContainerUtilRt.createEmptyCOWList();
        if (copyOnWriteArrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createEmptyCOWList"));
        }
        return copyOnWriteArrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> createLockFreeCopyOnWriteList() {
        ConcurrentList<T> concurrentList = ContainerUtil.createConcurrentList();
        if (concurrentList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createLockFreeCopyOnWriteList"));
        }
        return concurrentList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> createLockFreeCopyOnWriteList(@NotNull Collection<? extends T> c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/ContainerUtil", "createLockFreeCopyOnWriteList"));
        }
        LockFreeCopyOnWriteArrayList<? extends T> lockFreeCopyOnWriteArrayList = new LockFreeCopyOnWriteArrayList<T>(c);
        if (lockFreeCopyOnWriteArrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createLockFreeCopyOnWriteList"));
        }
        return lockFreeCopyOnWriteArrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectMap() {
        ConcurrentIntObjectHashMap concurrentIntObjectHashMap = new ConcurrentIntObjectHashMap();
        if (concurrentIntObjectHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createConcurrentIntObjectMap"));
        }
        return concurrentIntObjectHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        ConcurrentIntObjectHashMap concurrentIntObjectHashMap = new ConcurrentIntObjectHashMap(initialCapacity, loadFactor, concurrencyLevel);
        if (concurrentIntObjectHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createConcurrentIntObjectMap"));
        }
        return concurrentIntObjectHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectSoftValueMap() {
        ConcurrentSoftValueIntObjectHashMap concurrentSoftValueIntObjectHashMap = new ConcurrentSoftValueIntObjectHashMap();
        if (concurrentSoftValueIntObjectHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createConcurrentIntObjectSoftValueMap"));
        }
        return concurrentSoftValueIntObjectHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <V> ConcurrentLongObjectMap<V> createConcurrentLongObjectMap() {
        ConcurrentLongObjectHashMap concurrentLongObjectHashMap = new ConcurrentLongObjectHashMap();
        if (concurrentLongObjectHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createConcurrentLongObjectMap"));
        }
        return concurrentLongObjectHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <V> ConcurrentLongObjectMap<V> createConcurrentLongObjectMap(int initialCapacity) {
        ConcurrentLongObjectHashMap concurrentLongObjectHashMap = new ConcurrentLongObjectHashMap(initialCapacity);
        if (concurrentLongObjectHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createConcurrentLongObjectMap"));
        }
        return concurrentLongObjectHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakValueMap() {
        ConcurrentWeakValueHashMap concurrentWeakValueHashMap = new ConcurrentWeakValueHashMap();
        if (concurrentWeakValueHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createConcurrentWeakValueMap"));
        }
        return concurrentWeakValueHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectWeakValueMap() {
        ConcurrentWeakValueIntObjectHashMap concurrentWeakValueIntObjectHashMap = new ConcurrentWeakValueIntObjectHashMap();
        if (concurrentWeakValueIntObjectHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createConcurrentIntObjectWeakValueMap"));
        }
        return concurrentWeakValueIntObjectHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeySoftValueMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/containers/ContainerUtil", "createConcurrentWeakKeySoftValueMap"));
        }
        ConcurrentWeakKeySoftValueHashMap concurrentWeakKeySoftValueHashMap = new ConcurrentWeakKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
        if (concurrentWeakKeySoftValueHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createConcurrentWeakKeySoftValueMap"));
        }
        return concurrentWeakKeySoftValueHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftKeySoftValueMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/containers/ContainerUtil", "createConcurrentSoftKeySoftValueMap"));
        }
        ConcurrentSoftKeySoftValueHashMap concurrentSoftKeySoftValueHashMap = new ConcurrentSoftKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
        if (concurrentSoftKeySoftValueHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createConcurrentSoftKeySoftValueMap"));
        }
        return concurrentSoftKeySoftValueHashMap;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeySoftValueMap() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeyWeakValueMap() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeyWeakValueMap(@NotNull TObjectHashingStrategy<K> strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/util/containers/ContainerUtil", "createConcurrentWeakKeyWeakValueMap"));
        }
        ConcurrentWeakKeyWeakValueHashMap concurrentWeakKeyWeakValueHashMap = new ConcurrentWeakKeyWeakValueHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), strategy);
        if (concurrentWeakKeyWeakValueHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createConcurrentWeakKeyWeakValueMap"));
        }
        return concurrentWeakKeyWeakValueHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftValueMap() {
        ConcurrentSoftValueHashMap concurrentSoftValueHashMap = new ConcurrentSoftValueHashMap();
        if (concurrentSoftValueHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createConcurrentSoftValueMap"));
        }
        return concurrentSoftValueHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftMap() {
        ConcurrentSoftHashMap concurrentSoftHashMap = new ConcurrentSoftHashMap();
        if (concurrentSoftHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createConcurrentSoftMap"));
        }
        return concurrentSoftHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap() {
        ConcurrentWeakHashMap concurrentWeakHashMap = new ConcurrentWeakHashMap();
        if (concurrentWeakHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createConcurrentWeakMap"));
        }
        return concurrentWeakHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/containers/ContainerUtil", "createConcurrentSoftMap"));
        }
        ConcurrentSoftHashMap concurrentSoftHashMap = new ConcurrentSoftHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
        if (concurrentSoftHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createConcurrentSoftMap"));
        }
        return concurrentSoftHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/containers/ContainerUtil", "createConcurrentWeakMap"));
        }
        ConcurrentWeakHashMap concurrentWeakHashMap = new ConcurrentWeakHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
        if (concurrentWeakHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createConcurrentWeakMap"));
        }
        return concurrentWeakHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap(@NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/containers/ContainerUtil", "createConcurrentWeakMap"));
        }
        ConcurrentWeakHashMap concurrentWeakHashMap = new ConcurrentWeakHashMap(hashingStrategy);
        if (concurrentWeakHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createConcurrentWeakMap"));
        }
        return concurrentWeakHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ConcurrentList<T> createConcurrentList() {
        LockFreeCopyOnWriteArrayList lockFreeCopyOnWriteArrayList = new LockFreeCopyOnWriteArrayList();
        if (lockFreeCopyOnWriteArrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createConcurrentList"));
        }
        return lockFreeCopyOnWriteArrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ConcurrentList<T> createConcurrentList(@NotNull Collection<? extends T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "createConcurrentList"));
        }
        LockFreeCopyOnWriteArrayList<? extends T> lockFreeCopyOnWriteArrayList = new LockFreeCopyOnWriteArrayList<T>(collection);
        if (lockFreeCopyOnWriteArrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createConcurrentList"));
        }
        return lockFreeCopyOnWriteArrayList;
    }

    @Deprecated
    public static <T> void addIfNotNull(@Nullable T element, @NotNull Collection<T> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/containers/ContainerUtil", "addIfNotNull"));
        }
        ContainerUtilRt.addIfNotNull(element, result);
    }

    public static <T> void addIfNotNull(@NotNull Collection<T> result, @Nullable T element) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/containers/ContainerUtil", "addIfNotNull"));
        }
        ContainerUtilRt.addIfNotNull(result, element);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map2List(@NotNull T[] array, @NotNull Function<T, V> mapper) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/containers/ContainerUtil", "map2List"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/util/containers/ContainerUtil", "map2List"));
        }
        List<V> list = ContainerUtilRt.map2List(array, mapper);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "map2List"));
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map2List(@NotNull Collection<? extends T> collection, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "map2List"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/util/containers/ContainerUtil", "map2List"));
        }
        List<V> list = ContainerUtilRt.map2List(collection, mapper);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "map2List"));
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2Set(@NotNull T[] collection, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "map2Set"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/util/containers/ContainerUtil", "map2Set"));
        }
        Set<V> set = ContainerUtilRt.map2Set(collection, mapper);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "map2Set"));
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2Set(@NotNull Collection<? extends T> collection, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "map2Set"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/util/containers/ContainerUtil", "map2Set"));
        }
        Set<V> set = ContainerUtilRt.map2Set(collection, mapper);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "map2Set"));
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2LinkedSet(@NotNull Collection<? extends T> collection, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "map2LinkedSet"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/util/containers/ContainerUtil", "map2LinkedSet"));
        }
        if (collection.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "map2LinkedSet"));
            }
            return set;
        }
        LinkedHashSet<V> set = new LinkedHashSet<V>(collection.size());
        for (T t : collection) {
            set.add(mapper.fun(t));
        }
        LinkedHashSet<V> linkedHashSet = set;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "map2LinkedSet"));
        }
        return linkedHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2SetNotNull(@NotNull Collection<? extends T> collection, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "map2SetNotNull"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/util/containers/ContainerUtil", "map2SetNotNull"));
        }
        if (collection.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "map2SetNotNull"));
            }
            return set;
        }
        HashSet set = new HashSet(collection.size());
        for (T t : collection) {
            V value = mapper.fun(t);
            if (value == null) continue;
            set.add(value);
        }
        Set set2 = set.isEmpty() ? Collections.emptySet() : set;
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "map2SetNotNull"));
        }
        return set2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] toArray(@NotNull List<T> collection, @NotNull T[] array) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "toArray"));
        }
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/containers/ContainerUtil", "toArray"));
        }
        T[] TArray = ContainerUtilRt.toArray(collection, array);
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "toArray"));
        }
        return TArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] toArray(@NotNull Collection<T> c, @NotNull T[] sample) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/ContainerUtil", "toArray"));
        }
        if (sample == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sample", "com/intellij/util/containers/ContainerUtil", "toArray"));
        }
        T[] TArray = ContainerUtilRt.toArray(c, sample);
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "toArray"));
        }
        return TArray;
    }

    @NotNull
    public static <T> T[] copyAndClear(@NotNull Collection<T> collection, @NotNull ArrayFactory<T> factory, boolean clear) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "copyAndClear"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/util/containers/ContainerUtil", "copyAndClear"));
        }
        int size = collection.size();
        T[] a = factory.create(size);
        if (size > 0) {
            a = collection.toArray(a);
            if (clear) {
                collection.clear();
            }
        }
        if (a == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "copyAndClear"));
        }
        return a;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Collection<T> toCollection(@NotNull Iterable<T> iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/util/containers/ContainerUtil", "toCollection"));
        }
        ArrayList<T> arrayList = iterable instanceof Collection ? (ArrayList<T>)iterable : ContainerUtil.newArrayList(iterable);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "toCollection"));
        }
        return arrayList;
    }

    @NotNull
    public static <T> List<T> toList(@NotNull Enumeration<T> enumeration) {
        if (enumeration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumeration", "com/intellij/util/containers/ContainerUtil", "toList"));
        }
        if (!enumeration.hasMoreElements()) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "toList"));
            }
            return list;
        }
        SmartList<T> result = new SmartList<T>();
        while (enumeration.hasMoreElements()) {
            result.add(enumeration.nextElement());
        }
        SmartList<T> smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "toList"));
        }
        return smartList;
    }

    @Contract(value="null -> true", pure=true)
    public static <T> boolean isEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> notNullize(@Nullable List<T> list) {
        List list2 = list == null ? ContainerUtilRt.emptyList() : list;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "notNullize"));
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> notNullize(@Nullable Set<T> set) {
        Set set2 = set == null ? Collections.emptySet() : set;
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "notNullize"));
        }
        return set2;
    }

    @Nullable
    @Contract(pure=true)
    public static <T, C extends Collection<T>> C nullize(@Nullable C collection) {
        return ContainerUtil.isEmpty(collection) ? null : (C)collection;
    }

    private static boolean isAtLeastJava7() {
        return StringUtil.compareVersionNumbers(SystemInfo.JAVA_VERSION, "1.7") >= 0;
    }

    @Contract(pure=true)
    public static <T extends Comparable<T>> int compareLexicographically(@NotNull List<T> o1, @NotNull List<T> o2) {
        if (o1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/util/containers/ContainerUtil", "compareLexicographically"));
        }
        if (o2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/util/containers/ContainerUtil", "compareLexicographically"));
        }
        for (int i2 = 0; i2 < Math.min(o1.size(), o2.size()); ++i2) {
            int result = Comparing.compare((Comparable)o1.get(i2), (Comparable)o2.get(i2));
            if (result == 0) continue;
            return result;
        }
        return o1.size() < o2.size() ? -1 : (o1.size() == o2.size() ? 0 : 1);
    }

    @Contract(pure=true)
    public static <T> int compareLexicographically(@NotNull List<T> o1, @NotNull List<T> o2, @NotNull Comparator<T> comparator) {
        if (o1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/util/containers/ContainerUtil", "compareLexicographically"));
        }
        if (o2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/util/containers/ContainerUtil", "compareLexicographically"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/util/containers/ContainerUtil", "compareLexicographically"));
        }
        for (int i2 = 0; i2 < Math.min(o1.size(), o2.size()); ++i2) {
            int result = comparator.compare(o1.get(i2), o2.get(i2));
            if (result == 0) continue;
            return result;
        }
        return o1.size() < o2.size() ? -1 : (o1.size() == o2.size() ? 0 : 1);
    }

    @NotNull
    @Contract(pure=true)
    public static String toString(@NotNull Map<?, ?> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/util/containers/ContainerUtil", "toString"));
        }
        StringBuilder sb = new StringBuilder("{");
        Iterator<Map.Entry<?, ?>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> entry = iterator.next();
            sb.append(entry.getKey()).append('=').append(entry.getValue());
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append('}');
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "toString"));
        }
        return string;
    }

    @NotNull
    public static <K, V> Map<K, V> createWeakKeySoftValueMap() {
        WeakKeySoftValueHashMap weakKeySoftValueHashMap = new WeakKeySoftValueHashMap();
        if (weakKeySoftValueHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createWeakKeySoftValueMap"));
        }
        return weakKeySoftValueHashMap;
    }

    public static class KeyOrderedMultiMap<K, V>
    extends MultiMap<K, V> {
        public KeyOrderedMultiMap() {
        }

        public KeyOrderedMultiMap(@NotNull MultiMap<? extends K, ? extends V> toCopy) {
            if (toCopy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toCopy", "com/intellij/util/containers/ContainerUtil$KeyOrderedMultiMap", "<init>"));
            }
            super(toCopy);
        }

        @Override
        @NotNull
        protected Map<K, Collection<V>> createMap() {
            TreeMap treeMap = new TreeMap();
            if (treeMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$KeyOrderedMultiMap", "createMap"));
            }
            return treeMap;
        }

        @Override
        @NotNull
        protected Map<K, Collection<V>> createMap(int initialCapacity, float loadFactor) {
            TreeMap treeMap = new TreeMap();
            if (treeMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$KeyOrderedMultiMap", "createMap"));
            }
            return treeMap;
        }

        @NotNull
        public NavigableSet<K> navigableKeySet() {
            NavigableSet navigableSet = ((TreeMap)this.myMap).navigableKeySet();
            if (navigableSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$KeyOrderedMultiMap", "navigableKeySet"));
            }
            return navigableSet;
        }
    }

    private static interface ConcurrentMapFactory {
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap();

        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(int var1);

        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(@NotNull TObjectHashingStrategy<T> var1);

        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(int var1, float var2, int var3);

        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(int var1, float var2, int var3, @NotNull TObjectHashingStrategy<T> var4);
    }

    private static class ImmutableListBackedByArray<E>
    extends ImmutableList<E> {
        private final E[] myStore;

        private ImmutableListBackedByArray(@NotNull E[] array) {
            if (array == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/containers/ContainerUtil$ImmutableListBackedByArray", "<init>"));
            }
            this.myStore = array;
        }

        @Override
        public E get(int index) {
            return this.myStore[index];
        }

        @Override
        public int size() {
            return this.myStore.length;
        }
    }

    private static class ImmutableListBackedByList<E>
    extends ImmutableList<E> {
        private final List<E> myStore;

        private ImmutableListBackedByList(@NotNull List<E> list) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ContainerUtil$ImmutableListBackedByList", "<init>"));
            }
            this.myStore = list;
        }

        @Override
        public E get(int index) {
            return this.myStore.get(index);
        }

        @Override
        public int size() {
            return this.myStore.size();
        }
    }

    public static class ImmutableMapBuilder<K, V> {
        private final Map<K, V> myMap = new THashMap();

        public ImmutableMapBuilder<K, V> put(K key, V value) {
            this.myMap.put(key, value);
            return this;
        }

        @Contract(pure=true)
        public Map<K, V> build() {
            return Collections.unmodifiableMap(this.myMap);
        }
    }
}

