/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.impl.schema.XmlAttributeDescriptorImpl;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;

public class XmlPrefixReferenceProvider
extends PsiReferenceProvider {
    @Override
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        String type;
        XmlAttributeDescriptor descriptor;
        XmlTag tag;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/xml/util/XmlPrefixReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/xml/util/XmlPrefixReferenceProvider", "getReferencesByElement"));
        }
        XmlAttributeValue attributeValue = (XmlAttributeValue)element;
        String value = attributeValue.getValue();
        if (value == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/XmlPrefixReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        int i2 = value.indexOf(58);
        if (i2 <= 0) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/XmlPrefixReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement parent = attributeValue.getParent();
        if (parent instanceof XmlAttribute && (tag = ((XmlAttribute)parent).getParent()) != null && !XmlNSDescriptorImpl.checkSchemaNamespace(tag) && (descriptor = ((XmlAttribute)parent).getDescriptor()) instanceof XmlAttributeDescriptorImpl && (type = ((XmlAttributeDescriptorImpl)descriptor).getType()) != null && type.endsWith(":QName")) {
            String prefix = XmlUtil.findPrefixByQualifiedName(type);
            String ns = ((XmlTag)descriptor.getDeclaration()).getNamespaceByPrefix(prefix);
            if (XmlNSDescriptorImpl.checkSchemaNamespace(ns)) {
                PsiReference[] psiReferenceArray = new PsiReference[]{new SchemaPrefixReference(attributeValue, TextRange.from(1, i2), value.substring(0, i2), null)};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/XmlPrefixReferenceProvider", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/XmlPrefixReferenceProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }
}

