/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ImportUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SimplifiableJUnitAssertionInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("simplifiable.junit.assertion.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/SimplifiableJUnitAssertionInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("simplifiable.junit.assertion.problem.descriptor", infos[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/SimplifiableJUnitAssertionInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new SimplifyJUnitAssertFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SimplifiableJUnitAssertionVisitor();
    }

    static boolean isAssertTrueThatCouldBeAssertEquals(PsiMethodCallExpression expression) {
        if (!SimplifiableJUnitAssertionInspection.isAssertTrue(expression)) {
            return false;
        }
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        PsiMethod method = (PsiMethod)methodExpression.resolve();
        if (method == null) {
            return false;
        }
        PsiParameterList parameterList = method.getParameterList();
        if (parameterList.getParametersCount() < 1) {
            return false;
        }
        PsiClassType stringType = TypeUtils.getStringType(expression);
        PsiParameter[] parameters = parameterList.getParameters();
        PsiType paramType1 = parameters[0].getType();
        int testPosition = paramType1.equals(stringType) && parameters.length > 1 ? 1 : 0;
        PsiExpressionList argumentList = expression.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        PsiExpression testArgument = arguments[testPosition];
        return testArgument != null && SimplifiableJUnitAssertionInspection.isEqualityComparison(testArgument);
    }

    static boolean isAssertThatCouldBeAssertSame(PsiMethodCallExpression expression) {
        if (!SimplifiableJUnitAssertionInspection.isAssertTrue(expression) && !SimplifiableJUnitAssertionInspection.isAssertFalse(expression)) {
            return false;
        }
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        PsiMethod method = (PsiMethod)methodExpression.resolve();
        if (method == null) {
            return false;
        }
        PsiParameterList parameterList = method.getParameterList();
        if (parameterList.getParametersCount() < 1) {
            return false;
        }
        PsiClassType stringType = TypeUtils.getStringType(expression);
        PsiParameter[] parameters = parameterList.getParameters();
        PsiType paramType1 = parameters[0].getType();
        int testPosition = paramType1.equals(stringType) && parameters.length > 1 ? 1 : 0;
        PsiExpressionList argumentList = expression.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        PsiExpression testArgument = arguments[testPosition];
        return testArgument != null && SimplifiableJUnitAssertionInspection.isIdentityComparison(testArgument);
    }

    static boolean isAssertThatCouldBeAssertNull(PsiMethodCallExpression expression) {
        if (!SimplifiableJUnitAssertionInspection.isAssertTrue(expression) && !SimplifiableJUnitAssertionInspection.isAssertFalse(expression)) {
            return false;
        }
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        PsiMethod method = (PsiMethod)methodExpression.resolve();
        if (method == null) {
            return false;
        }
        PsiParameterList parameterList = method.getParameterList();
        if (parameterList.getParametersCount() < 1) {
            return false;
        }
        PsiClassType stringType = TypeUtils.getStringType(expression);
        PsiParameter[] parameters = parameterList.getParameters();
        PsiType paramType1 = parameters[0].getType();
        int testPosition = paramType1.equals(stringType) && parameters.length > 1 ? 1 : 0;
        PsiExpressionList argumentList = expression.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        PsiExpression testArgument = arguments[testPosition];
        return testArgument != null && SimplifiableJUnitAssertionInspection.isNullComparison(testArgument);
    }

    static boolean isAssertThatCouldBeFail(PsiMethodCallExpression expression) {
        boolean checkTrue;
        if (SimplifiableJUnitAssertionInspection.isAssertFalse(expression)) {
            checkTrue = true;
        } else if (SimplifiableJUnitAssertionInspection.isAssertTrue(expression)) {
            checkTrue = false;
        } else {
            return false;
        }
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        PsiMethod method = (PsiMethod)methodExpression.resolve();
        if (method == null) {
            return false;
        }
        PsiParameterList parameterList = method.getParameterList();
        if (parameterList.getParametersCount() < 1) {
            return false;
        }
        PsiClassType stringType = TypeUtils.getStringType(expression);
        PsiParameter[] parameters = parameterList.getParameters();
        PsiType paramType1 = parameters[0].getType();
        int testPosition = paramType1.equals(stringType) && parameters.length > 1 ? 1 : 0;
        PsiExpressionList argumentList = expression.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        PsiExpression testArgument = arguments[testPosition];
        if (testArgument == null) {
            return false;
        }
        String testArgumentText = testArgument.getText();
        if (checkTrue) {
            return "true".equals(testArgumentText);
        }
        return "false".equals(testArgumentText);
    }

    static boolean isAssertEqualsThatCouldBeAssertLiteral(PsiMethodCallExpression expression) {
        int secondTestPosition;
        int firstTestPosition;
        if (!SimplifiableJUnitAssertionInspection.isAssertEquals(expression)) {
            return false;
        }
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        PsiMethod method = (PsiMethod)methodExpression.resolve();
        if (method == null) {
            return false;
        }
        PsiParameterList parameterList = method.getParameterList();
        if (parameterList.getParametersCount() < 2) {
            return false;
        }
        PsiClassType stringType = TypeUtils.getStringType(expression);
        PsiParameter[] parameters = parameterList.getParameters();
        PsiType paramType1 = parameters[0].getType();
        if (paramType1.equals(stringType) && parameters.length > 2) {
            firstTestPosition = 1;
            secondTestPosition = 2;
        } else {
            firstTestPosition = 0;
            secondTestPosition = 1;
        }
        PsiExpressionList argumentList = expression.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        PsiExpression firstTestArgument = arguments[firstTestPosition];
        PsiExpression secondTestArgument = arguments[secondTestPosition];
        if (firstTestArgument == null || secondTestArgument == null) {
            return false;
        }
        return SimplifiableJUnitAssertionInspection.isSimpleLiteral(firstTestArgument, secondTestArgument) || SimplifiableJUnitAssertionInspection.isSimpleLiteral(secondTestArgument, firstTestArgument);
    }

    static boolean isSimpleLiteral(PsiExpression expression1, PsiExpression expression2) {
        if (!(expression1 instanceof PsiLiteralExpression)) {
            return false;
        }
        String text = expression1.getText();
        if ("null".equals(text)) {
            return true;
        }
        if (!"true".equals(text) && !"false".equals(text)) {
            return false;
        }
        PsiType type = expression2.getType();
        return PsiType.BOOLEAN.equals(type);
    }

    private static boolean isEqualityComparison(PsiExpression expression) {
        if (expression instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.EQEQ)) {
                return false;
            }
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return false;
            }
            PsiType type = lhs.getType();
            return type != null && ClassUtils.isPrimitive(type);
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
            if (!MethodCallUtils.isEqualsCall(call)) {
                return false;
            }
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            return methodExpression.getQualifierExpression() != null;
        }
        return false;
    }

    private static boolean isIdentityComparison(PsiExpression expression) {
        if (!(expression instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
        if (!ComparisonUtils.isEqualityComparison(binaryExpression)) {
            return false;
        }
        PsiExpression rhs = binaryExpression.getROperand();
        if (rhs == null) {
            return false;
        }
        PsiExpression lhs = binaryExpression.getLOperand();
        PsiType lhsType = lhs.getType();
        if (lhsType instanceof PsiPrimitiveType) {
            return false;
        }
        PsiType rhsType = rhs.getType();
        return !(rhsType instanceof PsiPrimitiveType);
    }

    private static boolean isNullComparison(PsiExpression expression) {
        if (!(expression instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
        if (!ComparisonUtils.isEqualityComparison(binaryExpression)) {
            return false;
        }
        PsiExpression rhs = binaryExpression.getROperand();
        if (rhs == null) {
            return false;
        }
        PsiExpression lhs = binaryExpression.getLOperand();
        return "null".equals(lhs.getText()) || "null".equals(rhs.getText());
    }

    private static boolean isAssertTrue(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/junit/SimplifiableJUnitAssertionInspection", "isAssertTrue"));
        }
        return SimplifiableJUnitAssertionInspection.isAssertMethodCall(expression, "assertTrue");
    }

    private static boolean isAssertFalse(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/junit/SimplifiableJUnitAssertionInspection", "isAssertFalse"));
        }
        return SimplifiableJUnitAssertionInspection.isAssertMethodCall(expression, "assertFalse");
    }

    private static boolean isAssertEquals(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/junit/SimplifiableJUnitAssertionInspection", "isAssertEquals"));
        }
        return SimplifiableJUnitAssertionInspection.isAssertMethodCall(expression, "assertEquals");
    }

    private static boolean isAssertMethodCall(@NotNull PsiMethodCallExpression expression, @NonNls @NotNull String assertMethodName) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/junit/SimplifiableJUnitAssertionInspection", "isAssertMethodCall"));
        }
        if (assertMethodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assertMethodName", "com/siyeh/ig/junit/SimplifiableJUnitAssertionInspection", "isAssertMethodCall"));
        }
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (!assertMethodName.equals(methodName)) {
            return false;
        }
        PsiMethod method = (PsiMethod)methodExpression.resolve();
        if (method == null) {
            return false;
        }
        PsiClass targetClass = method.getContainingClass();
        if (targetClass == null) {
            return false;
        }
        String qualifiedName = targetClass.getQualifiedName();
        return "junit.framework.Assert".equals(qualifiedName) || "org.junit.Assert".equals(qualifiedName);
    }

    private static class SimplifiableJUnitAssertionVisitor
    extends BaseInspectionVisitor {
        private SimplifiableJUnitAssertionVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/junit/SimplifiableJUnitAssertionInspection$SimplifiableJUnitAssertionVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(expression);
            if (SimplifiableJUnitAssertionInspection.isAssertThatCouldBeAssertNull(expression)) {
                if (SimplifiableJUnitAssertionVisitor.hasEqEqExpressionArgument(expression)) {
                    this.registerMethodCallError(expression, "assertNull()");
                } else {
                    this.registerMethodCallError(expression, "assertNotNull()");
                }
            } else if (SimplifiableJUnitAssertionInspection.isAssertThatCouldBeAssertSame(expression)) {
                if (SimplifiableJUnitAssertionVisitor.hasEqEqExpressionArgument(expression)) {
                    this.registerMethodCallError(expression, "assertSame()");
                } else {
                    this.registerMethodCallError(expression, "assertNotSame()");
                }
            } else if (SimplifiableJUnitAssertionInspection.isAssertTrueThatCouldBeAssertEquals(expression)) {
                this.registerMethodCallError(expression, "assertEquals()");
            } else if (SimplifiableJUnitAssertionInspection.isAssertEqualsThatCouldBeAssertLiteral(expression)) {
                this.registerMethodCallError(expression, SimplifiableJUnitAssertionVisitor.getReplacementMethodName(expression));
            } else if (SimplifiableJUnitAssertionInspection.isAssertThatCouldBeFail(expression)) {
                this.registerMethodCallError(expression, "fail()");
            }
        }

        @NonNls
        private static String getReplacementMethodName(PsiMethodCallExpression expression) {
            PsiExpression secondArgument;
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            PsiExpression firstArgument = arguments[0];
            if (firstArgument instanceof PsiLiteralExpression) {
                PsiLiteralExpression literalExpression = (PsiLiteralExpression)firstArgument;
                Object value = literalExpression.getValue();
                if (value == Boolean.TRUE) {
                    return "assertTrue()";
                }
                if (value == Boolean.FALSE) {
                    return "assertFalse()";
                }
                if (value == null) {
                    return "assertNull()";
                }
            }
            if ((secondArgument = arguments[1]) instanceof PsiLiteralExpression) {
                PsiLiteralExpression literalExpression = (PsiLiteralExpression)secondArgument;
                Object value = literalExpression.getValue();
                if (value == Boolean.TRUE) {
                    return "assertTrue()";
                }
                if (value == Boolean.FALSE) {
                    return "assertFalse()";
                }
                if (value == null) {
                    return "assertNull()";
                }
            }
            return "";
        }

        private static boolean hasEqEqExpressionArgument(PsiMethodCallExpression expression) {
            PsiExpressionList list = expression.getArgumentList();
            PsiExpression[] arguments = list.getExpressions();
            PsiExpression argument = arguments[0];
            if (!(argument instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)argument;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            return JavaTokenType.EQEQ.equals(tokenType);
        }
    }

    private static class SimplifyJUnitAssertFix
    extends InspectionGadgetsFix {
        private SimplifyJUnitAssertFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("simplify.junit.assertion.simplify.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/SimplifiableJUnitAssertionInspection$SimplifyJUnitAssertFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement methodNameIdentifier = descriptor.getPsiElement();
            PsiElement parent = methodNameIdentifier.getParent();
            if (parent == null) {
                return;
            }
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)parent.getParent();
            if (SimplifiableJUnitAssertionInspection.isAssertThatCouldBeAssertNull(callExpression)) {
                SimplifyJUnitAssertFix.replaceAssertWithAssertNull(callExpression);
            } else if (SimplifiableJUnitAssertionInspection.isAssertThatCouldBeAssertSame(callExpression)) {
                SimplifyJUnitAssertFix.replaceAssertWithAssertSame(callExpression);
            } else if (SimplifiableJUnitAssertionInspection.isAssertTrueThatCouldBeAssertEquals(callExpression)) {
                SimplifyJUnitAssertFix.replaceAssertTrueWithAssertEquals(callExpression);
            } else if (SimplifiableJUnitAssertionInspection.isAssertEqualsThatCouldBeAssertLiteral(callExpression)) {
                SimplifyJUnitAssertFix.replaceAssertEqualsWithAssertLiteral(callExpression);
            } else if (SimplifiableJUnitAssertionInspection.isAssertThatCouldBeFail(callExpression)) {
                SimplifyJUnitAssertFix.replaceAssertWithFail(callExpression);
            }
        }

        private static void addStaticImportOrQualifier(String methodName, PsiMethodCallExpression originalMethodCall, StringBuilder out) {
            PsiReferenceExpression methodExpression = originalMethodCall.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                PsiMethod method = originalMethodCall.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiClass containingClass = method.getContainingClass();
                if (containingClass != null && "org.junit.Assert".equals(containingClass.getQualifiedName()) && !ImportUtils.addStaticImport("org.junit.Assert", methodName, originalMethodCall)) {
                    out.append("org.junit.Assert.");
                }
            } else {
                out.append(qualifier.getText()).append('.');
            }
        }

        private static void replaceAssertWithFail(PsiMethodCallExpression callExpression) {
            PsiMethod method = callExpression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiExpressionList argumentList = callExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            PsiExpression message = arguments.length == 2 ? arguments[0] : null;
            StringBuilder newExpression = new StringBuilder();
            SimplifyJUnitAssertFix.addStaticImportOrQualifier("fail", callExpression, newExpression);
            newExpression.append("fail(");
            if (message != null) {
                newExpression.append(message.getText());
            }
            newExpression.append(')');
            PsiReplacementUtil.replaceExpressionAndShorten(callExpression, newExpression.toString());
        }

        private static void replaceAssertTrueWithAssertEquals(PsiMethodCallExpression callExpression) {
            PsiExpression message;
            int testPosition;
            PsiMethod method = callExpression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            PsiClassType stringType = TypeUtils.getStringType(callExpression);
            PsiType paramType1 = parameters[0].getType();
            PsiExpressionList argumentList = callExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (paramType1.equals(stringType) && parameters.length >= 2) {
                testPosition = 1;
                message = arguments[0];
            } else {
                testPosition = 0;
                message = null;
            }
            PsiExpression testArgument = arguments[testPosition];
            PsiExpression lhs = null;
            PsiExpression rhs = null;
            if (testArgument instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)testArgument;
                lhs = binaryExpression.getLOperand();
                rhs = binaryExpression.getROperand();
            } else if (testArgument instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression call = (PsiMethodCallExpression)testArgument;
                PsiReferenceExpression equalityMethodExpression = call.getMethodExpression();
                PsiExpressionList equalityArgumentList = call.getArgumentList();
                PsiExpression[] equalityArgs = equalityArgumentList.getExpressions();
                rhs = equalityArgs[0];
                lhs = equalityMethodExpression.getQualifierExpression();
            }
            if (!(lhs instanceof PsiLiteralExpression) && rhs instanceof PsiLiteralExpression) {
                PsiExpression temp = lhs;
                lhs = rhs;
                rhs = temp;
            }
            if (lhs == null || rhs == null) {
                return;
            }
            StringBuilder newExpression = new StringBuilder();
            SimplifyJUnitAssertFix.addStaticImportOrQualifier("assertEquals", callExpression, newExpression);
            newExpression.append("assertEquals(");
            if (message != null) {
                newExpression.append(message.getText()).append(',');
            }
            PsiType lhsType = lhs.getType();
            PsiType rhsType = rhs.getType();
            if (lhsType != null && rhsType != null && PsiUtil.isLanguageLevel5OrHigher(lhs)) {
                PsiPrimitiveType unboxedType;
                if (SimplifyJUnitAssertFix.isPrimitiveAndBoxedInteger(lhsType, rhsType)) {
                    unboxedType = PsiPrimitiveType.getUnboxedType(rhsType);
                    assert (unboxedType != null);
                    newExpression.append(lhs.getText()).append(",(").append(unboxedType.getCanonicalText()).append(')').append(rhs.getText());
                } else if (SimplifyJUnitAssertFix.isPrimitiveAndBoxedInteger(rhsType, lhsType)) {
                    unboxedType = PsiPrimitiveType.getUnboxedType(lhsType);
                    assert (unboxedType != null);
                    newExpression.append('(').append(unboxedType.getCanonicalText()).append(')').append(lhs.getText()).append(',').append(rhs.getText());
                } else {
                    newExpression.append(lhs.getText()).append(',').append(rhs.getText());
                }
            } else {
                newExpression.append(lhs.getText()).append(',').append(rhs.getText());
            }
            if (TypeUtils.hasFloatingPointType(lhs) || TypeUtils.hasFloatingPointType(rhs) || SimplifyJUnitAssertFix.isPrimitiveAndBoxedFloat(lhsType, rhsType) || SimplifyJUnitAssertFix.isPrimitiveAndBoxedFloat(rhsType, lhsType)) {
                newExpression.append(",0.0");
            }
            newExpression.append(')');
            PsiReplacementUtil.replaceExpressionAndShorten(callExpression, newExpression.toString());
        }

        private static boolean isPrimitiveAndBoxedInteger(PsiType lhsType, PsiType rhsType) {
            return lhsType instanceof PsiPrimitiveType && rhsType instanceof PsiClassType && PsiType.LONG.isAssignableFrom(rhsType);
        }

        private static boolean isPrimitiveAndBoxedFloat(PsiType lhsType, PsiType rhsType) {
            return lhsType instanceof PsiPrimitiveType && rhsType instanceof PsiClassType && PsiType.DOUBLE.equals(rhsType) && PsiType.FLOAT.equals(rhsType);
        }

        private static void replaceAssertWithAssertNull(PsiMethodCallExpression callExpression) {
            PsiExpression message;
            int testPosition;
            PsiMethod method = callExpression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            PsiClassType stringType = TypeUtils.getStringType(callExpression);
            PsiType paramType1 = parameters[0].getType();
            PsiExpressionList argumentList = callExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (paramType1.equals(stringType) && parameters.length >= 2) {
                testPosition = 1;
                message = arguments[0];
            } else {
                testPosition = 0;
                message = null;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)arguments[testPosition];
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return;
            }
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (!(lhs instanceof PsiLiteralExpression) && rhs instanceof PsiLiteralExpression) {
                rhs = lhs;
            }
            StringBuilder newExpression = new StringBuilder();
            PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            String memberName = "assertFalse".equals(methodName) ^ tokenType.equals(JavaTokenType.NE) ? "assertNotNull" : "assertNull";
            SimplifyJUnitAssertFix.addStaticImportOrQualifier(memberName, callExpression, newExpression);
            newExpression.append(memberName).append('(');
            if (message != null) {
                newExpression.append(message.getText()).append(',');
            }
            newExpression.append(rhs.getText()).append(')');
            PsiReplacementUtil.replaceExpressionAndShorten(callExpression, newExpression.toString());
        }

        private static void replaceAssertWithAssertSame(PsiMethodCallExpression callExpression) {
            PsiExpression message;
            int testPosition;
            PsiMethod method = callExpression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            PsiClassType stringType = TypeUtils.getStringType(callExpression);
            PsiType paramType1 = parameters[0].getType();
            PsiExpressionList argumentList = callExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (paramType1.equals(stringType) && parameters.length >= 2) {
                testPosition = 1;
                message = arguments[0];
            } else {
                testPosition = 0;
                message = null;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)arguments[testPosition];
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (!(lhs instanceof PsiLiteralExpression) && rhs instanceof PsiLiteralExpression) {
                PsiExpression temp = lhs;
                lhs = rhs;
                rhs = temp;
            }
            if (rhs == null) {
                return;
            }
            StringBuilder newExpression = new StringBuilder();
            PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            String memberName = "assertFalse".equals(methodName) ^ tokenType.equals(JavaTokenType.NE) ? "assertNotSame" : "assertSame";
            SimplifyJUnitAssertFix.addStaticImportOrQualifier(memberName, callExpression, newExpression);
            newExpression.append(memberName).append('(');
            if (message != null) {
                newExpression.append(message.getText()).append(',');
            }
            newExpression.append(lhs.getText()).append(',').append(rhs.getText()).append(')');
            PsiReplacementUtil.replaceExpressionAndShorten(callExpression, newExpression.toString());
        }

        private static void replaceAssertEqualsWithAssertLiteral(PsiMethodCallExpression callExpression) {
            String compareValue;
            String literalValue;
            PsiExpression message;
            int secondTestPosition;
            int firstTestPosition;
            PsiMethod method = callExpression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            PsiClassType stringType = TypeUtils.getStringType(callExpression);
            PsiType paramType1 = parameters[0].getType();
            PsiExpressionList argumentList = callExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (paramType1.equals(stringType) && parameters.length >= 3) {
                firstTestPosition = 1;
                secondTestPosition = 2;
                message = arguments[0];
            } else {
                firstTestPosition = 0;
                secondTestPosition = 1;
                message = null;
            }
            PsiExpression firstTestArgument = arguments[firstTestPosition];
            PsiExpression secondTestArgument = arguments[secondTestPosition];
            if (SimplifiableJUnitAssertionInspection.isSimpleLiteral(firstTestArgument, secondTestArgument)) {
                literalValue = firstTestArgument.getText();
                compareValue = secondTestArgument.getText();
            } else {
                literalValue = secondTestArgument.getText();
                compareValue = firstTestArgument.getText();
            }
            String uppercaseLiteralValue = Character.toUpperCase(literalValue.charAt(0)) + literalValue.substring(1);
            StringBuilder newExpression = new StringBuilder();
            String methodName = "assert" + uppercaseLiteralValue;
            SimplifyJUnitAssertFix.addStaticImportOrQualifier(methodName, callExpression, newExpression);
            newExpression.append(methodName).append('(');
            if (message != null) {
                newExpression.append(message.getText()).append(',');
            }
            newExpression.append(compareValue).append(')');
            PsiReplacementUtil.replaceExpressionAndShorten(callExpression, newExpression.toString());
        }
    }
}

