/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UseOfObsoleteAssertInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("usage.of.obsolete.assert.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/UseOfObsoleteAssertInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("use.of.obsolete.assert.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/UseOfObsoleteAssertInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ReplaceObsoleteAssertsFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UseOfObsoleteAssertVisitor();
    }

    private static class ReplaceObsoleteAssertsFix
    extends InspectionGadgetsFix {
        private ReplaceObsoleteAssertsFix() {
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiMethodCallExpression psiElement = PsiTreeUtil.getParentOfType(descriptor.getPsiElement(), PsiMethodCallExpression.class);
            if (psiElement == null) {
                return;
            }
            PsiClass newAssertClass = JavaPsiFacade.getInstance(project).findClass("org.junit.Assert", GlobalSearchScope.allScope(project));
            PsiClass oldAssertClass = JavaPsiFacade.getInstance(project).findClass("junit.framework.Assert", GlobalSearchScope.allScope(project));
            if (newAssertClass == null) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = psiElement;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            PsiElement usedImport = qualifierExpression instanceof PsiReferenceExpression ? ((PsiReferenceExpression)qualifierExpression).advancedResolve(true).getCurrentFileResolveScope() : methodExpression.advancedResolve(true).getCurrentFileResolveScope();
            PsiMethod psiMethod = methodCallExpression.resolveMethod();
            boolean isImportUnused = ReplaceObsoleteAssertsFix.isImportBecomeUnused(methodCallExpression, usedImport, psiMethod);
            PsiImportStaticStatement staticStatement = null;
            if (qualifierExpression == null) {
                staticStatement = ReplaceObsoleteAssertsFix.staticallyImported(oldAssertClass, methodExpression);
            }
            JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance(project);
            if (staticStatement == null) {
                methodExpression.setQualifierExpression(JavaPsiFacade.getElementFactory(project).createReferenceExpression(newAssertClass));
                if (isImportUnused && usedImport instanceof PsiImportStatementBase) {
                    usedImport.delete();
                }
                styleManager.shortenClassReferences(methodExpression);
            } else if (isImportUnused) {
                PsiJavaCodeReferenceElement importReference = staticStatement.getImportReference();
                if (importReference != null) {
                    if (staticStatement.isOnDemand()) {
                        importReference.bindToElement(newAssertClass);
                    } else {
                        PsiElement importQExpression = importReference.getQualifier();
                        if (importQExpression instanceof PsiJavaCodeReferenceElement) {
                            ((PsiJavaCodeReferenceElement)importQExpression).bindToElement(newAssertClass);
                        }
                    }
                }
            } else {
                methodExpression.setQualifierExpression(JavaPsiFacade.getElementFactory(project).createReferenceExpression(newAssertClass));
                styleManager.shortenClassReferences(methodExpression);
            }
        }

        private static boolean isImportBecomeUnused(final PsiMethodCallExpression methodCallExpression, final PsiElement usedImport, final PsiMethod psiMethod) {
            final boolean[] proceed = new boolean[]{true};
            methodCallExpression.getContainingFile().accept(new JavaRecursiveElementWalkingVisitor(){

                @Override
                public void visitElement(PsiElement element) {
                    if (proceed[0]) {
                        super.visitElement(element);
                    }
                }

                @Override
                public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                    super.visitMethodCallExpression(expression);
                    if (expression == methodCallExpression) {
                        return;
                    }
                    PsiMethod resolved = expression.resolveMethod();
                    if (resolved == psiMethod) {
                        proceed[0] = false;
                    } else {
                        PsiElement resolveScope = expression.getMethodExpression().advancedResolve(false).getCurrentFileResolveScope();
                        if (resolveScope == usedImport) {
                            proceed[0] = false;
                        }
                    }
                }
            });
            return proceed[0];
        }

        @Nullable
        private static PsiImportStaticStatement staticallyImported(PsiClass oldAssertClass, PsiReferenceExpression methodExpression) {
            PsiImportStaticStatement[] statements;
            String referenceName = methodExpression.getReferenceName();
            PsiFile containingFile = methodExpression.getContainingFile();
            if (!(containingFile instanceof PsiJavaFile)) {
                return null;
            }
            PsiImportList importList = ((PsiJavaFile)containingFile).getImportList();
            if (importList == null) {
                return null;
            }
            for (PsiImportStaticStatement statement : statements = importList.getImportStaticStatements()) {
                PsiElement qualifier;
                if (oldAssertClass != statement.resolveTargetClass()) continue;
                String importRefName = statement.getReferenceName();
                PsiJavaCodeReferenceElement importReference = statement.getImportReference();
                if (importReference == null || !(Comparing.strEqual(importRefName, referenceName) ? (qualifier = importReference.getQualifier()) instanceof PsiJavaCodeReferenceElement : importRefName == null)) continue;
                return statement;
            }
            return null;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("use.of.obsolete.assert.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/UseOfObsoleteAssertInspection$ReplaceObsoleteAssertsFix", "getFamilyName"));
            }
            return string;
        }
    }

    private static class UseOfObsoleteAssertVisitor
    extends BaseInspectionVisitor {
        private UseOfObsoleteAssertVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            Project project = expression.getProject();
            Module module = ModuleUtilCore.findModuleForPsiElement(expression);
            if (module == null) {
                return;
            }
            PsiClass newAssertClass = JavaPsiFacade.getInstance(project).findClass("org.junit.Assert", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope(module));
            if (newAssertClass == null) {
                return;
            }
            PsiMethod psiMethod = expression.resolveMethod();
            if (psiMethod == null || !psiMethod.hasModifierProperty("static")) {
                return;
            }
            PsiClass containingClass = psiMethod.getContainingClass();
            if (containingClass != null && Comparing.strEqual(containingClass.getQualifiedName(), "junit.framework.Assert")) {
                this.registerMethodCallError(expression, new Object[0]);
            }
        }
    }
}

