/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.google.common.base.MoreObjects;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransactionGuardImpl
extends TransactionGuard {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.application.TransactionGuardImpl");
    private final Queue<Transaction> myQueue = new LinkedBlockingQueue<Transaction>();
    private final Map<ModalityState, TransactionIdImpl> myModality2Transaction = ContainerUtil.createConcurrentWeakMap();
    private final Map<ModalityState, Boolean> myWriteSafeModalities = ContainerUtil.createConcurrentWeakMap();
    private TransactionIdImpl myCurrentTransaction;
    private boolean myWritingAllowed;
    private boolean myErrorReported;
    private static boolean ourTestingTransactions;

    public TransactionGuardImpl() {
        this.myWriteSafeModalities.put(ModalityState.NON_MODAL, true);
    }

    @NotNull
    private Queue<Transaction> getQueue(@Nullable TransactionIdImpl transaction) {
        while (transaction != null && transaction.myFinished) {
            transaction = transaction.myParent;
        }
        Queue<Transaction> queue = transaction == null ? this.myQueue : transaction.myQueue;
        if (queue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/TransactionGuardImpl", "getQueue"));
        }
        return queue;
    }

    private void pollQueueLater() {
        TransactionGuardImpl.invokeLater(new Runnable(){

            @Override
            public void run() {
                Queue queue = TransactionGuardImpl.this.getQueue(TransactionGuardImpl.this.myCurrentTransaction);
                Transaction next = (Transaction)queue.peek();
                if (next != null && TransactionGuardImpl.this.canRunTransactionNow(next, false)) {
                    queue.remove();
                    TransactionGuardImpl.this.runSyncTransaction(next);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSyncTransaction(@NotNull Transaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transaction", "com/intellij/openapi/application/TransactionGuardImpl", "runSyncTransaction"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (Disposer.isDisposed(transaction.parentDisposable)) {
            return;
        }
        boolean wasWritingAllowed = this.myWritingAllowed;
        this.myWritingAllowed = true;
        this.myCurrentTransaction = new TransactionIdImpl(this.myCurrentTransaction);
        try {
            transaction.runnable.run();
        }
        finally {
            Queue<Transaction> queue = this.getQueue(this.myCurrentTransaction.myParent);
            queue.addAll(this.myCurrentTransaction.myQueue);
            if (!queue.isEmpty()) {
                this.pollQueueLater();
            }
            this.myWritingAllowed = wasWritingAllowed;
            this.myCurrentTransaction.myFinished = true;
            this.myCurrentTransaction = this.myCurrentTransaction.myParent;
        }
    }

    @Override
    public void submitTransaction(@NotNull Disposable parentDisposable, @Nullable TransactionId expectedContext, @NotNull Runnable _transaction) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/application/TransactionGuardImpl", "submitTransaction"));
        }
        if (_transaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_transaction", "com/intellij/openapi/application/TransactionGuardImpl", "submitTransaction"));
        }
        final TransactionIdImpl expectedId = (TransactionIdImpl)expectedContext;
        final Transaction transaction = new Transaction(_transaction, expectedId, parentDisposable);
        Application app = ApplicationManager.getApplication();
        final boolean isDispatchThread = app.isDispatchThread();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (TransactionGuardImpl.this.canRunTransactionNow(transaction, isDispatchThread)) {
                    TransactionGuardImpl.this.runSyncTransaction(transaction);
                } else {
                    TransactionGuardImpl.this.getQueue(expectedId).offer(transaction);
                    TransactionGuardImpl.this.pollQueueLater();
                }
            }
        };
        if (isDispatchThread) {
            runnable.run();
        } else {
            TransactionGuardImpl.invokeLater(runnable);
        }
    }

    private boolean canRunTransactionNow(Transaction transaction, boolean sync) {
        if (sync && !this.myWritingAllowed) {
            return false;
        }
        TransactionIdImpl currentId = this.myCurrentTransaction;
        if (currentId == null) {
            return true;
        }
        return transaction.expectedContext != null && currentId.myStartCounter <= transaction.expectedContext.myStartCounter;
    }

    @Override
    public void submitTransactionAndWait(final @NotNull Runnable runnable) throws ProcessCanceledException {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/application/TransactionGuardImpl", "submitTransactionAndWait"));
        }
        Application app = ApplicationManager.getApplication();
        if (app.isDispatchThread()) {
            Transaction transaction = new Transaction(runnable, this.getContextTransaction(), app);
            if (!this.canRunTransactionNow(transaction, true)) {
                String message = "Cannot run synchronous submitTransactionAndWait from invokeLater. Please use asynchronous submit*Transaction. See TransactionGuard FAQ for details.\nTransaction: " + runnable;
                if (!this.isWriteSafeModality(ModalityState.current())) {
                    message = message + "\nUnsafe modality: " + ModalityState.current();
                }
                LOG.error(message);
            }
            this.runSyncTransaction(transaction);
            return;
        }
        if (app.isReadAccessAllowed()) {
            throw new IllegalStateException("submitTransactionAndWait should not be invoked from a read action");
        }
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        final Throwable[] exception = new Throwable[]{null};
        this.submitTransaction(Disposer.newDisposable("never disposed"), this.getContextTransaction(), new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (Throwable e) {
                    exception[0] = e;
                }
                finally {
                    semaphore.up();
                }
            }
        });
        semaphore.waitFor();
        if (exception[0] != null) {
            throw new RuntimeException(exception[0]);
        }
    }

    public void performUserActivity(Runnable activity) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        AccessToken token = this.startActivity(true);
        try {
            activity.run();
        }
        finally {
            token.finish();
        }
    }

    @NotNull
    public AccessToken startActivity(boolean userActivity) {
        boolean allowWriting;
        this.myErrorReported = false;
        boolean bl = allowWriting = userActivity && this.isWriteSafeModality(ModalityState.current());
        if (this.myWritingAllowed == allowWriting) {
            AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
            if (accessToken == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/TransactionGuardImpl", "startActivity"));
            }
            return accessToken;
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        final boolean prev = this.myWritingAllowed;
        this.myWritingAllowed = allowWriting;
        AccessToken accessToken = new AccessToken(){

            @Override
            public void finish() {
                TransactionGuardImpl.this.myWritingAllowed = prev;
            }
        };
        if (accessToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/TransactionGuardImpl", "startActivity"));
        }
        return accessToken;
    }

    public boolean isWriteSafeModality(ModalityState state) {
        return Boolean.TRUE.equals(this.myWriteSafeModalities.get(state));
    }

    public void assertWriteActionAllowed() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (TransactionGuardImpl.areAssertionsEnabled() && !this.myWritingAllowed && !this.myErrorReported) {
            String message = "Write access is allowed from write-safe contexts only. Please ensure you're using invokeLater/invokeAndWait with a correct modality state (not \"any\"). See TransactionGuard documentation for details.\n  current modality=" + ModalityState.current() + "\n  known modalities=" + this.myWriteSafeModalities;
            LOG.error(message);
            this.myErrorReported = true;
        }
    }

    private static boolean areAssertionsEnabled() {
        Application app = ApplicationManager.getApplication();
        if (app.isUnitTestMode() && !ourTestingTransactions) {
            return false;
        }
        if (app instanceof ApplicationEx && !((ApplicationEx)app).isLoaded()) {
            return false;
        }
        return Registry.is("ide.require.transaction.for.model.changes", false);
    }

    @Override
    public void submitTransactionLater(final @NotNull Disposable parentDisposable, final @NotNull Runnable transaction) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/application/TransactionGuardImpl", "submitTransactionLater"));
        }
        if (transaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transaction", "com/intellij/openapi/application/TransactionGuardImpl", "submitTransactionLater"));
        }
        final TransactionIdImpl id = this.getContextTransaction();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TransactionGuardImpl.this.submitTransaction(parentDisposable, id, transaction);
            }
        };
        TransactionGuardImpl.invokeLater(runnable);
    }

    private static void invokeLater(Runnable runnable) {
        ApplicationManager.getApplication().invokeLater(runnable, ModalityState.any(), Condition.FALSE);
    }

    @Override
    public TransactionIdImpl getContextTransaction() {
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
            return indicator != null ? this.myModality2Transaction.get(indicator.getModalityState()) : null;
        }
        return this.myWritingAllowed ? this.myCurrentTransaction : null;
    }

    public void enteredModality(@NotNull ModalityState modality) {
        if (modality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modality", "com/intellij/openapi/application/TransactionGuardImpl", "enteredModality"));
        }
        TransactionIdImpl contextTransaction = this.getContextTransaction();
        if (contextTransaction != null) {
            this.myModality2Transaction.put(modality, contextTransaction);
        }
        this.myWriteSafeModalities.put(modality, this.myWritingAllowed);
    }

    @Nullable
    public TransactionIdImpl getModalityTransaction(@NotNull ModalityState modalityState) {
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/openapi/application/TransactionGuardImpl", "getModalityTransaction"));
        }
        return this.myModality2Transaction.get(modalityState);
    }

    @NotNull
    public Runnable wrapLaterInvocation(final @NotNull Runnable runnable, @NotNull ModalityState modalityState) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/application/TransactionGuardImpl", "wrapLaterInvocation"));
        }
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/openapi/application/TransactionGuardImpl", "wrapLaterInvocation"));
        }
        if (this.isWriteSafeModality(modalityState)) {
            Runnable runnable2 = new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().assertIsDispatchThread();
                    boolean prev = TransactionGuardImpl.this.myWritingAllowed;
                    TransactionGuardImpl.this.myWritingAllowed = true;
                    try {
                        runnable.run();
                    }
                    finally {
                        TransactionGuardImpl.this.myWritingAllowed = prev;
                    }
                }

                public String toString() {
                    return runnable.toString();
                }
            };
            if (runnable2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/TransactionGuardImpl", "wrapLaterInvocation"));
            }
            return runnable2;
        }
        Runnable runnable3 = runnable;
        if (runnable3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/TransactionGuardImpl", "wrapLaterInvocation"));
        }
        return runnable3;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("currentTransaction", (Object)this.myCurrentTransaction).add("writingAllowed", this.myWritingAllowed).toString();
    }

    public static void setTestingTransactions(boolean testingTransactions) {
        ourTestingTransactions = testingTransactions;
    }

    private static class TransactionIdImpl
    implements TransactionId {
        private static final AtomicLong ourTransactionCounter = new AtomicLong();
        final long myStartCounter = ourTransactionCounter.getAndIncrement();
        final Queue<Transaction> myQueue = new LinkedBlockingQueue<Transaction>();
        boolean myFinished;
        final TransactionIdImpl myParent;

        public TransactionIdImpl(@Nullable TransactionIdImpl parent) {
            this.myParent = parent;
        }

        public String toString() {
            return "Transaction " + this.myStartCounter + (this.myFinished ? "(finished)" : "");
        }
    }

    private static class Transaction {
        @NotNull
        final Runnable runnable;
        @Nullable
        final TransactionIdImpl expectedContext;
        @NotNull
        final Disposable parentDisposable;

        Transaction(@NotNull Runnable runnable, @Nullable TransactionIdImpl expectedContext, @NotNull Disposable parentDisposable) {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/application/TransactionGuardImpl$Transaction", "<init>"));
            }
            if (parentDisposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/application/TransactionGuardImpl$Transaction", "<init>"));
            }
            this.runnable = runnable;
            this.expectedContext = expectedContext;
            this.parentDisposable = parentDisposable;
        }
    }
}

