/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.UnsignedShortArrayList;
import java.awt.EventQueue;
import org.jetbrains.annotations.NotNull;

public class PausesStat {
    private static final int N_MAX = 100000;
    private final UnsignedShortArrayList durations;
    @NotNull
    private final String myName;
    private final Thread myEdtThread;
    private boolean started;
    private long startTimeStamp;
    private int maxDuration;
    private Object maxDurationDescription;
    private int totalNumberRecorded;
    private int indexToOverwrite;

    public PausesStat(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/PausesStat", "<init>"));
        }
        this.durations = new UnsignedShortArrayList();
        this.myName = name;
        assert (EventQueue.isDispatchThread()) : Thread.currentThread();
        this.myEdtThread = Thread.currentThread();
    }

    private int register(int duration) {
        if (this.durations.size() == 100000) {
            this.durations.set(this.indexToOverwrite, duration);
            this.indexToOverwrite = (this.indexToOverwrite + 1) % 100000;
        } else {
            this.durations.add(duration);
        }
        return duration;
    }

    public void started() {
        this.assertEdt();
        assert (!this.started);
        this.started = true;
        this.startTimeStamp = System.currentTimeMillis();
    }

    private void assertEdt() {
        assert (Thread.currentThread() == this.myEdtThread) : Thread.currentThread();
    }

    public void finished(@NotNull String description) {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/util/PausesStat", "finished"));
        }
        this.assertEdt();
        assert (this.started);
        long finishStamp = System.currentTimeMillis();
        int duration = (int)(finishStamp - this.startTimeStamp);
        this.started = false;
        if ((duration = Math.min(duration, 65535)) > this.maxDuration) {
            this.maxDuration = duration;
            this.maxDurationDescription = description;
        }
        ++this.totalNumberRecorded;
        this.register(duration);
    }

    public String statistics() {
        int number = this.durations.size();
        int[] duration = this.durations.toArray();
        int total = 0;
        for (int d : duration) {
            total += d;
        }
        return this.myName + " Statistics" + (this.totalNumberRecorded == number ? "" : " (" + this.totalNumberRecorded + " events was recorded in total, but only last " + number + " are reported here)") + ":\nEvent number:     " + number + "\nTotal time spent: " + total + "ms\nAverage duration: " + (number == 0 ? 0 : total / number) + "ms\nMedian  duration: " + ArrayUtil.averageAmongMedians(duration, 3) + "ms\nMax  duration:    " + (this.maxDuration == 65535 ? ">" : "") + this.maxDuration + "ms (it was '" + this.maxDurationDescription + "')";
    }
}

