/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteElementFix;
import com.intellij.codeInsight.daemon.impl.quickfix.GoToSymbolFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MoveFileFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixActionRegistrarImpl;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExportsStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class ModuleHighlightUtil {
    @Nullable
    static PsiJavaModule getModuleDescriptor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "getModuleDescriptor"));
        }
        VirtualFile file = Optional.of(element).map(e -> e instanceof PsiFileSystemItem ? (PsiFileSystemItem)e : e.getContainingFile()).map(PsiFileSystemItem::getVirtualFile).orElse(null);
        if (file == null) {
            return null;
        }
        Project project = element.getProject();
        ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance(project);
        if (element instanceof PsiCompiledElement) {
            return Optional.ofNullable(index.getClassRootForFile(file)).map(r -> r.findChild("module-info.class")).map(PsiManager.getInstance(project)::findFile).map(f -> f instanceof PsiJavaFile ? ((PsiJavaFile)f).getModuleDeclaration() : null).orElse(null);
        }
        Module module = index.getModuleForFile(file);
        return Optional.ofNullable(module).map(m -> FilenameIndex.getVirtualFilesByName(project, "module-info.java", m.getModuleScope(false))).map(c -> c.size() == 1 ? (VirtualFile)c.iterator().next() : null).map(PsiManager.getInstance(project)::findFile).map(f -> f instanceof PsiJavaFile ? ((PsiJavaFile)f).getModuleDeclaration() : null).orElse(null);
    }

    @Nullable
    static HighlightInfo checkFileName(@NotNull PsiJavaModule element, @NotNull PsiFile file) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkFileName"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkFileName"));
        }
        if (!"module-info.java".equals(file.getName())) {
            String message = JavaErrorMessages.message("module.file.wrong.name", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(element)).description(message).create();
            QuickFixAction.registerQuickFixAction(info, ModuleHighlightUtil.factory().createRenameFileFix("module-info.java"));
            return info;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkFileDuplicates(@NotNull PsiJavaModule element, @NotNull PsiFile file) {
        Project project;
        Collection<VirtualFile> others;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkFileDuplicates"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkFileDuplicates"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement(element);
        if (module != null && (others = FilenameIndex.getVirtualFilesByName(project = file.getProject(), "module-info.java", module.getModuleScope(false))).size() > 1) {
            String message = JavaErrorMessages.message("module.file.duplicate", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(element)).description(message).create();
            others.stream().map(f -> PsiManager.getInstance(project).findFile((VirtualFile)f)).filter(f -> {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "lambda$checkFileDuplicates$7"));
                }
                return f != file;
            }).findFirst().ifPresent(duplicate -> QuickFixAction.registerQuickFixAction(info, new GoToSymbolFix((NavigatablePsiElement)duplicate, JavaErrorMessages.message("module.open.duplicate.text", new Object[0]))));
            return info;
        }
        return null;
    }

    @NotNull
    static List<HighlightInfo> checkDuplicateStatements(@NotNull PsiJavaModule module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkDuplicateStatements"));
        }
        List<HighlightInfo> results = ContainerUtil.newSmartList();
        ModuleHighlightUtil.checkDuplicateRefs(SyntaxTraverser.psiTraverser().children(module).filter(PsiRequiresStatement.class), st -> Optional.ofNullable(st.getReferenceElement()).map(PsiJavaModuleReferenceElement::getReferenceText), "module.duplicate.requires", results);
        ModuleHighlightUtil.checkDuplicateRefs(SyntaxTraverser.psiTraverser().children(module).filter(PsiExportsStatement.class), st -> Optional.ofNullable(st.getPackageReference()).map(ModuleHighlightUtil::refText), "module.duplicate.export", results);
        ModuleHighlightUtil.checkDuplicateRefs(SyntaxTraverser.psiTraverser().children(module).filter(PsiUsesStatement.class), st -> Optional.ofNullable(st.getClassReference()).map(ModuleHighlightUtil::refText), "module.duplicate.uses", results);
        ModuleHighlightUtil.checkDuplicateRefs(SyntaxTraverser.psiTraverser().children(module).filter(PsiProvidesStatement.class), st -> Optional.of(Pair.pair(st.getInterfaceReference(), st.getImplementationReference())).map(p -> p.first != null && p.second != null ? ModuleHighlightUtil.refText((PsiJavaCodeReferenceElement)p.first) + " / " + ModuleHighlightUtil.refText((PsiJavaCodeReferenceElement)p.second) : null), "module.duplicate.provides", results);
        List<HighlightInfo> list = results;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkDuplicateStatements"));
        }
        return list;
    }

    private static <T extends PsiElement> void checkDuplicateRefs(Iterable<T> statements, Function<T, Optional<String>> ref, @PropertyKey(resourceBundle="messages.JavaErrorMessages") String key, List<HighlightInfo> results) {
        THashSet filter = ContainerUtil.newTroveSet();
        for (PsiElement statement : statements) {
            String refText = ref.apply(statement).orElse(null);
            if (refText == null || filter.add((String)refText)) continue;
            String message = JavaErrorMessages.message(key, refText);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(statement).description(message).create();
            QuickFixAction.registerQuickFixAction(info, new DeleteElementFix(statement));
            results.add(info);
        }
    }

    @NotNull
    static List<HighlightInfo> checkUnusedServices(@NotNull PsiJavaModule module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkUnusedServices"));
        }
        List<HighlightInfo> results = ContainerUtil.newSmartList();
        THashSet exports = ContainerUtil.newTroveSet();
        THashSet uses = ContainerUtil.newTroveSet();
        for (PsiElement psiElement : SyntaxTraverser.psiTraverser().children(module)) {
            PsiJavaCodeReferenceElement ref;
            if (psiElement instanceof PsiExportsStatement) {
                ref = ((PsiExportsStatement)psiElement).getPackageReference();
                if (ref == null) continue;
                exports.add((String)ModuleHighlightUtil.refText(ref));
                continue;
            }
            if (!(psiElement instanceof PsiUsesStatement) || (ref = ((PsiUsesStatement)psiElement).getClassReference()) == null) continue;
            uses.add((String)ModuleHighlightUtil.refText(ref));
        }
        Module host = ModuleUtilCore.findModuleForPsiElement(module);
        for (PsiProvidesStatement statement : SyntaxTraverser.psiTraverser().children(module).filter(PsiProvidesStatement.class)) {
            String className;
            String packageName;
            PsiElement target;
            PsiJavaCodeReferenceElement ref = statement.getInterfaceReference();
            if (ref == null || !((target = ref.resolve()) instanceof PsiClass) || ModuleUtilCore.findModuleForPsiElement(target) != host || exports.contains(packageName = StringUtil.getPackageName(className = ModuleHighlightUtil.refText(ref))) || uses.contains(className)) continue;
            String message = JavaErrorMessages.message("module.service.unused", new Object[0]);
            results.add(HighlightInfo.newHighlightInfo(HighlightInfoType.WARNING).range(ModuleHighlightUtil.range(ref)).description(message).create());
        }
        List<HighlightInfo> list = results;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkUnusedServices"));
        }
        return list;
    }

    private static String refText(PsiJavaCodeReferenceElement ref) {
        return PsiNameHelper.getQualifiedClassName(ref.getText(), true);
    }

    @Nullable
    static HighlightInfo checkFileLocation(@NotNull PsiJavaModule element, @NotNull PsiFile file) {
        VirtualFile root;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkFileLocation"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkFileLocation"));
        }
        VirtualFile vFile = file.getVirtualFile();
        if (vFile != null && (root = ProjectFileIndex.SERVICE.getInstance(file.getProject()).getSourceRootForFile(vFile)) != null && !root.equals(vFile.getParent())) {
            String message = JavaErrorMessages.message("module.file.wrong.location", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.WARNING).range(ModuleHighlightUtil.range(element)).description(message).create();
            QuickFixAction.registerQuickFixAction(info, new MoveFileFix(vFile, root, QuickFixBundle.message("move.file.to.source.root.text", new Object[0])));
            return info;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkModuleReference(@Nullable PsiJavaModuleReferenceElement refElement, @NotNull PsiJavaModule container) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkModuleReference"));
        }
        if (refElement != null) {
            PsiPolyVariantReference ref = refElement.getReference();
            assert (ref != null) : refElement.getParent();
            PsiElement target = ref.resolve();
            if (!(target instanceof PsiJavaModule)) {
                return ModuleHighlightUtil.moduleResolveError(refElement, ref);
            }
            if (target == container) {
                String message = JavaErrorMessages.message("module.cyclic.dependence", container.getModuleName());
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(refElement).description(message).create();
            }
            Collection<PsiJavaModule> cycle = JavaModuleGraphUtil.findCycle((PsiJavaModule)target);
            if (cycle != null && cycle.contains(container)) {
                Stream<String> stream = cycle.stream().map(PsiJavaModule::getModuleName);
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    stream = stream.sorted();
                }
                String message = JavaErrorMessages.message("module.cyclic.dependence", stream.collect(Collectors.joining(", ")));
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(refElement).description(message).create();
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkPackageReference(@Nullable PsiJavaCodeReferenceElement refElement) {
        Module module;
        PsiElement target;
        if (refElement != null && (target = refElement.resolve()) instanceof PsiPackage && (module = ModuleUtilCore.findModuleForPsiElement(refElement)) != null) {
            String packageName = ((PsiPackage)target).getQualifiedName();
            PsiDirectory[] directories = ((PsiPackage)target).getDirectories(module.getModuleScope(false));
            if (directories.length == 0) {
                String message = JavaErrorMessages.message("package.not.found", packageName);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(refElement).description(message).create();
            }
            if (PsiUtil.isPackageEmpty(directories, packageName)) {
                String message = JavaErrorMessages.message("package.is.empty", packageName);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(refElement).description(message).create();
            }
        }
        return null;
    }

    @NotNull
    static List<HighlightInfo> checkExportTargets(@NotNull PsiExportsStatement statement, @NotNull PsiJavaModule container) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkExportTargets"));
        }
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkExportTargets"));
        }
        List<HighlightInfo> results = ContainerUtil.newSmartList();
        THashSet targets = ContainerUtil.newTroveSet();
        for (PsiJavaModuleReferenceElement refElement : SyntaxTraverser.psiTraverser().children(statement).filter(PsiJavaModuleReferenceElement.class)) {
            String message;
            String refText = refElement.getReferenceText();
            PsiPolyVariantReference ref = refElement.getReference();
            assert (ref != null) : statement;
            PsiElement target = ref.resolve();
            if (!(target instanceof PsiJavaModule)) {
                results.add(ModuleHighlightUtil.moduleResolveError(refElement, ref));
                continue;
            }
            if (!targets.add((String)refText)) {
                message = JavaErrorMessages.message("module.duplicate.export", refText);
                results.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(refElement).description(message).create());
                continue;
            }
            if (target != container) continue;
            message = JavaErrorMessages.message("module.self.export", new Object[0]);
            results.add(HighlightInfo.newHighlightInfo(HighlightInfoType.WARNING).range(refElement).description(message).create());
        }
        List<HighlightInfo> list = results;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkExportTargets"));
        }
        return list;
    }

    @Nullable
    static HighlightInfo checkServiceReference(@Nullable PsiJavaCodeReferenceElement refElement) {
        PsiElement target;
        if (refElement != null && (target = refElement.resolve()) instanceof PsiClass && ((PsiClass)target).isEnum()) {
            String message = JavaErrorMessages.message("module.service.enum", ((PsiClass)target).getName());
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(refElement)).description(message).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkServiceImplementation(@Nullable PsiJavaCodeReferenceElement implRef, @Nullable PsiJavaCodeReferenceElement intRef) {
        if (implRef != null && intRef != null) {
            PsiElement implTarget = implRef.resolve();
            PsiElement intTarget = intRef.resolve();
            if (implTarget instanceof PsiClass && intTarget instanceof PsiClass) {
                PsiClass implClass = (PsiClass)implTarget;
                if (!InheritanceUtil.isInheritorOrSelf(implClass, (PsiClass)intTarget, true)) {
                    String message = JavaErrorMessages.message("module.service.subtype", new Object[0]);
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).description(message).create();
                }
                if (implClass.hasModifierProperty("abstract")) {
                    String message = JavaErrorMessages.message("module.service.abstract", implClass.getName());
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).description(message).create();
                }
                PsiMethod[] constructors = implClass.getConstructors();
                if (constructors.length > 0) {
                    PsiMethod constructor = JBIterable.of(constructors).find(c -> c.getParameterList().getParametersCount() == 0);
                    if (constructor == null) {
                        String message = JavaErrorMessages.message("module.service.no.ctor", implClass.getName());
                        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).description(message).create();
                    }
                    if (!constructor.hasModifierProperty("public")) {
                        String message = JavaErrorMessages.message("module.service.hidden.ctor", implClass.getName());
                        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).description(message).create();
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkPackageAccessibility(@NotNull PsiJavaCodeReferenceElement ref, @NotNull PsiElement target, @NotNull PsiJavaModule refModule) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkPackageAccessibility"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkPackageAccessibility"));
        }
        if (refModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refModule", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkPackageAccessibility"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement(ref);
        if (module != null) {
            PsiDirectory[] dirs;
            PsiElement refImport;
            if (target instanceof PsiClass && !(target instanceof PsiCompiledElement) && module != ModuleUtilCore.findModuleForPsiElement(target)) {
                PsiElement targetFile = target.getParent();
                if (targetFile instanceof PsiClassOwner) {
                    PsiJavaModule targetModule = ModuleHighlightUtil.getModuleDescriptor(target);
                    String packageName = ((PsiClassOwner)targetFile).getPackageName();
                    return ModuleHighlightUtil.checkPackageAccessibility(ref, refModule, targetModule, packageName);
                }
            } else if (target instanceof PsiPackage && (refImport = ref.getParent()) instanceof PsiImportStatementBase && ((PsiImportStatementBase)refImport).isOnDemand() && (dirs = ((PsiPackage)target).getDirectories(module.getModuleWithDependenciesAndLibrariesScope(false))).length == 1 && ModuleUtilCore.findModuleForPsiElement(dirs[0]) != module) {
                PsiJavaModule targetModule = ModuleHighlightUtil.getModuleDescriptor(dirs[0]);
                String packageName = ((PsiPackage)target).getQualifiedName();
                return ModuleHighlightUtil.checkPackageAccessibility(ref, refModule, targetModule, packageName);
            }
        }
        return null;
    }

    private static HighlightInfo checkPackageAccessibility(PsiJavaCodeReferenceElement ref, PsiJavaModule refModule, PsiJavaModule targetModule, String packageName) {
        if (targetModule == null) {
            String message = JavaErrorMessages.message("module.package.on.classpath", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range(ref).description(message).create();
        }
        String refModuleName = refModule.getModuleName();
        String requiredName = targetModule.getModuleName();
        if (!(targetModule instanceof PsiCompiledElement) && !ModuleHighlightUtil.isExported(targetModule, packageName)) {
            String message = JavaErrorMessages.message("module.package.not.exported", requiredName, packageName, refModuleName);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range(ref).description(message).create();
        }
        if (!"java.base".equals(requiredName) && !JavaModuleGraphUtil.reads(refModule, targetModule)) {
            String message = JavaErrorMessages.message("module.not.in.requirements", refModuleName, requiredName);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range(ref).description(message).create();
        }
        return null;
    }

    private static boolean isExported(PsiJavaModule module, String packageName) {
        for (PsiExportsStatement statement : SyntaxTraverser.psiTraverser().children(module).filter(PsiExportsStatement.class)) {
            String exportedName = Optional.ofNullable(statement.getPackageReference()).map(ModuleHighlightUtil::refText).orElse("");
            if (!packageName.equals(exportedName)) continue;
            return true;
        }
        return false;
    }

    private static HighlightInfo moduleResolveError(PsiJavaModuleReferenceElement refElement, PsiPolyVariantReference ref) {
        boolean missing = ref.multiResolve(true).length == 0;
        String message = JavaErrorMessages.message(missing ? "module.not.found" : "module.not.on.path", refElement.getReferenceText());
        HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range(refElement).description(message).create();
        if (!missing) {
            ModuleHighlightUtil.factory().registerOrderEntryFixes(new QuickFixActionRegistrarImpl(info), ref);
        }
        return info;
    }

    private static QuickFixFactory factory() {
        return QuickFixFactory.getInstance();
    }

    private static TextRange range(PsiJavaModule module) {
        PsiKeyword kw = PsiTreeUtil.getChildOfType(module, PsiKeyword.class);
        return new TextRange(kw != null ? kw.getTextOffset() : module.getTextOffset(), module.getNameElement().getTextRange().getEndOffset());
    }

    private static PsiElement range(PsiJavaCodeReferenceElement refElement) {
        return ObjectUtils.notNull(refElement.getReferenceNameElement(), refElement);
    }
}

