/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.javaDoc;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.javaDoc.JavaDocLocalInspectionBase;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.javadoc.PsiDocParamRef;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.javadoc.JavadocManager;
import com.intellij.psi.javadoc.JavadocTagInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavadocHighlightUtil {
    private static final String[] TAGS_TO_CHECK = new String[]{"author", "version", "since"};
    private static final Set<String> UNIQUE_TAGS = ContainerUtil.newHashSet("return", "deprecated", "serial", "serialData");
    private static final TokenSet SEE_TAG_REFS = TokenSet.create(JavaDocElementType.DOC_REFERENCE_HOLDER, JavaDocElementType.DOC_METHOD_OR_FIELD_REF);

    static boolean isJavaDocRequired(@NotNull JavaDocLocalInspectionBase inspection, @NotNull PsiModifierListOwner element) {
        if (inspection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspection", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "isJavaDocRequired"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "isJavaDocRequired"));
        }
        int actualAccess = JavadocHighlightUtil.getAccessNumber(RefJavaUtil.getInstance().getAccessModifier(element));
        if (element instanceof PsiPackage) {
            return 1 <= JavadocHighlightUtil.getAccessNumber(inspection.PACKAGE_OPTIONS);
        }
        if (element instanceof PsiClass) {
            boolean isInner = PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class) != null;
            return actualAccess <= JavadocHighlightUtil.getAccessNumber(isInner ? inspection.INNER_CLASS_OPTIONS : inspection.TOP_LEVEL_CLASS_OPTIONS);
        }
        if (element instanceof PsiMethod) {
            element = PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            while (element != null) {
                actualAccess = Math.max(actualAccess, JavadocHighlightUtil.getAccessNumber(RefJavaUtil.getInstance().getAccessModifier(element)));
                element = PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            }
            return actualAccess <= JavadocHighlightUtil.getAccessNumber(inspection.METHOD_OPTIONS);
        }
        if (element instanceof PsiField) {
            element = PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            while (element != null) {
                actualAccess = Math.max(actualAccess, JavadocHighlightUtil.getAccessNumber(RefJavaUtil.getInstance().getAccessModifier(element)));
                element = PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            }
            return actualAccess <= JavadocHighlightUtil.getAccessNumber(inspection.FIELD_OPTIONS);
        }
        return false;
    }

    private static int getAccessNumber(JavaDocLocalInspectionBase.Options options) {
        return JavadocHighlightUtil.getAccessNumber(options.ACCESS_JAVADOC_REQUIRED_FOR);
    }

    private static int getAccessNumber(String accessModifier) {
        if (accessModifier.startsWith("none")) {
            return 0;
        }
        if (accessModifier.startsWith("public")) {
            return 1;
        }
        if (accessModifier.startsWith("protected")) {
            return 2;
        }
        if (accessModifier.startsWith("package")) {
            return 3;
        }
        if (accessModifier.startsWith("private")) {
            return 4;
        }
        return 5;
    }

    static void reportMissingTag(@NotNull PsiElement toHighlight, @NotNull ProblemHolder holder) {
        if (toHighlight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toHighlight", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "reportMissingTag"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "reportMissingTag"));
        }
        String message = InspectionsBundle.message("inspection.javadoc.problem.descriptor", new Object[0]);
        holder.problem(toHighlight, message, holder.addJavadocFix(toHighlight));
    }

    static void checkRequiredTags(@NotNull PsiDocTag[] tags, @NotNull Predicate<String> tagRequired, @NotNull PsiElement toHighlight, @NotNull ProblemHolder holder) {
        if (tags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tags", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "checkRequiredTags"));
        }
        if (tagRequired == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagRequired", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "checkRequiredTags"));
        }
        if (toHighlight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toHighlight", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "checkRequiredTags"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "checkRequiredTags"));
        }
        boolean[] isTagRequired = new boolean[TAGS_TO_CHECK.length];
        boolean[] isTagPresent = new boolean[TAGS_TO_CHECK.length];
        boolean someTagsAreRequired = false;
        for (int i2 = 0; i2 < TAGS_TO_CHECK.length; ++i2) {
            isTagRequired[i2] = tagRequired.test(TAGS_TO_CHECK[i2]);
            someTagsAreRequired |= isTagRequired[i2];
        }
        if (!someTagsAreRequired) {
            return;
        }
        for (PsiDocTag tag : tags) {
            int p = ArrayUtil.find(TAGS_TO_CHECK, tag.getName());
            if (p < 0) continue;
            isTagPresent[p] = true;
        }
        for (int i3 = 0; i3 < TAGS_TO_CHECK.length; ++i3) {
            if (!isTagRequired[i3] || isTagPresent[i3]) continue;
            String tagName = TAGS_TO_CHECK[i3];
            String message = InspectionsBundle.message("inspection.javadoc.problem.missing.tag", "<code>@" + tagName + "</code>");
            holder.problem(toHighlight, message, holder.addMissingTagFix(tagName, ""));
        }
    }

    static void checkRequiredTagDescriptions(@NotNull PsiDocTag[] tags, @NotNull ProblemHolder holder) {
        if (tags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tags", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "checkRequiredTagDescriptions"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "checkRequiredTagDescriptions"));
        }
        for (PsiDocTag tag : tags) {
            String tagName = tag.getName();
            if (ArrayUtil.find(TAGS_TO_CHECK, tagName) < 0 || !JavadocHighlightUtil.emptyTag(tag)) continue;
            String message = InspectionsBundle.message("inspection.javadoc.problem.missing.tag.description", StringUtil.capitalize(tagName), tagName);
            holder.problem(tag.getNameElement(), message, null);
        }
    }

    static void checkTagValues(@NotNull PsiDocTag[] tags, @Nullable PsiElement context, @NotNull ProblemHolder holder) {
        if (tags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tags", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "checkTagValues"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "checkTagValues"));
        }
        JavadocManager docManager = JavadocManager.SERVICE.getInstance(holder.project());
        for (PsiDocTag tag : tags) {
            int textOffset;
            PsiElement element;
            PsiReference reference;
            String tagName = tag.getName();
            JavadocTagInfo tagInfo = docManager.getTagInfo(tagName);
            if ((tagInfo == null || !tagInfo.isValidInContext(context)) && JavadocHighlightUtil.checkTagInfo(tag, tagInfo, holder)) continue;
            PsiDocTagValue value = tag.getValueElement();
            if (tagInfo != null && !tagInfo.isValidInContext(context)) continue;
            String message = tagInfo == null ? null : tagInfo.checkTagValue(value);
            PsiReference psiReference = reference = value != null ? value.getReference() : null;
            if (message == null && reference != null && (element = reference.resolve()) == null && (textOffset = value.getTextOffset()) == value.getTextRange().getEndOffset()) {
                holder.eolProblem(tag, InspectionsBundle.message("inspection.javadoc.problem.name.expected", new Object[0]), null);
            }
            if (message != null) {
                PsiDocTagValue valueElement = tag.getValueElement();
                if (valueElement == null) {
                    String tagText = "<code>" + tag.getName() + "</code>";
                    holder.problem(tag, InspectionsBundle.message("inspection.javadoc.method.problem.missing.tag.description", tagText), null);
                } else {
                    holder.problem(valueElement, message, null);
                }
            }
            PsiElement[] dataElements = tag.getDataElements();
            if ("see".equals(tagName)) {
                if (dataElements.length == 0 || dataElements.length == 1 && JavadocHighlightUtil.empty(dataElements[0])) {
                    holder.problem(tag.getNameElement(), InspectionsBundle.message("inspection.javadoc.problem.see.tag.expecting.ref", new Object[0]), null);
                } else if (!JavadocHighlightUtil.isValidSeeRef(dataElements[0])) {
                    holder.problem(dataElements[0], InspectionsBundle.message("inspection.javadoc.problem.see.tag.expecting.ref", new Object[0]), null);
                }
            }
            JavadocHighlightUtil.checkInlineTags(dataElements, holder);
        }
    }

    private static boolean isValidSeeRef(PsiElement e) {
        if (SEE_TAG_REFS.contains(e.getNode().getElementType())) {
            return true;
        }
        String text = e.getText().trim();
        if (StringUtil.isQuotedString(text) && text.charAt(0) == '\"') {
            return true;
        }
        return text.toLowerCase(Locale.US).startsWith("<a href=");
    }

    static void checkInlineTags(@NotNull PsiElement[] elements, @NotNull ProblemHolder holder) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "checkInlineTags"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "checkInlineTags"));
        }
        JavadocManager docManager = JavadocManager.SERVICE.getInstance(holder.project());
        for (PsiElement element : elements) {
            PsiElement nameElement;
            PsiElement target;
            PsiReference reference;
            PsiDocTagValue value;
            if (!(element instanceof PsiInlineDocTag)) continue;
            PsiInlineDocTag tag = (PsiInlineDocTag)element;
            if (docManager.getTagInfo(tag.getName()) == null) {
                JavadocHighlightUtil.checkTagInfo(tag, null, holder);
            }
            if (holder.inspection().IGNORE_POINT_TO_ITSELF || (value = tag.getValueElement()) == null || (reference = value.getReference()) == null || (target = reference.resolve()) == null || PsiTreeUtil.getParentOfType((PsiElement)tag, PsiDocCommentOwner.class) != PsiTreeUtil.getParentOfType(target, PsiDocCommentOwner.class, false) || (nameElement = tag.getNameElement()) == null) continue;
            holder.problem(nameElement, InspectionsBundle.message("inspection.javadoc.problem.pointing.to.itself", new Object[0]), null);
        }
    }

    private static boolean checkTagInfo(PsiDocTag tag, JavadocTagInfo tagInfo, ProblemHolder holder) {
        String tagName = tag.getName();
        StringTokenizer tokenizer = new StringTokenizer(holder.inspection().myAdditionalJavadocTags, ", ");
        while (tokenizer.hasMoreTokens()) {
            if (!Comparing.strEqual(tagName, tokenizer.nextToken())) continue;
            return true;
        }
        PsiElement nameElement = tag.getNameElement();
        if (nameElement != null) {
            String key = tagInfo == null ? "inspection.javadoc.problem.wrong.tag" : "inspection.javadoc.problem.disallowed.tag";
            holder.problem(nameElement, InspectionsBundle.message(key, "<code>" + tagName + "</code>"), holder.registerTagFix(tagName));
        }
        return false;
    }

    static void checkForPeriod(@NotNull PsiDocComment docComment, @Nullable PsiElement context, @NotNull ProblemHolder holder) {
        if (docComment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docComment", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "checkForPeriod"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "checkForPeriod"));
        }
        int dotIndex = docComment.getText().indexOf(46);
        int tagOffset = 0;
        if (dotIndex >= 0) {
            for (PsiDocTag tag : docComment.getTags()) {
                String tagName = tag.getName();
                JavadocTagInfo tagInfo = JavadocManager.SERVICE.getInstance(tag.getProject()).getTagInfo(tagName);
                if (tagInfo == null || !tagInfo.isValidInContext(context) || tagInfo.isInline()) continue;
                tagOffset = tag.getTextOffset();
                break;
            }
        }
        if (dotIndex == -1 || tagOffset > 0 && dotIndex + docComment.getTextOffset() > tagOffset) {
            holder.problem(docComment.getFirstChild(), InspectionsBundle.message("inspection.javadoc.problem.descriptor1", new Object[0]), null);
        }
    }

    static void checkDuplicateTags(@NotNull PsiDocTag[] tags, @NotNull ProblemHolder holder) {
        if (tags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tags", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "checkDuplicateTags"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "checkDuplicateTags"));
        }
        Set documentedParamNames = null;
        Set documentedExceptions = null;
        Set uniqueTags = null;
        for (PsiDocTag tag : tags) {
            PsiDocTagValue value;
            if ("param".equals(tag.getName())) {
                PsiReference reference;
                value = tag.getValueElement();
                if (!(value instanceof PsiDocParamRef) || (reference = value.getReference()) == null) continue;
                String paramName = reference.getCanonicalText();
                if ((documentedParamNames = JavadocHighlightUtil.set(documentedParamNames)).contains(paramName)) {
                    holder.problem(tag.getNameElement(), InspectionsBundle.message("inspection.javadoc.problem.duplicate.param", paramName), null);
                }
                documentedParamNames.add(paramName);
                continue;
            }
            if (!holder.inspection().isIgnoreDuplicatedThrows() && ("throws".equals(tag.getName()) || "exception".equals(tag.getName()))) {
                PsiJavaCodeReferenceElement refElement;
                PsiElement element;
                PsiElement firstChild;
                value = tag.getValueElement();
                if (value == null || (firstChild = value.getFirstChild()) == null || !(firstChild.getFirstChild() instanceof PsiJavaCodeReferenceElement) || !((element = (refElement = (PsiJavaCodeReferenceElement)firstChild.getFirstChild()).resolve()) instanceof PsiClass)) continue;
                String fqName = ((PsiClass)element).getQualifiedName();
                if ((documentedExceptions = JavadocHighlightUtil.set(documentedExceptions)).contains(fqName)) {
                    holder.problem(tag.getNameElement(), InspectionsBundle.message("inspection.javadoc.problem.duplicate.throws", fqName), null);
                }
                documentedExceptions.add(fqName);
                continue;
            }
            if (!UNIQUE_TAGS.contains(tag.getName())) continue;
            if ((uniqueTags = JavadocHighlightUtil.set(uniqueTags)).contains(tag.getName())) {
                holder.problem(tag.getNameElement(), InspectionsBundle.message("inspection.javadoc.problem.duplicate.tag", tag.getName()), null);
            }
            uniqueTags.add(tag.getName());
        }
    }

    static void checkForBadCharacters(@NotNull PsiDocComment docComment, final @NotNull ProblemHolder holder) {
        if (docComment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docComment", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "checkForBadCharacters"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "checkForBadCharacters"));
        }
        docComment.accept(new PsiRecursiveElementVisitor(){

            @Override
            public void visitElement(PsiElement element) {
                super.visitElement(element);
                ASTNode node = element.getNode();
                if (node != null && node.getElementType() == JavaDocTokenType.DOC_COMMENT_BAD_CHARACTER) {
                    holder.problem(element, InspectionsBundle.message("inspection.illegal.character", new Object[0]), null);
                }
            }
        });
    }

    static void checkMissingTypeParamTags(@NotNull PsiClass psiClass, @NotNull PsiDocTag[] tags, @NotNull PsiElement toHighlight, @NotNull ProblemHolder holder) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "checkMissingTypeParamTags"));
        }
        if (tags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tags", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "checkMissingTypeParamTags"));
        }
        if (toHighlight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toHighlight", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "checkMissingTypeParamTags"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "checkMissingTypeParamTags"));
        }
        if (psiClass.hasTypeParameters()) {
            List<PsiTypeParameter> absentParameters = null;
            for (PsiTypeParameter typeParameter : psiClass.getTypeParameters()) {
                if (JavadocHighlightUtil.hasTagForParameter(tags, typeParameter)) continue;
                absentParameters = JavadocHighlightUtil.list(absentParameters);
                absentParameters.add(typeParameter);
            }
            if (absentParameters != null) {
                for (PsiTypeParameter typeParameter : absentParameters) {
                    String message = InspectionsBundle.message("inspection.javadoc.problem.missing.tag", "<code>@param</code>");
                    holder.problem(toHighlight, message, holder.addMissingTagFix("param", "<" + typeParameter.getName() + ">"));
                }
            }
        }
    }

    static void checkMissingReturnTag(@NotNull PsiDocTag[] tags, @NotNull PsiMethod psiMethod, @NotNull PsiElement toHighlight, @NotNull ProblemHolder holder) {
        boolean hasReturnTag;
        if (tags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tags", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "checkMissingReturnTag"));
        }
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "checkMissingReturnTag"));
        }
        if (toHighlight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toHighlight", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "checkMissingReturnTag"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "checkMissingReturnTag"));
        }
        if (!(psiMethod.isConstructor() || PsiType.VOID.equals(psiMethod.getReturnType()) || (hasReturnTag = Stream.of(tags).anyMatch(tag -> "return".equals(tag.getName()))))) {
            String message = InspectionsBundle.message("inspection.javadoc.problem.missing.tag", "<code>@return</code>");
            holder.problem(toHighlight, message, holder.addMissingTagFix("return", ""));
        }
    }

    static void checkMissingParamTags(@NotNull PsiDocTag[] tags, @NotNull PsiMethod psiMethod, @NotNull PsiElement toHighlight, @NotNull ProblemHolder holder) {
        if (tags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tags", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "checkMissingParamTags"));
        }
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "checkMissingParamTags"));
        }
        if (toHighlight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toHighlight", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "checkMissingParamTags"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "checkMissingParamTags"));
        }
        List<PsiParameter> absentParameters = null;
        for (PsiParameter param : psiMethod.getParameterList().getParameters()) {
            if (JavadocHighlightUtil.hasTagForParameter(tags, param)) continue;
            absentParameters = JavadocHighlightUtil.list(absentParameters);
            absentParameters.add(param);
        }
        if (absentParameters != null) {
            for (PsiParameter parameter : absentParameters) {
                String name = parameter.getName();
                if (name == null) continue;
                String tagText = "<code>" + name + "</code>";
                String message = InspectionsBundle.message("inspection.javadoc.method.problem.missing.param.tag", tagText);
                holder.problem(toHighlight, message, holder.addMissingParamTagFix(name));
            }
        }
    }

    static void checkMissingThrowsTags(@NotNull PsiDocTag[] tags, @NotNull PsiMethod psiMethod, @NotNull PsiElement toHighlight, @NotNull ProblemHolder holder) {
        if (tags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tags", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "checkMissingThrowsTags"));
        }
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "checkMissingThrowsTags"));
        }
        if (toHighlight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toHighlight", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "checkMissingThrowsTags"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "checkMissingThrowsTags"));
        }
        PsiClassType[] thrownTypes = psiMethod.getThrowsList().getReferencedTypes();
        if (thrownTypes.length <= 0) {
            return;
        }
        LinkedHashMap<PsiClassType, PsiClass> declaredExceptions = ContainerUtil.newLinkedHashMap();
        for (PsiClassType classType : thrownTypes) {
            PsiClass psiClass = classType.resolve();
            if (psiClass == null) continue;
            declaredExceptions.put(classType, psiClass);
        }
        for (PsiDocTag tag : tags) {
            PsiElement target;
            PsiElement psiElement;
            PsiElement firstChild;
            PsiDocTagValue value;
            if (!"throws".equals(tag.getName()) && !"exception".equals(tag.getName()) || (value = tag.getValueElement()) == null || (firstChild = value.getFirstChild()) == null || !((psiElement = firstChild.getFirstChild()) instanceof PsiJavaCodeReferenceElement) || !((target = ((PsiJavaCodeReferenceElement)psiElement).resolve()) instanceof PsiClass)) continue;
            Iterator it = declaredExceptions.keySet().iterator();
            while (it.hasNext()) {
                PsiClass psiClass = (PsiClass)declaredExceptions.get(it.next());
                if (!InheritanceUtil.isInheritorOrSelf((PsiClass)target, psiClass, true)) continue;
                it.remove();
            }
        }
        for (PsiClassType declaredException : declaredExceptions.keySet()) {
            String tagText = "<code>@throws</code> " + declaredException.getCanonicalText();
            String message = InspectionsBundle.message("inspection.javadoc.problem.missing.tag", tagText);
            String firstDeclaredException = declaredException.getCanonicalText();
            holder.problem(toHighlight, message, holder.addMissingTagFix("throws", firstDeclaredException));
        }
    }

    static void checkEmptyMethodTagsDescription(@NotNull PsiDocTag[] tags, @NotNull ProblemHolder holder) {
        if (tags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tags", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "checkEmptyMethodTagsDescription"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "checkEmptyMethodTagsDescription"));
        }
        for (PsiDocTag tag : tags) {
            PsiDocTagValue valueElement;
            String tagText;
            if ("return".equals(tag.getName())) {
                if (!JavadocHighlightUtil.emptyTag(tag)) continue;
                tagText = "<code>@return</code>";
                holder.problem(tag.getNameElement(), InspectionsBundle.message("inspection.javadoc.method.problem.missing.tag.description", tagText), null);
                continue;
            }
            if ("throws".equals(tag.getName()) || "exception".equals(tag.getName())) {
                if (!JavadocHighlightUtil.emptyThrowsTag(tag)) continue;
                tagText = "<code>" + tag.getName() + "</code>";
                holder.problem(tag.getNameElement(), InspectionsBundle.message("inspection.javadoc.method.problem.missing.tag.description", tagText), null);
                continue;
            }
            if (!"param".equals(tag.getName()) || (valueElement = tag.getValueElement()) == null || !JavadocHighlightUtil.emptyParamTag(tag, valueElement)) continue;
            String tagText2 = "<code>@param " + valueElement.getText() + "</code>";
            holder.problem(valueElement, InspectionsBundle.message("inspection.javadoc.method.problem.missing.tag.description", tagText2), null);
        }
    }

    private static <T> Set<T> set(Set<T> set) {
        return set != null ? set : ContainerUtil.newHashSet();
    }

    private static <T> List<T> list(List<T> list) {
        return list != null ? list : ContainerUtil.newSmartList();
    }

    private static boolean emptyTag(PsiDocTag tag) {
        return Stream.of(tag.getChildren()).filter(e -> e instanceof PsiDocToken && ((PsiDocToken)e).getTokenType() == JavaDocTokenType.DOC_COMMENT_DATA || e instanceof PsiDocTagValue || e instanceof PsiInlineDocTag).allMatch(JavadocHighlightUtil::empty);
    }

    private static boolean emptyThrowsTag(PsiDocTag tag) {
        return Stream.of(tag.getChildren()).filter(e -> e instanceof PsiDocToken && ((PsiDocToken)e).getTokenType() == JavaDocTokenType.DOC_COMMENT_DATA).allMatch(JavadocHighlightUtil::empty);
    }

    private static boolean emptyParamTag(PsiDocTag tag, PsiDocTagValue valueElement) {
        PsiElement[] dataElements = tag.getDataElements();
        return dataElements.length < 2 || Stream.of(dataElements).filter(e -> e != valueElement).allMatch(JavadocHighlightUtil::empty);
    }

    private static boolean empty(PsiElement e) {
        return e.getText().chars().allMatch(c -> c <= 32);
    }

    public static boolean hasTagForParameter(@NotNull PsiDocTag[] tags, PsiElement param) {
        if (tags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tags", "com/intellij/codeInspection/javaDoc/JavadocHighlightUtil", "hasTagForParameter"));
        }
        for (PsiDocTag tag : tags) {
            PsiReference psiReference;
            PsiDocTagValue value;
            if (!"param".equals(tag.getName()) || !((value = tag.getValueElement()) instanceof PsiDocParamRef) || (psiReference = value.getReference()) == null || !psiReference.isReferenceTo(param)) continue;
            return true;
        }
        return false;
    }

    public static interface ProblemHolder {
        public Project project();

        public JavaDocLocalInspectionBase inspection();

        public void problem(@NotNull PsiElement var1, @NotNull @Nls String var2, @Nullable LocalQuickFix var3);

        public void eolProblem(@NotNull PsiElement var1, @NotNull @Nls String var2, @Nullable LocalQuickFix var3);

        public LocalQuickFix addJavadocFix(@NotNull PsiElement var1);

        public LocalQuickFix addMissingTagFix(@NotNull String var1, @NotNull String var2);

        public LocalQuickFix addMissingParamTagFix(@NotNull String var1);

        public LocalQuickFix registerTagFix(@NotNull String var1);
    }
}

