/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.visibility;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.UnusedSymbolUtil;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.codeInspection.visibility.VisibilityInspection;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.fixes.ChangeModifierFix;
import com.siyeh.ig.psiutils.MethodUtils;
import gnu.trove.TObjectIntHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AccessCanBeTightenedInspection
extends BaseJavaBatchLocalInspectionTool {
    private final VisibilityInspection myVisibilityInspection;

    AccessCanBeTightenedInspection(@NotNull VisibilityInspection visibilityInspection) {
        if (visibilityInspection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibilityInspection", "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection", "<init>"));
        }
        this.myVisibilityInspection = visibilityInspection;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.VISIBILITY_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        if ("Member access can be tightened" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection", "getDisplayName"));
        }
        return "Member access can be tightened";
    }

    @Override
    @NotNull
    public String getShortName() {
        if ("WeakerAccess" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection", "getShortName"));
        }
        return "WeakerAccess";
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection", "buildVisitor"));
        }
        MyVisitor myVisitor = new MyVisitor(holder);
        if (myVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection", "buildVisitor"));
        }
        return myVisitor;
    }

    private static boolean isInnerClass(@NotNull PsiClass memberClass) {
        if (memberClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberClass", "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection", "isInnerClass"));
        }
        return memberClass.getContainingClass() != null || memberClass instanceof PsiAnonymousClass;
    }

    private static boolean isInReferenceList(@Nullable PsiElement list, final @NotNull PsiMember member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection", "isInReferenceList"));
        }
        if (list == null) {
            return false;
        }
        final PsiManager psiManager = member.getManager();
        final boolean[] result = new boolean[1];
        list.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                if (psiManager.areElementsEquivalent(reference.resolve(), member)) {
                    result[0] = true;
                    this.stopWalking();
                }
            }
        });
        return result[0];
    }

    @PsiUtil.AccessLevel
    private int suggestPackageLocal(@NotNull PsiMember member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection", "suggestPackageLocal"));
        }
        boolean suggestPackageLocal = member instanceof PsiClass && ClassUtil.isTopLevelClass((PsiClass)member) ? this.myVisibilityInspection.SUGGEST_PACKAGE_LOCAL_FOR_TOP_CLASSES : this.myVisibilityInspection.SUGGEST_PACKAGE_LOCAL_FOR_MEMBERS;
        return suggestPackageLocal ? 2 : 4;
    }

    private static void log(String s) {
    }

    private class MyVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;
        private final UnusedDeclarationInspectionBase myDeadCodeInspection;
        private final TObjectIntHashMap<PsiClass> maxSuggestedLevelForChildMembers;

        public MyVisitor(ProblemsHolder holder) {
            if (holder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection$MyVisitor", "<init>"));
            }
            this.maxSuggestedLevelForChildMembers = new TObjectIntHashMap();
            this.myHolder = holder;
            InspectionProfile profile = InspectionProjectProfileManager.getInstance(holder.getProject()).getCurrentProfile();
            UnusedDeclarationInspectionBase tool = (UnusedDeclarationInspectionBase)profile.getUnwrappedTool("unused", (PsiElement)holder.getFile());
            this.myDeadCodeInspection = tool == null ? new UnusedDeclarationInspectionBase() : tool;
        }

        @Override
        public void visitClass(PsiClass aClass) {
            this.checkMember(aClass);
        }

        @Override
        public void visitMethod(PsiMethod method) {
            this.checkMember(method);
        }

        @Override
        public void visitField(PsiField field) {
            this.checkMember(field);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkMember(@NotNull PsiMember member) {
            if (member == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection$MyVisitor", "checkMember"));
            }
            PsiClass memberClass = member.getContainingClass();
            PsiModifierList memberModifierList = member.getModifierList();
            if (memberModifierList == null) {
                return;
            }
            int currentLevel = PsiUtil.getAccessLevel(memberModifierList);
            int suggestedLevel = this.suggestLevel(member, memberClass, currentLevel);
            if (memberClass != null) {
                TObjectIntHashMap<PsiClass> tObjectIntHashMap = this.maxSuggestedLevelForChildMembers;
                synchronized (tObjectIntHashMap) {
                    int prevMax = this.maxSuggestedLevelForChildMembers.get((Object)memberClass);
                    this.maxSuggestedLevelForChildMembers.put((Object)memberClass, Math.max(prevMax, suggestedLevel));
                }
            }
            AccessCanBeTightenedInspection.log(member.getName() + ": effective level is '" + PsiUtil.getAccessModifier(suggestedLevel) + "'");
            if (suggestedLevel < currentLevel) {
                PsiElement toHighlight;
                if (member instanceof PsiClass) {
                    int memberMaxLevel;
                    TObjectIntHashMap<PsiClass> prevMax = this.maxSuggestedLevelForChildMembers;
                    synchronized (prevMax) {
                        memberMaxLevel = this.maxSuggestedLevelForChildMembers.get((Object)((PsiClass)member));
                    }
                    if (memberMaxLevel > suggestedLevel) {
                        return;
                    }
                }
                PsiElement psiElement = toHighlight = currentLevel == 2 ? ((PsiNameIdentifierOwner)((Object)member)).getNameIdentifier() : ContainerUtil.find(memberModifierList.getChildren(), element -> element instanceof PsiKeyword && element.getText().equals(PsiUtil.getAccessModifier(currentLevel)));
                assert (toHighlight != null) : member + " ; " + ((PsiNameIdentifierOwner)((Object)member)).getNameIdentifier() + "; " + memberModifierList.getText();
                String suggestedModifier = PsiUtil.getAccessModifier(suggestedLevel);
                this.myHolder.registerProblem(toHighlight, "Access can be " + VisibilityUtil.toPresentableText(suggestedModifier), new ChangeModifierFix(suggestedModifier));
            }
        }

        @PsiUtil.AccessLevel
        private int suggestLevel(@NotNull PsiMember member, PsiClass memberClass, @PsiUtil.AccessLevel int currentLevel) {
            if (member == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection$MyVisitor", "suggestLevel"));
            }
            if (member.hasModifierProperty("private") || member.hasModifierProperty("native")) {
                return currentLevel;
            }
            if (member instanceof PsiMethod && member instanceof SyntheticElement || !member.isPhysical()) {
                return currentLevel;
            }
            if (member instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)member;
                if (!method.getHierarchicalMethodSignature().getSuperSignatures().isEmpty()) {
                    AccessCanBeTightenedInspection.log(member.getName() + " overrides");
                    return currentLevel;
                }
                if (MethodUtils.isOverridden(method)) {
                    AccessCanBeTightenedInspection.log(member.getName() + " overridden");
                    return currentLevel;
                }
            }
            if (member instanceof PsiEnumConstant) {
                return currentLevel;
            }
            if (member instanceof PsiClass && (member instanceof PsiAnonymousClass || member instanceof PsiTypeParameter || member instanceof PsiSyntheticClass || PsiUtil.isLocalClass((PsiClass)member))) {
                return currentLevel;
            }
            if (memberClass != null && (memberClass.isInterface() || memberClass.isEnum() || memberClass.isAnnotationType() || PsiUtil.isLocalClass(memberClass) && member instanceof PsiClass)) {
                return currentLevel;
            }
            PsiFile memberFile = member.getContainingFile();
            Project project = memberFile.getProject();
            if (this.myDeadCodeInspection.isEntryPoint(member)) {
                AccessCanBeTightenedInspection.log(member.getName() + " is entry point");
                return currentLevel;
            }
            PsiDirectory memberDirectory = memberFile.getContainingDirectory();
            PsiPackage memberPackage = memberDirectory == null ? null : JavaDirectoryService.getInstance().getPackage(memberDirectory);
            AccessCanBeTightenedInspection.log(member.getName() + ": checking effective level for " + member);
            AtomicInteger maxLevel = new AtomicInteger(1);
            AtomicBoolean foundUsage = new AtomicBoolean();
            boolean proceed = UnusedSymbolUtil.processUsages(project, memberFile, member, new EmptyProgressIndicator(), null, info -> {
                if (member == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection$MyVisitor", "lambda$suggestLevel$1"));
                }
                PsiElement element = info.getElement();
                if (element == null) {
                    return true;
                }
                PsiFile psiFile = info.getFile();
                if (psiFile == null) {
                    return true;
                }
                return this.handleUsage(member, memberClass, memberFile, maxLevel, memberPackage, element, psiFile, foundUsage);
            });
            if (proceed && member instanceof PsiClass && LambdaUtil.isFunctionalClass((PsiClass)member)) {
                FunctionalExpressionSearch.search((PsiClass)member).forEach(functionalExpression -> {
                    if (member == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection$MyVisitor", "lambda$suggestLevel$2"));
                    }
                    PsiFile psiFile = functionalExpression.getContainingFile();
                    return this.handleUsage(member, memberClass, memberFile, maxLevel, memberPackage, (PsiElement)functionalExpression, psiFile, foundUsage);
                });
            }
            if (!foundUsage.get()) {
                AccessCanBeTightenedInspection.log(member.getName() + " unused; ignore");
                return currentLevel;
            }
            int suggestedLevel = maxLevel.get();
            if (suggestedLevel == 1 && memberClass == null) {
                suggestedLevel = AccessCanBeTightenedInspection.this.suggestPackageLocal(member);
            }
            String suggestedModifier = PsiUtil.getAccessModifier(suggestedLevel);
            AccessCanBeTightenedInspection.log(member.getName() + ": effective level is '" + suggestedModifier + "'");
            return suggestedLevel;
        }

        private boolean handleUsage(@NotNull PsiMember member, @Nullable PsiClass memberClass, @NotNull PsiFile memberFile, @NotNull AtomicInteger maxLevel, @Nullable PsiPackage memberPackage, @NotNull PsiElement element, @NotNull PsiFile psiFile, @NotNull AtomicBoolean foundUsage) {
            if (member == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection$MyVisitor", "handleUsage"));
            }
            if (memberFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberFile", "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection$MyVisitor", "handleUsage"));
            }
            if (maxLevel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maxLevel", "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection$MyVisitor", "handleUsage"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection$MyVisitor", "handleUsage"));
            }
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection$MyVisitor", "handleUsage"));
            }
            if (foundUsage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foundUsage", "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection$MyVisitor", "handleUsage"));
            }
            foundUsage.set(true);
            if (!(psiFile instanceof PsiJavaFile)) {
                AccessCanBeTightenedInspection.log("     refd from " + psiFile.getName() + "; set to public");
                maxLevel.set(4);
                return false;
            }
            int level = this.getEffectiveLevel(element, psiFile, member, memberFile, memberClass, memberPackage);
            AccessCanBeTightenedInspection.log("    ref in file " + psiFile.getName() + "; level = " + PsiUtil.getAccessModifier(level) + "; (" + element + ")");
            maxLevel.getAndAccumulate(level, Math::max);
            return level != 4;
        }

        @PsiUtil.AccessLevel
        private int getEffectiveLevel(@NotNull PsiElement element, @NotNull PsiFile file, @NotNull PsiMember member, @NotNull PsiFile memberFile, PsiClass memberClass, PsiPackage memberPackage) {
            PsiPackage aPackage;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection$MyVisitor", "getEffectiveLevel"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection$MyVisitor", "getEffectiveLevel"));
            }
            if (member == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection$MyVisitor", "getEffectiveLevel"));
            }
            if (memberFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberFile", "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection$MyVisitor", "getEffectiveLevel"));
            }
            PsiClass innerClass = PsiTreeUtil.getParentOfType(element, PsiClass.class);
            boolean isAbstractMember = member.hasModifierProperty("abstract");
            if (memberClass != null && PsiTreeUtil.isAncestor(innerClass, memberClass, false) || innerClass != null && PsiTreeUtil.isAncestor(memberClass, innerClass, false) && !innerClass.hasModifierProperty("static")) {
                if (AccessCanBeTightenedInspection.isInReferenceList(innerClass.getModifierList(), member) || AccessCanBeTightenedInspection.isInReferenceList(innerClass.getImplementsList(), member) || AccessCanBeTightenedInspection.isInReferenceList(innerClass.getExtendsList(), member)) {
                    return AccessCanBeTightenedInspection.this.suggestPackageLocal(member);
                }
                return !isAbstractMember && (((AccessCanBeTightenedInspection)AccessCanBeTightenedInspection.this).myVisibilityInspection.SUGGEST_PRIVATE_FOR_INNERS || !AccessCanBeTightenedInspection.isInnerClass(memberClass)) ? 1 : AccessCanBeTightenedInspection.this.suggestPackageLocal(member);
            }
            PsiDirectory directory = file.getContainingDirectory();
            PsiPackage psiPackage = aPackage = directory == null ? null : JavaDirectoryService.getInstance().getPackage(directory);
            if (aPackage == memberPackage || aPackage != null && memberPackage != null && Comparing.strEqual(aPackage.getQualifiedName(), memberPackage.getQualifiedName())) {
                return AccessCanBeTightenedInspection.this.suggestPackageLocal(member);
            }
            if (innerClass != null && memberClass != null && innerClass.isInheritor(memberClass, true)) {
                boolean isConstructor;
                PsiElement resolved = element instanceof PsiReference ? ((PsiReference)((Object)element)).resolve() : null;
                boolean bl = isConstructor = resolved instanceof PsiClass && element.getParent() instanceof PsiNewExpression || resolved instanceof PsiMethod && ((PsiMethod)resolved).isConstructor();
                if (!isConstructor) {
                    return 3;
                }
            }
            return 4;
        }
    }
}

