/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.util.Comparing;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorColorsSchemeImpl
extends AbstractColorsScheme
implements ExternalizableScheme {
    public EditorColorsSchemeImpl(EditorColorsScheme parentScheme) {
        super(parentScheme);
    }

    @Override
    public void setAttributes(@NotNull TextAttributesKey key, TextAttributes attributes) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/colors/impl/EditorColorsSchemeImpl", "setAttributes"));
        }
        if (attributes == TextAttributes.USE_INHERITED_MARKER || !attributes.equals(this.getAttributes(key))) {
            this.myAttributesMap.put(key, attributes);
        }
    }

    @Override
    public void setColor(ColorKey key, Color color) {
        if (!Comparing.equal(color, this.getColor(key))) {
            this.myColorsMap.put(key, color);
        }
    }

    @Override
    public TextAttributes getAttributes(@Nullable TextAttributesKey key) {
        if (key != null) {
            TextAttributesKey fallbackKey = key.getFallbackAttributeKey();
            TextAttributes attributes = this.getDirectlyDefinedAttributes(key);
            if (fallbackKey == null) {
                return attributes;
            }
            if (attributes != null && attributes != TextAttributes.USE_INHERITED_MARKER) {
                return attributes;
            }
            attributes = this.getFallbackAttributes(fallbackKey);
            if (attributes != null) {
                return attributes;
            }
        }
        return this.myParentScheme.getAttributes(key);
    }

    @Override
    @Nullable
    public Color getColor(ColorKey key) {
        if (this.myColorsMap.containsKey(key)) {
            return (Color)this.myColorsMap.get(key);
        }
        return this.myParentScheme.getColor(key);
    }

    @Override
    public Object clone() {
        EditorColorsSchemeImpl newScheme = new EditorColorsSchemeImpl(this.myParentScheme);
        this.copyTo(newScheme);
        newScheme.setName(this.getName());
        newScheme.setDefaultMetaInfo(this);
        return newScheme;
    }
}

