/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project;

import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.PathKt;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\u001a\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t\u001a\u001e\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e\u001a\u000e\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\t\u001a\u001a\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u000e2\b\b\u0002\u0010\u0014\u001a\u00020\u0001H\u0007\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"isDirectoryBased", "", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)Z", "stateStore", "Lcom/intellij/openapi/components/impl/stores/IProjectStore;", "getStateStore", "(Lcom/intellij/openapi/project/Project;)Lcom/intellij/openapi/components/impl/stores/IProjectStore;", "getProjectStoreDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "file", "isEqualToProjectFileStorePath", "project", "filePath", "", "storePath", "isProjectDirectoryExistsUsingIo", "parent", "isValidProjectPath", "path", "fastCheckIpr", "projectModel-impl"})
public final class ProjectKt {
    public static final boolean isDirectoryBased(@NotNull Project $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        IComponentStore store = ServiceKt.getStateStore($receiver);
        return store instanceof IProjectStore && Intrinsics.areEqual((Object)((Object)StorageScheme.DIRECTORY_BASED), (Object)((Object)((IProjectStore)store).getStorageScheme()));
    }

    @NotNull
    public static final IProjectStore getStateStore(@NotNull Project $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Object object = $receiver.getPicoContainer().getComponentInstance(IComponentStore.class);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.components.impl.stores.IProjectStore");
        }
        return (IProjectStore)object;
    }

    @Nullable
    public static final VirtualFile getProjectStoreDirectory(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return file.isDirectory() ? file.findChild(".idea") : (VirtualFile)null;
    }

    @JvmOverloads
    public static final boolean isValidProjectPath(@NotNull String path, boolean fastCheckIpr) {
        Path path2;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        if (fastCheckIpr && StringsKt.endsWith$default((String)path, (String)".ipr", (boolean)false, (int)2, null)) {
            return true;
        }
        try {
            path2 = Paths.get(path, new String[0]);
        }
        catch (InvalidPathException e) {
            return false;
        }
        Path file = path2;
        BasicFileAttributes basicFileAttributes = PathKt.basicAttributesIfExists(file);
        if (basicFileAttributes == null) {
            return false;
        }
        BasicFileAttributes attributes = basicFileAttributes;
        return !attributes.isDirectory() || PathKt.exists(file.resolve(".idea"));
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ boolean isValidProjectPath$default(String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: isValidProjectPath");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return ProjectKt.isValidProjectPath(string, bl);
    }

    @JvmOverloads
    public static boolean isValidProjectPath(@NotNull String path) {
        return ProjectKt.isValidProjectPath$default(path, false, 2, null);
    }

    public static final boolean isProjectDirectoryExistsUsingIo(@NotNull VirtualFile parent) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        try {
            return PathKt.exists(Paths.get(FileUtil.toSystemDependentName(parent.getPath()), ".idea"));
        }
        catch (InvalidPathException e) {
            return false;
        }
    }

    public static final boolean isEqualToProjectFileStorePath(@NotNull Project project, @NotNull String filePath, @NotNull String storePath) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)storePath, (String)"storePath");
        if (!ProjectKt.isDirectoryBased(project)) {
            return false;
        }
        IComponentStore iComponentStore = ServiceKt.getStateStore(project);
        if (iComponentStore == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.components.impl.stores.IProjectStore");
        }
        IProjectStore store = (IProjectStore)iComponentStore;
        return StringsKt.equals((String)filePath, (String)store.getStateStorageManager().expandMacros(storePath), (!SystemInfo.isFileSystemCaseSensitive ? 1 : 0) != 0);
    }
}

