/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.PrioritizedInternalDocumentListener;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.editor.impl.event.RetargetRangeMarkers;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ExternalChangeAction;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.DocumentCommitProcessor;
import com.intellij.psi.impl.PsiDocumentTransactionListener;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiToDocumentSynchronizer;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.text.BlockSupport;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiDocumentManagerBase
extends PsiDocumentManager
implements DocumentListener,
ProjectComponent {
    static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.PsiDocumentManagerImpl");
    private static final Key<Document> HARD_REF_TO_DOCUMENT = Key.create("HARD_REFERENCE_TO_DOCUMENT");
    private final Key<PsiFile> HARD_REF_TO_PSI;
    private static final Key<List<Runnable>> ACTION_AFTER_COMMIT = Key.create("ACTION_AFTER_COMMIT");
    protected final Project myProject;
    private final PsiManager myPsiManager;
    private final DocumentCommitProcessor myDocumentCommitProcessor;
    protected final Set<Document> myUncommittedDocuments;
    private final Map<Document, UncommittedInfo> myUncommittedInfos;
    protected boolean myStopTrackingDocuments;
    private boolean myPerformBackgroundCommit;
    private volatile boolean myIsCommitInProgress;
    private final PsiToDocumentSynchronizer mySynchronizer;
    private final List<PsiDocumentManager.Listener> myListeners;
    private final Map<Object, Runnable> actionsWhenAllDocumentsAreCommitted;
    private static final Object PERFORM_ALWAYS_KEY = new Object(){

        @NonNls
        public String toString() {
            return "PERFORM_ALWAYS";
        }
    };

    protected PsiDocumentManagerBase(@NotNull Project project, @NotNull PsiManager psiManager, @NotNull MessageBus bus, @NonNls @NotNull DocumentCommitProcessor documentCommitProcessor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/PsiDocumentManagerBase", "<init>"));
        }
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "com/intellij/psi/impl/PsiDocumentManagerBase", "<init>"));
        }
        if (bus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bus", "com/intellij/psi/impl/PsiDocumentManagerBase", "<init>"));
        }
        if (documentCommitProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentCommitProcessor", "com/intellij/psi/impl/PsiDocumentManagerBase", "<init>"));
        }
        this.HARD_REF_TO_PSI = Key.create("HARD_REFERENCE_TO_PSI");
        this.myUncommittedDocuments = ContainerUtil.newConcurrentSet();
        this.myUncommittedInfos = ContainerUtil.newConcurrentMap();
        this.myPerformBackgroundCommit = true;
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.actionsWhenAllDocumentsAreCommitted = new LinkedHashMap<Object, Runnable>();
        this.myProject = project;
        this.myPsiManager = psiManager;
        this.myDocumentCommitProcessor = documentCommitProcessor;
        this.mySynchronizer = new PsiToDocumentSynchronizer(this, bus);
        this.myPsiManager.addPsiTreeChangeListener(this.mySynchronizer);
        bus.connect().subscribe(PsiDocumentTransactionListener.TOPIC, new PsiDocumentTransactionListener(){

            @Override
            public void transactionStarted(@NotNull Document document, @NotNull PsiFile file) {
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase$1", "transactionStarted"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/PsiDocumentManagerBase$1", "transactionStarted"));
                }
                PsiDocumentManagerBase.this.myUncommittedDocuments.remove(document);
            }

            @Override
            public void transactionCompleted(@NotNull Document document, @NotNull PsiFile file) {
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase$1", "transactionCompleted"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/PsiDocumentManagerBase$1", "transactionCompleted"));
                }
            }
        });
    }

    @Override
    @Nullable
    public PsiFile getPsiFile(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "getPsiFile"));
        }
        PsiFile userData = document.getUserData(this.HARD_REF_TO_PSI);
        if (userData != null) {
            return userData;
        }
        PsiFile psiFile = this.getCachedPsiFile(document);
        if (psiFile != null) {
            return psiFile;
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        psiFile = this.getPsiFile(virtualFile);
        if (psiFile == null) {
            return null;
        }
        this.fireFileCreated(document, psiFile);
        return psiFile;
    }

    @Deprecated
    public static void cachePsi(@NotNull Document document, @Nullable PsiFile file) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "cachePsi"));
        }
        LOG.warn("Unsupported method");
    }

    public void associatePsi(@NotNull Document document, @Nullable PsiFile file) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "associatePsi"));
        }
        document.putUserData(this.HARD_REF_TO_PSI, file);
    }

    @Override
    public PsiFile getCachedPsiFile(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "getCachedPsiFile"));
        }
        PsiFile userData = document.getUserData(this.HARD_REF_TO_PSI);
        if (userData != null) {
            return userData;
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        return this.getCachedPsiFile(virtualFile);
    }

    @Nullable
    FileViewProvider getCachedViewProvider(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "getCachedViewProvider"));
        }
        VirtualFile virtualFile = PsiDocumentManagerBase.getVirtualFile(document);
        if (virtualFile == null) {
            return null;
        }
        return this.getCachedViewProvider(virtualFile);
    }

    private FileViewProvider getCachedViewProvider(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/psi/impl/PsiDocumentManagerBase", "getCachedViewProvider"));
        }
        return ((PsiManagerEx)this.myPsiManager).getFileManager().findCachedViewProvider(virtualFile);
    }

    @Nullable
    private static VirtualFile getVirtualFile(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "getVirtualFile"));
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        return virtualFile;
    }

    @Nullable
    PsiFile getCachedPsiFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/psi/impl/PsiDocumentManagerBase", "getCachedPsiFile"));
        }
        return ((PsiManagerEx)this.myPsiManager).getFileManager().getCachedPsiFile(virtualFile);
    }

    @Nullable
    private PsiFile getPsiFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/psi/impl/PsiDocumentManagerBase", "getPsiFile"));
        }
        return ((PsiManagerEx)this.myPsiManager).getFileManager().findFile(virtualFile);
    }

    @Override
    public Document getDocument(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/PsiDocumentManagerBase", "getDocument"));
        }
        if (file instanceof PsiBinaryFile) {
            return null;
        }
        Document document = this.getCachedDocument(file);
        if (document != null) {
            if (!file.getViewProvider().isPhysical() && document.getUserData(this.HARD_REF_TO_PSI) == null) {
                PsiUtilCore.ensureValid(file);
                this.associatePsi(document, file);
            }
            return document;
        }
        FileViewProvider viewProvider = file.getViewProvider();
        if (!viewProvider.isEventSystemEnabled()) {
            return null;
        }
        document = FileDocumentManager.getInstance().getDocument(viewProvider.getVirtualFile());
        if (document != null) {
            if (document.getTextLength() != file.getTextLength()) {
                String message = "Document/PSI mismatch: " + file + " (" + file.getClass() + "); physical=" + viewProvider.isPhysical();
                if (document.getTextLength() + file.getTextLength() < 8096) {
                    message = message + "\n=== document ===\n" + document.getText() + "\n=== PSI ===\n" + file.getText();
                }
                throw new AssertionError((Object)message);
            }
            if (!viewProvider.isPhysical()) {
                PsiUtilCore.ensureValid(file);
                this.associatePsi(document, file);
                file.putUserData(HARD_REF_TO_DOCUMENT, document);
            }
        }
        return document;
    }

    @Override
    public Document getCachedDocument(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/PsiDocumentManagerBase", "getCachedDocument"));
        }
        if (!file.isPhysical()) {
            return null;
        }
        VirtualFile vFile = file.getViewProvider().getVirtualFile();
        return FileDocumentManager.getInstance().getCachedDocument(vFile);
    }

    @Override
    public void commitAllDocuments() {
        Document[] documents;
        ApplicationManager.getApplication().assertIsDispatchThread();
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        if (this.myUncommittedDocuments.isEmpty()) {
            return;
        }
        for (Document document : documents = this.getUncommittedDocuments()) {
            this.commitDocument(document);
        }
        LOG.assertTrue(!this.hasUncommitedDocuments(), this.myUncommittedDocuments);
    }

    @Override
    public void performForCommittedDocument(@NotNull Document doc, @NotNull Runnable action) {
        Document document;
        if (doc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/psi/impl/PsiDocumentManagerBase", "performForCommittedDocument"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/psi/impl/PsiDocumentManagerBase", "performForCommittedDocument"));
        }
        Document document2 = document = doc instanceof DocumentWindow ? ((DocumentWindow)doc).getDelegate() : doc;
        if (this.isCommitted(document)) {
            action.run();
        } else {
            PsiDocumentManagerBase.addRunOnCommit(document, action);
        }
    }

    public boolean cancelAndRunWhenAllCommitted(@NonNls @NotNull Object key, @NotNull Runnable action) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/impl/PsiDocumentManagerBase", "cancelAndRunWhenAllCommitted"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/psi/impl/PsiDocumentManagerBase", "cancelAndRunWhenAllCommitted"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed()) {
            action.run();
            return true;
        }
        if (this.myUncommittedDocuments.isEmpty()) {
            if (!this.isCommitInProgress()) assert (this.actionsWhenAllDocumentsAreCommitted.isEmpty()) : this.actionsWhenAllDocumentsAreCommitted;
            action.run();
            return true;
        }
        this.checkWeAreOutsideAfterCommitHandler();
        this.actionsWhenAllDocumentsAreCommitted.put(key, action);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRunOnCommit(@NotNull Document document, @NotNull Runnable action) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "addRunOnCommit"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/psi/impl/PsiDocumentManagerBase", "addRunOnCommit"));
        }
        Key<List<Runnable>> key = ACTION_AFTER_COMMIT;
        synchronized (key) {
            List<Runnable> list = document.getUserData(ACTION_AFTER_COMMIT);
            if (list == null) {
                list = new SmartList<Runnable>();
                document.putUserData(ACTION_AFTER_COMMIT, list);
            }
            list.add(action);
        }
    }

    @Override
    public void commitDocument(@NotNull Document doc) {
        if (doc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/psi/impl/PsiDocumentManagerBase", "commitDocument"));
        }
        Document document = doc instanceof DocumentWindow ? ((DocumentWindow)doc).getDelegate() : doc;
        VirtualFile vFile = PsiDocumentManagerBase.getVirtualFile(document);
        if (vFile != null && !PsiDocumentManagerBase.isFreeThreaded(vFile)) {
            ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        }
        if (!this.isCommitted(document)) {
            this.doCommit(document);
        }
    }

    public boolean finishCommit(final @NotNull Document document, final @NotNull List<Processor<Document>> finishProcessors, final boolean synchronously, @NotNull Object reason) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "finishCommit"));
        }
        if (finishProcessors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finishProcessors", "com/intellij/psi/impl/PsiDocumentManagerBase", "finishCommit"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/PsiDocumentManagerBase", "finishCommit"));
        }
        assert (!this.myProject.isDisposed()) : "Already disposed";
        ApplicationManager.getApplication().assertIsDispatchThread();
        final boolean[] ok = new boolean[]{true};
        DocumentRunnable runnable = new DocumentRunnable(document, this.myProject){

            @Override
            public void run() {
                ok[0] = PsiDocumentManagerBase.this.finishCommitInWriteAction(document, finishProcessors, synchronously);
            }
        };
        if (synchronously) {
            runnable.run();
        } else {
            ApplicationManager.getApplication().runWriteAction(runnable);
        }
        if (ok[0]) {
            if (!this.mySynchronizer.isDocumentAffectedByTransactions(document)) {
                InjectedLanguageManager.getInstance(this.myProject).startRunInjectors(document, synchronously);
            }
            this.runAfterCommitActions(document);
            if (DebugUtil.DO_EXPENSIVE_CHECKS && !ApplicationInfoImpl.isInPerformanceTest()) {
                this.checkAllElementsValid(document, reason);
            }
        }
        return ok[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean finishCommitInWriteAction(@NotNull Document document, @NotNull List<Processor<Document>> finishProcessors, boolean synchronously) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "finishCommitInWriteAction"));
        }
        if (finishProcessors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finishProcessors", "com/intellij/psi/impl/PsiDocumentManagerBase", "finishCommitInWriteAction"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed()) {
            return false;
        }
        assert (!(document instanceof DocumentWindow));
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile != null) {
            this.getSmartPointerManager().fastenBelts(virtualFile);
        }
        FileViewProvider viewProvider = this.getCachedViewProvider(document);
        this.myIsCommitInProgress = true;
        boolean success = true;
        try {
            if (viewProvider != null) {
                success = this.commitToExistingPsi(document, finishProcessors, synchronously, virtualFile, viewProvider);
            } else {
                this.handleCommitWithoutPsi(document);
            }
        }
        catch (Throwable e) {
            this.forceReload(virtualFile, viewProvider);
            LOG.error(e);
        }
        finally {
            if (success) {
                this.myUncommittedDocuments.remove(document);
            }
            this.myIsCommitInProgress = false;
        }
        return success;
    }

    private boolean commitToExistingPsi(@NotNull Document document, @NotNull List<Processor<Document>> finishProcessors, boolean synchronously, @Nullable VirtualFile virtualFile, @NotNull FileViewProvider viewProvider) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "commitToExistingPsi"));
        }
        if (finishProcessors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finishProcessors", "com/intellij/psi/impl/PsiDocumentManagerBase", "commitToExistingPsi"));
        }
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/psi/impl/PsiDocumentManagerBase", "commitToExistingPsi"));
        }
        for (Processor<Document> finishRunnable : finishProcessors) {
            boolean success = finishRunnable.process(document);
            if (synchronously) assert (success) : finishRunnable + " in " + finishProcessors;
            if (success) continue;
            return false;
        }
        this.clearUncommittedInfo(document);
        if (virtualFile != null) {
            this.getSmartPointerManager().updatePointerTargetsAfterReparse(virtualFile);
        }
        viewProvider.contentsSynchronized();
        return true;
    }

    void forceReload(VirtualFile virtualFile, @Nullable FileViewProvider viewProvider) {
        if (viewProvider instanceof SingleRootFileViewProvider) {
            ((SingleRootFileViewProvider)viewProvider).markInvalidated();
        }
        if (virtualFile != null) {
            ((FileManagerImpl)((PsiManagerEx)this.myPsiManager).getFileManager()).forceReload(virtualFile);
        }
    }

    private void checkAllElementsValid(@NotNull Document document, final @NotNull Object reason) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "checkAllElementsValid"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/PsiDocumentManagerBase", "checkAllElementsValid"));
        }
        final PsiFile psiFile = this.getCachedPsiFile(document);
        if (psiFile != null) {
            psiFile.accept(new PsiRecursiveElementWalkingVisitor(){

                @Override
                public void visitElement(PsiElement element) {
                    if (!element.isValid()) {
                        throw new AssertionError((Object)("Commit to '" + psiFile.getVirtualFile() + "' has led to invalid element: " + element + "; Reason: '" + reason + "'"));
                    }
                }
            });
        }
    }

    private void doCommit(final @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "doCommit"));
        }
        assert (!this.myIsCommitInProgress) : "Do not call commitDocument() from inside PSI change listener";
        if (this.getSynchronizer().isDocumentAffectedByTransactions(document)) {
            return;
        }
        final PsiFile psiFile = this.getPsiFile(document);
        if (psiFile == null) {
            this.myUncommittedDocuments.remove(document);
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                PsiDocumentManagerBase.this.myIsCommitInProgress = true;
                try {
                    PsiDocumentManagerBase.this.myDocumentCommitProcessor.commitSynchronously(document, PsiDocumentManagerBase.this.myProject, psiFile);
                }
                finally {
                    PsiDocumentManagerBase.this.myIsCommitInProgress = false;
                }
                assert (!PsiDocumentManagerBase.this.isInUncommittedSet(document)) : "Document :" + document;
            }
        };
        if (PsiDocumentManagerBase.isFreeThreaded(psiFile.getViewProvider().getVirtualFile())) {
            runnable.run();
        } else {
            ApplicationManager.getApplication().runWriteAction(runnable);
        }
    }

    static boolean isFreeThreaded(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/PsiDocumentManagerBase", "isFreeThreaded"));
        }
        return Boolean.TRUE.equals(file.getUserData(SingleRootFileViewProvider.FREE_THREADED));
    }

    public boolean isCommitInProgress() {
        return this.myIsCommitInProgress;
    }

    @Override
    public <T> T commitAndRunReadAction(final @NotNull Computable<T> computation) {
        if (computation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computation", "com/intellij/psi/impl/PsiDocumentManagerBase", "commitAndRunReadAction"));
        }
        final Ref<Object> ref = Ref.create(null);
        this.commitAndRunReadAction(new Runnable(){

            @Override
            public void run() {
                ref.set(computation.compute());
            }
        });
        return ref.get();
    }

    @Override
    public void reparseFiles(@NotNull Collection<VirtualFile> files, boolean includeOpenFiles) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/psi/impl/PsiDocumentManagerBase", "reparseFiles"));
        }
        FileContentUtilCore.reparseFiles(files);
    }

    @Override
    public void commitAndRunReadAction(final @NotNull Runnable runnable) {
        boolean executed;
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/psi/impl/PsiDocumentManagerBase", "commitAndRunReadAction"));
        }
        Application application = ApplicationManager.getApplication();
        if (SwingUtilities.isEventDispatchThread()) {
            this.commitAllDocuments();
            runnable.run();
            return;
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            LOG.error("Don't call commitAndRunReadAction inside ReadAction, it will cause a deadlock otherwise. " + Thread.currentThread());
        }
        while (!(executed = application.runReadAction(new Computable<Boolean>(){

            @Override
            public Boolean compute() {
                if (PsiDocumentManagerBase.this.myUncommittedDocuments.isEmpty()) {
                    runnable.run();
                    return true;
                }
                return false;
            }
        }).booleanValue())) {
            final Semaphore semaphore = new Semaphore();
            semaphore.down();
            application.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PsiDocumentManagerBase.this.performWhenAllCommitted(new Runnable(){

                        @Override
                        public void run() {
                            semaphore.up();
                        }
                    });
                }
            }, ModalityState.any());
            semaphore.waitFor();
        }
    }

    @Override
    public boolean performWhenAllCommitted(@NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/psi/impl/PsiDocumentManagerBase", "performWhenAllCommitted"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkWeAreOutsideAfterCommitHandler();
        assert (!this.myProject.isDisposed()) : "Already disposed: " + this.myProject;
        if (this.myUncommittedDocuments.isEmpty()) {
            action.run();
            return true;
        }
        CompositeRunnable actions = (CompositeRunnable)this.actionsWhenAllDocumentsAreCommitted.get(PERFORM_ALWAYS_KEY);
        if (actions == null) {
            actions = new CompositeRunnable();
            this.actionsWhenAllDocumentsAreCommitted.put(PERFORM_ALWAYS_KEY, actions);
        }
        actions.add(action);
        ModalityState current = ModalityState.current();
        if (current != ModalityState.NON_MODAL) {
            for (Document document : this.myUncommittedDocuments) {
                this.myDocumentCommitProcessor.commitAsynchronously(this.myProject, document, "re-added with modality " + current + " because performWhenAllCommitted(" + current + ") was called", current);
            }
        }
        return false;
    }

    @Override
    public void performLaterWhenAllCommitted(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/psi/impl/PsiDocumentManagerBase", "performLaterWhenAllCommitted"));
        }
        this.performLaterWhenAllCommitted(runnable, ModalityState.defaultModalityState());
    }

    @Override
    public void performLaterWhenAllCommitted(final @NotNull Runnable runnable, final ModalityState modalityState) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/psi/impl/PsiDocumentManagerBase", "performLaterWhenAllCommitted"));
        }
        final Runnable whenAllCommitted = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (PsiDocumentManagerBase.this.hasUncommitedDocuments()) {
                            PsiDocumentManagerBase.this.performLaterWhenAllCommitted(runnable);
                        } else {
                            runnable.run();
                        }
                    }
                }, modalityState, PsiDocumentManagerBase.this.myProject.getDisposed());
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread() && this.isInsideCommitHandler()) {
            whenAllCommitted.run();
        } else {
            UIUtil.invokeLaterIfNeeded(new Runnable(){

                @Override
                public void run() {
                    PsiDocumentManagerBase.this.performWhenAllCommitted(whenAllCommitted);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAfterCommitActions(@NotNull Document document) {
        List<Runnable> list;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "runAfterCommitActions"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Key<List<Runnable>> key = ACTION_AFTER_COMMIT;
        synchronized (key) {
            list = document.getUserData(ACTION_AFTER_COMMIT);
            if (list != null) {
                list = new ArrayList<Runnable>(list);
                document.putUserData(ACTION_AFTER_COMMIT, null);
            }
        }
        if (list != null) {
            for (Runnable runnable : list) {
                runnable.run();
            }
        }
        if (!this.hasUncommitedDocuments() && !this.actionsWhenAllDocumentsAreCommitted.isEmpty()) {
            ArrayList<Map.Entry<Object, Runnable>> entries = new ArrayList<Map.Entry<Object, Runnable>>(new LinkedHashMap<Object, Runnable>(this.actionsWhenAllDocumentsAreCommitted).entrySet());
            this.beforeCommitHandler();
            try {
                for (Map.Entry entry : entries) {
                    Runnable action = (Runnable)entry.getValue();
                    try {
                        action.run();
                    }
                    catch (ProcessCanceledException processCanceledException) {
                    }
                    catch (Throwable e) {
                        LOG.error("During running " + action, e);
                    }
                }
            }
            finally {
                this.actionsWhenAllDocumentsAreCommitted.clear();
            }
        }
    }

    private void beforeCommitHandler() {
        this.actionsWhenAllDocumentsAreCommitted.put(PERFORM_ALWAYS_KEY, EmptyRunnable.getInstance());
    }

    private void checkWeAreOutsideAfterCommitHandler() {
        if (this.isInsideCommitHandler()) {
            throw new IncorrectOperationException("You must not call performWhenAllCommitted()/cancelAndRunWhenCommitted() from within after-commit handler");
        }
    }

    private boolean isInsideCommitHandler() {
        return this.actionsWhenAllDocumentsAreCommitted.get(PERFORM_ALWAYS_KEY) == EmptyRunnable.getInstance();
    }

    @Override
    public void addListener(@NotNull PsiDocumentManager.Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/psi/impl/PsiDocumentManagerBase", "addListener"));
        }
        this.myListeners.add(listener);
    }

    @Override
    public void removeListener(@NotNull PsiDocumentManager.Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/psi/impl/PsiDocumentManagerBase", "removeListener"));
        }
        this.myListeners.remove(listener);
    }

    @Override
    public boolean isDocumentBlockedByPsi(@NotNull Document doc) {
        if (doc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/psi/impl/PsiDocumentManagerBase", "isDocumentBlockedByPsi"));
        }
        return false;
    }

    @Override
    public void doPostponedOperationsAndUnblockDocument(@NotNull Document doc) {
        if (doc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/psi/impl/PsiDocumentManagerBase", "doPostponedOperationsAndUnblockDocument"));
        }
    }

    void fireDocumentCreated(@NotNull Document document, PsiFile file) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "fireDocumentCreated"));
        }
        for (PsiDocumentManager.Listener listener : this.myListeners) {
            listener.documentCreated(document, file);
        }
    }

    private void fireFileCreated(@NotNull Document document, @NotNull PsiFile file) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "fireFileCreated"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/PsiDocumentManagerBase", "fireFileCreated"));
        }
        for (PsiDocumentManager.Listener listener : this.myListeners) {
            listener.fileCreated(file, document);
        }
    }

    @Override
    @NotNull
    public CharSequence getLastCommittedText(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "getLastCommittedText"));
        }
        CharSequence charSequence = this.getLastCommittedDocument(document).getImmutableCharSequence();
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiDocumentManagerBase", "getLastCommittedText"));
        }
        return charSequence;
    }

    @Override
    public long getLastCommittedStamp(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "getLastCommittedStamp"));
        }
        if (document instanceof DocumentWindow) {
            document = ((DocumentWindow)document).getDelegate();
        }
        return this.getLastCommittedDocument(document).getModificationStamp();
    }

    @Override
    @Nullable
    public Document getLastCommittedDocument(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/PsiDocumentManagerBase", "getLastCommittedDocument"));
        }
        Document document = this.getDocument(file);
        return document == null ? null : this.getLastCommittedDocument(document);
    }

    @NotNull
    public DocumentEx getLastCommittedDocument(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "getLastCommittedDocument"));
        }
        if (document instanceof FrozenDocument) {
            DocumentEx documentEx = (DocumentEx)document;
            if (documentEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiDocumentManagerBase", "getLastCommittedDocument"));
            }
            return documentEx;
        }
        if (document instanceof DocumentWindow) {
            DocumentWindow answer;
            DocumentWindow window = (DocumentWindow)document;
            Document delegate = window.getDelegate();
            if (delegate instanceof FrozenDocument) {
                DocumentEx documentEx = (DocumentEx)((Object)window);
                if (documentEx == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiDocumentManagerBase", "getLastCommittedDocument"));
                }
                return documentEx;
            }
            if (!window.isValid()) {
                throw new AssertionError((Object)("host committed: " + this.isCommitted(delegate) + ", window=" + window));
            }
            UncommittedInfo info = this.myUncommittedInfos.get(delegate);
            DocumentWindow documentWindow = answer = info == null ? null : (DocumentWindow)info.myFrozenWindows.get(document);
            if (answer == null) {
                answer = this.freezeWindow(window);
            }
            if (info != null) {
                answer = ConcurrencyUtil.cacheOrGet(info.myFrozenWindows, window, answer);
            }
            DocumentEx documentEx = (DocumentEx)((Object)answer);
            if (documentEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiDocumentManagerBase", "getLastCommittedDocument"));
            }
            return documentEx;
        }
        assert (document instanceof DocumentImpl);
        UncommittedInfo info = this.myUncommittedInfos.get(document);
        FrozenDocument frozenDocument = info != null ? info.myFrozen : ((DocumentImpl)document).freeze();
        if (frozenDocument == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiDocumentManagerBase", "getLastCommittedDocument"));
        }
        return frozenDocument;
    }

    @NotNull
    protected DocumentWindow freezeWindow(@NotNull DocumentWindow document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "freezeWindow"));
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public List<DocumentEvent> getEventsSinceCommit(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "getEventsSinceCommit"));
        }
        assert (document instanceof DocumentImpl);
        UncommittedInfo info = this.myUncommittedInfos.get(document);
        if (info != null) {
            List list = info.myEvents;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiDocumentManagerBase", "getEventsSinceCommit"));
            }
            return list;
        }
        List<DocumentEvent> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiDocumentManagerBase", "getEventsSinceCommit"));
        }
        return list;
    }

    @Override
    @NotNull
    public Document[] getUncommittedDocuments() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Document[] documents = this.myUncommittedDocuments.toArray(new Document[this.myUncommittedDocuments.size()]);
        Document[] documentArray = ArrayUtil.stripTrailingNulls(documents);
        if (documentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiDocumentManagerBase", "getUncommittedDocuments"));
        }
        return documentArray;
    }

    boolean isInUncommittedSet(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "isInUncommittedSet"));
        }
        if (document instanceof DocumentWindow) {
            document = ((DocumentWindow)document).getDelegate();
        }
        return this.myUncommittedDocuments.contains(document);
    }

    @Override
    public boolean isUncommited(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "isUncommited"));
        }
        return !this.isCommitted(document);
    }

    @Override
    public boolean isCommitted(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "isCommitted"));
        }
        if (document instanceof DocumentWindow) {
            document = ((DocumentWindow)document).getDelegate();
        }
        if (this.getSynchronizer().isInSynchronization(document)) {
            return true;
        }
        return !((DocumentEx)document).isInEventsHandling() && !this.isInUncommittedSet(document);
    }

    @Override
    public boolean hasUncommitedDocuments() {
        return !this.myIsCommitInProgress && !this.myUncommittedDocuments.isEmpty();
    }

    @Override
    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        FileViewProvider viewProvider;
        boolean inMyProject;
        boolean isRelevant;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/PsiDocumentManagerBase", "beforeDocumentChange"));
        }
        if (this.myStopTrackingDocuments || this.myProject.isDisposed()) {
            return;
        }
        Document document = event.getDocument();
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        boolean bl = isRelevant = virtualFile != null && this.isRelevant(virtualFile);
        if (document instanceof DocumentImpl && !this.myUncommittedInfos.containsKey(document)) {
            this.myUncommittedInfos.put(document, new UncommittedInfo((DocumentImpl)document));
        }
        boolean bl2 = inMyProject = (viewProvider = this.getCachedViewProvider(document)) != null && viewProvider.getManager() == this.myPsiManager;
        if (!isRelevant || !inMyProject) {
            return;
        }
        List<PsiFile> files = viewProvider.getAllFiles();
        PsiFile psiCause = null;
        for (PsiFile file : files) {
            if (file == null) {
                throw new AssertionError((Object)("View provider " + viewProvider + " (" + viewProvider.getClass() + ") returned null in its files array: " + files + " for file " + viewProvider.getVirtualFile()));
            }
            if (!PsiToDocumentSynchronizer.isInsideAtomicChange(file)) continue;
            psiCause = file;
        }
        if (psiCause == null) {
            this.beforeDocumentChangeOnUnlockedDocument(viewProvider);
        }
        ((SingleRootFileViewProvider)viewProvider).beforeDocumentChanged(psiCause);
    }

    protected void beforeDocumentChangeOnUnlockedDocument(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/psi/impl/PsiDocumentManagerBase", "beforeDocumentChangeOnUnlockedDocument"));
        }
    }

    @Override
    public void documentChanged(DocumentEvent event) {
        boolean forceCommit;
        boolean inMyProject;
        if (this.myStopTrackingDocuments || this.myProject.isDisposed()) {
            return;
        }
        Document document = event.getDocument();
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        boolean isRelevant = virtualFile != null && this.isRelevant(virtualFile);
        FileViewProvider viewProvider = this.getCachedViewProvider(document);
        if (viewProvider == null) {
            this.handleCommitWithoutPsi(document);
            return;
        }
        boolean bl = inMyProject = viewProvider.getManager() == this.myPsiManager;
        if (!isRelevant || !inMyProject) {
            this.clearUncommittedInfo(document);
            return;
        }
        List<PsiFile> files = viewProvider.getAllFiles();
        boolean commitNecessary = true;
        for (PsiFile file : files) {
            if (PsiToDocumentSynchronizer.isInsideAtomicChange(file)) {
                commitNecessary = false;
                continue;
            }
            assert (file instanceof PsiFileImpl || "mock.file".equals(file.getName()) && ApplicationManager.getApplication().isUnitTestMode()) : event + "; file=" + file + "; allFiles=" + files + "; viewProvider=" + viewProvider;
        }
        boolean bl2 = forceCommit = ApplicationManager.getApplication().hasWriteAction(ExternalChangeAction.class) && (SystemProperties.getBooleanProperty("idea.force.commit.on.external.change", false) || ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode());
        if (event.isWholeTextReplaced() && document.getTextLength() > 100000) {
            document.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, Boolean.TRUE);
        }
        if (commitNecessary) {
            assert (!(document instanceof DocumentWindow));
            this.myUncommittedDocuments.add(document);
            if (forceCommit) {
                this.commitDocument(document);
            } else if (!((DocumentEx)document).isInBulkUpdate() && this.myPerformBackgroundCommit) {
                this.myDocumentCommitProcessor.commitAsynchronously(this.myProject, document, event, ApplicationManager.getApplication().getCurrentModalityState());
            }
        } else {
            this.clearUncommittedInfo(document);
        }
    }

    void handleCommitWithoutPsi(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "handleCommitWithoutPsi"));
        }
        UncommittedInfo prevInfo = this.clearUncommittedInfo(document);
        if (prevInfo == null) {
            return;
        }
        if (!this.myProject.isInitialized() || this.myProject.isDisposed()) {
            return;
        }
        this.myUncommittedDocuments.remove(document);
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null || !FileIndexFacade.getInstance(this.myProject).isInContent(virtualFile)) {
            return;
        }
        final PsiFile psiFile = this.getPsiFile(document);
        if (psiFile == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new ExternalChangeAction(){

            @Override
            public void run() {
                FileViewProvider viewProvider = psiFile.getViewProvider();
                if (viewProvider instanceof SingleRootFileViewProvider) {
                    ((SingleRootFileViewProvider)viewProvider).onContentReload();
                } else {
                    LOG.error("Invalid view provider: " + viewProvider + " of " + viewProvider.getClass());
                }
            }
        });
    }

    @Nullable
    private UncommittedInfo clearUncommittedInfo(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "clearUncommittedInfo"));
        }
        UncommittedInfo info = this.myUncommittedInfos.remove(document);
        if (info != null) {
            this.getSmartPointerManager().updatePointers(document, info.myFrozen, info.myEvents);
            info.removeListener();
        }
        return info;
    }

    private SmartPointerManagerImpl getSmartPointerManager() {
        return (SmartPointerManagerImpl)SmartPointerManager.getInstance(this.myProject);
    }

    private boolean isRelevant(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/psi/impl/PsiDocumentManagerBase", "isRelevant"));
        }
        return !virtualFile.getFileType().isBinary() && !this.myProject.isDisposed();
    }

    public static boolean checkConsistency(@NotNull PsiFile psiFile, @NotNull Document document) {
        int i2;
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/psi/impl/PsiDocumentManagerBase", "checkConsistency"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerBase", "checkConsistency"));
        }
        if (psiFile.getVirtualFile() == null) {
            return true;
        }
        CharSequence editorText = document.getCharsSequence();
        int documentLength = document.getTextLength();
        if (psiFile.textMatches(editorText)) {
            LOG.assertTrue(psiFile.getTextLength() == documentLength);
            return true;
        }
        char[] fileText = psiFile.textToCharArray();
        String error = "File '" + psiFile.getName() + "' text mismatch after reparse. File length=" + fileText.length + "; Doc length=" + documentLength + "\n";
        for (i2 = 0; i2 < documentLength; ++i2) {
            if (i2 >= fileText.length) {
                error = error + "editorText.length > psiText.length i=" + i2 + "\n";
                break;
            }
            if (i2 >= editorText.length()) {
                error = error + "editorText.length > psiText.length i=" + i2 + "\n";
                break;
            }
            if (editorText.charAt(i2) == fileText[i2]) continue;
            error = error + "first unequal char i=" + i2 + "\n";
            break;
        }
        error = error + "*********************************************\n";
        error = error + "Editor Text tail:(" + (documentLength - i2) + ")\n";
        error = error + "*********************************************\n";
        error = error + "Psi Text tail:(" + (fileText.length - i2) + ")\n";
        error = error + "*********************************************\n";
        if (document instanceof DocumentWindow) {
            error = error + "doc: '" + document.getText() + "'\n";
            error = error + "psi: '" + psiFile.getText() + "'\n";
            error = error + "ast: '" + psiFile.getNode().getText() + "'\n";
            error = error + psiFile.getLanguage() + "\n";
            PsiLanguageInjectionHost context = InjectedLanguageManager.getInstance(psiFile.getProject()).getInjectionHost(psiFile);
            if (context != null) {
                error = error + "context: " + context + "; text: '" + context.getText() + "'\n";
                error = error + "context file: " + context.getContainingFile() + "\n";
            }
            error = error + "document window ranges: " + Arrays.asList(((DocumentWindow)document).getHostRanges()) + "\n";
        }
        LOG.error(error);
        return false;
    }

    @VisibleForTesting
    public void clearUncommittedDocuments() {
        for (UncommittedInfo info : this.myUncommittedInfos.values()) {
            info.removeListener();
        }
        this.myUncommittedInfos.clear();
        this.myUncommittedDocuments.clear();
        this.mySynchronizer.cleanupForNextTest();
    }

    public void disableBackgroundCommit(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/psi/impl/PsiDocumentManagerBase", "disableBackgroundCommit"));
        }
        assert (this.myPerformBackgroundCommit);
        this.myPerformBackgroundCommit = false;
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                PsiDocumentManagerBase.this.myPerformBackgroundCommit = true;
            }
        });
    }

    @Override
    public void projectOpened() {
    }

    @Override
    public void projectClosed() {
    }

    @Override
    public void initComponent() {
    }

    @Override
    public void disposeComponent() {
        this.clearUncommittedDocuments();
    }

    @Override
    @NotNull
    public String getComponentName() {
        String string = this.getClass().getSimpleName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiDocumentManagerBase", "getComponentName"));
        }
        return string;
    }

    @NotNull
    public PsiToDocumentSynchronizer getSynchronizer() {
        PsiToDocumentSynchronizer psiToDocumentSynchronizer = this.mySynchronizer;
        if (psiToDocumentSynchronizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiDocumentManagerBase", "getSynchronizer"));
        }
        return psiToDocumentSynchronizer;
    }

    private static class UncommittedInfo
    extends DocumentAdapter
    implements PrioritizedInternalDocumentListener {
        private final DocumentImpl myOriginal;
        private final FrozenDocument myFrozen;
        private final List<DocumentEvent> myEvents = ContainerUtil.newArrayList();
        private final ConcurrentMap<DocumentWindow, DocumentWindow> myFrozenWindows = ContainerUtil.newConcurrentMap();

        private UncommittedInfo(DocumentImpl original) {
            this.myOriginal = original;
            this.myFrozen = original.freeze();
            this.myOriginal.addDocumentListener(this);
        }

        @Override
        public int getPriority() {
            return 40;
        }

        @Override
        public void documentChanged(DocumentEvent e) {
            this.myEvents.add(e);
        }

        @Override
        public void moveTextHappened(int start, int end, int base) {
            this.myEvents.add(new RetargetRangeMarkers(this.myOriginal, start, end, base));
        }

        public void removeListener() {
            this.myOriginal.removeDocumentListener(this);
        }
    }

    private static class CompositeRunnable
    extends ArrayList<Runnable>
    implements Runnable {
        private CompositeRunnable() {
        }

        @Override
        public void run() {
            for (Runnable runnable : this) {
                runnable.run();
            }
        }
    }
}

