/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSuperExpressionImpl
extends ExpressionPsiElement
implements PsiSuperExpression,
Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiSuperExpressionImpl");

    public PsiSuperExpressionImpl() {
        super(SUPER_EXPRESSION);
    }

    @Override
    public PsiJavaCodeReferenceElement getQualifier() {
        return (PsiJavaCodeReferenceElement)this.findChildByRoleAsPsiElement(54);
    }

    @Override
    public PsiType getType() {
        PsiJavaCodeReferenceElement qualifier = this.getQualifier();
        if (qualifier != null) {
            PsiElement aClass = qualifier.resolve();
            if (!(aClass instanceof PsiClass)) {
                return null;
            }
            return this.getSuperType((PsiClass)aClass, PsiUtil.isLanguageLevel8OrHigher(this));
        }
        for (PsiElement scope = this.getContext(); scope != null; scope = scope.getContext()) {
            PsiType fragmentSuperType;
            if (scope instanceof PsiClass) {
                PsiClass aClass = (PsiClass)scope;
                return this.getSuperType(aClass, false);
            }
            if (scope instanceof PsiExpressionList && scope.getParent() instanceof PsiAnonymousClass) {
                scope = scope.getParent();
                continue;
            }
            if (!(scope instanceof JavaCodeFragment) || (fragmentSuperType = ((JavaCodeFragment)scope).getSuperType()) == null) continue;
            return fragmentSuperType;
        }
        return null;
    }

    @Nullable
    private PsiType getSuperType(PsiClass aClass, boolean checkImmediateSuperInterfaces) {
        PsiClassType[] superTypes;
        PsiClass containingClass;
        if ("java.lang.Object".equals(aClass.getQualifiedName())) {
            return null;
        }
        PsiClass psiClass = containingClass = checkImmediateSuperInterfaces ? PsiTreeUtil.getParentOfType((PsiElement)this, PsiClass.class) : null;
        if (containingClass != null) {
            superTypes = containingClass.isInterface() ? containingClass.getExtendsListTypes() : (containingClass instanceof PsiAnonymousClass ? new PsiClassType[]{((PsiAnonymousClass)containingClass).getBaseClassType()} : containingClass.getImplementsListTypes());
            for (PsiClassType superType : superTypes) {
                PsiClass superClass = superType.resolve();
                if (superClass == null || !superClass.isInterface() || !aClass.equals(superClass)) continue;
                return superType;
            }
        }
        if (aClass.isInterface()) {
            return PsiType.getJavaLangObject(this.getManager(), this.getResolveScope());
        }
        if (aClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassType = ((PsiAnonymousClass)aClass).getBaseClassType();
            PsiClass psiClass2 = baseClassType.resolve();
            return psiClass2 != null && !psiClass2.isInterface() ? baseClassType : PsiType.getJavaLangObject(this.getManager(), this.getResolveScope());
        }
        superTypes = aClass.getExtendsListTypes();
        return superTypes.length == 0 ? PsiType.getJavaLangObject(this.getManager(), this.getResolveScope()) : superTypes[0];
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 54: {
                return this.getFirstChildNode().getElementType() == JAVA_CODE_REFERENCE ? this.getFirstChildNode() : null;
            }
            case 55: {
                return this.findChildByType(DOT);
            }
            case 96: 
        }
        return this.getLastChildNode();
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i2 = child.getElementType();
        if (i2 == JAVA_CODE_REFERENCE) {
            return 54;
        }
        if (i2 == DOT) {
            return 55;
        }
        if (i2 == SUPER_KEYWORD) {
            return 96;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/tree/java/PsiSuperExpressionImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitSuperExpression(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiSuperExpression:" + this.getText();
    }
}

