/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.core.JavaCoreBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiJavaModuleReference
extends PsiReferenceBase.Poly<PsiJavaModuleReferenceElement> {
    private static final Key<ParameterizedCachedValue<PsiJavaModule, Pair<String, Boolean>>> KEY = Key.create("java.module.ref.text.resolve");

    public PsiJavaModuleReference(@NotNull PsiJavaModuleReferenceElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/PsiJavaModuleReference", "<init>"));
        }
        super(element, new TextRange(0, element.getTextLength()), false);
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string = ((PsiJavaModuleReferenceElement)this.getElement()).getReferenceText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaModuleReference", "getCanonicalText"));
        }
        return string;
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaModuleReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Override
    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = ResolveCache.getInstance(this.getProject()).resolveWithCaching(this, Resolver.INSTANCE, false, incompleteCode);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaModuleReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newName) throws IncorrectOperationException {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/psi/impl/source/PsiJavaModuleReference", "handleElementRename"));
        }
        PsiJavaModuleReferenceElement element = (PsiJavaModuleReferenceElement)this.getElement();
        if (element instanceof PsiCompiledElement) {
            throw new IncorrectOperationException(JavaCoreBundle.message("psi.error.attempt.to.edit.class.file", element.getContainingFile()));
        }
        PsiElementFactory factory = PsiElementFactory.SERVICE.getInstance(element.getProject());
        PsiJavaModuleReferenceElement newElement = factory.createModuleFromText("module " + newName + " {}").getNameElement();
        return element.replace(newElement);
    }

    private Project getProject() {
        return ((PsiJavaModuleReferenceElement)this.getElement()).getProject();
    }

    @Nullable
    public static PsiJavaModule resolve(final @NotNull PsiElement refOwner, String refText, boolean incompleteCode) {
        if (refOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refOwner", "com/intellij/psi/impl/source/PsiJavaModuleReference", "resolve"));
        }
        if (StringUtil.isEmpty(refText)) {
            return null;
        }
        CachedValuesManager manager = CachedValuesManager.getManager(refOwner.getProject());
        return manager.getParameterizedCachedValue(refOwner, KEY, new ParameterizedCachedValueProvider<PsiJavaModule, Pair<String, Boolean>>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<PsiJavaModule> compute(Pair<String, Boolean> p) {
                Collection modules = Resolver.findModules(refOwner.getContainingFile(), (String)p.first, (Boolean)p.second);
                PsiJavaModule module = modules.size() == 1 ? (PsiJavaModule)modules.iterator().next() : null;
                return CachedValueProvider.Result.create(module, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
            }
        }, false, Pair.pair(refText, incompleteCode));
    }

    private static class Resolver
    implements ResolveCache.PolyVariantResolver<PsiJavaModuleReference> {
        private static final ResolveCache.PolyVariantResolver<PsiJavaModuleReference> INSTANCE = new Resolver();

        private Resolver() {
        }

        @Override
        @NotNull
        public ResolveResult[] resolve(@NotNull PsiJavaModuleReference reference, boolean incompleteCode) {
            String moduleName;
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/psi/impl/source/PsiJavaModuleReference$Resolver", "resolve"));
            }
            PsiFile file = ((PsiJavaModuleReferenceElement)reference.getElement()).getContainingFile();
            Collection<PsiJavaModule> modules = Resolver.findModules(file, moduleName = reference.getCanonicalText(), incompleteCode);
            if (!modules.isEmpty()) {
                ResolveResult[] result = new ResolveResult[modules.size()];
                int i = 0;
                for (PsiJavaModule module : modules) {
                    result[i++] = new PsiElementResolveResult(module);
                }
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaModuleReference$Resolver", "resolve"));
                }
                return result;
            }
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaModuleReference$Resolver", "resolve"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }

        private static Collection<PsiJavaModule> findModules(PsiFile file, String moduleName, boolean incompleteCode) {
            Project project = file.getProject();
            GlobalSearchScope scope = null;
            if (incompleteCode || file.getOriginalFile() instanceof PsiCompiledFile) {
                scope = GlobalSearchScope.allScope(project);
            } else {
                Module module;
                VirtualFile vFile = file.getVirtualFile();
                if (vFile != null && (module = FileIndexFacade.getInstance(project).getModuleForFile(vFile)) != null) {
                    scope = module.getModuleWithDependenciesAndLibrariesScope(false);
                }
            }
            return scope != null ? JavaFileManager.SERVICE.getInstance(project).findModules(moduleName, scope) : Collections.emptyList();
        }
    }
}

