/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBaseJavaLocalInspectionTool
extends LocalInspectionTool {
    private static final Condition<PsiElement> PROBLEM_ELEMENT_CONDITION = Conditions.and(Conditions.instanceOf(PsiFile.class, PsiClass.class, PsiMethod.class, PsiField.class), Conditions.notInstanceOf(PsiTypeParameter.class));

    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/AbstractBaseJavaLocalInspectionTool", "checkMethod"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/AbstractBaseJavaLocalInspectionTool", "checkMethod"));
        }
        return null;
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInspection/AbstractBaseJavaLocalInspectionTool", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/AbstractBaseJavaLocalInspectionTool", "checkClass"));
        }
        return null;
    }

    @Nullable
    public ProblemDescriptor[] checkField(@NotNull PsiField field, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInspection/AbstractBaseJavaLocalInspectionTool", "checkField"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/AbstractBaseJavaLocalInspectionTool", "checkField"));
        }
        return null;
    }

    @Override
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/AbstractBaseJavaLocalInspectionTool", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/AbstractBaseJavaLocalInspectionTool", "checkFile"));
        }
        return null;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/AbstractBaseJavaLocalInspectionTool", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitMethod(PsiMethod method) {
                this.addDescriptors(AbstractBaseJavaLocalInspectionTool.this.checkMethod(method, holder.getManager(), isOnTheFly));
            }

            @Override
            public void visitClass(PsiClass aClass) {
                this.addDescriptors(AbstractBaseJavaLocalInspectionTool.this.checkClass(aClass, holder.getManager(), isOnTheFly));
            }

            @Override
            public void visitField(PsiField field) {
                this.addDescriptors(AbstractBaseJavaLocalInspectionTool.this.checkField(field, holder.getManager(), isOnTheFly));
            }

            @Override
            public void visitFile(PsiFile file) {
                this.addDescriptors(AbstractBaseJavaLocalInspectionTool.this.checkFile(file, holder.getManager(), isOnTheFly));
            }

            private void addDescriptors(ProblemDescriptor[] descriptors) {
                if (descriptors != null) {
                    for (ProblemDescriptor descriptor : descriptors) {
                        holder.registerProblem(descriptor);
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AbstractBaseJavaLocalInspectionTool", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    @Override
    public PsiNamedElement getProblemElement(PsiElement psiElement) {
        return (PsiNamedElement)PsiTreeUtil.findFirstParent(psiElement, PROBLEM_ELEMENT_CONDITION);
    }
}

