/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.impl.search.JavaNullMethodArgumentUtil;
import com.intellij.util.SmartList;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class NullParameterConstraintChecker
extends DataFlowRunner {
    private final Set<PsiParameter> myPossiblyViolatedParameters;

    private NullParameterConstraintChecker(Collection<PsiParameter> parameters, boolean isOnTheFly) {
        super(false, true, isOnTheFly);
        this.myPossiblyViolatedParameters = new THashSet(parameters);
    }

    @NotNull
    static PsiParameter[] checkMethodParameters(PsiMethod method) {
        if (method.getBody() == null) {
            if (PsiParameter.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/NullParameterConstraintChecker", "checkMethodParameters"));
            }
            return PsiParameter.EMPTY_ARRAY;
        }
        SmartList<PsiParameter> nullableParameters = new SmartList<PsiParameter>();
        PsiParameter[] parameters = method.getParameterList().getParameters();
        for (int index = 0; index < parameters.length; ++index) {
            PsiParameter parameter = parameters[index];
            if (parameter.getType() instanceof PsiPrimitiveType || NullableNotNullManager.isNotNull(parameter) || NullableNotNullManager.isNullable(parameter) || !JavaNullMethodArgumentUtil.hasNullArgument(method, index)) continue;
            nullableParameters.add(parameter);
        }
        if (nullableParameters.isEmpty()) {
            if (PsiParameter.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/NullParameterConstraintChecker", "checkMethodParameters"));
            }
            return PsiParameter.EMPTY_ARRAY;
        }
        NullParameterConstraintChecker checker = new NullParameterConstraintChecker(nullableParameters, true);
        checker.analyzeMethod(method.getBody(), new StandardInstructionVisitor());
        PsiParameter[] psiParameterArray = checker.myPossiblyViolatedParameters.toArray(new PsiParameter[checker.myPossiblyViolatedParameters.size()]);
        if (psiParameterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/NullParameterConstraintChecker", "checkMethodParameters"));
        }
        return psiParameterArray;
    }

    @Override
    @NotNull
    protected DfaInstructionState[] acceptInstruction(@NotNull InstructionVisitor visitor, @NotNull DfaInstructionState instructionState) {
        PsiModifierListOwner psiVariable;
        DfaValue value;
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/codeInspection/dataFlow/NullParameterConstraintChecker", "acceptInstruction"));
        }
        if (instructionState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instructionState", "com/intellij/codeInspection/dataFlow/NullParameterConstraintChecker", "acceptInstruction"));
        }
        Instruction instruction = instructionState.getInstruction();
        if (instruction instanceof AssignInstruction && (value = ((AssignInstruction)instruction).getAssignedValue()) instanceof DfaVariableValue && (psiVariable = ((DfaVariableValue)value).getPsiVariable()) instanceof PsiParameter) {
            this.myPossiblyViolatedParameters.remove(psiVariable);
        }
        if (instruction instanceof ReturnInstruction && !((ReturnInstruction)instruction).isViaException()) {
            DfaMemoryState memState = instructionState.getMemoryState();
            for (PsiParameter parameter : this.myPossiblyViolatedParameters.toArray(new PsiParameter[this.myPossiblyViolatedParameters.size()])) {
                DfaVariableValue dfaVar = this.getFactory().getVarFactory().createVariableValue(parameter, false);
                if (memState.isNotNull(dfaVar)) continue;
                this.myPossiblyViolatedParameters.remove(parameter);
            }
        }
        DfaInstructionState[] dfaInstructionStateArray = super.acceptInstruction(visitor, instructionState);
        if (dfaInstructionStateArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/NullParameterConstraintChecker", "acceptInstruction"));
        }
        return dfaInstructionStateArray;
    }

    @Override
    @NotNull
    protected DfaMemoryState createMemoryState() {
        MyDfaMemoryState myDfaMemoryState = new MyDfaMemoryState(this.getFactory());
        if (myDfaMemoryState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/NullParameterConstraintChecker", "createMemoryState"));
        }
        return myDfaMemoryState;
    }

    private class MyDfaMemoryState
    extends DfaMemoryStateImpl {
        protected MyDfaMemoryState(DfaValueFactory factory) {
            super(factory);
        }

        protected MyDfaMemoryState(MyDfaMemoryState toCopy) {
            super(toCopy);
        }

        @Override
        public void flushVariable(@NotNull DfaVariableValue variable) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInspection/dataFlow/NullParameterConstraintChecker$MyDfaMemoryState", "flushVariable"));
            }
            PsiModifierListOwner psi = variable.getPsiVariable();
            if (psi instanceof PsiParameter && NullParameterConstraintChecker.this.myPossiblyViolatedParameters.contains(psi)) {
                return;
            }
            super.flushVariable(variable);
        }

        @Override
        @NotNull
        public DfaMemoryStateImpl createCopy() {
            MyDfaMemoryState myDfaMemoryState = new MyDfaMemoryState(this);
            if (myDfaMemoryState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/NullParameterConstraintChecker$MyDfaMemoryState", "createCopy"));
            }
            return myDfaMemoryState;
        }
    }
}

