/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection;

import com.intellij.codeInspection.InspectionProfile;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.SeverityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface InspectionProfileManager
extends ProfileManager,
SeverityProvider {
    public static final String INSPECTION_DIR = "inspection";

    @NotNull
    public static InspectionProfileManager getInstance() {
        InspectionProfileManager inspectionProfileManager = ServiceManager.getService(InspectionProfileManager.class);
        if (inspectionProfileManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProfileManager", "getInstance"));
        }
        return inspectionProfileManager;
    }

    @NotNull
    public static InspectionProfileManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/profile/codeInspection/InspectionProfileManager", "getInstance"));
        }
        InspectionProjectProfileManager inspectionProjectProfileManager = InspectionProjectProfileManager.getInstance(project);
        if (inspectionProjectProfileManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProfileManager", "getInstance"));
        }
        return inspectionProjectProfileManager;
    }

    public void fireProfileChanged(@Nullable Profile var1);

    public void fireProfileChanged(@Nullable Profile var1, @NotNull Profile var2);

    public void setRootProfile(@Nullable String var1);

    @Deprecated
    @NotNull
    default public Profile getRootProfile() {
        InspectionProfile inspectionProfile = this.getCurrentProfile();
        if (inspectionProfile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProfileManager", "getRootProfile"));
        }
        return inspectionProfile;
    }
}

