/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.smartPointers.MarkerCache;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerEx;
import com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import com.intellij.psi.impl.smartPointers.SmartPsiFileRangePointerImpl;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartPointerManagerImpl
extends SmartPointerManager {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl");
    private static final ReferenceQueue<SmartPsiElementPointerImpl> ourQueue = new ReferenceQueue();
    private final Project myProject;
    private final Key<FilePointersList> POINTERS_KEY;
    private final PsiDocumentManagerBase myPsiDocManager;
    private static final Key<Reference<SmartPsiElementPointerImpl>> CACHED_SMART_POINTER_KEY;

    public SmartPointerManagerImpl(Project project) {
        this.myProject = project;
        this.myPsiDocManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(this.myProject);
        this.POINTERS_KEY = Key.create("SMART_POINTERS for " + project);
    }

    private static void processQueue() {
        PointerReference reference;
        while ((reference = (PointerReference)ourQueue.poll()) != null) {
            FilePointersList pointers = (FilePointersList)reference.file.getUserData(reference.key);
            if (pointers == null) continue;
            pointers.removeReference(reference);
        }
    }

    public void fastenBelts(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "fastenBelts"));
        }
        SmartPointerManagerImpl.processQueue();
        FilePointersList pointers = this.getPointers(file);
        if (pointers != null) {
            pointers.processAlivePointers(new Processor<SmartPsiElementPointerImpl>(){

                @Override
                public boolean process(SmartPsiElementPointerImpl pointer) {
                    pointer.getElementInfo().fastenBelt();
                    return true;
                }
            });
        }
    }

    @Override
    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile containingFile = element.getContainingFile();
        SmartPsiElementPointer<E> smartPsiElementPointer = this.createSmartPsiElementPointer(element, containingFile);
        if (smartPsiElementPointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        return smartPsiElementPointer;
    }

    @Override
    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element, PsiFile containingFile) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        SmartPsiElementPointer<E> smartPsiElementPointer = this.createSmartPsiElementPointer(element, containingFile, false);
        if (smartPsiElementPointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        return smartPsiElementPointer;
    }

    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element, PsiFile containingFile, boolean forInjected) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        if (containingFile != null && !containingFile.isValid() || containingFile == null && !element.isValid()) {
            PsiUtilCore.ensureValid(element);
            LOG.error("Invalid element:" + element);
        }
        SmartPointerManagerImpl.processQueue();
        SmartPsiElementPointerImpl<E> pointer = SmartPointerManagerImpl.getCachedPointer(element);
        if (pointer != null && pointer.incrementAndGetReferenceCount(1) > 0) {
            SmartPsiElementPointerImpl<E> smartPsiElementPointerImpl = pointer;
            if (smartPsiElementPointerImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
            }
            return smartPsiElementPointerImpl;
        }
        pointer = new SmartPsiElementPointerImpl<E>(this.myProject, element, containingFile, forInjected);
        if (containingFile != null) {
            this.trackPointer(pointer, containingFile.getViewProvider().getVirtualFile());
        }
        element.putUserData(CACHED_SMART_POINTER_KEY, new SoftReference<SmartPsiElementPointerImpl<E>>(pointer));
        SmartPsiElementPointerImpl<E> smartPsiElementPointerImpl = pointer;
        if (smartPsiElementPointerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        return smartPsiElementPointerImpl;
    }

    private static <E extends PsiElement> SmartPsiElementPointerImpl<E> getCachedPointer(@NotNull E element) {
        Object cachedElement;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getCachedPointer"));
        }
        Reference<SmartPsiElementPointerImpl> data = element.getUserData(CACHED_SMART_POINTER_KEY);
        SmartPsiElementPointerImpl cachedPointer = SoftReference.dereference(data);
        if (cachedPointer != null && ((cachedElement = cachedPointer.getElement()) == null || cachedElement != element)) {
            return null;
        }
        return cachedPointer;
    }

    @Override
    @NotNull
    public SmartPsiFileRange createSmartPsiFileRangePointer(@NotNull PsiFile file, @NotNull TextRange range) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        SmartPsiFileRange smartPsiFileRange = this.createSmartPsiFileRangePointer(file, range, false);
        if (smartPsiFileRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        return smartPsiFileRange;
    }

    @NotNull
    public SmartPsiFileRange createSmartPsiFileRangePointer(@NotNull PsiFile file, @NotNull TextRange range, boolean forInjected) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        if (!file.isValid()) {
            LOG.error("Invalid element:" + file);
        }
        SmartPointerManagerImpl.processQueue();
        SmartPsiFileRangePointerImpl pointer = new SmartPsiFileRangePointerImpl(file, ProperTextRange.create(range), forInjected);
        this.trackPointer(pointer, file.getViewProvider().getVirtualFile());
        SmartPsiFileRangePointerImpl smartPsiFileRangePointerImpl = pointer;
        if (smartPsiFileRangePointerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        return smartPsiFileRangePointerImpl;
    }

    private <E extends PsiElement> void trackPointer(@NotNull SmartPsiElementPointerImpl<E> pointer, @NotNull VirtualFile containingFile) {
        block4: {
            FilePointersList pointers;
            if (pointer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "trackPointer"));
            }
            if (containingFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "trackPointer"));
            }
            SmartPointerElementInfo info = pointer.getElementInfo();
            if (!(info instanceof SelfElementInfo)) {
                return;
            }
            PointerReference reference = new PointerReference(pointer, containingFile, this.POINTERS_KEY);
            do {
                if ((pointers = this.getPointers(containingFile)) != null) continue;
                pointers = containingFile.putUserDataIfAbsent(this.POINTERS_KEY, new FilePointersList());
            } while (!pointers.add(reference));
            if (!((SelfElementInfo)info).hasRange()) break block4;
            pointers.markerCache.rangeChanged();
        }
    }

    @Override
    public void removePointer(@NotNull SmartPsiElementPointer pointer) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "removePointer"));
        }
        if (!(pointer instanceof SmartPsiElementPointerImpl) || this.myProject.isDisposed()) {
            return;
        }
        PsiFile containingFile = pointer.getContainingFile();
        int refCount = ((SmartPsiElementPointerImpl)pointer).incrementAndGetReferenceCount(-1);
        if (refCount == 0) {
            PsiElement element = ((SmartPointerEx)pointer).getCachedElement();
            if (element != null) {
                element.putUserData(CACHED_SMART_POINTER_KEY, null);
            }
            SmartPointerElementInfo info = ((SmartPsiElementPointerImpl)pointer).getElementInfo();
            info.cleanup();
            if (containingFile == null) {
                return;
            }
            VirtualFile vFile = containingFile.getViewProvider().getVirtualFile();
            FilePointersList pointers = this.getPointers(vFile);
            PointerReference reference = ((SmartPsiElementPointerImpl)pointer).pointerReference;
            if (pointers != null && reference != null) {
                pointers.removeReference(reference);
            }
        }
    }

    @Nullable
    private FilePointersList getPointers(@NotNull VirtualFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getPointers"));
        }
        return containingFile.getUserData(this.POINTERS_KEY);
    }

    @Nullable
    MarkerCache getMarkerCache(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getMarkerCache"));
        }
        FilePointersList pointers = this.getPointers(file);
        return pointers == null ? null : pointers.markerCache;
    }

    public int getPointersNumber(@NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getPointersNumber"));
        }
        VirtualFile file = containingFile.getViewProvider().getVirtualFile();
        FilePointersList pointers = this.getPointers(file);
        return pointers == null ? 0 : pointers.getSize();
    }

    @Override
    public boolean pointToTheSameElement(@NotNull SmartPsiElementPointer pointer1, @NotNull SmartPsiElementPointer pointer2) {
        if (pointer1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer1", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "pointToTheSameElement"));
        }
        if (pointer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer2", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "pointToTheSameElement"));
        }
        return SmartPsiElementPointerImpl.pointsToTheSameElementAs(pointer1, pointer2);
    }

    public void updatePointers(Document document, FrozenDocument frozen, List<DocumentEvent> events) {
        FilePointersList list;
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        FilePointersList filePointersList = list = file == null ? null : this.getPointers(file);
        if (list == null) {
            return;
        }
        list.markerCache.updateMarkers(frozen, events);
    }

    public void updatePointerTargetsAfterReparse(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "updatePointerTargetsAfterReparse"));
        }
        FilePointersList list = this.getPointers(file);
        if (list == null) {
            return;
        }
        list.processAlivePointers(new Processor<SmartPsiElementPointerImpl>(){

            @Override
            public boolean process(SmartPsiElementPointerImpl pointer) {
                if (!(pointer instanceof SmartPsiFileRangePointerImpl)) {
                    SmartPointerManagerImpl.updatePointerTarget(pointer, pointer.getPsiRange());
                }
                return true;
            }
        });
    }

    private static <E extends PsiElement> void updatePointerTarget(@NotNull SmartPsiElementPointerImpl<E> pointer, @Nullable Segment pointerRange) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "updatePointerTarget"));
        }
        E cachedElement = pointer.getCachedElement();
        if (cachedElement == null || cachedElement.isValid() && pointerRange != null && pointerRange.equals(cachedElement.getTextRange())) {
            return;
        }
        pointer.cacheElement(pointer.doRestoreElement());
    }

    Project getProject() {
        return this.myProject;
    }

    PsiDocumentManagerBase getPsiDocumentManager() {
        return this.myPsiDocManager;
    }

    static {
        LowMemoryWatcher.register(new Runnable(){

            @Override
            public void run() {
                SmartPointerManagerImpl.processQueue();
            }
        }, ApplicationManager.getApplication());
        CACHED_SMART_POINTER_KEY = Key.create("CACHED_SMART_POINTER_KEY");
    }

    static class FilePointersList {
        private int nextAvailableIndex;
        private int size;
        private PointerReference[] references = new PointerReference[10];
        private final MarkerCache markerCache = new MarkerCache(this);
        private boolean mySorted;

        FilePointersList() {
        }

        private synchronized boolean add(@NotNull PointerReference reference) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$FilePointersList", "add"));
            }
            if (reference.file.getUserData(reference.key) != this) {
                return false;
            }
            if (this.nextAvailableIndex >= this.references.length || this.nextAvailableIndex > this.size * 2) {
                int newCapacity = (this.nextAvailableIndex >= this.references.length ? this.references.length : this.size) * 3 / 2 + 1;
                final PointerReference[] newReferences = new PointerReference[newCapacity];
                final int[] o = new int[]{0};
                this.processAlivePointers(new Processor<SmartPsiElementPointerImpl>(){

                    @Override
                    public boolean process(SmartPsiElementPointerImpl pointer) {
                        int n = o[0];
                        o[0] = n + 1;
                        FilePointersList.storePointerReference(newReferences, n, pointer.pointerReference);
                        return true;
                    }
                });
                this.references = newReferences;
                this.size = this.nextAvailableIndex = o[0];
            }
            assert (this.references[this.nextAvailableIndex] == null) : this.references[this.nextAvailableIndex];
            FilePointersList.storePointerReference(this.references, this.nextAvailableIndex++, reference);
            ++this.size;
            this.mySorted = false;
            return true;
        }

        private synchronized void removeReference(@NotNull PointerReference reference) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$FilePointersList", "removeReference"));
            }
            int index = reference.index;
            if (index < 0) {
                return;
            }
            assert (this.references[index] == reference) : "At " + index + " expected " + reference + ", found " + this.references[index];
            this.references[index].index = -1;
            this.references[index] = null;
            if (--this.size == 0) {
                reference.file.replace(reference.key, this, null);
            }
        }

        synchronized boolean processAlivePointers(@NotNull Processor<SmartPsiElementPointerImpl> processor) {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$FilePointersList", "processAlivePointers"));
            }
            for (int i2 = 0; i2 < this.nextAvailableIndex; ++i2) {
                PointerReference ref = this.references[i2];
                if (ref == null) continue;
                SmartPsiElementPointerImpl pointer = (SmartPsiElementPointerImpl)ref.get();
                if (pointer == null) {
                    this.removeReference(ref);
                    continue;
                }
                if (processor.process(pointer)) continue;
                return false;
            }
            return true;
        }

        private void ensureSorted() {
            if (!this.mySorted) {
                ArrayList pointers = new ArrayList();
                this.processAlivePointers(new CommonProcessors.CollectProcessor<SmartPsiElementPointerImpl>(pointers));
                assert (this.size == pointers.size());
                Collections.sort(pointers, new Comparator<SmartPsiElementPointerImpl>(){

                    @Override
                    public int compare(SmartPsiElementPointerImpl p1, SmartPsiElementPointerImpl p2) {
                        return MarkerCache.INFO_COMPARATOR.compare((SelfElementInfo)p1.getElementInfo(), (SelfElementInfo)p2.getElementInfo());
                    }
                });
                for (int i2 = 0; i2 < pointers.size(); ++i2) {
                    FilePointersList.storePointerReference(this.references, i2, ((SmartPsiElementPointerImpl)pointers.get((int)i2)).pointerReference);
                }
                Arrays.fill(this.references, pointers.size(), this.nextAvailableIndex, null);
                this.nextAvailableIndex = pointers.size();
                this.mySorted = true;
            }
        }

        private static void storePointerReference(PointerReference[] references, int index, PointerReference ref) {
            references[index] = ref;
            ref.index = index;
        }

        synchronized List<SelfElementInfo> getSortedInfos() {
            this.ensureSorted();
            final ArrayList<SelfElementInfo> infos = ContainerUtil.newArrayListWithCapacity(this.size);
            this.processAlivePointers(new Processor<SmartPsiElementPointerImpl>(){

                @Override
                public boolean process(SmartPsiElementPointerImpl pointer) {
                    SelfElementInfo info = (SelfElementInfo)pointer.getElementInfo();
                    if (!info.hasRange()) {
                        return false;
                    }
                    infos.add(info);
                    return true;
                }
            });
            return infos;
        }

        int getSize() {
            return this.size;
        }

        synchronized void markUnsorted() {
            this.mySorted = false;
        }
    }

    static class PointerReference
    extends WeakReference<SmartPsiElementPointerImpl> {
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final Key<FilePointersList> key;
        private int index;

        private PointerReference(@NotNull SmartPsiElementPointerImpl<?> pointer, @NotNull VirtualFile containingFile, @NotNull Key<FilePointersList> key) {
            if (pointer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$PointerReference", "<init>"));
            }
            if (containingFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$PointerReference", "<init>"));
            }
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$PointerReference", "<init>"));
            }
            super(pointer, ourQueue);
            this.index = -2;
            this.file = containingFile;
            this.key = key;
            pointer.pointerReference = this;
        }
    }
}

