/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.TreeMap;
import javax.swing.SwingConstants;

public class GeometryUtil
implements SwingConstants {
    private static final int myArrowSize = 9;
    private static final Shape myArrowPolygon = new Polygon(new int[]{0, 9, 0, 0}, new int[]{0, 4, 9, 0}, 4);

    public static Point getIntersectionPoint(Line2D aSegment, Rectangle aRectangle) {
        if (GeometryUtil.segmentOutsideRectangle(aRectangle, aSegment)) {
            throw new IllegalArgumentException("Segment " + GeometryUtil.toString(aSegment) + " lies out of rectangle " + aRectangle + " or intersects more than one bound");
        }
        if (GeometryUtil.segmentInsideRectangle(aRectangle, aSegment)) {
            return null;
        }
        Line2D[] bounds = new Line2D[]{GeometryUtil.getTopOf(aRectangle), GeometryUtil.getRightOf(aRectangle), GeometryUtil.getBottomOf(aRectangle), GeometryUtil.getLeftOf(aRectangle)};
        for (int i2 = 0; i2 < bounds.length; ++i2) {
            if (!bounds[i2].intersectsLine(aSegment)) continue;
            return GeometryUtil.getIntersectionPoint(aSegment, bounds[i2]);
        }
        return null;
    }

    public static Line2D.Double getLeftOf(Rectangle aRectangle) {
        return new Line2D.Double(aRectangle.getX(), aRectangle.getY(), aRectangle.getX(), aRectangle.getY() + aRectangle.getHeight());
    }

    public static Line2D.Double getBottomOf(Rectangle aRectangle) {
        return new Line2D.Double(aRectangle.getX(), aRectangle.getY() + aRectangle.getHeight(), aRectangle.getX() + aRectangle.getWidth(), aRectangle.getY() + aRectangle.getHeight());
    }

    public static Line2D.Double getRightOf(Rectangle aRectangle) {
        return new Line2D.Double(aRectangle.getX() + aRectangle.getWidth(), aRectangle.getY(), aRectangle.getX() + aRectangle.getWidth(), aRectangle.getY() + aRectangle.getHeight());
    }

    public static Line2D.Double getTopOf(Rectangle aRectangle) {
        return new Line2D.Double(aRectangle.getX(), aRectangle.getY(), aRectangle.getX() + aRectangle.getWidth(), aRectangle.getY());
    }

    private static boolean segmentInsideRectangle(Rectangle aRectangle, Line2D aSegment) {
        return GeometryUtil.isWithin(aRectangle, aSegment.getP1()) && GeometryUtil.isWithin(aRectangle, aSegment.getP2());
    }

    private static boolean segmentOutsideRectangle(Rectangle aRectangle, Line2D aSegment) {
        return !GeometryUtil.isWithin(aRectangle, aSegment.getP1()) && !GeometryUtil.isWithin(aRectangle, aSegment.getP2());
    }

    public static boolean isWithin(Rectangle aRectangle, Point2D aPoint) {
        return aPoint.getX() > aRectangle.getX() && aPoint.getX() < aRectangle.getX() + (double)aRectangle.getBounds().width && aPoint.getY() > aRectangle.getY() && aPoint.getY() < aRectangle.getY() + (double)aRectangle.getBounds().height;
    }

    public static Point getIntersectionPoint(Line2D aFirst, Line2D aSecond) {
        double firstDeltaX = aFirst.getX2() - aFirst.getX1();
        double firstDeltaY = aFirst.getY2() - aFirst.getY1();
        double kFirst = firstDeltaY / firstDeltaX;
        double bFirst = aFirst.getY1() - kFirst * aFirst.getX1();
        double secondDeltaX = aSecond.getX2() - aSecond.getX1();
        double secondDeltaY = aSecond.getY2() - aSecond.getY1();
        double kSecond = secondDeltaY / secondDeltaX;
        double bSecond = aSecond.getY1() - kSecond * aSecond.getX1();
        double xIntersection = -1.0E8;
        double yIntersection = -1.0E8;
        double deltaK = kFirst - kSecond;
        if (GeometryUtil.linesAreAngledAndParallel(kFirst, kSecond)) {
            return null;
        }
        if (Double.isInfinite(deltaK) || 0.0 == deltaK) {
            if (firstDeltaX == secondDeltaX && 0.0 == firstDeltaX) {
                return null;
            }
            if (firstDeltaY == secondDeltaY && 0.0 == firstDeltaY) {
                return null;
            }
            if (0.0 == firstDeltaX && 0.0 == secondDeltaY) {
                xIntersection = aFirst.getX1();
                yIntersection = aSecond.getY1();
            } else if (0.0 == secondDeltaX && 0.0 == firstDeltaY) {
                xIntersection = aSecond.getX1();
                yIntersection = aFirst.getY1();
            } else if (0.0 == firstDeltaX) {
                xIntersection = aFirst.getX1();
                yIntersection = kSecond * xIntersection + bSecond;
            } else {
                xIntersection = aSecond.getX1();
                yIntersection = kFirst * xIntersection + bFirst;
            }
        } else {
            xIntersection = (bSecond - bFirst) / deltaK;
            yIntersection = kFirst * xIntersection + bFirst;
        }
        return new Point((int)xIntersection, (int)yIntersection);
    }

    private static boolean linesAreAngledAndParallel(double aKFirst, double aKSecond) {
        return aKFirst == aKSecond && 0.0 != aKFirst;
    }

    public static String toString(Line2D aLine) {
        return aLine.getP1() + ":" + aLine.getP2();
    }

    public static boolean intersects(Rectangle aRectangle, Line2D aLine) {
        if (aLine == null || aRectangle == null) {
            return false;
        }
        return !GeometryUtil.segmentOutsideRectangle(aRectangle, aLine) && !GeometryUtil.segmentInsideRectangle(aRectangle, aLine);
    }

    public static int getPointPositionOnRectangle(Rectangle aRectangle, Point aPoint, int aEpsilon) {
        int ERROR_CODE = Integer.MIN_VALUE;
        if (GeometryUtil.pointOnBound(GeometryUtil.getTopOf(aRectangle), aPoint, aEpsilon)) {
            return 1;
        }
        if (GeometryUtil.pointOnBound(GeometryUtil.getBottomOf(aRectangle), aPoint, aEpsilon)) {
            return 3;
        }
        if (GeometryUtil.pointOnBound(GeometryUtil.getLeftOf(aRectangle), aPoint, aEpsilon)) {
            return 2;
        }
        if (GeometryUtil.pointOnBound(GeometryUtil.getRightOf(aRectangle), aPoint, aEpsilon)) {
            return 4;
        }
        return Integer.MIN_VALUE;
    }

    private static boolean pointOnBound(Line2D aTop, Point aPoint, int aEpsilon) {
        return GeometryUtil.withinRange(aTop.getX1(), aTop.getX2(), aPoint.getX(), aEpsilon) && GeometryUtil.withinRange(aTop.getY1(), aTop.getY2(), aPoint.getY(), aEpsilon);
    }

    private static boolean withinRange(double aLeft, double aRight, double aValue, int aEpsilon) {
        return aLeft - (double)aEpsilon <= aValue && aRight + (double)aEpsilon >= aValue;
    }

    public static double getShiftByY(Line2D aLine, double aPointDeltaY) {
        return aPointDeltaY * ((aLine.getX2() - aLine.getX1()) / (aLine.getY2() - aLine.getY1()));
    }

    public static double getShiftByX(Line2D aLine, double aPointDeltaX) {
        double width = aLine.getX2() - aLine.getX1();
        double height = aLine.getY2() - aLine.getY1();
        return aPointDeltaX * (height / width);
    }

    public static Shape getArrowShape(Line2D line, Point2D intersectionPoint) {
        double deltaY = line.getP2().getY() - line.getP1().getY();
        double length = Math.sqrt(Math.pow(deltaY, 2.0) + Math.pow(line.getP2().getX() - line.getP1().getX(), 2.0));
        double theta = Math.asin(deltaY / length);
        if (line.getP1().getX() > line.getP2().getX()) {
            theta = Math.PI - theta;
        }
        AffineTransform rotate = AffineTransform.getRotateInstance(theta, 9.0, 4.0);
        Shape polygon = rotate.createTransformedShape(myArrowPolygon);
        AffineTransform move = AffineTransform.getTranslateInstance(intersectionPoint.getX() - 9.0, intersectionPoint.getY() - 4.0);
        polygon = move.createTransformedShape(polygon);
        return polygon;
    }

    public static int getClosestToLineRectangleCorner(Rectangle aRectange, Line2D aSegment) {
        OrientedPoint northWest = new OrientedPoint(aRectange.getX(), aRectange.getY(), 8);
        OrientedPoint northEast = new OrientedPoint(aRectange.getMaxX(), aRectange.getY(), 2);
        OrientedPoint southEast = new OrientedPoint(aRectange.getMaxX(), aRectange.getMaxY(), 4);
        OrientedPoint southWest = new OrientedPoint(aRectange.getX(), aRectange.getMaxY(), 6);
        TreeMap<Double, OrientedPoint> sorter = new TreeMap<Double, OrientedPoint>();
        sorter.put(GeometryUtil.getDistance(aSegment, northWest), northWest);
        sorter.put(GeometryUtil.getDistance(aSegment, southWest), southWest);
        sorter.put(GeometryUtil.getDistance(aSegment, southEast), southEast);
        sorter.put(GeometryUtil.getDistance(aSegment, northEast), northEast);
        return ((OrientedPoint)sorter.get(sorter.firstKey())).getOrientation();
    }

    private static Double getDistance(Line2D aSegment, Point aPoint) {
        double lenght1 = GeometryUtil.getLineLength(aSegment.getX1(), aSegment.getY1(), aPoint.getX(), aPoint.getY());
        double lenght2 = GeometryUtil.getLineLength(aSegment.getX2(), aSegment.getY2(), aPoint.getX(), aPoint.getY());
        return new Double(lenght1 + lenght2);
    }

    public static double getLineLength(double aX1, double aY1, double aX2, double aY2) {
        double deltaX = aX2 - aX1;
        double deltaY = aY2 - aY1;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY);
    }

    public static double cos(Line2D aLine) {
        double length = GeometryUtil.getLineLength(aLine.getX1(), aLine.getY1(), aLine.getX2(), aLine.getY2());
        if (length == 0.0) {
            throw new IllegalArgumentException(GeometryUtil.toString(aLine) + " has a zero length");
        }
        double deltaX = aLine.getX2() - aLine.getX1();
        return deltaX / length;
    }

    public static double sin(Line2D aLine) {
        double length = GeometryUtil.getLineLength(aLine.getX1(), aLine.getY1(), aLine.getX2(), aLine.getY2());
        if (length == 0.0) {
            throw new IllegalArgumentException(GeometryUtil.toString(aLine) + " has a zero length");
        }
        double deltaY = aLine.getY2() - aLine.getY1();
        return deltaY / length;
    }

    private static class OrientedPoint
    extends Point {
        private final int myOrientation;

        public OrientedPoint(double x, double y, int aOrientation) {
            super((int)x, (int)y);
            this.myOrientation = aOrientation;
        }

        public int getOrientation() {
            return this.myOrientation;
        }
    }
}

