/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.FormatUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class StringConcatenationInFormatCallInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.concatenation.in.format.call.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/StringConcatenationInFormatCallInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("string.concatenation.in.format.call.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/StringConcatenationInFormatCallInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringConcatenationInFormatCallVisitor();
    }

    private static class StringConcatenationInFormatCallVisitor
    extends BaseInspectionVisitor {
        private StringConcatenationInFormatCallVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            PsiExpression operand;
            super.visitMethodCallExpression(expression);
            if (!FormatUtils.isFormatCall(expression)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression formatArgument = FormatUtils.getFormatArgument(argumentList);
            if (!ExpressionUtils.hasStringType(formatArgument)) {
                return;
            }
            if (!(formatArgument instanceof PsiPolyadicExpression)) {
                return;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)formatArgument;
            PsiExpression[] operands = polyadicExpression.getOperands();
            int count = 0;
            PsiExpression[] psiExpressionArray = operands;
            int n = psiExpressionArray.length;
            for (int j = 0; !(j >= n || (operand = psiExpressionArray[j]) instanceof PsiReferenceExpression && ++count > 1); ++j) {
            }
            if (count == 0) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }
    }
}

