/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class ExtractParameterAsLocalVariableFix
extends InspectionGadgetsFix {
    @Override
    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("extract.parameter.as.local.variable.quickfix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/ExtractParameterAsLocalVariableFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor) {
        String replacementText;
        int endIndex;
        int startIndex;
        PsiElement body;
        PsiElement element = descriptor.getPsiElement();
        if (!(element instanceof PsiExpression)) {
            return;
        }
        PsiExpression expression = ParenthesesUtils.stripParentheses((PsiExpression)element);
        if (!(expression instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression parameterReference = (PsiReferenceExpression)expression;
        PsiElement target = parameterReference.resolve();
        if (!(target instanceof PsiParameter)) {
            return;
        }
        PsiParameter parameter = (PsiParameter)target;
        PsiElement declarationScope = parameter.getDeclarationScope();
        if (declarationScope instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)declarationScope;
            body = method.getBody();
        } else if (declarationScope instanceof PsiCatchSection) {
            PsiCatchSection catchSection = (PsiCatchSection)declarationScope;
            body = catchSection.getCatchBlock();
        } else if (declarationScope instanceof PsiLoopStatement) {
            PsiLoopStatement forStatement = (PsiLoopStatement)declarationScope;
            PsiStatement forBody = forStatement.getBody();
            if (forBody instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)forBody;
                body = blockStatement.getCodeBlock();
            } else {
                body = forBody;
            }
        } else if (declarationScope instanceof PsiLambdaExpression) {
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)declarationScope;
            body = lambdaExpression.getBody();
        } else {
            return;
        }
        if (body == null) {
            return;
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance(project);
        String parameterName = parameterReference.getText();
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance(project);
        String variableName = javaCodeStyleManager.suggestUniqueVariableName(parameterName, (PsiElement)parameterReference, true);
        SearchScope scope = parameter.getUseScope();
        Query<PsiReference> search = ReferencesSearch.search(parameter, scope);
        PsiReference reference = search.findFirst();
        if (reference == null) {
            return;
        }
        PsiElement referenceElement = reference.getElement();
        if (!(referenceElement instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression firstReference = (PsiReferenceExpression)referenceElement;
        PsiElement[] children = body.getChildren();
        if (body instanceof PsiCodeBlock) {
            startIndex = 1;
            endIndex = children.length - 1;
        } else {
            startIndex = 0;
            endIndex = children.length;
        }
        boolean newDeclarationCreated = false;
        StringBuilder buffer = new StringBuilder();
        for (int i2 = startIndex; i2 < endIndex; ++i2) {
            PsiElement child = children[i2];
            newDeclarationCreated |= ExtractParameterAsLocalVariableFix.replaceVariableName(child, firstReference, variableName, parameterName, buffer);
        }
        if (body instanceof PsiExpression) {
            buffer.insert(0, "return ");
            buffer.append(';');
        }
        if (newDeclarationCreated) {
            replacementText = "{" + buffer + '}';
        } else {
            PsiType type = parameter.getType();
            String className = type.getCanonicalText();
            replacementText = '{' + className + ' ' + variableName + " = " + parameterName + ';' + buffer + '}';
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance(project).getElementFactory();
        PsiCodeBlock block = elementFactory.createCodeBlockFromText(replacementText, declarationScope);
        body.replace(block);
        codeStyleManager.reformat(declarationScope);
    }

    private static boolean replaceVariableName(PsiElement element, PsiReferenceExpression firstReference, String newName, String originalName, StringBuilder out) {
        PsiElement[] children;
        String text;
        if (element instanceof PsiReferenceExpression) {
            PsiType type;
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
            if (element.equals(firstReference) && ExtractParameterAsLocalVariableFix.isLeftSideOfSimpleAssignment(referenceExpression) && (type = firstReference.getType()) != null) {
                out.append(type.getCanonicalText());
                out.append(' ');
                out.append(newName);
                return true;
            }
            text = element.getText();
            if (text.equals(originalName)) {
                out.append(newName);
                return false;
            }
        }
        if ((children = element.getChildren()).length != 0) {
            boolean result = false;
            for (PsiElement child : children) {
                if (result) {
                    out.append(child.getText());
                    continue;
                }
                result = ExtractParameterAsLocalVariableFix.replaceVariableName(child, firstReference, newName, originalName, out);
            }
            return result;
        }
        text = element.getText();
        out.append(text);
        return false;
    }

    private static boolean isLeftSideOfSimpleAssignment(PsiReferenceExpression reference) {
        if (reference == null) {
            return false;
        }
        PsiElement parent = reference.getParent();
        if (!(parent instanceof PsiAssignmentExpression)) {
            return false;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
        IElementType tokenType = assignmentExpression.getOperationTokenType();
        if (!JavaTokenType.EQ.equals(tokenType)) {
            return false;
        }
        PsiExpression lExpression = assignmentExpression.getLExpression();
        if (!reference.equals(lExpression)) {
            return false;
        }
        PsiExpression rExpression = assignmentExpression.getRExpression();
        if (rExpression instanceof PsiAssignmentExpression) {
            return false;
        }
        PsiElement grandParent = parent.getParent();
        return grandParent instanceof PsiExpressionStatement;
    }
}

