/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.util.containers.ContainerUtil;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public final class CustomShortcutSet
implements ShortcutSet {
    public static final CustomShortcutSet EMPTY = new CustomShortcutSet(Shortcut.EMPTY_ARRAY);
    private final Shortcut[] myShortcuts;

    public CustomShortcutSet(@NotNull KeyStroke keyStroke) {
        if (keyStroke == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyStroke", "com/intellij/openapi/actionSystem/CustomShortcutSet", "<init>"));
        }
        this(new KeyboardShortcut(keyStroke, null));
    }

    public CustomShortcutSet(Shortcut ... shortcuts) {
        if (shortcuts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortcuts", "com/intellij/openapi/actionSystem/CustomShortcutSet", "<init>"));
        }
        this.myShortcuts = shortcuts.length == 0 ? Shortcut.EMPTY_ARRAY : (Shortcut[])shortcuts.clone();
    }

    public CustomShortcutSet(Integer ... keyCodes) {
        this.myShortcuts = ContainerUtil.map(keyCodes, integer -> new KeyboardShortcut(KeyStroke.getKeyStroke(integer, 0), null), Shortcut.EMPTY_ARRAY);
    }

    @Override
    @NotNull
    public Shortcut[] getShortcuts() {
        Shortcut[] shortcutArray = this.myShortcuts.length == 0 ? Shortcut.EMPTY_ARRAY : (Shortcut[])this.myShortcuts.clone();
        if (shortcutArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/CustomShortcutSet", "getShortcuts"));
        }
        return shortcutArray;
    }

    @NotNull
    public static CustomShortcutSet fromString(String ... keyboardShortcuts) {
        if (keyboardShortcuts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyboardShortcuts", "com/intellij/openapi/actionSystem/CustomShortcutSet", "fromString"));
        }
        Shortcut[] shortcuts = new KeyboardShortcut[keyboardShortcuts.length];
        for (int i2 = 0; i2 < keyboardShortcuts.length; ++i2) {
            shortcuts[i2] = KeyboardShortcut.fromString(keyboardShortcuts[i2]);
        }
        CustomShortcutSet customShortcutSet = new CustomShortcutSet(shortcuts);
        if (customShortcutSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/CustomShortcutSet", "fromString"));
        }
        return customShortcutSet;
    }
}

