/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class CircularCharBuffer {
    private char[] myArray;
    private final int myMaxCapacity;
    private int mySize;
    private int myTail;
    private int myHead;

    public CircularCharBuffer(int initialCapacity) {
        this(initialCapacity, -1);
    }

    public CircularCharBuffer(int initialCapacity, int maxCapacity) {
        assert (maxCapacity < 0 || initialCapacity <= maxCapacity);
        this.myArray = new char[initialCapacity];
        this.myMaxCapacity = maxCapacity;
        this.mySize = 0;
        this.myTail = 0;
        this.myHead = 0;
    }

    public void add(char c) {
        this.resizeIfNeeded(this.mySize + 1);
        this.doAdd(c);
    }

    public void add(char[] buffer) {
        this.resizeIfNeeded(this.mySize + buffer.length);
        for (char c : buffer) {
            this.doAdd(c);
        }
    }

    public void add(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/util/containers/CircularCharBuffer", "add"));
        }
        this.resizeIfNeeded(this.mySize + str.length());
        for (int i2 = 0; i2 < str.length(); ++i2) {
            this.doAdd(str.charAt(i2));
        }
    }

    private void doAdd(char c) {
        this.myArray[this.myTail] = c;
        ++this.myTail;
        int length = this.myArray.length;
        if (this.myTail >= length) {
            this.myTail = 0;
        }
        ++this.mySize;
        if (this.mySize > length) {
            this.doPoll();
        }
    }

    public int poll() {
        return this.doPoll();
    }

    public int doPoll() {
        if (this.mySize == 0) {
            return -1;
        }
        char res = this.myArray[this.myHead];
        ++this.myHead;
        if (this.myHead >= this.myArray.length) {
            this.myHead = 0;
        }
        --this.mySize;
        return res;
    }

    @NotNull
    public String getText() {
        this.normalize();
        String string = new String(this.myArray, 0, this.mySize);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/CircularCharBuffer", "getText"));
        }
        return string;
    }

    public boolean isEmpty() {
        return this.mySize == 0;
    }

    public int size() {
        return this.mySize;
    }

    private boolean resizeIfNeeded(int newSize) {
        int length = this.myArray.length;
        if (newSize <= length) {
            return true;
        }
        if (this.myMaxCapacity > -1 && length == this.myMaxCapacity) {
            return false;
        }
        this.normalize();
        int newLength = Math.max(length << 1, newSize);
        if (this.myMaxCapacity > -1) {
            newLength = Math.min(this.myMaxCapacity, newLength);
        }
        char[] newArray = new char[newLength];
        System.arraycopy(this.myArray, this.myHead, newArray, 0, this.mySize);
        this.myArray = newArray;
        this.myTail = this.mySize % newArray.length;
        return true;
    }

    private void normalize() {
        if (this.myHead == 0) {
            return;
        }
        int length = this.myArray.length;
        if (this.myHead < this.myTail) {
            CircularCharBuffer.moveSubArrayLeft(this.myArray, this.myHead, this.mySize, this.myHead);
        } else {
            int headSize = this.myTail;
            int tailSize = length - this.myHead;
            CircularCharBuffer.reverseSubArray(this.myArray, 0, headSize);
            CircularCharBuffer.reverseSubArray(this.myArray, length - tailSize, tailSize);
            CircularCharBuffer.reverseSubArray(this.myArray, 0, length);
            CircularCharBuffer.moveSubArrayLeft(this.myArray, length - headSize, headSize, length - headSize - tailSize);
        }
        this.myHead = 0;
        this.myTail = this.mySize % length;
    }

    private static void moveSubArrayLeft(char[] array, int startInd, int length, int moveLeftCount) {
        for (int i2 = startInd; i2 < startInd + length; ++i2) {
            array[i2 - moveLeftCount] = array[i2];
        }
    }

    private static void reverseSubArray(char[] array, int startInd, int length) {
        for (int i2 = 0; i2 < length / 2; ++i2) {
            ArrayUtil.swap(array, startInd + i2, startInd + length - 1 - i2);
        }
    }
}

