/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.SmartRefElementPointer;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SmartRefElementPointerImpl
implements SmartRefElementPointer {
    @NonNls
    public static final String FQNAME_ATTR = "FQNAME";
    @NonNls
    public static final String TYPE_ATTR = "TYPE";
    @NonNls
    public static final String ENTRY_POINT = "entry_point";
    private final boolean myIsPersistent;
    private RefEntity myRefElement;
    private final String myFQName;
    private final String myType;

    public SmartRefElementPointerImpl(RefEntity ref, boolean isPersistent) {
        this.myIsPersistent = isPersistent;
        this.myRefElement = ref;
        this.myFQName = ref.getExternalName();
        this.myType = ref.getRefManager().getType(ref);
    }

    public SmartRefElementPointerImpl(Element jDomElement) {
        this.myIsPersistent = true;
        this.myRefElement = null;
        this.myFQName = jDomElement.getAttributeValue(FQNAME_ATTR);
        this.myType = jDomElement.getAttributeValue(TYPE_ATTR);
    }

    public SmartRefElementPointerImpl(String type, String fqName) {
        this.myIsPersistent = true;
        this.myFQName = fqName;
        this.myType = type;
    }

    public SmartRefElementPointerImpl(String type, String fqName, RefManager manager) {
        this.myIsPersistent = false;
        this.myFQName = fqName;
        this.myType = type;
        this.resolve(manager);
    }

    @Override
    public boolean isPersistent() {
        return this.myIsPersistent;
    }

    @Override
    public String getFQName() {
        return this.myFQName;
    }

    @Override
    public RefEntity getRefElement() {
        return this.myRefElement;
    }

    @Override
    public void writeExternal(Element parentNode) {
        Element element = new Element(ENTRY_POINT);
        element.setAttribute(TYPE_ATTR, this.myType);
        element.setAttribute(FQNAME_ATTR, this.getFQName());
        parentNode.addContent(element);
    }

    @Override
    public boolean resolve(@NotNull RefManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/reference/SmartRefElementPointerImpl", "resolve"));
        }
        if (this.myRefElement != null) {
            return this.myRefElement instanceof RefElement && this.myRefElement.isValid();
        }
        this.myRefElement = manager.getReference(this.myType, this.getFQName());
        return this.myRefElement != null;
    }

    @Override
    public void freeReference() {
        this.myRefElement = null;
    }
}

