/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ModuleParser {
    private static final Set<String> STATEMENT_KEYWORDS = ContainerUtil.newHashSet("requires", "exports", "uses", "provides");

    public static void parseModule(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/java/parser/ModuleParser", "parseModule"));
        }
        PsiBuilder.Marker module = builder.mark();
        ModuleParser.mapAndAdvance(builder, JavaTokenType.MODULE_KEYWORD);
        if (ModuleParser.parseName(builder) == null) {
            module.drop();
            if (builder.getTokenType() != null) {
                ModuleParser.parseExtras(builder, JavaErrorMessages.message("expected.module.declaration", new Object[0]));
            } else {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
            }
            return;
        }
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.LBRACE)) {
            if (builder.getTokenType() != null) {
                ModuleParser.parseExtras(builder, JavaErrorMessages.message("expected.module.declaration", new Object[0]));
            } else {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.lbrace", new Object[0]));
            }
        } else {
            ModuleParser.parseModuleContent(builder);
        }
        JavaParserUtil.done(module, JavaElementType.MODULE);
        if (builder.getTokenType() != null) {
            ModuleParser.parseExtras(builder, JavaErrorMessages.message("unexpected.tokens", new Object[0]));
        }
    }

    private static PsiBuilder.Marker parseName(PsiBuilder builder) {
        PsiBuilder.Marker nameElement = builder.mark();
        boolean empty = true;
        boolean idExpected = true;
        while (true) {
            IElementType t;
            if ((t = builder.getTokenType()) == JavaTokenType.IDENTIFIER) {
                if (!idExpected) {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.dot", new Object[0]));
                }
                idExpected = false;
            } else {
                if (t != JavaTokenType.DOT) break;
                if (idExpected) {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
                }
                idExpected = true;
            }
            builder.advanceLexer();
            empty = false;
        }
        if (!empty) {
            if (idExpected) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
            }
            nameElement.done(JavaElementType.MODULE_REFERENCE);
            return nameElement;
        }
        nameElement.drop();
        return null;
    }

    private static void parseModuleContent(PsiBuilder builder) {
        IElementType token;
        PsiBuilder.Marker invalid = null;
        while ((token = builder.getTokenType()) != null && token != JavaTokenType.RBRACE) {
            if (token == JavaTokenType.SEMICOLON) {
                if (invalid != null) {
                    invalid.error(JavaErrorMessages.message("expected.module.statement", new Object[0]));
                    invalid = null;
                }
                builder.advanceLexer();
                continue;
            }
            PsiBuilder.Marker statement = ModuleParser.parseStatement(builder);
            if (statement == null) {
                if (invalid == null) {
                    invalid = builder.mark();
                }
                builder.advanceLexer();
                continue;
            }
            if (invalid == null) continue;
            invalid.errorBefore(JavaErrorMessages.message("expected.module.statement", new Object[0]), statement);
            invalid = null;
        }
        if (invalid != null) {
            invalid.error(JavaErrorMessages.message("expected.module.statement", new Object[0]));
        }
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.RBRACE) && invalid == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.rbrace", new Object[0]));
        }
    }

    private static PsiBuilder.Marker parseStatement(PsiBuilder builder) {
        String kw = builder.getTokenText();
        if ("requires".equals(kw)) {
            return ModuleParser.parseRequiresStatement(builder);
        }
        if ("exports".equals(kw)) {
            return ModuleParser.parseExportsStatement(builder);
        }
        if ("uses".equals(kw)) {
            return ModuleParser.parseUsesStatement(builder);
        }
        if ("provides".equals(kw)) {
            return ModuleParser.parseProvidesStatement(builder);
        }
        return null;
    }

    private static PsiBuilder.Marker parseRequiresStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        ModuleParser.mapAndAdvance(builder, JavaTokenType.REQUIRES_KEYWORD);
        PsiBuilderUtil.expect(builder, JavaTokenType.PUBLIC_KEYWORD);
        if (ModuleParser.parseNameRef(builder) != null) {
            JavaParserUtil.semicolon(builder);
        } else {
            PsiBuilderUtil.expect(builder, JavaTokenType.SEMICOLON);
        }
        statement.done(JavaElementType.REQUIRES_STATEMENT);
        return statement;
    }

    private static PsiBuilder.Marker parseExportsStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        boolean hasError = false;
        ModuleParser.mapAndAdvance(builder, JavaTokenType.EXPORTS_KEYWORD);
        if (ModuleParser.parseClassOrPackageRef(builder) != null) {
            if ("to".equals(builder.getTokenText())) {
                PsiBuilder.Marker ref;
                ModuleParser.mapAndAdvance(builder, JavaTokenType.TO_KEYWORD);
                do {
                    ref = ModuleParser.parseNameRef(builder);
                } while (PsiBuilderUtil.expect(builder, JavaTokenType.COMMA));
                if (ref == null) {
                    hasError = true;
                }
            }
        } else {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.package.reference", new Object[0]));
            hasError = true;
        }
        if (!hasError) {
            JavaParserUtil.semicolon(builder);
        } else {
            PsiBuilderUtil.expect(builder, JavaTokenType.SEMICOLON);
        }
        statement.done(JavaElementType.EXPORTS_STATEMENT);
        return statement;
    }

    private static PsiBuilder.Marker parseUsesStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        ModuleParser.mapAndAdvance(builder, JavaTokenType.USES_KEYWORD);
        if (ModuleParser.parseClassOrPackageRef(builder) != null) {
            JavaParserUtil.semicolon(builder);
        } else {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.class.reference", new Object[0]));
            PsiBuilderUtil.expect(builder, JavaTokenType.SEMICOLON);
        }
        statement.done(JavaElementType.USES_STATEMENT);
        return statement;
    }

    private static PsiBuilder.Marker parseProvidesStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        boolean hasError = false;
        ModuleParser.mapAndAdvance(builder, JavaTokenType.PROVIDES_KEYWORD);
        if (ModuleParser.parseClassOrPackageRef(builder) == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.class.reference", new Object[0]));
            hasError = true;
        }
        if ("with".equals(builder.getTokenText())) {
            ModuleParser.mapAndAdvance(builder, JavaTokenType.WITH_KEYWORD);
            if (ModuleParser.parseClassOrPackageRef(builder) == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.class.reference", new Object[0]));
                hasError = true;
            }
        } else if (!hasError) {
            IElementType next = builder.getTokenType();
            if (next == JavaTokenType.IDENTIFIER && !STATEMENT_KEYWORDS.contains(builder.getTokenText())) {
                PsiBuilder.Marker marker = builder.mark();
                builder.advanceLexer();
                marker.error(JavaErrorMessages.message("expected.with", new Object[0]));
            } else {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.with", new Object[0]));
            }
            hasError = true;
        }
        if (!hasError) {
            JavaParserUtil.semicolon(builder);
        } else {
            PsiBuilderUtil.expect(builder, JavaTokenType.SEMICOLON);
        }
        statement.done(JavaElementType.PROVIDES_STATEMENT);
        return statement;
    }

    private static PsiBuilder.Marker parseNameRef(PsiBuilder builder) {
        PsiBuilder.Marker name = ModuleParser.parseName(builder);
        if (name == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
        }
        return name;
    }

    private static void mapAndAdvance(PsiBuilder builder, IElementType keyword) {
        builder.remapCurrentToken(keyword);
        builder.advanceLexer();
    }

    private static void parseExtras(PsiBuilder builder, String message) {
        PsiBuilder.Marker extras = builder.mark();
        while (builder.getTokenType() != null) {
            builder.advanceLexer();
        }
        extras.error(message);
    }

    private static PsiBuilder.Marker parseClassOrPackageRef(PsiBuilder builder) {
        return JavaParser.INSTANCE.getReferenceParser().parseJavaCodeReference(builder, true, false, false, false);
    }
}

