/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import gnu.trove.TObjectIntHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassUtil {
    private ClassUtil() {
    }

    public static String extractPackageName(String className) {
        if (className != null) {
            int i2 = className.lastIndexOf(46);
            return i2 == -1 ? "" : className.substring(0, i2);
        }
        return null;
    }

    @NotNull
    public static String extractClassName(@NotNull String fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "com/intellij/psi/util/ClassUtil", "extractClassName"));
        }
        int i2 = fqName.lastIndexOf(46);
        String string = i2 == -1 ? fqName : fqName.substring(i2 + 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/ClassUtil", "extractClassName"));
        }
        return string;
    }

    public static String createNewClassQualifiedName(String qualifiedName, String className) {
        if (className == null) {
            return null;
        }
        if (qualifiedName == null || qualifiedName.isEmpty()) {
            return className;
        }
        return qualifiedName + "." + ClassUtil.extractClassName(className);
    }

    public static PsiDirectory sourceRoot(PsiDirectory containingDirectory) {
        while (containingDirectory != null) {
            if (JavaDirectoryService.getInstance().isSourceRoot(containingDirectory)) {
                return containingDirectory;
            }
            containingDirectory = containingDirectory.getParentDirectory();
        }
        return null;
    }

    public static void formatClassName(@NotNull PsiClass aClass, @NotNull StringBuilder buf) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/ClassUtil", "formatClassName"));
        }
        if (buf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "com/intellij/psi/util/ClassUtil", "formatClassName"));
        }
        String qName = aClass.getQualifiedName();
        if (qName != null) {
            buf.append(qName);
        } else {
            PsiClass parentClass = PsiTreeUtil.getContextOfType((PsiElement)aClass, PsiClass.class, true);
            if (parentClass != null) {
                ClassUtil.formatClassName(parentClass, buf);
                buf.append("$");
                buf.append(ClassUtil.getNonQualifiedClassIdx(aClass, parentClass));
                String name = aClass.getName();
                if (name != null) {
                    buf.append(name);
                }
            }
        }
    }

    private static int getNonQualifiedClassIdx(@NotNull PsiClass psiClass, final @NotNull PsiClass containingClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/util/ClassUtil", "getNonQualifiedClassIdx"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "com/intellij/psi/util/ClassUtil", "getNonQualifiedClassIdx"));
        }
        TObjectIntHashMap<PsiClass> indices = CachedValuesManager.getCachedValue(containingClass, new CachedValueProvider<TObjectIntHashMap<PsiClass>>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<TObjectIntHashMap<PsiClass>> compute() {
                TObjectIntHashMap map = new TObjectIntHashMap();
                int index = 0;
                for (PsiClass aClass : ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot(containingClass)).postOrderDfsTraversal().filter(PsiClass.class)) {
                    if (aClass.getQualifiedName() != null) continue;
                    map.put((Object)aClass, ++index);
                }
                return CachedValueProvider.Result.create(map, containingClass);
            }
        });
        return indices.get((Object)psiClass);
    }

    public static PsiClass findNonQualifiedClassByIndex(@NotNull String indexName, @NotNull PsiClass containingClass) {
        if (indexName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexName", "com/intellij/psi/util/ClassUtil", "findNonQualifiedClassByIndex"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "com/intellij/psi/util/ClassUtil", "findNonQualifiedClassByIndex"));
        }
        return ClassUtil.findNonQualifiedClassByIndex(indexName, containingClass, false);
    }

    public static PsiClass findNonQualifiedClassByIndex(@NotNull String indexName, final @NotNull PsiClass containingClass, final boolean jvmCompatible) {
        if (indexName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexName", "com/intellij/psi/util/ClassUtil", "findNonQualifiedClassByIndex"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "com/intellij/psi/util/ClassUtil", "findNonQualifiedClassByIndex"));
        }
        String prefix = ClassUtil.getDigitPrefix(indexName);
        final int idx = !prefix.isEmpty() ? Integer.parseInt(prefix) : -1;
        final String name = prefix.length() < indexName.length() ? indexName.substring(prefix.length()) : null;
        final PsiClass[] result = new PsiClass[1];
        containingClass.accept(new JavaRecursiveElementVisitor(){
            private int myCurrentIdx;

            @Override
            public void visitElement(PsiElement element) {
                if (result[0] == null) {
                    super.visitElement(element);
                }
            }

            @Override
            public void visitClass(PsiClass aClass) {
                if (!jvmCompatible) {
                    super.visitClass(aClass);
                    if (aClass.getQualifiedName() == null) {
                        ++this.myCurrentIdx;
                        if (this.myCurrentIdx == idx && Comparing.strEqual(name, aClass.getName())) {
                            result[0] = aClass;
                        }
                    }
                    return;
                }
                if (aClass == containingClass) {
                    super.visitClass(aClass);
                    return;
                }
                if (Comparing.strEqual(name, aClass.getName())) {
                    ++this.myCurrentIdx;
                    if (this.myCurrentIdx == idx || idx == -1) {
                        result[0] = aClass;
                    }
                }
            }

            @Override
            public void visitTypeParameter(PsiTypeParameter classParameter) {
                if (!jvmCompatible) {
                    super.visitTypeParameter(classParameter);
                } else {
                    this.visitElement(classParameter);
                }
            }
        });
        return result[0];
    }

    @NotNull
    private static String getDigitPrefix(@NotNull String indexName) {
        char c;
        int i2;
        if (indexName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexName", "com/intellij/psi/util/ClassUtil", "getDigitPrefix"));
        }
        for (i2 = 0; i2 < indexName.length() && Character.isDigit(c = indexName.charAt(i2)); ++i2) {
        }
        String string = i2 == 0 ? "" : indexName.substring(0, i2);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/ClassUtil", "getDigitPrefix"));
        }
        return string;
    }

    @Nullable
    public static PsiClass findPsiClass(@NotNull PsiManager manager, @NotNull String name) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/util/ClassUtil", "findPsiClass"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/util/ClassUtil", "findPsiClass"));
        }
        return ClassUtil.findPsiClass(manager, name, null, false);
    }

    @Nullable
    public static PsiClass findPsiClass(@NotNull PsiManager manager, @NotNull String name, @Nullable PsiClass parent, boolean jvmCompatible) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/util/ClassUtil", "findPsiClass"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/util/ClassUtil", "findPsiClass"));
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope(manager.getProject());
        return ClassUtil.findPsiClass(manager, name, parent, jvmCompatible, scope);
    }

    @Nullable
    public static PsiClass findPsiClass(@NotNull PsiManager manager, @NotNull String name, @Nullable PsiClass parent, boolean jvmCompatible, @NotNull GlobalSearchScope scope) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/util/ClassUtil", "findPsiClass"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/util/ClassUtil", "findPsiClass"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/util/ClassUtil", "findPsiClass"));
        }
        if (parent != null) {
            return ClassUtil.findSubClass(name, parent, jvmCompatible);
        }
        PsiClass result = JavaPsiFacade.getInstance(manager.getProject()).findClass(name, scope);
        if (result != null) {
            return result;
        }
        int p = 0;
        while ((p = name.indexOf(36, p + 1)) > 0 && p < name.length() - 1) {
            String suffix;
            String prefix = name.substring(0, p);
            parent = JavaPsiFacade.getInstance(manager.getProject()).findClass(prefix, scope);
            if (parent == null || (result = ClassUtil.findSubClass(suffix = name.substring(p + 1), parent, jvmCompatible)) == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    private static PsiClass findSubClass(@NotNull String name, @NotNull PsiClass parent, boolean jvmCompatible) {
        PsiClass result;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/util/ClassUtil", "findSubClass"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/util/ClassUtil", "findSubClass"));
        }
        PsiClass psiClass = result = ClassUtil.isIndexed(name) ? ClassUtil.findNonQualifiedClassByIndex(name, parent, jvmCompatible) : parent.findInnerClassByName(name, false);
        if (result != null) {
            return result;
        }
        int p = 0;
        while ((p = name.indexOf(36, p + 1)) > 0 && p < name.length() - 1) {
            String suffix;
            String prefix = name.substring(0, p);
            PsiClass subClass = ClassUtil.isIndexed(prefix) ? ClassUtil.findNonQualifiedClassByIndex(prefix, parent, jvmCompatible) : parent.findInnerClassByName(prefix, false);
            if (subClass == null || (result = ClassUtil.findSubClass(suffix = name.substring(p + 1), subClass, jvmCompatible)) == null) continue;
            return result;
        }
        return null;
    }

    private static boolean isIndexed(String name) {
        return Character.isDigit(name.charAt(0));
    }

    @Nullable
    public static String getJVMClassName(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/ClassUtil", "getJVMClassName"));
        }
        PsiClass containingClass = aClass.getContainingClass();
        if (containingClass != null) {
            String parentName = ClassUtil.getJVMClassName(containingClass);
            if (parentName == null) {
                return null;
            }
            return parentName + "$" + aClass.getName();
        }
        return aClass.getQualifiedName();
    }

    @Nullable
    public static PsiClass findPsiClassByJVMName(@NotNull PsiManager manager, @NotNull String jvmClassName) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/util/ClassUtil", "findPsiClassByJVMName"));
        }
        if (jvmClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmClassName", "com/intellij/psi/util/ClassUtil", "findPsiClassByJVMName"));
        }
        return ClassUtil.findPsiClass(manager, jvmClassName.replace('/', '.'), null, true);
    }

    public static boolean isTopLevelClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/ClassUtil", "isTopLevelClass"));
        }
        if (aClass.getContainingClass() != null) {
            return false;
        }
        if (aClass instanceof PsiAnonymousClass) {
            return false;
        }
        PsiElement parent = aClass.getParent();
        if (parent instanceof PsiDeclarationStatement && parent.getParent() instanceof PsiCodeBlock) {
            return false;
        }
        PsiFile parentFile = aClass.getContainingFile();
        return parentFile != null && parentFile.getLanguage() == JavaLanguage.INSTANCE;
    }
}

