/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.AbstractValues;
import com.intellij.codeInspection.bytecodeAnalysis.CombinedData;
import com.intellij.codeInspection.bytecodeAnalysis.Method;
import com.intellij.util.containers.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.org.objectweb.asm.Handle;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.LdcInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TypeInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

final class CombinedInterpreter
extends BasicInterpreter {
    final boolean[] dereferencedParams;
    final boolean[] notNullableParams;
    final Set<CombinedData.ParamKey>[] parameterFlow;
    final boolean[] dereferencedValues;
    private final InsnList insns;

    CombinedInterpreter(InsnList insns, int arity) {
        this.dereferencedParams = new boolean[arity];
        this.notNullableParams = new boolean[arity];
        this.parameterFlow = new Set[arity];
        this.insns = insns;
        this.dereferencedValues = new boolean[insns.size()];
    }

    private int insnIndex(AbstractInsnNode insn) {
        return this.insns.indexOf(insn);
    }

    private static BasicValue track(int origin, BasicValue basicValue) {
        return basicValue == null ? null : new CombinedData.TrackableValue(origin, basicValue.getType());
    }

    public BasicValue newOperation(AbstractInsnNode insn) throws AnalyzerException {
        int origin = this.insnIndex(insn);
        switch (insn.getOpcode()) {
            case 3: {
                return AbstractValues.FalseValue;
            }
            case 4: {
                return AbstractValues.TrueValue;
            }
            case 1: {
                return new CombinedData.TrackableNullValue(origin);
            }
            case 18: {
                Object cst = ((LdcInsnNode)insn).cst;
                if (cst instanceof Type) {
                    Type type = (Type)cst;
                    if (type.getSort() == 10 || type.getSort() == 9) {
                        return AbstractValues.CLASS_VALUE;
                    }
                    if (type.getSort() != 11) break;
                    return AbstractValues.METHOD_VALUE;
                }
                if (cst instanceof String) {
                    return AbstractValues.STRING_VALUE;
                }
                if (!(cst instanceof Handle)) break;
                return AbstractValues.METHOD_HANDLE_VALUE;
            }
            case 187: {
                return new AbstractValues.NotNullValue(Type.getObjectType((String)((TypeInsnNode)insn).desc));
            }
        }
        return CombinedInterpreter.track(origin, super.newOperation(insn));
    }

    public BasicValue unaryOperation(AbstractInsnNode insn, BasicValue value) throws AnalyzerException {
        int origin = this.insnIndex(insn);
        switch (insn.getOpcode()) {
            case 180: 
            case 190: 
            case 194: {
                if (value instanceof CombinedData.NthParamValue) {
                    this.dereferencedParams[((CombinedData.NthParamValue)value).n] = true;
                }
                if (value instanceof CombinedData.Trackable) {
                    this.dereferencedValues[((CombinedData.Trackable)value).getOriginInsnIndex()] = true;
                }
                return CombinedInterpreter.track(origin, super.unaryOperation(insn, value));
            }
            case 192: {
                if (!(value instanceof CombinedData.NthParamValue)) break;
                return new CombinedData.NthParamValue(Type.getObjectType((String)((TypeInsnNode)insn).desc), ((CombinedData.NthParamValue)value).n);
            }
            case 188: 
            case 189: {
                return new AbstractValues.NotNullValue(super.unaryOperation(insn, value).getType());
            }
        }
        return CombinedInterpreter.track(origin, super.unaryOperation(insn, value));
    }

    public BasicValue binaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 181: {
                if (value1 instanceof CombinedData.NthParamValue) {
                    this.dereferencedParams[((CombinedData.NthParamValue)value1).n] = true;
                }
                if (value1 instanceof CombinedData.Trackable) {
                    this.dereferencedValues[((CombinedData.Trackable)value1).getOriginInsnIndex()] = true;
                }
                if (!(value2 instanceof CombinedData.NthParamValue)) break;
                this.notNullableParams[((CombinedData.NthParamValue)value2).n] = true;
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                if (value1 instanceof CombinedData.NthParamValue) {
                    this.dereferencedParams[((CombinedData.NthParamValue)value1).n] = true;
                }
                if (!(value1 instanceof CombinedData.Trackable)) break;
                this.dereferencedValues[((CombinedData.Trackable)value1).getOriginInsnIndex()] = true;
                break;
            }
        }
        return CombinedInterpreter.track(this.insnIndex(insn), super.binaryOperation(insn, value1, value2));
    }

    public BasicValue ternaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2, BasicValue value3) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 86: {
                if (value1 instanceof CombinedData.NthParamValue) {
                    this.dereferencedParams[((CombinedData.NthParamValue)value1).n] = true;
                }
                if (!(value1 instanceof CombinedData.Trackable)) break;
                this.dereferencedValues[((CombinedData.Trackable)value1).getOriginInsnIndex()] = true;
                break;
            }
            case 83: {
                if (value1 instanceof CombinedData.NthParamValue) {
                    this.dereferencedParams[((CombinedData.NthParamValue)value1).n] = true;
                }
                if (value1 instanceof CombinedData.Trackable) {
                    this.dereferencedValues[((CombinedData.Trackable)value1).getOriginInsnIndex()] = true;
                }
                if (!(value3 instanceof CombinedData.NthParamValue)) break;
                this.notNullableParams[((CombinedData.NthParamValue)value3).n] = true;
                break;
            }
        }
        return null;
    }

    public BasicValue naryOperation(AbstractInsnNode insn, List<? extends BasicValue> values) throws AnalyzerException {
        int opCode = insn.getOpcode();
        int shift = opCode == 184 ? 0 : 1;
        int origin = this.insnIndex(insn);
        switch (opCode) {
            case 182: 
            case 183: 
            case 185: {
                BasicValue receiver = values.get(0);
                if (receiver instanceof CombinedData.NthParamValue) {
                    this.dereferencedParams[((CombinedData.NthParamValue)receiver).n] = true;
                }
                if (!(receiver instanceof CombinedData.Trackable)) break;
                this.dereferencedValues[((CombinedData.Trackable)receiver).getOriginInsnIndex()] = true;
            }
        }
        switch (opCode) {
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                boolean stable = opCode == 184 || opCode == 183;
                MethodInsnNode mNode = (MethodInsnNode)insn;
                Method method = new Method(mNode.owner, mNode.name, mNode.desc);
                Type retType = Type.getReturnType((String)mNode.desc);
                for (int i2 = shift; i2 < values.size(); ++i2) {
                    if (!(values.get(i2) instanceof CombinedData.NthParamValue)) continue;
                    int n = ((CombinedData.NthParamValue)values.get((int)i2)).n;
                    if (opCode == 185) {
                        this.notNullableParams[n] = true;
                        continue;
                    }
                    Set<CombinedData.ParamKey> npKeys = this.parameterFlow[n];
                    if (npKeys == null) {
                        this.parameterFlow[n] = npKeys = new HashSet<CombinedData.ParamKey>();
                    }
                    npKeys.add(new CombinedData.ParamKey(method, i2 - shift, stable));
                }
                BasicValue receiver = null;
                if (shift == 1) {
                    receiver = values.remove(0);
                }
                boolean thisCall = (opCode == 185 || opCode == 182) && receiver == CombinedData.ThisValue;
                return new CombinedData.TrackableCallValue(origin, retType, method, values, stable, thisCall);
            }
            case 197: {
                return new AbstractValues.NotNullValue(super.naryOperation(insn, values).getType());
            }
        }
        return CombinedInterpreter.track(origin, super.naryOperation(insn, values));
    }
}

