/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import com.intellij.psi.impl.source.resolve.SymbolCollectingProcessor;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NotNullFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.indexing.IndexingDataKeys;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiJavaFileBaseImpl
extends PsiFileImpl
implements PsiJavaFile {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.PsiJavaFileBaseImpl");
    private static final String[] IMPLICIT_IMPORTS = new String[]{"java.lang"};
    private final CachedValue<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> myResolveCache;
    private volatile String myPackageName;
    private static final NotNullLazyKey<LanguageLevel, PsiJavaFileBaseImpl> LANGUAGE_LEVEL_KEY = NotNullLazyKey.create("LANGUAGE_LEVEL", new NotNullFunction<PsiJavaFileBaseImpl, LanguageLevel>(){

        @Override
        @NotNull
        public LanguageLevel fun(PsiJavaFileBaseImpl file) {
            LanguageLevel languageLevel = file.getLanguageLevelInner();
            if (languageLevel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl$1", "fun"));
            }
            return languageLevel;
        }
    });

    protected PsiJavaFileBaseImpl(IElementType elementType, IElementType contentElementType, FileViewProvider viewProvider) {
        super(elementType, contentElementType, viewProvider);
        this.myResolveCache = CachedValuesManager.getManager(this.myManager.getProject()).createCachedValue(new MyCacheBuilder(this), false);
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myPackageName = null;
    }

    @Override
    @NotNull
    public PsiClass[] getClasses() {
        StubElement stub = this.getGreenStub();
        if (stub != null) {
            PsiClass[] psiClassArray = (PsiClass[])stub.getChildrenByType(JavaStubElementTypes.CLASS, PsiClass.ARRAY_FACTORY);
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getClasses"));
            }
            return psiClassArray;
        }
        PsiClass[] psiClassArray = (PsiClass[])this.calcTreeElement().getChildrenAsPsiElements(Constants.CLASS_BIT_SET, PsiClass.ARRAY_FACTORY);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getClasses"));
        }
        return psiClassArray;
    }

    @Override
    public PsiPackageStatement getPackageStatement() {
        ASTNode node = this.calcTreeElement().findChildByType(JavaElementType.PACKAGE_STATEMENT);
        return node != null ? (PsiPackageStatement)node.getPsi() : null;
    }

    @Override
    @NotNull
    public String getPackageName() {
        PsiJavaFileStub stub = (PsiJavaFileStub)this.getGreenStub();
        if (stub != null) {
            String string = stub.getPackageName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getPackageName"));
            }
            return string;
        }
        String name = this.myPackageName;
        if (name == null) {
            PsiPackageStatement statement = this.getPackageStatement();
            name = statement == null ? "" : statement.getPackageName();
            this.myPackageName = name;
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getPackageName"));
        }
        return string;
    }

    @Override
    public void setPackageName(String packageName) throws IncorrectOperationException {
        if (PsiUtil.isModuleFile(this)) {
            throw new IncorrectOperationException("Cannot set package name for module declarations");
        }
        PsiPackageStatement packageStatement = this.getPackageStatement();
        PsiElementFactory factory = JavaPsiFacade.getInstance(this.getProject()).getElementFactory();
        if (packageStatement != null) {
            if (!packageName.isEmpty()) {
                PsiJavaCodeReferenceElement reference = packageStatement.getPackageReference();
                reference.replace(factory.createReferenceFromText(packageName, packageStatement));
            } else {
                packageStatement.delete();
            }
        } else if (!packageName.isEmpty()) {
            this.addBefore(factory.createPackageStatement(packageName), this.getFirstChild());
        }
    }

    @Override
    public PsiImportList getImportList() {
        StubElement stub = this.getGreenStub();
        if (stub != null) {
            PsiImportList[] nodes = (PsiImportList[])stub.getChildrenByType(JavaStubElementTypes.IMPORT_LIST, PsiImportList.ARRAY_FACTORY);
            if (nodes.length == 1) {
                return nodes[0];
            }
            if (nodes.length == 0) {
                return null;
            }
            this.reportStubAstMismatch(stub + "; " + stub.getChildrenStubs(), this.getStubTree(), PsiDocumentManager.getInstance(this.getProject()).getCachedDocument(this));
        }
        ASTNode node = this.calcTreeElement().findChildByType(JavaElementType.IMPORT_LIST);
        return (PsiImportList)SourceTreeToPsiMap.treeElementToPsi(node);
    }

    @Override
    @NotNull
    public PsiElement[] getOnDemandImports(boolean includeImplicit, boolean checkIncludes) {
        PsiImportStatement[] statements;
        PsiImportList importList = this.getImportList();
        if (importList == null) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getOnDemandImports"));
            }
            return EMPTY_ARRAY;
        }
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        for (PsiImportStatement statement : statements = importList.getImportStatements()) {
            PsiElement resolved;
            if (!statement.isOnDemand() || (resolved = statement.resolve()) == null) continue;
            array.add(resolved);
        }
        if (includeImplicit) {
            PsiJavaCodeReferenceElement[] implicitRefs;
            for (PsiJavaCodeReferenceElement implicitRef : implicitRefs = this.getImplicitlyImportedPackageReferences()) {
                PsiElement resolved = implicitRef.resolve();
                if (resolved == null) continue;
                array.add(resolved);
            }
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(array);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getOnDemandImports"));
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public PsiClass[] getSingleClassImports(boolean checkIncludes) {
        PsiImportStatement[] statements;
        PsiImportList importList = this.getImportList();
        if (importList == null) {
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getSingleClassImports"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        ArrayList<PsiClass> array = new ArrayList<PsiClass>();
        for (PsiImportStatement statement : statements = importList.getImportStatements()) {
            PsiElement ref;
            if (statement.isOnDemand() || !((ref = statement.resolve()) instanceof PsiClass)) continue;
            array.add((PsiClass)ref);
        }
        PsiClass[] psiClassArray = array.toArray(new PsiClass[array.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getSingleClassImports"));
        }
        return psiClassArray;
    }

    @Override
    public PsiJavaCodeReferenceElement findImportReferenceTo(PsiClass aClass) {
        PsiImportList importList = this.getImportList();
        if (importList != null) {
            PsiImportStatement[] statements;
            for (PsiImportStatement statement : statements = importList.getImportStatements()) {
                PsiElement ref;
                if (statement.isOnDemand() || (ref = statement.resolve()) == null || !this.getManager().areElementsEquivalent(ref, aClass)) continue;
                return statement.getImportReference();
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String[] getImplicitlyImportedPackages() {
        if (IMPLICIT_IMPORTS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getImplicitlyImportedPackages"));
        }
        return IMPLICIT_IMPORTS;
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement[] getImplicitlyImportedPackageReferences() {
        PsiJavaCodeReferenceElement[] psiJavaCodeReferenceElementArray = PsiImplUtil.namesToPackageReferences(this.myManager, IMPLICIT_IMPORTS);
        if (psiJavaCodeReferenceElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getImplicitlyImportedPackageReferences"));
        }
        return psiJavaCodeReferenceElementArray;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "processDeclarations"));
        }
        assert (this.isValid());
        if (processor instanceof ClassResolverProcessor && this.isPhysical() && (this.getUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING) == Boolean.TRUE || this.myResolveCache.hasUpToDateValue())) {
            ClassResolverProcessor hint = (ClassResolverProcessor)processor;
            String name = hint.getName(state);
            MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext> cache = this.myResolveCache.getValue();
            MyResolveCacheProcessor cacheProcessor = new MyResolveCacheProcessor(processor, state);
            return name != null ? cache.processForKey(name, cacheProcessor) : cache.processAllValues(cacheProcessor);
        }
        return this.processDeclarationsNoGuess(processor, state, lastParent, place);
    }

    /*
     * WARNING - void declaration
     */
    private boolean processDeclarationsNoGuess(PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, PsiElement place) {
        PsiImportStaticStatement[] importStaticStatements;
        PsiElement resolved;
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "processDeclarationsNoGuess"));
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        ElementClassHint classHint = processor.getHint(ElementClassHint.KEY);
        NameHint nameHint = processor.getHint(NameHint.KEY);
        String name = nameHint != null ? nameHint.getName(state) : null;
        PsiImportList importList = this.getImportList();
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            void var14_21;
            PsiClass[] classes;
            for (PsiClass aClass : classes = this.getClasses()) {
                if (processor.execute(aClass, state)) continue;
                return false;
            }
            PsiImportStatement[] importStatements = importList != null ? importList.getImportStatements() : PsiImportStatement.EMPTY_ARRAY;
            for (PsiElement psiElement : importStatements) {
                String refText;
                if (psiElement.isOnDemand() || name != null && ((refText = psiElement.getQualifiedName()) == null || !refText.endsWith(name)) || !((resolved = psiElement.resolve()) instanceof PsiClass)) continue;
                processor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, psiElement);
                PsiClass containingClass = ((PsiClass)resolved).getContainingClass();
                if (!(containingClass != null && containingClass.hasTypeParameters() ? !processor.execute(resolved, state.put(PsiSubstitutor.KEY, PsiJavaFileBaseImpl.createRawSubstitutor(containingClass))) : !processor.execute(resolved, state))) continue;
                return false;
            }
            processor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, null);
            PsiPackage aPackage = JavaPsiFacade.getInstance(this.myManager.getProject()).findPackage(this.getPackageName());
            if (aPackage != null && !aPackage.processDeclarations(processor, state, null, place)) {
                return false;
            }
            PsiImportStatement[] psiImportStatementArray = importStatements;
            int n = psiImportStatementArray.length;
            boolean bl = false;
            while (var14_21 < n) {
                PsiElement resolved2;
                PsiImportStatement statement2 = psiImportStatementArray[var14_21];
                if (statement2.isOnDemand() && (resolved2 = statement2.resolve()) != null) {
                    processor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, statement2);
                    PsiJavaFileBaseImpl.processOnDemandTarget(resolved2, processor, state, place);
                }
                ++var14_21;
            }
        }
        PsiImportStaticStatement[] psiImportStaticStatementArray = importStaticStatements = importList != null ? importList.getImportStaticStatements() : PsiImportStaticStatement.EMPTY_ARRAY;
        if (importStaticStatements.length > 0) {
            StaticImportFilteringProcessor staticImportProcessor = new StaticImportFilteringProcessor(processor);
            for (PsiElement psiElement : importStaticStatements) {
                JavaResolveResult[] results;
                PsiJavaCodeReferenceElement reference;
                if (psiElement.isOnDemand() || (reference = psiElement.getImportReference()) == null || (results = reference.multiResolve(false)).length <= 0) continue;
                staticImportProcessor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, psiElement);
                String referenceName = psiElement.getReferenceName();
                for (JavaResolveResult result : results) {
                    staticImportProcessor.registerSingleStaticImportHiding(result, referenceName);
                    PsiElement element = result.getElement();
                    if (element == null || staticImportProcessor.execute(element, state)) continue;
                    return false;
                }
            }
            for (PsiElement psiElement : importStaticStatements) {
                PsiClass targetElement;
                if (!psiElement.isOnDemand() || (targetElement = psiElement.resolveTargetClass()) == null) continue;
                staticImportProcessor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, psiElement);
                if (targetElement.processDeclarations(staticImportProcessor, state, lastParent, place)) continue;
                return false;
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            processor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, null);
            PsiJavaCodeReferenceElement[] implicitlyImported = this.getImplicitlyImportedPackageReferences();
            for (PsiElement psiElement : implicitlyImported) {
                resolved = psiElement.resolve();
                if (resolved == null || PsiJavaFileBaseImpl.processOnDemandTarget(resolved, processor, state, place)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private static PsiSubstitutor createRawSubstitutor(PsiClass containingClass) {
        PsiSubstitutor psiSubstitutor = JavaPsiFacade.getElementFactory(containingClass.getProject()).createRawSubstitutor(containingClass);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "createRawSubstitutor"));
        }
        return psiSubstitutor;
    }

    private static boolean processOnDemandTarget(PsiElement target, PsiScopeProcessor processor, ResolveState substitutor, PsiElement place) {
        if (target instanceof PsiPackage) {
            if (!target.processDeclarations(processor, substitutor, null, place)) {
                return false;
            }
        } else if (target instanceof PsiClass) {
            PsiClass[] inners = ((PsiClass)target).getInnerClasses();
            if (((PsiClass)target).hasTypeParameters()) {
                substitutor = substitutor.put(PsiSubstitutor.KEY, PsiJavaFileBaseImpl.createRawSubstitutor((PsiClass)target));
            }
            for (PsiClass inner : inners) {
                if (processor.execute(inner, substitutor)) continue;
                return false;
            }
        } else {
            LOG.assertTrue(false);
        }
        return true;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitJavaFile(this);
        } else {
            visitor.visitFile(this);
        }
    }

    @Override
    @NotNull
    public Language getLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        if (javaLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getLanguage"));
        }
        return javaLanguage;
    }

    @Override
    public boolean importClass(PsiClass aClass) {
        return JavaCodeStyleManager.getInstance(this.getProject()).addImport(this, aClass);
    }

    @Override
    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = LANGUAGE_LEVEL_KEY.getValue(this);
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl", "getLanguageLevel"));
        }
        return languageLevel;
    }

    @Override
    @Nullable
    public PsiJavaModule getModuleDeclaration() {
        return null;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.putUserData(LANGUAGE_LEVEL_KEY, null);
    }

    private LanguageLevel getLanguageLevelInner() {
        if (this.myOriginalFile instanceof PsiJavaFile) {
            return ((PsiJavaFile)this.myOriginalFile).getLanguageLevel();
        }
        LanguageLevel forcedLanguageLevel = this.getUserData(PsiUtil.FILE_LANGUAGE_LEVEL_KEY);
        if (forcedLanguageLevel != null) {
            return forcedLanguageLevel;
        }
        VirtualFile virtualFile = this.getVirtualFile();
        if (virtualFile == null) {
            virtualFile = this.getUserData(IndexingDataKeys.VIRTUAL_FILE);
        }
        Project project = this.getProject();
        if (virtualFile == null) {
            PsiFile originalFile = this.getOriginalFile();
            if (originalFile instanceof PsiJavaFile && originalFile != this) {
                return ((PsiJavaFile)originalFile).getLanguageLevel();
            }
            return LanguageLevelProjectExtension.getInstance(project).getLanguageLevel();
        }
        return JavaPsiImplementationHelper.getInstance(project).getEffectiveLanguageLevel(virtualFile);
    }

    private static class MyResolveCacheProcessor
    implements Processor<SymbolCollectingProcessor.ResultWithContext> {
        private final PsiScopeProcessor myProcessor;
        private final ResolveState myState;

        public MyResolveCacheProcessor(PsiScopeProcessor processor, ResolveState state) {
            this.myProcessor = processor;
            this.myState = state;
        }

        @Override
        public boolean process(SymbolCollectingProcessor.ResultWithContext result) {
            PsiClass containingClass;
            PsiElement context = result.getFileContext();
            this.myProcessor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, context);
            PsiNamedElement element = result.getElement();
            if (element instanceof PsiClass && context instanceof PsiImportStatement && (containingClass = ((PsiClass)element).getContainingClass()) != null && containingClass.hasTypeParameters()) {
                return this.myProcessor.execute(element, this.myState.put(PsiSubstitutor.KEY, PsiJavaFileBaseImpl.createRawSubstitutor(containingClass)));
            }
            return this.myProcessor.execute(element, this.myState);
        }
    }

    private static class MyCacheBuilder
    implements CachedValueProvider<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> {
        private final PsiJavaFileBaseImpl myFile;

        public MyCacheBuilder(PsiJavaFileBaseImpl file) {
            this.myFile = file;
        }

        @Override
        public CachedValueProvider.Result<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> compute() {
            SymbolCollectingProcessor p = new SymbolCollectingProcessor();
            this.myFile.processDeclarationsNoGuess(p, ResolveState.initial(), this.myFile, this.myFile);
            MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext> results = p.getResults();
            return CachedValueProvider.Result.create(results, PsiModificationTracker.MODIFICATION_COUNT, this.myFile);
        }
    }

    private static class StaticImportFilteringProcessor
    implements PsiScopeProcessor {
        private final PsiScopeProcessor myDelegate;
        private boolean myIsProcessingOnDemand;
        private final Collection<String> myHiddenFieldNames = new HashSet<String>();
        private final Collection<String> myHiddenMethodNames = new HashSet<String>();
        private final Collection<String> myHiddenTypeNames = new HashSet<String>();
        private final Collection<PsiElement> myCollectedElements = new HashSet<PsiElement>();

        public StaticImportFilteringProcessor(PsiScopeProcessor delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public <T> T getHint(@NotNull Key<T> hintKey) {
            if (hintKey == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl$StaticImportFilteringProcessor", "getHint"));
            }
            return this.myDelegate.getHint(hintKey);
        }

        @Override
        public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl$StaticImportFilteringProcessor", "handleEvent"));
            }
            if (JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT.equals(event) && associated instanceof PsiImportStaticStatement) {
                PsiImportStaticStatement importStaticStatement = (PsiImportStaticStatement)associated;
                this.myIsProcessingOnDemand = importStaticStatement.isOnDemand();
            }
            this.myDelegate.handleEvent(event, associated);
        }

        private void registerSingleStaticImportHiding(JavaResolveResult result, String referenceName) {
            this.getHiddenMembers(result.getElement()).add(referenceName);
        }

        private Collection<String> getHiddenMembers(PsiElement element) {
            if (element instanceof PsiField) {
                return this.myHiddenFieldNames;
            }
            return element instanceof PsiClass ? this.myHiddenTypeNames : this.myHiddenMethodNames;
        }

        @Override
        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl$StaticImportFilteringProcessor", "execute"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl$StaticImportFilteringProcessor", "execute"));
            }
            if (element instanceof PsiModifierListOwner && ((PsiModifierListOwner)element).hasModifierProperty("static")) {
                if (element instanceof PsiNamedElement && this.myIsProcessingOnDemand) {
                    String name = ((PsiNamedElement)element).getName();
                    if (this.getHiddenMembers(element).contains(name)) {
                        return true;
                    }
                }
                if (this.myCollectedElements.add(element)) {
                    return this.myDelegate.execute(element, state);
                }
            }
            return true;
        }
    }
}

