/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;

public class ClassImplementationsSearch
implements QueryExecutor<PsiElement, DefinitionsScopedSearch.SearchParameters> {
    @Override
    public boolean execute(@NotNull DefinitionsScopedSearch.SearchParameters queryParameters, @NotNull Processor<PsiElement> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/codeInsight/navigation/ClassImplementationsSearch", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/codeInsight/navigation/ClassImplementationsSearch", "execute"));
        }
        PsiElement sourceElement = queryParameters.getElement();
        return !(sourceElement instanceof PsiClass) || ClassImplementationsSearch.processImplementations((PsiClass)sourceElement, consumer, queryParameters.getScope());
    }

    public static boolean processImplementations(PsiClass psiClass, Processor<PsiElement> processor, SearchScope scope) {
        boolean showInterfaces = Registry.is("ide.goto.implementation.show.interfaces");
        if (!ClassInheritorsSearch.search(psiClass, scope, true).forEach(new PsiElementProcessorAdapter<PsiClass>(element -> {
            if (!showInterfaces && element.isInterface()) {
                return true;
            }
            return processor.process(element);
        }))) {
            return false;
        }
        return FunctionalExpressionSearch.search(psiClass, scope).forEach(processor::process);
    }
}

