/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.ContractInferenceInterpreter;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.PreContract;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class DelegationContract
extends PreContract {
    private final PsiMethodCallExpression myExpression;
    private final boolean myNegated;

    DelegationContract(PsiMethodCallExpression expression, boolean negated) {
        this.myExpression = expression;
        this.myNegated = negated;
    }

    @Override
    @NotNull
    List<MethodContract> toContracts(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/DelegationContract", "toContracts"));
        }
        JavaResolveResult result = this.myExpression.resolveMethodGenerics();
        PsiMethod targetMethod = (PsiMethod)result.getElement();
        if (targetMethod == null) {
            List<MethodContract> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DelegationContract", "toContracts"));
            }
            return list;
        }
        PsiParameter[] parameters = targetMethod.getParameterList().getParameters();
        PsiExpression[] arguments = this.myExpression.getArgumentList().getExpressions();
        boolean varArgCall = MethodCallInstruction.isVarArgCall(targetMethod, result.getSubstitutor(), arguments, parameters);
        boolean notNull = NullableNotNullManager.isNotNull(targetMethod);
        MethodContract.ValueConstraint[] emptyConstraints = MethodContract.createConstraintArray(method.getParameterList().getParametersCount());
        List<MethodContract> fromDelegate = ContainerUtil.mapNotNull(ControlFlowAnalyzer.getMethodContracts(targetMethod), delegateContract -> {
            MethodContract.ValueConstraint returnValue;
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/DelegationContract", "lambda$toContracts$0"));
            }
            MethodContract.ValueConstraint[] answer = emptyConstraints;
            for (int i2 = 0; i2 < delegateContract.arguments.length; ++i2) {
                if (i2 >= arguments.length) {
                    return null;
                }
                MethodContract.ValueConstraint argConstraint = delegateContract.arguments[i2];
                if (argConstraint == MethodContract.ValueConstraint.ANY_VALUE) continue;
                if (varArgCall && i2 >= parameters.length - 1) {
                    if (argConstraint != MethodContract.ValueConstraint.NULL_VALUE) break;
                    return null;
                }
                int paramIndex = ContractInferenceInterpreter.resolveParameter(arguments[i2], method);
                if (!(paramIndex < 0 ? argConstraint != ContractInferenceInterpreter.getLiteralConstraint(arguments[i2]) : (answer = ContractInferenceInterpreter.withConstraint(answer, paramIndex, argConstraint, method)) == null)) continue;
                return null;
            }
            MethodContract.ValueConstraint valueConstraint = returnValue = this.myNegated ? ContractInferenceInterpreter.negateConstraint(delegateContract.returnValue) : delegateContract.returnValue;
            if (notNull && returnValue != MethodContract.ValueConstraint.THROW_EXCEPTION) {
                returnValue = MethodContract.ValueConstraint.NOT_NULL_VALUE;
            }
            return answer == null ? null : new MethodContract(answer, returnValue);
        });
        if (notNull) {
            List<MethodContract> list = ContainerUtil.concat(fromDelegate, Collections.singletonList(new MethodContract(emptyConstraints, MethodContract.ValueConstraint.NOT_NULL_VALUE)));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DelegationContract", "toContracts"));
            }
            return list;
        }
        List<MethodContract> list = fromDelegate;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DelegationContract", "toContracts"));
        }
        return list;
    }
}

