/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NonNls;

public class SpinAllocator<T> {
    public static final int MAX_SIMULTANEOUS_ALLOCATIONS = 64;
    private final AtomicBoolean[] myEmployed = new AtomicBoolean[64];
    private final Object[] myObjects = new Object[64];
    protected final ICreator<T> myCreator;
    protected final IDisposer<T> myDisposer;

    public SpinAllocator(ICreator<T> creator, IDisposer<T> disposer) {
        this.myCreator = creator;
        this.myDisposer = disposer;
        for (int i2 = 0; i2 < 64; ++i2) {
            this.myEmployed[i2] = new AtomicBoolean(false);
        }
    }

    public T alloc() {
        for (int i2 = 0; i2 < 64; ++i2) {
            if (this.myEmployed[i2].getAndSet(true)) continue;
            Object result = this.myObjects[i2];
            if (result == null) {
                this.myObjects[i2] = result = this.myCreator.createInstance();
            }
            return (T)result;
        }
        throw new AllocatorExhaustedException();
    }

    public void dispose(T instance) {
        for (int i2 = 0; i2 < 64; ++i2) {
            if (this.myObjects[i2] != instance) continue;
            if (!this.myEmployed[i2].get()) {
                throw new AllocatorDisposeException("Instance is already disposed.");
            }
            this.myDisposer.disposeInstance(instance);
            this.myEmployed[i2].set(false);
            return;
        }
        throw new AllocatorDisposeException("Attempt to dispose non-allocated instance.");
    }

    public static class AllocatorDisposeException
    extends RuntimeException {
        public AllocatorDisposeException(@NonNls String message) {
            super(message);
        }
    }

    public static class AllocatorExhaustedException
    extends RuntimeException {
        public AllocatorExhaustedException() {
            super("SpinAllocator has exhausted! Too many threads or you're going to get StackOverflow.");
        }
    }

    public static interface IDisposer<T> {
        public void disposeInstance(T var1);
    }

    public static interface ICreator<T> {
        public T createInstance();
    }
}

