/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantMethodOverrideInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("redundant.method.override.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/RedundantMethodOverrideInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("redundant.method.override.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/RedundantMethodOverrideInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RedundantMethodOverrideFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RedundantMethodOverrideVisitor();
    }

    private static class RedundantMethodOverrideVisitor
    extends BaseInspectionVisitor {
        private RedundantMethodOverrideVisitor() {
        }

        @Override
        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            PsiMethod superMethod = MethodUtils.getSuper(method);
            if (superMethod == null) {
                return;
            }
            if (!RedundantMethodOverrideVisitor.modifierListsAreEquivalent(method.getModifierList(), superMethod.getModifierList())) {
                return;
            }
            PsiType superReturnType = superMethod.getReturnType();
            if (superReturnType == null || !superReturnType.equals(method.getReturnType())) {
                return;
            }
            if (method.hasModifierProperty("final")) {
                return;
            }
            ParameterEquivalenceChecker checker = new ParameterEquivalenceChecker(method, superMethod);
            PsiCodeBlock superBody = superMethod.getBody();
            if (checker.codeBlocksAreEquivalent(body, superBody) || this.isSuperCallWithSameArguments(body, method, superMethod)) {
                this.registerMethodError(method, new Object[0]);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isSuperCallWithSameArguments(PsiCodeBlock body, PsiMethod method, PsiMethod superMethod) {
            PsiExpression expression;
            PsiStatement[] statements = body.getStatements();
            if (statements.length != 1) {
                return false;
            }
            PsiStatement statement = statements[0];
            if (PsiType.VOID.equals(method.getReturnType())) {
                if (!(statement instanceof PsiExpressionStatement)) return false;
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
                expression = expressionStatement.getExpression();
            } else {
                if (!(statement instanceof PsiReturnStatement)) return false;
                PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
                expression = ParenthesesUtils.stripParentheses(returnStatement.getReturnValue());
            }
            if (!(expression instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            if (!MethodCallUtils.isSuperMethodCall(methodCallExpression, method)) {
                return false;
            }
            if (!superMethod.hasModifierProperty("protected")) return RedundantMethodOverrideVisitor.areSameArguments(methodCallExpression, method);
            PsiJavaFile file = (PsiJavaFile)method.getContainingFile();
            PsiPackage aPackage = JavaPsiFacade.getInstance(method.getProject()).findPackage(file.getPackageName());
            if (aPackage == null) {
                return false;
            }
            PackageScope scope = new PackageScope(aPackage, false, false);
            if (this.isOnTheFly()) {
                PsiSearchHelper searchHelper = PsiSearchHelper.SERVICE.getInstance(method.getProject());
                PsiSearchHelper.SearchCostResult cost = searchHelper.isCheapEnoughToSearch(method.getName(), scope, null, null);
                if (cost == PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES) {
                    return true;
                }
                if (cost == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                    return false;
                }
            }
            Query<PsiReference> search = ReferencesSearch.search(method, scope);
            PsiClass containingClass = method.getContainingClass();
            for (PsiReference reference : search) {
                if (PsiTreeUtil.isAncestor(containingClass, reference.getElement(), true)) continue;
                return false;
            }
            return RedundantMethodOverrideVisitor.areSameArguments(methodCallExpression, method);
        }

        private static boolean areSameArguments(PsiMethodCallExpression methodCallExpression, PsiMethod method) {
            PsiParameter[] parameters;
            PsiExpression[] arguments = methodCallExpression.getArgumentList().getExpressions();
            if (arguments.length != (parameters = method.getParameterList().getParameters()).length) {
                return false;
            }
            for (int i2 = 0; i2 < arguments.length; ++i2) {
                PsiExpression argument = arguments[i2];
                PsiExpression exp = PsiUtil.deparenthesizeExpression(argument);
                if (!(exp instanceof PsiReferenceExpression)) {
                    return false;
                }
                PsiElement resolved = ((PsiReferenceExpression)exp).resolve();
                if (method.getManager().areElementsEquivalent(parameters[i2], resolved)) continue;
                return false;
            }
            return true;
        }

        private static boolean modifierListsAreEquivalent(@Nullable PsiModifierList list1, @Nullable PsiModifierList list2) {
            if (list1 == null) {
                return list2 == null;
            }
            if (list2 == null) {
                return false;
            }
            HashSet<String> annotations1 = new HashSet<String>();
            for (PsiAnnotation annotation : list1.getAnnotations()) {
                annotations1.add(annotation.getQualifiedName());
            }
            HashSet<String> annotations2 = new HashSet<String>();
            for (PsiAnnotation annotation : list2.getAnnotations()) {
                annotations2.add(annotation.getQualifiedName());
            }
            Set uniques = RedundantMethodOverrideVisitor.disjunction(annotations1, annotations2);
            uniques.remove("java.lang.Override");
            if (!uniques.isEmpty()) {
                return false;
            }
            return list1.hasModifierProperty("strictfp") == list2.hasModifierProperty("strictfp") && list1.hasModifierProperty("synchronized") == list2.hasModifierProperty("synchronized") && list1.hasModifierProperty("public") == list2.hasModifierProperty("public") && list1.hasModifierProperty("protected") == list2.hasModifierProperty("protected");
        }

        private static <T> Set<T> disjunction(Collection<T> set1, Collection<T> set2) {
            HashSet<T> result = new HashSet<T>();
            for (T t : set1) {
                if (set2.contains(t)) continue;
                result.add(t);
            }
            for (T t : set2) {
                if (set1.contains(t)) continue;
                result.add(t);
            }
            return result;
        }

        private static class ParameterEquivalenceChecker
        extends EquivalenceChecker {
            private final PsiMethod myMethod;
            private final PsiMethod mySuperMethod;

            ParameterEquivalenceChecker(@NotNull PsiMethod method, @NotNull PsiMethod superMethod) {
                if (method == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/inheritance/RedundantMethodOverrideInspection$RedundantMethodOverrideVisitor$ParameterEquivalenceChecker", "<init>"));
                }
                if (superMethod == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethod", "com/siyeh/ig/inheritance/RedundantMethodOverrideInspection$RedundantMethodOverrideVisitor$ParameterEquivalenceChecker", "<init>"));
                }
                this.myMethod = method;
                this.mySuperMethod = superMethod;
            }

            @Override
            protected EquivalenceChecker.Decision referenceExpressionsAreEquivalentDecision(PsiReferenceExpression referenceExpression1, PsiReferenceExpression referenceExpression2) {
                if (this.areSameParameters(referenceExpression1, referenceExpression2)) {
                    return EXACTLY_MATCHES;
                }
                return super.referenceExpressionsAreEquivalentDecision(referenceExpression1, referenceExpression2);
            }

            private boolean areSameParameters(PsiReferenceExpression referenceExpression1, PsiReferenceExpression referenceExpression2) {
                int index2;
                PsiElement scope2;
                PsiElement resolved1 = referenceExpression1.resolve();
                PsiElement resolved2 = referenceExpression2.resolve();
                if (!(resolved1 instanceof PsiParameter) || !(resolved2 instanceof PsiParameter)) {
                    return false;
                }
                PsiElement scope1 = ((PsiParameter)resolved1).getDeclarationScope();
                if (scope1 == (scope2 = ((PsiParameter)resolved2).getDeclarationScope()) || scope1 != this.myMethod && scope1 != this.mySuperMethod || scope2 != this.myMethod && scope2 != this.mySuperMethod) {
                    return false;
                }
                PsiElement parent1 = resolved1.getParent();
                PsiElement parent2 = resolved2.getParent();
                if (!(parent1 instanceof PsiParameterList) || !(parent2 instanceof PsiParameterList)) {
                    return false;
                }
                int index1 = ((PsiParameterList)parent1).getParameterIndex((PsiParameter)resolved1);
                return index1 == (index2 = ((PsiParameterList)parent2).getParameterIndex((PsiParameter)resolved2));
            }
        }
    }

    private static class RedundantMethodOverrideFix
    extends InspectionGadgetsFix {
        private RedundantMethodOverrideFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("redundant.method.override.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/RedundantMethodOverrideInspection$RedundantMethodOverrideFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement methodNameIdentifier = descriptor.getPsiElement();
            PsiElement method = methodNameIdentifier.getParent();
            assert (method != null);
            RedundantMethodOverrideFix.deleteElement(method);
        }
    }
}

