/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PathMacroMap {
    private static final Logger LOG = Logger.getInstance(PathMacroMap.class);

    public abstract String substitute(String var1, boolean var2);

    public final void substitute(@NotNull Element e, boolean caseSensitive) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/components/PathMacroMap", "substitute"));
        }
        this.substitute(e, caseSensitive, false);
    }

    public final void substitute(@NotNull Element e, boolean caseSensitive, boolean recursively, @Nullable PathMacroFilter filter) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/components/PathMacroMap", "substitute"));
        }
        if (filter != null && filter.skipPathMacros(e)) {
            return;
        }
        for (Content child : e.getContent()) {
            if (child instanceof Element) {
                this.substitute((Element)child, caseSensitive, recursively, filter);
                continue;
            }
            if (child instanceof Text) {
                String newText;
                String oldText;
                Text t = (Text)child;
                if (filter != null && filter.skipPathMacros(t) || (oldText = t.getText()) == (newText = recursively || filter != null && filter.recursePathMacros(t) ? this.substituteRecursively(oldText, caseSensitive) : this.substitute(oldText, caseSensitive))) continue;
                t.setText(newText);
                continue;
            }
            if (child instanceof Comment) continue;
            LOG.error("Wrong content: " + child.getClass());
        }
        for (Attribute attribute : e.getAttributes()) {
            String newValue;
            String oldValue;
            if (filter != null && filter.skipPathMacros(attribute) || (oldValue = attribute.getValue()) == (newValue = recursively || filter != null && filter.recursePathMacros(attribute) ? this.substituteRecursively(oldValue, caseSensitive) : this.substitute(oldValue, caseSensitive))) continue;
            attribute.setValue(newValue);
        }
    }

    public final void substitute(@NotNull Element e, boolean caseSensitive, boolean recursively) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/components/PathMacroMap", "substitute"));
        }
        this.substitute(e, caseSensitive, recursively, null);
    }

    @NotNull
    public String substituteRecursively(@NotNull String text, boolean caseSensitive) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/components/PathMacroMap", "substituteRecursively"));
        }
        String string = this.substitute(text, caseSensitive);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/PathMacroMap", "substituteRecursively"));
        }
        return string;
    }

    @NotNull
    protected static String quotePath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/components/PathMacroMap", "quotePath"));
        }
        String string = FileUtil.toSystemIndependentName(path);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/PathMacroMap", "quotePath"));
        }
        return string;
    }

    public abstract int hashCode();
}

