/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutor;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public final class LanguageSubstitutors
extends LanguageExtension<LanguageSubstitutor> {
    public static final LanguageSubstitutors INSTANCE = new LanguageSubstitutors();
    private static final Logger LOG = Logger.getInstance(LanguageSubstitutors.class);
    private static final Key<Key<Language>> PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY = Key.create("PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY");
    private static final Key<Boolean> REPARSING_SCHEDULED = Key.create("REPARSING_SCHEDULED");

    private LanguageSubstitutors() {
        super("com.intellij.lang.substitutor");
    }

    @NotNull
    public Language substituteLanguage(@NotNull Language lang, @NotNull VirtualFile file, @NotNull Project project) {
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "com/intellij/psi/LanguageSubstitutors", "substituteLanguage"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/LanguageSubstitutors", "substituteLanguage"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/LanguageSubstitutors", "substituteLanguage"));
        }
        for (LanguageSubstitutor substitutor : this.forKey(lang)) {
            Language language = substitutor.getLanguage(file, project);
            if (language == null) continue;
            LanguageSubstitutors.processLanguageSubstitution(file, lang, language, project);
            Language language2 = language;
            if (language2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/LanguageSubstitutors", "substituteLanguage"));
            }
            return language2;
        }
        Language language = lang;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/LanguageSubstitutors", "substituteLanguage"));
        }
        return language;
    }

    private static void processLanguageSubstitution(final @NotNull VirtualFile file, @NotNull Language originalLang, final @NotNull Language substitutedLang, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/LanguageSubstitutors", "processLanguageSubstitution"));
        }
        if (originalLang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalLang", "com/intellij/psi/LanguageSubstitutors", "processLanguageSubstitution"));
        }
        if (substitutedLang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutedLang", "com/intellij/psi/LanguageSubstitutors", "processLanguageSubstitution"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/LanguageSubstitutors", "processLanguageSubstitution"));
        }
        if (file instanceof VirtualFileWindow) {
            return;
        }
        Key<Language> projectKey = LanguageSubstitutors.getOrCreateProjectKey(project);
        Language prevSubstitutedLang = projectKey.get(file);
        final Language prevLang = ObjectUtils.notNull(prevSubstitutedLang, originalLang);
        if (!prevLang.is(substitutedLang) && file.replace(projectKey, prevSubstitutedLang, substitutedLang)) {
            if (prevSubstitutedLang == null) {
                return;
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            file.putUserData(REPARSING_SCHEDULED, true);
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (file.replace(REPARSING_SCHEDULED, true, null)) {
                        LOG.info("Reparsing " + file.getPath() + " because of language substitution " + prevLang.getID() + "->" + substitutedLang.getID());
                        FileContentUtilCore.reparseFiles(file);
                    }
                }
            }, ModalityState.defaultModalityState());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Key<Language> getOrCreateProjectKey(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/LanguageSubstitutors", "getOrCreateProjectKey"));
        }
        Key<Language> key = PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY.get(project);
        if (key == null) {
            Key<Key<Language>> key2 = PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY;
            synchronized (key2) {
                key = PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY.get(project);
                if (key == null) {
                    key = new Key("Substituted lang key for " + project.getName());
                    PROJECT_KEY_FOR_SUBSTITUTED_LANG_KEY.set(project, key);
                }
            }
        }
        Key<Language> key3 = key;
        if (key3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/LanguageSubstitutors", "getOrCreateProjectKey"));
        }
        return key3;
    }

    public static void cancelReparsing(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/LanguageSubstitutors", "cancelReparsing"));
        }
        REPARSING_SCHEDULED.set(file, null);
    }
}

