/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MisorderedAssertEqualsArgumentsInspectionBase
extends BaseInspection {
    @NonNls
    private static final Set<String> methodNames = ContainerUtil.newHashSet("assertEquals", "assertEqualsNoOrder", "assertNotEquals", "assertArrayEquals", "assertSame", "assertNotSame", "failNotSame", "failNotEquals");

    public abstract boolean checkTestNG();

    @Override
    @NotNull
    public final String getDisplayName() {
        String string = InspectionGadgetsBundle.message("misordered.assert.equals.arguments.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/MisorderedAssertEqualsArgumentsInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected final String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("misordered.assert.equals.arguments.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/MisorderedAssertEqualsArgumentsInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public final InspectionGadgetsFix buildFix(Object ... infos) {
        return new FlipArgumentsFix();
    }

    @Override
    public final BaseInspectionVisitor buildVisitor() {
        return new MisorderedAssertEqualsParametersVisitor();
    }

    private class MisorderedAssertEqualsParametersVisitor
    extends BaseInspectionVisitor {
        private MisorderedAssertEqualsParametersVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiExpression actualArgument;
            PsiExpression expectedArgument;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/junit/MisorderedAssertEqualsArgumentsInspectionBase$MisorderedAssertEqualsParametersVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!methodNames.contains(methodName)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null || method.hasModifierProperty("private")) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length < 2) {
                return;
            }
            PsiClassType stringType = TypeUtils.getStringType(expression);
            PsiClass containingClass = method.getContainingClass();
            if (MisorderedAssertEqualsArgumentsInspectionBase.this.checkTestNG() ? InheritanceUtil.isInheritor(containingClass, "org.testng.AssertJUnit") : InheritanceUtil.isInheritor(containingClass, "junit.framework.Assert") || InheritanceUtil.isInheritor(containingClass, "org.junit.Assert")) {
                PsiType firstArgumentType = arguments[0].getType();
                if (((Object)stringType).equals(firstArgumentType) && arguments.length > 2) {
                    expectedArgument = arguments[1];
                    actualArgument = arguments[2];
                } else {
                    expectedArgument = arguments[0];
                    actualArgument = arguments[1];
                }
            } else if (MisorderedAssertEqualsArgumentsInspectionBase.this.checkTestNG() && InheritanceUtil.isInheritor(containingClass, "org.testng.Assert")) {
                expectedArgument = arguments[1];
                actualArgument = arguments[0];
            } else {
                return;
            }
            if (expectedArgument == null || actualArgument == null) {
                return;
            }
            if (this.looksLikeExpectedArgument(expectedArgument) || !this.looksLikeExpectedArgument(actualArgument)) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }

        private boolean looksLikeExpectedArgument(@Nullable PsiExpression expression) {
            PsiClassType classType;
            PsiClass aClass;
            if ((expression = ParenthesesUtils.stripParentheses(expression)) == null) {
                return false;
            }
            PsiType type = expression.getType();
            if (ExpressionUtils.computeConstantExpression(expression) != null || PsiType.NULL.equals(type)) {
                return true;
            }
            if (expression instanceof PsiReferenceExpression) {
                PsiLocalVariable variable;
                PsiExpression definition;
                PsiField field;
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
                PsiElement target = referenceExpression.resolve();
                if (target instanceof PsiEnumConstant) {
                    return true;
                }
                if (target instanceof PsiField ? (field = (PsiField)target).hasModifierProperty("static") && field.hasModifierProperty("final") : target instanceof PsiLocalVariable && LibraryUtil.isOnlyLibraryCodeUsed(definition = DeclarationSearchUtils.findDefinition(referenceExpression, variable = (PsiLocalVariable)target))) {
                    return true;
                }
            }
            if (expression instanceof PsiCallExpression && type instanceof PsiClassType && (aClass = (classType = (PsiClassType)type).resolve()) instanceof PsiCompiledElement) {
                return LibraryUtil.isOnlyLibraryCodeUsed(expression);
            }
            return false;
        }
    }

    private static class FlipArgumentsFix
    extends InspectionGadgetsFix {
        private FlipArgumentsFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("misordered.assert.equals.arguments.flip.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/MisorderedAssertEqualsArgumentsInspectionBase$FlipArgumentsFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiExpression actualArgument;
            PsiExpression expectedArgument;
            boolean junit;
            PsiElement methodNameIdentifier = descriptor.getPsiElement();
            PsiElement parent = methodNameIdentifier.getParent();
            if (parent == null) {
                return;
            }
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)parent.getParent();
            if (callExpression == null) {
                return;
            }
            PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
            PsiMethod method = (PsiMethod)methodExpression.resolve();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (InheritanceUtil.isInheritor(containingClass, "org.testng.Assert")) {
                junit = false;
            } else if (InheritanceUtil.isInheritor(containingClass, "org.testng.AssertJUnit") || InheritanceUtil.isInheritor(containingClass, "junit.framework.Assert") || InheritanceUtil.isInheritor(containingClass, "org.junit.Assert")) {
                junit = true;
            } else {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            PsiClassType stringType = TypeUtils.getStringType(callExpression);
            PsiType parameterType1 = parameters[0].getType();
            PsiExpressionList argumentList = callExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (junit) {
                if (parameterType1.equals(stringType) && parameters.length > 2) {
                    expectedArgument = arguments[1];
                    actualArgument = arguments[2];
                } else {
                    expectedArgument = arguments[0];
                    actualArgument = arguments[1];
                }
            } else {
                actualArgument = arguments[0];
                expectedArgument = arguments[1];
            }
            PsiElement copy = expectedArgument.copy();
            expectedArgument.replace(actualArgument);
            actualArgument.replace(copy);
        }
    }
}

