/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeHighlighting;

import com.intellij.ui.JBColor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ColorGenerator {
    @NotNull
    public static List<Color> generateLinearColorSequence(@NotNull List<Color> anchorColors, int colorsBetweenAnchors) {
        if (anchorColors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchorColors", "com/intellij/codeHighlighting/ColorGenerator", "generateLinearColorSequence"));
        }
        assert (colorsBetweenAnchors >= 0);
        if (anchorColors.isEmpty()) {
            List<Color> list = Collections.singletonList(JBColor.GRAY);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeHighlighting/ColorGenerator", "generateLinearColorSequence"));
            }
            return list;
        }
        if (anchorColors.size() == 1) {
            List<Color> list = Collections.singletonList(anchorColors.get(0));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeHighlighting/ColorGenerator", "generateLinearColorSequence"));
            }
            return list;
        }
        int segmentCount = anchorColors.size() - 1;
        ArrayList<Color> result = new ArrayList<Color>(anchorColors.size() + segmentCount * colorsBetweenAnchors);
        result.add(anchorColors.get(0));
        for (int i2 = 0; i2 < segmentCount; ++i2) {
            Color color1 = anchorColors.get(i2);
            Color color2 = anchorColors.get(i2 + 1);
            List<Color> linearColors = ColorGenerator.generateLinearColorSequence(color1, color2, colorsBetweenAnchors);
            result.addAll(linearColors.subList(1, linearColors.size()));
        }
        ArrayList<Color> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeHighlighting/ColorGenerator", "generateLinearColorSequence"));
        }
        return arrayList;
    }

    @NotNull
    public static List<Color> generateLinearColorSequence(@NotNull Color color1, @NotNull Color color2, int colorsBetweenAnchors) {
        if (color1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color1", "com/intellij/codeHighlighting/ColorGenerator", "generateLinearColorSequence"));
        }
        if (color2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color2", "com/intellij/codeHighlighting/ColorGenerator", "generateLinearColorSequence"));
        }
        assert (colorsBetweenAnchors >= 0);
        ArrayList<Color> result = new ArrayList<Color>(colorsBetweenAnchors + 2);
        result.add(color1);
        for (int i2 = 1; i2 <= colorsBetweenAnchors; ++i2) {
            float ratio = (float)i2 / (float)(colorsBetweenAnchors + 1);
            result.add(new Color(ColorGenerator.ratio(color1.getRed(), color2.getRed(), ratio), ColorGenerator.ratio(color1.getGreen(), color2.getGreen(), ratio), ColorGenerator.ratio(color1.getBlue(), color2.getBlue(), ratio)));
        }
        result.add(color2);
        ArrayList<Color> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeHighlighting/ColorGenerator", "generateLinearColorSequence"));
        }
        return arrayList;
    }

    private static int ratio(int val1, int val2, float ratio) {
        int value = (int)((float)val1 + (float)(val2 - val1) * ratio);
        return Math.max(Math.min(value, 255), 0);
    }
}

