/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Collection;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComparatorCombinatorsInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance("#" + ComparatorCombinatorsInspection.class.getName());

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/ComparatorCombinatorsInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitLambdaExpression(PsiLambdaExpression lambda2) {
                PsiBinaryExpression binOp;
                super.visitLambdaExpression(lambda2);
                PsiType type = lambda2.getFunctionalInterfaceType();
                PsiParameter[] parameters = lambda2.getParameterList().getParameters();
                if (parameters.length != 2 || !(type instanceof PsiClassType) || !((PsiClassType)type).rawType().equalsToText("java.util.Comparator")) {
                    return;
                }
                PsiExpression body = LambdaUtil.extractSingleExpressionFromBody(lambda2.getBody());
                String methodName = null;
                if (body instanceof PsiMethodCallExpression) {
                    PsiMethodCallExpression methodCall = (PsiMethodCallExpression)body;
                    PsiExpression[] args = methodCall.getArgumentList().getExpressions();
                    if (args.length == 1 && MethodUtils.isCompareToCall(methodCall)) {
                        PsiExpression left = methodCall.getMethodExpression().getQualifierExpression();
                        PsiExpression right = args[0];
                        if (left instanceof PsiReferenceExpression && right instanceof PsiReferenceExpression) {
                            PsiElement leftElement = ((PsiReferenceExpression)left).resolve();
                            PsiElement rightElement = ((PsiReferenceExpression)right).resolve();
                            if (leftElement == parameters[0] && rightElement == parameters[1]) {
                                methodName = "naturalOrder";
                            } else if (leftElement == parameters[1] && rightElement == parameters[0]) {
                                methodName = "reverseOrder";
                            }
                        }
                        if (methodName == null && ComparatorCombinatorsInspection.areEquivalent(parameters, left, right)) {
                            methodName = "comparing";
                        }
                    } else {
                        PsiClass compareClass;
                        PsiMethod method = methodCall.resolveMethod();
                        if (args.length == 2 && method != null && method.getName().equals("compare") && (compareClass = method.getContainingClass()) != null) {
                            if ("java.lang.Double".equals(compareClass.getQualifiedName())) {
                                methodName = "comparingDouble";
                            } else if ("java.lang.Integer".equals(compareClass.getQualifiedName())) {
                                methodName = "comparingInt";
                            } else if ("java.lang.Long".equals(compareClass.getQualifiedName())) {
                                methodName = "comparingLong";
                            } else {
                                return;
                            }
                            if (!ComparatorCombinatorsInspection.areEquivalent(parameters, args[0], args[1])) {
                                return;
                            }
                        }
                    }
                } else if (body instanceof PsiBinaryExpression && (binOp = (PsiBinaryExpression)body).getOperationTokenType().equals(JavaTokenType.MINUS) && ComparatorCombinatorsInspection.areEquivalent(parameters, binOp.getLOperand(), binOp.getROperand())) {
                    methodName = "comparingInt";
                }
                if (methodName != null) {
                    holder.registerProblem((PsiElement)lambda2, "Can be replaced with Comparator." + methodName, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new ReplaceWithComparatorFix(methodName));
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ComparatorCombinatorsInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    @Contract(value="_, null, _ -> false; _, !null, null -> false")
    private static boolean areEquivalent(@NotNull PsiParameter[] parameters, @Nullable PsiExpression left, @Nullable PsiExpression right) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInspection/ComparatorCombinatorsInspection", "areEquivalent"));
        }
        if (left == null || right == null) {
            return false;
        }
        if (!PsiTreeUtil.processElements(left, e -> {
            if (parameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInspection/ComparatorCombinatorsInspection", "lambda$areEquivalent$0"));
            }
            return !(e instanceof PsiReferenceExpression) || ((PsiReferenceExpression)e).resolve() != parameters[1];
        }) || !PsiTreeUtil.processElements(right, e -> {
            if (parameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInspection/ComparatorCombinatorsInspection", "lambda$areEquivalent$1"));
            }
            return !(e instanceof PsiReferenceExpression) || ((PsiReferenceExpression)e).resolve() != parameters[0];
        })) {
            return false;
        }
        PsiExpression copy = (PsiExpression)right.copy();
        PsiElement[] rightRefs = PsiTreeUtil.collectElements(copy, e -> {
            if (parameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInspection/ComparatorCombinatorsInspection", "lambda$areEquivalent$2"));
            }
            return e instanceof PsiReferenceExpression && ((PsiReferenceExpression)e).resolve() == parameters[1];
        });
        PsiElementFactory factory = JavaPsiFacade.getElementFactory(left.getProject());
        String paramName = parameters[0].getName();
        if (paramName == null) {
            return false;
        }
        for (PsiElement ref : rightRefs) {
            PsiElement nameElement = ((PsiReferenceExpression)ref).getReferenceNameElement();
            LOG.assertTrue(nameElement != null);
            nameElement.replace(factory.createIdentifier(paramName));
        }
        return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(left, copy);
    }

    static class ReplaceWithComparatorFix
    implements LocalQuickFix {
        private final String myMethodName;

        public ReplaceWithComparatorFix(String methodName) {
            this.myMethodName = methodName;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = "Replace with Comparator." + this.myMethodName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ComparatorCombinatorsInspection$ReplaceWithComparatorFix", "getName"));
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Simplify comparator using Comparator static methods" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ComparatorCombinatorsInspection$ReplaceWithComparatorFix", "getFamilyName"));
            }
            return "Simplify comparator using Comparator static methods";
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement result;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ComparatorCombinatorsInspection$ReplaceWithComparatorFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/ComparatorCombinatorsInspection$ReplaceWithComparatorFix", "applyFix"));
            }
            PsiElement element = descriptor.getStartElement();
            if (!(element instanceof PsiLambdaExpression)) {
                return;
            }
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)element;
            PsiParameter[] parameters = lambda2.getParameterList().getParameters();
            if (parameters.length != 2) {
                return;
            }
            PsiExpression body = LambdaUtil.extractSingleExpressionFromBody(lambda2.getBody());
            PsiExpression keyExtractor = null;
            String methodName = null;
            if (body instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCall = (PsiMethodCallExpression)body;
                if (MethodUtils.isCompareToCall(methodCall)) {
                    methodName = "comparing";
                    keyExtractor = methodCall.getMethodExpression().getQualifierExpression();
                    if (keyExtractor instanceof PsiReferenceExpression) {
                        PsiElement keyElement = ((PsiReferenceExpression)keyExtractor).resolve();
                        if (keyElement == parameters[0]) {
                            methodName = "naturalOrder";
                        } else if (keyElement == parameters[1]) {
                            methodName = "reverseOrder";
                        }
                    }
                } else {
                    String className;
                    PsiClass containingClass;
                    PsiMethod method = methodCall.resolveMethod();
                    if (method != null && method.getName().equals("compare") && (containingClass = method.getContainingClass()) != null && (className = containingClass.getQualifiedName()) != null) {
                        PsiExpression[] args = methodCall.getArgumentList().getExpressions();
                        if (args.length != 2) {
                            return;
                        }
                        keyExtractor = args[0];
                        switch (className) {
                            case "java.lang.Long": {
                                methodName = "comparingLong";
                                break;
                            }
                            case "java.lang.Integer": {
                                methodName = "comparingInt";
                                break;
                            }
                            case "java.lang.Double": {
                                methodName = "comparingDouble";
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                    }
                }
            } else if (body instanceof PsiBinaryExpression) {
                PsiBinaryExpression binOp = (PsiBinaryExpression)body;
                if (!binOp.getOperationTokenType().equals(JavaTokenType.MINUS)) {
                    return;
                }
                methodName = "comparingInt";
                keyExtractor = binOp.getLOperand();
            }
            if (methodName == null || keyExtractor == null) {
                return;
            }
            if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
                return;
            }
            String parameterName = parameters[0].getName();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(project);
            if (!methodName.startsWith("comparing")) {
                result = lambda2.replace(factory.createExpressionFromText("java.util.Comparator." + methodName + "()", element));
            } else {
                String newLambda = parameterName + " -> " + keyExtractor.getText();
                PsiExpression replacement = factory.createExpressionFromText("java.util.Comparator." + methodName + "(" + newLambda + ")", element);
                result = lambda2.replace(replacement);
                ReplaceWithComparatorFix.normalizeLambda(((PsiMethodCallExpression)result).getArgumentList().getExpressions()[0], factory);
            }
            CodeStyleManager.getInstance(project).reformat(JavaCodeStyleManager.getInstance(project).shortenClassReferences(result));
        }

        private static void normalizeLambda(PsiExpression expression, PsiElementFactory factory) {
            if (!(expression instanceof PsiLambdaExpression)) {
                return;
            }
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)expression;
            PsiParameter[] parameters = lambda2.getParameterList().getParameters();
            PsiElement body = lambda2.getBody();
            if (body == null) {
                return;
            }
            if (LambdaCanBeMethodReferenceInspection.replaceLambdaWithMethodReference(lambda2) == lambda2) {
                String[] names;
                PsiParameter parameter = parameters[0];
                String name = parameter.getName();
                SuggestedNameInfo nameCandidate = null;
                JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(expression.getProject());
                if (name != null) {
                    if (name.length() > 1 && name.endsWith("1")) {
                        nameCandidate = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, name.substring(0, name.length() - 1), null, parameter.getType(), true);
                    } else if (name.equals("first")) {
                        nameCandidate = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, null, parameter.getType(), true);
                    }
                }
                if (nameCandidate != null && (names = codeStyleManager.suggestUniqueVariableName(nameCandidate, (PsiElement)lambda2, (boolean)true).names).length > 0) {
                    String newName = names[0];
                    Collection references = PsiTreeUtil.collectElementsOfType(body, PsiReferenceExpression.class);
                    ((StreamEx)((StreamEx)StreamEx.of(references).filter(ref -> ref.resolve() == parameter)).map(PsiJavaCodeReferenceElement::getReferenceNameElement).nonNull()).forEach(nameElement -> nameElement.replace(factory.createIdentifier(newName)));
                    parameter.setName(newName);
                }
            }
        }
    }
}

