/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.StreamApiUtil;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplifyStreamApiCallChainsInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance("#" + SimplifyStreamApiCallChainsInspection.class.getName());
    private static final String FOR_EACH_METHOD = "forEach";
    private static final String FOR_EACH_ORDERED_METHOD = "forEachOrdered";
    private static final String STREAM_METHOD = "stream";
    private static final String EMPTY_METHOD = "empty";
    private static final String AS_LIST_METHOD = "asList";
    private static final String OF_METHOD = "of";
    private static final String EMPTY_LIST_METHOD = "emptyList";
    private static final String EMPTY_SET_METHOD = "emptySet";
    private static final String SINGLETON_LIST_METHOD = "singletonList";
    private static final String SINGLETON_METHOD = "singleton";
    private static final String COLLECT_METHOD = "collect";
    private static final String IS_PRESENT_METHOD = "isPresent";
    private static final String FIND_ANY_METHOD = "findAny";
    private static final String FIND_FIRST_METHOD = "findFirst";
    private static final String FILTER_METHOD = "filter";
    private static final String ANY_MATCH_METHOD = "anyMatch";
    private static final String NONE_MATCH_METHOD = "noneMatch";
    private static final String ALL_MATCH_METHOD = "allMatch";
    private static final String TO_ARRAY_METHOD = "toArray";
    private static final String COUNTING_COLLECTOR = "counting";
    private static final String TO_LIST_COLLECTOR = "toList";
    private static final String TO_SET_COLLECTOR = "toSet";
    private static final String TO_COLLECTION_COLLECTOR = "toCollection";
    private static final String MIN_BY_COLLECTOR = "minBy";
    private static final String MAX_BY_COLLECTOR = "maxBy";
    private static final String MAPPING_COLLECTOR = "mapping";
    private static final String REDUCING_COLLECTOR = "reducing";
    private static final String SUMMING_INT_COLLECTOR = "summingInt";
    private static final String SUMMING_LONG_COLLECTOR = "summingLong";
    private static final String SUMMING_DOUBLE_COLLECTOR = "summingDouble";

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "buildVisitor"));
        }
        if (!PsiUtil.isLanguageLevel8OrHigher(holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitMethodCallExpression(PsiMethodCallExpression methodCall) {
                PsiMethod method = methodCall.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiClass psiClass = method.getContainingClass();
                if (psiClass == null) {
                    return;
                }
                if (SimplifyStreamApiCallChainsInspection.isCallOf(method, "java.util.Collection", SimplifyStreamApiCallChainsInspection.STREAM_METHOD, 0)) {
                    this.handleCollectionStream(methodCall);
                } else if (SimplifyStreamApiCallChainsInspection.isCallOf(method, "java.util.stream.Stream", SimplifyStreamApiCallChainsInspection.COLLECT_METHOD, 1)) {
                    this.handleStreamCollect(methodCall);
                } else if (SimplifyStreamApiCallChainsInspection.isCallOf(method, "java.util.Optional", SimplifyStreamApiCallChainsInspection.IS_PRESENT_METHOD, 0)) {
                    this.handleOptionalIsPresent(methodCall);
                } else if (SimplifyStreamApiCallChainsInspection.isStreamCall(method, SimplifyStreamApiCallChainsInspection.TO_ARRAY_METHOD, false)) {
                    this.handleToArray(methodCall);
                } else if (SimplifyStreamApiCallChainsInspection.isStreamCall(method, SimplifyStreamApiCallChainsInspection.ANY_MATCH_METHOD, true)) {
                    if (SimplifyStreamApiCallChainsInspection.isParentNegated(methodCall)) {
                        boolean argNegated = SimplifyStreamApiCallChainsInspection.isArgumentLambdaNegated(methodCall);
                        this.registerMatchFix(methodCall, new SimplifyMatchNegationFix("!" + psiClass.getName() + (argNegated ? ".anyMatch(x -> !(...))" : ".anyMatch(...)"), argNegated ? SimplifyStreamApiCallChainsInspection.ALL_MATCH_METHOD : SimplifyStreamApiCallChainsInspection.NONE_MATCH_METHOD));
                    }
                } else if (SimplifyStreamApiCallChainsInspection.isStreamCall(method, SimplifyStreamApiCallChainsInspection.NONE_MATCH_METHOD, true)) {
                    if (SimplifyStreamApiCallChainsInspection.isParentNegated(methodCall)) {
                        this.registerMatchFix(methodCall, new SimplifyMatchNegationFix("!" + psiClass.getName() + ".noneMatch(...)", SimplifyStreamApiCallChainsInspection.ANY_MATCH_METHOD));
                    }
                    if (SimplifyStreamApiCallChainsInspection.isArgumentLambdaNegated(methodCall)) {
                        this.registerMatchFix(methodCall, new SimplifyMatchNegationFix(psiClass.getName() + ".noneMatch(x -> !(...))", SimplifyStreamApiCallChainsInspection.ALL_MATCH_METHOD));
                    }
                } else if (SimplifyStreamApiCallChainsInspection.isStreamCall(method, SimplifyStreamApiCallChainsInspection.ALL_MATCH_METHOD, true)) {
                    if (SimplifyStreamApiCallChainsInspection.isArgumentLambdaNegated(methodCall)) {
                        boolean parentNegated = SimplifyStreamApiCallChainsInspection.isParentNegated(methodCall);
                        this.registerMatchFix(methodCall, new SimplifyMatchNegationFix((parentNegated ? "!" : "") + psiClass.getName() + ".allMatch(x -> !(...))", parentNegated ? SimplifyStreamApiCallChainsInspection.ANY_MATCH_METHOD : SimplifyStreamApiCallChainsInspection.NONE_MATCH_METHOD));
                    }
                } else {
                    this.handleMapToObj(methodCall);
                    this.handleStreamForEach(methodCall, method);
                }
            }

            private void handleToArray(PsiMethodCallExpression methodCall) {
                PsiArrayType type;
                if (SimplifyStreamApiCallChainsInspection.isCollectionStream(SimplifyStreamApiCallChainsInspection.getQualifierMethodCall(methodCall)) && (type = SimplifyStreamApiCallChainsInspection.getArrayType(methodCall)) != null) {
                    PsiElement nameElement = methodCall.getMethodExpression().getReferenceNameElement();
                    LOG.assertTrue(nameElement != null);
                    String replacement = type.equalsToText("java.lang.Object[]") ? "" : "new " + type.getCanonicalText().replaceFirst("\\[]", "[0]");
                    holder.registerProblem(nameElement, "Can be replaced with collection.toArray()", new SimplifyCallChainFix(new ReplaceWithToArrayFix(replacement)));
                }
            }

            void registerMatchFix(PsiMethodCallExpression methodCall, SimplifyMatchNegationFix fix) {
                PsiElement nameElement = methodCall.getMethodExpression().getReferenceNameElement();
                if (nameElement != null) {
                    holder.registerProblem(nameElement, fix.getMessage(), new SimplifyCallChainFix(fix));
                }
            }

            private void handleMapToObj(PsiMethodCallExpression methodCall) {
                PsiElement nameElement = methodCall.getMethodExpression().getReferenceNameElement();
                if (nameElement == null || !"mapToObj".equals(nameElement.getText())) {
                    return;
                }
                PsiExpression[] args = methodCall.getArgumentList().getExpressions();
                if (args.length != 1) {
                    return;
                }
                PsiType type = StreamApiUtil.getStreamElementType(methodCall.getType());
                if (!(type instanceof PsiClassType)) {
                    return;
                }
                PsiClass targetClass = ((PsiClassType)type).resolve();
                PsiExpression qualifier = methodCall.getMethodExpression().getQualifierExpression();
                if (qualifier == null || !TypeConversionUtil.boxingConversionApplicable(StreamApiUtil.getStreamElementType(qualifier.getType()), type)) {
                    return;
                }
                if (this.isBoxingFunction(args[0], targetClass)) {
                    ReplaceWithBoxedFix fix = new ReplaceWithBoxedFix();
                    holder.registerProblem(nameElement, "Can be replaced with 'boxed'", new SimplifyCallChainFix(fix));
                }
            }

            @Contract(value="null, _ -> false")
            private boolean isBoxingFunction(PsiExpression arg, PsiClass targetClass) {
                PsiMethod method;
                PsiElement target;
                if (arg instanceof PsiMethodReferenceExpression && (target = ((PsiMethodReferenceExpression)arg).resolve()) instanceof PsiMethod && targetClass == (method = (PsiMethod)target).getContainingClass() && (method.isConstructor() || method.getName().equals("valueOf")) && method.getParameterList().getParametersCount() == 1) {
                    return true;
                }
                if (arg instanceof PsiLambdaExpression) {
                    PsiLambdaExpression lambda2 = (PsiLambdaExpression)arg;
                    PsiParameter[] parameters = lambda2.getParameterList().getParameters();
                    if (parameters.length != 1) {
                        return false;
                    }
                    PsiParameter parameter = parameters[0];
                    PsiExpression expression = PsiUtil.skipParenthesizedExprDown(LambdaUtil.extractSingleExpressionFromBody(lambda2.getBody()));
                    if (ExpressionUtils.isReferenceTo(expression, parameter)) {
                        return true;
                    }
                    if (expression instanceof PsiCallExpression) {
                        PsiMethod method2;
                        PsiJavaCodeReferenceElement ref;
                        PsiExpressionList list = ((PsiCallExpression)expression).getArgumentList();
                        if (list == null) {
                            return false;
                        }
                        PsiExpression[] args = list.getExpressions();
                        if (args.length != 1 || !ExpressionUtils.isReferenceTo(args[0], parameter)) {
                            return false;
                        }
                        if (expression instanceof PsiNewExpression && (ref = ((PsiNewExpression)expression).getClassReference()) != null && ref.isReferenceTo(targetClass)) {
                            return true;
                        }
                        if (expression instanceof PsiMethodCallExpression && (method2 = ((PsiMethodCallExpression)expression).resolveMethod()) != null && method2.getContainingClass() == targetClass && method2.getName().equals("valueOf")) {
                            return true;
                        }
                    }
                }
                return false;
            }

            private void handleOptionalIsPresent(PsiMethodCallExpression methodCall) {
                PsiMethod streamMethod;
                PsiExpression streamQualifier;
                PsiMethod optionalProducer;
                PsiExpression optionalQualifier = methodCall.getMethodExpression().getQualifierExpression();
                if (optionalQualifier instanceof PsiMethodCallExpression && (SimplifyStreamApiCallChainsInspection.isCallOf(optionalProducer = ((PsiMethodCallExpression)optionalQualifier).resolveMethod(), "java.util.stream.Stream", SimplifyStreamApiCallChainsInspection.FIND_FIRST_METHOD, 0) || SimplifyStreamApiCallChainsInspection.isCallOf(optionalProducer, "java.util.stream.Stream", SimplifyStreamApiCallChainsInspection.FIND_ANY_METHOD, 0)) && (streamQualifier = ((PsiMethodCallExpression)optionalQualifier).getMethodExpression().getQualifierExpression()) instanceof PsiMethodCallExpression && SimplifyStreamApiCallChainsInspection.isCallOf(streamMethod = ((PsiMethodCallExpression)streamQualifier).resolveMethod(), "java.util.stream.Stream", SimplifyStreamApiCallChainsInspection.FILTER_METHOD, 1)) {
                    ReplaceOptionalIsPresentChainFix fix = new ReplaceOptionalIsPresentChainFix(optionalProducer.getName());
                    holder.registerProblem((PsiElement)methodCall, SimplifyStreamApiCallChainsInspection.getCallChainRange(methodCall, (PsiMethodCallExpression)streamQualifier), fix.getMessage(), new SimplifyCallChainFix(fix));
                }
            }

            private void handleStreamForEach(PsiMethodCallExpression methodCall, PsiMethod method) {
                String name;
                if (SimplifyStreamApiCallChainsInspection.isCallOf(method, "java.util.stream.Stream", SimplifyStreamApiCallChainsInspection.FOR_EACH_METHOD, 1)) {
                    name = SimplifyStreamApiCallChainsInspection.FOR_EACH_METHOD;
                } else if (SimplifyStreamApiCallChainsInspection.isCallOf(method, "java.util.stream.Stream", SimplifyStreamApiCallChainsInspection.FOR_EACH_ORDERED_METHOD, 1)) {
                    name = SimplifyStreamApiCallChainsInspection.FOR_EACH_ORDERED_METHOD;
                } else {
                    return;
                }
                PsiMethodCallExpression qualifierCall = SimplifyStreamApiCallChainsInspection.getQualifierMethodCall(methodCall);
                if (SimplifyStreamApiCallChainsInspection.isCollectionStream(qualifierCall)) {
                    ReplaceStreamMethodFix fix = new ReplaceStreamMethodFix(name, SimplifyStreamApiCallChainsInspection.FOR_EACH_METHOD, true);
                    holder.registerProblem((PsiElement)methodCall, SimplifyStreamApiCallChainsInspection.getCallChainRange(methodCall, qualifierCall), fix.getMessage(), new SimplifyCallChainFix(fix));
                }
            }

            private void handleStreamCollect(PsiMethodCallExpression methodCall) {
                PsiExpression parameter = methodCall.getArgumentList().getExpressions()[0];
                if (parameter instanceof PsiMethodCallExpression) {
                    ReplaceCollectorFix fix;
                    PsiMethodCallExpression collectorCall = (PsiMethodCallExpression)parameter;
                    PsiMethod collectorMethod = collectorCall.resolveMethod();
                    if (SimplifyStreamApiCallChainsInspection.isCallOf(collectorMethod, "java.util.stream.Collectors", SimplifyStreamApiCallChainsInspection.COUNTING_COLLECTOR, 0)) {
                        fix = new ReplaceCollectorFix(SimplifyStreamApiCallChainsInspection.COUNTING_COLLECTOR, "count()", false);
                    } else if (SimplifyStreamApiCallChainsInspection.isCallOf(collectorMethod, "java.util.stream.Collectors", SimplifyStreamApiCallChainsInspection.MIN_BY_COLLECTOR, 1)) {
                        fix = new ReplaceCollectorFix(SimplifyStreamApiCallChainsInspection.MIN_BY_COLLECTOR, "min({0})", true);
                    } else if (SimplifyStreamApiCallChainsInspection.isCallOf(collectorMethod, "java.util.stream.Collectors", SimplifyStreamApiCallChainsInspection.MAX_BY_COLLECTOR, 1)) {
                        fix = new ReplaceCollectorFix(SimplifyStreamApiCallChainsInspection.MAX_BY_COLLECTOR, "max({0})", true);
                    } else if (SimplifyStreamApiCallChainsInspection.isCallOf(collectorMethod, "java.util.stream.Collectors", SimplifyStreamApiCallChainsInspection.MAPPING_COLLECTOR, 2)) {
                        fix = new ReplaceCollectorFix(SimplifyStreamApiCallChainsInspection.MAPPING_COLLECTOR, "map({0}).collect({1})", false);
                    } else if (SimplifyStreamApiCallChainsInspection.isCallOf(collectorMethod, "java.util.stream.Collectors", SimplifyStreamApiCallChainsInspection.REDUCING_COLLECTOR, 1)) {
                        fix = new ReplaceCollectorFix(SimplifyStreamApiCallChainsInspection.REDUCING_COLLECTOR, "reduce({0})", true);
                    } else if (SimplifyStreamApiCallChainsInspection.isCallOf(collectorMethod, "java.util.stream.Collectors", SimplifyStreamApiCallChainsInspection.REDUCING_COLLECTOR, 2)) {
                        fix = new ReplaceCollectorFix(SimplifyStreamApiCallChainsInspection.REDUCING_COLLECTOR, "reduce({0}, {1})", false);
                    } else if (SimplifyStreamApiCallChainsInspection.isCallOf(collectorMethod, "java.util.stream.Collectors", SimplifyStreamApiCallChainsInspection.REDUCING_COLLECTOR, 3)) {
                        fix = new ReplaceCollectorFix(SimplifyStreamApiCallChainsInspection.REDUCING_COLLECTOR, "map({1}).reduce({0}, {2})", false);
                    } else if (SimplifyStreamApiCallChainsInspection.isCallOf(collectorMethod, "java.util.stream.Collectors", SimplifyStreamApiCallChainsInspection.SUMMING_INT_COLLECTOR, 1)) {
                        fix = new ReplaceCollectorFix(SimplifyStreamApiCallChainsInspection.SUMMING_INT_COLLECTOR, "mapToInt({0}).sum()", false);
                    } else if (SimplifyStreamApiCallChainsInspection.isCallOf(collectorMethod, "java.util.stream.Collectors", SimplifyStreamApiCallChainsInspection.SUMMING_LONG_COLLECTOR, 1)) {
                        fix = new ReplaceCollectorFix(SimplifyStreamApiCallChainsInspection.SUMMING_LONG_COLLECTOR, "mapToLong({0}).sum()", false);
                    } else if (SimplifyStreamApiCallChainsInspection.isCallOf(collectorMethod, "java.util.stream.Collectors", SimplifyStreamApiCallChainsInspection.SUMMING_DOUBLE_COLLECTOR, 1)) {
                        fix = new ReplaceCollectorFix(SimplifyStreamApiCallChainsInspection.SUMMING_DOUBLE_COLLECTOR, "mapToDouble({0}).sum()", false);
                    } else {
                        PsiElement startElement;
                        PsiMethodCallExpression qualifier;
                        String replacement;
                        if (!(PsiUtil.resolveClassInClassTypeOnly(methodCall.getType()) instanceof PsiTypeParameter) && (replacement = SimplifyStreamApiCallChainsInspection.collectorToCollection(collectorCall)) != null && SimplifyStreamApiCallChainsInspection.isCollectionStream(qualifier = SimplifyStreamApiCallChainsInspection.getQualifierMethodCall(methodCall)) && (startElement = qualifier.getMethodExpression().getReferenceNameElement()) != null) {
                            holder.registerProblem((PsiElement)methodCall, new TextRange(startElement.getTextOffset() - methodCall.getTextOffset(), methodCall.getTextLength()), "Can be replaced with '" + replacement + "' constructor", new SimplifyCallChainFix(new SimplifyCollectionCreationFix(replacement)));
                        }
                        return;
                    }
                    if (collectorCall.getArgumentList().getExpressions().length == collectorMethod.getParameterList().getParametersCount()) {
                        TextRange range = methodCall.getTextRange();
                        PsiElement nameElement = methodCall.getMethodExpression().getReferenceNameElement();
                        if (nameElement != null) {
                            range = new TextRange(nameElement.getTextOffset(), range.getEndOffset());
                        }
                        holder.registerProblem((PsiElement)methodCall, range.shiftRight(-methodCall.getTextOffset()), fix.getMessage(), new SimplifyCallChainFix(fix));
                    }
                }
            }

            private void handleCollectionStream(PsiMethodCallExpression methodCall) {
                ReplaceCollectionStreamFix fix = SimplifyStreamApiCallChainsInspection.findCollectionStreamFix(methodCall);
                if (fix != null) {
                    holder.registerProblem((PsiElement)methodCall, null, fix.getMessage(), new SimplifyCallChainFix(fix));
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    @Nullable
    private static ReplaceCollectionStreamFix findCollectionStreamFix(PsiMethodCallExpression methodCall) {
        PsiMethodCallExpression qualifierCall = SimplifyStreamApiCallChainsInspection.getQualifierMethodCall(methodCall);
        if (qualifierCall == null) {
            return null;
        }
        PsiMethod qualifier = qualifierCall.resolveMethod();
        if (SimplifyStreamApiCallChainsInspection.isCallOf(qualifier, "java.util.Arrays", AS_LIST_METHOD, 1)) {
            return SimplifyStreamApiCallChainsInspection.hasSingleArrayArgument(qualifierCall) ? new ArraysAsListSingleArrayFix() : new ReplaceWithStreamOfFix("Arrays.asList()");
        }
        if (SimplifyStreamApiCallChainsInspection.isCallOf(qualifier, "java.util.Collections", SINGLETON_LIST_METHOD, 1)) {
            if (!SimplifyStreamApiCallChainsInspection.hasSingleArrayArgument(qualifierCall)) {
                return new ReplaceSingletonWithStreamOfFix("Collections.singletonList()");
            }
        } else if (SimplifyStreamApiCallChainsInspection.isCallOf(qualifier, "java.util.Collections", SINGLETON_METHOD, 1)) {
            if (!SimplifyStreamApiCallChainsInspection.hasSingleArrayArgument(qualifierCall)) {
                return new ReplaceSingletonWithStreamOfFix("Collections.singleton()");
            }
        } else {
            if (SimplifyStreamApiCallChainsInspection.isCallOf(qualifier, "java.util.Collections", EMPTY_LIST_METHOD, 0)) {
                return new ReplaceWithStreamEmptyFix(EMPTY_LIST_METHOD);
            }
            if (SimplifyStreamApiCallChainsInspection.isCallOf(qualifier, "java.util.Collections", EMPTY_SET_METHOD, 0)) {
                return new ReplaceWithStreamEmptyFix(EMPTY_SET_METHOD);
            }
        }
        return null;
    }

    @Contract(value="null -> false")
    private static boolean isCollectionStream(PsiMethodCallExpression qualifierCall) {
        if (qualifierCall == null) {
            return false;
        }
        PsiMethod qualifier = qualifierCall.resolveMethod();
        return SimplifyStreamApiCallChainsInspection.isCallOf(qualifier, "java.util.Collection", STREAM_METHOD, 0);
    }

    public static PsiElement simplifyCollectionStreamCalls(PsiElement element) {
        boolean replaced = true;
        while (replaced) {
            PsiElement[] streamCalls;
            replaced = false;
            for (PsiElement streamCall : streamCalls = PsiTreeUtil.collectElements(element, e -> e instanceof PsiMethodCallExpression && SimplifyStreamApiCallChainsInspection.isCollectionStream((PsiMethodCallExpression)e))) {
                PsiElement replacement;
                ReplaceCollectionStreamFix fix;
                if (!streamCall.isValid() || (fix = SimplifyStreamApiCallChainsInspection.findCollectionStreamFix((PsiMethodCallExpression)streamCall)) == null || (replacement = fix.simplify((PsiMethodCallExpression)streamCall)) == null) continue;
                replaced = true;
                if (element != streamCall) continue;
                element = replacement;
            }
        }
        return element;
    }

    @Nullable
    private static PsiArrayType getArrayType(PsiMethodCallExpression call) {
        PsiType type = call.getType();
        if (!(type instanceof PsiArrayType)) {
            return null;
        }
        PsiArrayType candidate = (PsiArrayType)type;
        PsiExpression[] args = call.getArgumentList().getExpressions();
        if (args.length == 0) {
            return candidate;
        }
        if (args.length != 1) {
            return null;
        }
        PsiExpression supplier = args[0];
        if (supplier instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)supplier;
            PsiTypeElement qualifierType = methodRef.getQualifierType();
            if (methodRef.isConstructor() && qualifierType != null && candidate.isAssignableFrom(qualifierType.getType())) {
                return candidate;
            }
        } else if (supplier instanceof PsiLambdaExpression) {
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)supplier;
            PsiParameter[] parameters = lambda2.getParameterList().getParameters();
            if (parameters.length != 1) {
                return null;
            }
            PsiParameter sizeParameter = parameters[0];
            PsiExpression body = LambdaUtil.extractSingleExpressionFromBody(lambda2.getBody());
            if (body instanceof PsiNewExpression) {
                PsiNewExpression newExpression = (PsiNewExpression)body;
                PsiExpression[] dimensions = newExpression.getArrayDimensions();
                PsiType newExpressionType = newExpression.getType();
                if (dimensions.length != 0 && ExpressionUtils.isReferenceTo(dimensions[0], sizeParameter) && newExpressionType != null && candidate.isAssignableFrom(newExpressionType)) {
                    return candidate;
                }
            }
        }
        return null;
    }

    private static boolean isCollectionConstructor(PsiMethod ctor) {
        if (!ctor.getModifierList().hasExplicitModifier("public")) {
            return false;
        }
        PsiParameterList list = ctor.getParameterList();
        if (list.getParametersCount() != 1) {
            return false;
        }
        PsiParameter parameter = list.getParameters()[0];
        PsiTypeElement typeElement = parameter.getTypeElement();
        if (typeElement == null) {
            return false;
        }
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly(typeElement.getType());
        if (aClass == null) {
            return false;
        }
        return "java.util.Collection".equals(aClass.getQualifiedName());
    }

    @Nullable
    private static String collectorToCollection(PsiMethodCallExpression call) {
        PsiClass aClass;
        PsiMethod ctor;
        PsiElement element;
        PsiMethodReferenceExpression methodRef;
        PsiExpression[] expressions;
        PsiMethod method = call.resolveMethod();
        if (SimplifyStreamApiCallChainsInspection.isCallOf(method, "java.util.stream.Collectors", TO_LIST_COLLECTOR, 0)) {
            return "java.util.ArrayList";
        }
        if (SimplifyStreamApiCallChainsInspection.isCallOf(method, "java.util.stream.Collectors", TO_SET_COLLECTOR, 0)) {
            return "java.util.HashSet";
        }
        if (SimplifyStreamApiCallChainsInspection.isCallOf(method, "java.util.stream.Collectors", TO_COLLECTION_COLLECTOR, 1) && (expressions = call.getArgumentList().getExpressions()).length == 1 && expressions[0] instanceof PsiMethodReferenceExpression && (methodRef = (PsiMethodReferenceExpression)expressions[0]).isConstructor() && (element = methodRef.resolve()) instanceof PsiMethod && (ctor = (PsiMethod)element).getParameterList().getParametersCount() == 0 && (aClass = ctor.getContainingClass()) != null && Stream.of(aClass.getConstructors()).anyMatch(SimplifyStreamApiCallChainsInspection::isCollectionConstructor)) {
            return aClass.getQualifiedName();
        }
        return null;
    }

    static boolean isParentNegated(PsiMethodCallExpression methodCall) {
        PsiElement parent = PsiUtil.skipParenthesizedExprUp(methodCall.getParent());
        return parent instanceof PsiExpression && BoolUtils.isNegation((PsiExpression)parent);
    }

    static boolean isArgumentLambdaNegated(PsiMethodCallExpression methodCall) {
        PsiExpression[] expressions = methodCall.getArgumentList().getExpressions();
        if (expressions.length != 1) {
            return false;
        }
        PsiExpression arg = expressions[0];
        if (!(arg instanceof PsiLambdaExpression)) {
            return false;
        }
        PsiElement body = ((PsiLambdaExpression)arg).getBody();
        return body instanceof PsiExpression && BoolUtils.isNegation((PsiExpression)body);
    }

    static boolean hasSingleArrayArgument(PsiMethodCallExpression qualifierCall) {
        PsiType type;
        PsiExpression[] argumentExpressions = qualifierCall.getArgumentList().getExpressions();
        if (argumentExpressions.length == 1 && (type = argumentExpressions[0].getType()) instanceof PsiArrayType) {
            PsiType[] parameters;
            PsiType methodType = qualifierCall.getType();
            return !(methodType instanceof PsiClassType) || (parameters = ((PsiClassType)methodType).getParameters()).length != 1 || !TypeConversionUtil.isAssignable(parameters[0], type) || TypeConversionUtil.isAssignable(parameters[0], ((PsiArrayType)type).getComponentType());
        }
        return false;
    }

    @Nullable
    static PsiMethodCallExpression getQualifierMethodCall(PsiMethodCallExpression methodCall) {
        PsiExpression qualifierExpression = methodCall.getMethodExpression().getQualifierExpression();
        if (qualifierExpression instanceof PsiMethodCallExpression) {
            return (PsiMethodCallExpression)qualifierExpression;
        }
        return null;
    }

    @NotNull
    protected static TextRange getCallChainRange(@NotNull PsiMethodCallExpression expression, @NotNull PsiMethodCallExpression qualifierExpression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "getCallChainRange"));
        }
        if (qualifierExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierExpression", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "getCallChainRange"));
        }
        PsiReferenceExpression qualifierMethodExpression = qualifierExpression.getMethodExpression();
        PsiElement qualifierNameElement = qualifierMethodExpression.getReferenceNameElement();
        int startOffset = (qualifierNameElement != null ? qualifierNameElement : qualifierMethodExpression).getTextOffset();
        int endOffset = expression.getMethodExpression().getTextRange().getEndOffset();
        TextRange textRange = new TextRange(startOffset, endOffset).shiftRight(-expression.getTextOffset());
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "getCallChainRange"));
        }
        return textRange;
    }

    @Contract(value="null, _, _, _ -> false")
    protected static boolean isCallOf(@Nullable PsiMethod method, @NotNull String className, @NotNull String methodName, int parametersCount) {
        PsiClass containingClass;
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "isCallOf"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "isCallOf"));
        }
        if (method == null) {
            return false;
        }
        return methodName.equals(method.getName()) && method.getParameterList().getParametersCount() == parametersCount && (containingClass = method.getContainingClass()) != null && className.equals(containingClass.getQualifiedName());
    }

    @Contract(value="null, _, _ -> false")
    static boolean isStreamCall(@Nullable PsiMethod method, @NotNull String methodName, boolean checkSingleParameter) {
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "isStreamCall"));
        }
        if (method == null || !methodName.equals(method.getName()) || checkSingleParameter && method.getParameterList().getParametersCount() != 1) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        return containingClass != null && InheritanceUtil.isInheritor(containingClass, "java.util.stream.BaseStream");
    }

    private static class ReplaceWithToArrayFix
    implements CallChainFix {
        private final String myReplacement;

        private ReplaceWithToArrayFix(String replacement) {
            this.myReplacement = replacement;
        }

        @Override
        public String getName() {
            return "Replace 'collection.stream().toArray()' with 'collection.toArray()'";
        }

        @Override
        public void applyFix(@NotNull Project project, PsiElement element) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceWithToArrayFix", "applyFix"));
            }
            PsiMethodCallExpression toArrayCall = PsiTreeUtil.getParentOfType(element, PsiMethodCallExpression.class);
            if (toArrayCall == null) {
                return;
            }
            PsiExpression qualifier = toArrayCall.getMethodExpression().getQualifierExpression();
            if (!(qualifier instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression streamCall = (PsiMethodCallExpression)qualifier;
            PsiExpression collectionExpression = streamCall.getMethodExpression().getQualifierExpression();
            if (collectionExpression == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            PsiElement result = ct.replaceAndRestoreComments((PsiElement)toArrayCall, ct.text(collectionExpression) + ".toArray(" + this.myReplacement + ")");
            CodeStyleManager.getInstance(project).reformat(JavaCodeStyleManager.getInstance(project).shortenClassReferences(result));
        }
    }

    private static class ReplaceWithBoxedFix
    implements CallChainFix {
        private ReplaceWithBoxedFix() {
        }

        @Override
        public String getName() {
            return "Replace with 'boxed'";
        }

        @Override
        public void applyFix(@NotNull Project project, PsiElement element) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceWithBoxedFix", "applyFix"));
            }
            if (!(element instanceof PsiIdentifier)) {
                return;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiExpression[] args = ((PsiMethodCallExpression)grandParent).getArgumentList().getExpressions();
            if (args.length != 1) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(project);
            element.replace(factory.createIdentifier("boxed"));
            args[0].delete();
            ((PsiMethodCallExpression)grandParent).getTypeArgumentList().delete();
        }
    }

    private static class SimplifyCollectionCreationFix
    implements CallChainFix {
        private String myReplacement;

        public SimplifyCollectionCreationFix(String replacement) {
            this.myReplacement = replacement;
        }

        @Override
        public String getName() {
            return "Replace with '" + this.myReplacement + "' constructor";
        }

        @Override
        public void applyFix(@NotNull Project project, PsiElement element) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$SimplifyCollectionCreationFix", "applyFix"));
            }
            if (!(element instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression collectCall = (PsiMethodCallExpression)element;
            PsiType type = collectCall.getType();
            PsiClass resolvedType = PsiUtil.resolveClassInClassTypeOnly(type);
            if (resolvedType == null || resolvedType instanceof PsiTypeParameter) {
                return;
            }
            PsiMethodCallExpression streamCall = SimplifyStreamApiCallChainsInspection.getQualifierMethodCall(collectCall);
            if (streamCall == null) {
                return;
            }
            PsiExpression collectionExpression = streamCall.getMethodExpression().getQualifierExpression();
            if (collectionExpression == null) {
                return;
            }
            String typeText = type.getCanonicalText();
            if ("java.util.List".equals(resolvedType.getQualifiedName()) || "java.util.Set".equals(resolvedType.getQualifiedName())) {
                PsiType[] parameters = ((PsiClassType)type).getParameters();
                if (parameters.length != 1) {
                    return;
                }
                typeText = this.myReplacement + "<" + parameters[0].getCanonicalText() + ">";
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(project);
            PsiExpression result = factory.createExpressionFromText("new " + typeText + "(" + collectionExpression.getText() + ")", element);
            PsiNewExpression newExpression = (PsiNewExpression)element.replace(result);
            PsiJavaCodeReferenceElement classReference = newExpression.getClassOrAnonymousClassReference();
            LOG.assertTrue(classReference != null);
            JavaCodeStyleManager.getInstance(project).shortenClassReferences(classReference);
            if (PsiDiamondTypeUtil.canCollapseToDiamond(newExpression, newExpression, null)) {
                PsiDiamondTypeUtil.replaceExplicitWithDiamond(classReference.getParameterList());
            }
            CodeStyleManager.getInstance(project).reformat(newExpression);
        }
    }

    private static class SimplifyMatchNegationFix
    implements CallChainFix {
        private final String myFrom;
        private final String myTo;

        private SimplifyMatchNegationFix(String from, String to) {
            this.myFrom = from;
            this.myTo = to;
        }

        @Override
        public String getName() {
            return "Replace " + this.myFrom + " with " + this.myTo + "(...)";
        }

        public String getMessage() {
            return this.myFrom + " can be replaced with " + this.myTo + "(...)";
        }

        @Override
        public void applyFix(@NotNull Project project, PsiElement element) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$SimplifyMatchNegationFix", "applyFix"));
            }
            if (element instanceof PsiIdentifier) {
                boolean removeParentNegation;
                boolean removeLambdaNegation;
                String from;
                switch (from = element.getText()) {
                    case "allMatch": {
                        removeLambdaNegation = true;
                        removeParentNegation = this.myTo.equals(SimplifyStreamApiCallChainsInspection.ANY_MATCH_METHOD);
                        break;
                    }
                    case "anyMatch": {
                        removeParentNegation = true;
                        removeLambdaNegation = this.myTo.equals(SimplifyStreamApiCallChainsInspection.ALL_MATCH_METHOD);
                        break;
                    }
                    case "noneMatch": {
                        removeParentNegation = this.myTo.equals(SimplifyStreamApiCallChainsInspection.ANY_MATCH_METHOD);
                        removeLambdaNegation = this.myTo.equals(SimplifyStreamApiCallChainsInspection.ALL_MATCH_METHOD);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                PsiMethodCallExpression methodCall = PsiTreeUtil.getParentOfType(element, PsiMethodCallExpression.class);
                if (methodCall == null) {
                    return;
                }
                if (removeParentNegation && !SimplifyStreamApiCallChainsInspection.isParentNegated(methodCall)) {
                    return;
                }
                if (removeLambdaNegation && !SimplifyStreamApiCallChainsInspection.isArgumentLambdaNegated(methodCall)) {
                    return;
                }
                PsiElementFactory factory = JavaPsiFacade.getElementFactory(project);
                element.replace(factory.createIdentifier(this.myTo));
                if (removeLambdaNegation) {
                    PsiExpression body = (PsiExpression)((PsiLambdaExpression)methodCall.getArgumentList().getExpressions()[0]).getBody();
                    PsiExpression negated = BoolUtils.getNegated(body);
                    LOG.assertTrue(negated != null);
                    body.replace(negated);
                }
                if (removeParentNegation) {
                    PsiUtil.skipParenthesizedExprUp(methodCall.getParent()).replace(methodCall);
                }
            }
        }
    }

    private static class ReplaceOptionalIsPresentChainFix
    implements CallChainFix {
        private final String myFindMethodName;

        ReplaceOptionalIsPresentChainFix(String findMethodName) {
            this.myFindMethodName = findMethodName;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = "Replace Stream.filter()." + this.myFindMethodName + "().isPresent() with Stream.anyMatch()";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceOptionalIsPresentChainFix", "getName"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, PsiElement element) {
            PsiMethodCallExpression findCall;
            PsiExpression findQualifier;
            PsiMethodCallExpression isPresentCall;
            PsiExpression isPresentQualifier;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceOptionalIsPresentChainFix", "applyFix"));
            }
            if (element instanceof PsiMethodCallExpression && (isPresentQualifier = (isPresentCall = (PsiMethodCallExpression)element).getMethodExpression().getQualifierExpression()) instanceof PsiMethodCallExpression && (findQualifier = (findCall = (PsiMethodCallExpression)isPresentQualifier).getMethodExpression().getQualifierExpression()) instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression filterCall = (PsiMethodCallExpression)findQualifier;
                PsiElement replacement = element.replace(filterCall);
                PsiElementFactory factory = JavaPsiFacade.getElementFactory(project);
                PsiElement filterName = ((PsiMethodCallExpression)replacement).getMethodExpression().getReferenceNameElement();
                LOG.assertTrue(filterName != null);
                filterName.replace(factory.createIdentifier(SimplifyStreamApiCallChainsInspection.ANY_MATCH_METHOD));
            }
        }

        @NotNull
        public String getMessage() {
            String string = "Stream.filter()." + this.myFindMethodName + "().isPresent() can be replaced with Stream.anyMatch()";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceOptionalIsPresentChainFix", "getMessage"));
            }
            return string;
        }
    }

    private static class ReplaceCollectorFix
    implements CallChainFix {
        private final String myCollector;
        private final String myStreamSequence;
        private final String myStreamSequenceStripped;
        private final boolean myChangeSemantics;

        public ReplaceCollectorFix(String collector, String streamSequence, boolean changeSemantics) {
            this.myCollector = collector;
            this.myStreamSequence = streamSequence;
            this.myStreamSequenceStripped = streamSequence.replaceAll("\\([^)]+\\)", "()");
            this.myChangeSemantics = changeSemantics;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = "Replace Stream.collect(" + this.myCollector + "()) with Stream." + this.myStreamSequenceStripped + (this.myChangeSemantics ? " (may change semantics when result is null)" : "");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectorFix", "getName"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, PsiElement element) {
            PsiExpression parameter;
            PsiMethodCallExpression collectCall;
            PsiExpression qualifierExpression;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectorFix", "applyFix"));
            }
            if (element instanceof PsiMethodCallExpression && (qualifierExpression = (collectCall = (PsiMethodCallExpression)element).getMethodExpression().getQualifierExpression()) != null && (parameter = collectCall.getArgumentList().getExpressions()[0]) instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression collectorCall = (PsiMethodCallExpression)parameter;
                PsiExpression[] collectorArgs = collectorCall.getArgumentList().getExpressions();
                String result = MessageFormat.format(this.myStreamSequence, Arrays.stream(collectorArgs).map(PsiElement::getText).toArray());
                PsiElementFactory factory = JavaPsiFacade.getElementFactory(project);
                PsiExpression replacement = factory.createExpressionFromText(qualifierExpression.getText() + "." + result, collectCall);
                ReplaceCollectorFix.addBoxingIfNecessary(factory, collectCall.replace(replacement));
            }
        }

        private static void addBoxingIfNecessary(PsiElementFactory factory, PsiElement expression) {
            PsiExpression castExpression;
            PsiElement cast;
            PsiClassType boxedType;
            PsiType type;
            if (expression instanceof PsiExpression && (type = ((PsiExpression)expression).getType()) instanceof PsiPrimitiveType && (boxedType = ((PsiPrimitiveType)type).getBoxedType(expression)) != null && (cast = expression.replace(castExpression = factory.createExpressionFromText("(" + boxedType.getCanonicalText() + ") " + expression.getText(), expression))) instanceof PsiTypeCastExpression && RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)cast)) {
                RedundantCastUtil.removeCast((PsiTypeCastExpression)cast);
            }
        }

        @NotNull
        public String getMessage() {
            String string = "Stream.collect(" + this.myCollector + "()) can be replaced with Stream." + this.myStreamSequenceStripped + (this.myChangeSemantics ? " (may change semantics when result is null)" : "");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectorFix", "getMessage"));
            }
            return string;
        }
    }

    static class ReplaceStreamMethodFix
    implements CallChainFix {
        private final String myStreamMethod;
        private final String myCollectionMethod;
        private final boolean myChangeSemantics;

        public ReplaceStreamMethodFix(String streamMethod, String collectionMethod, boolean changeSemantics) {
            this.myStreamMethod = streamMethod;
            this.myCollectionMethod = collectionMethod;
            this.myChangeSemantics = changeSemantics;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = "Replace Collection.stream()." + this.myStreamMethod + "() with Collection." + this.myCollectionMethod + "()" + (this.myChangeSemantics ? " (may change semantics)" : "");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceStreamMethodFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getMessage() {
            String string = "Collection.stream()." + this.myStreamMethod + "() can be replaced with Collection." + this.myCollectionMethod + "()" + (this.myChangeSemantics ? " (may change semantics)" : "");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceStreamMethodFix", "getMessage"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, PsiElement element) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceStreamMethodFix", "applyFix"));
            }
            if (!(element instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression streamMethodCall = (PsiMethodCallExpression)element;
            PsiMethodCallExpression collectionStreamCall = SimplifyStreamApiCallChainsInspection.getQualifierMethodCall(streamMethodCall);
            if (collectionStreamCall == null) {
                return;
            }
            PsiExpression collectionExpression = collectionStreamCall.getMethodExpression().getQualifierExpression();
            if (collectionExpression == null) {
                return;
            }
            collectionStreamCall.replace(collectionExpression);
            if (!this.myStreamMethod.equals(this.myCollectionMethod)) {
                streamMethodCall.getMethodExpression().handleElementRename(this.myCollectionMethod);
            }
        }
    }

    private static class ReplaceWithStreamEmptyFix
    extends ReplaceCollectionStreamFix {
        private ReplaceWithStreamEmptyFix(String qualifierMethodName) {
            super("Collections." + qualifierMethodName + "()", "java.util.stream.Stream", SimplifyStreamApiCallChainsInspection.EMPTY_METHOD);
        }
    }

    private static class ArraysAsListSingleArrayFix
    extends ReplaceCollectionStreamFix {
        private ArraysAsListSingleArrayFix() {
            super("Arrays.asList()", "java.util.Arrays", SimplifyStreamApiCallChainsInspection.STREAM_METHOD);
        }
    }

    private static class ReplaceSingletonWithStreamOfFix
    extends ReplaceWithStreamOfFix {
        private ReplaceSingletonWithStreamOfFix(String qualifierCall) {
            super(qualifierCall);
        }

        @Override
        @Nullable
        protected String getTypeParameter(@NotNull PsiMethodCallExpression qualifierCall) {
            PsiType argType;
            if (qualifierCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierCall", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceSingletonWithStreamOfFix", "getTypeParameter"));
            }
            String typeParameter = super.getTypeParameter(qualifierCall);
            if (typeParameter != null) {
                return typeParameter;
            }
            PsiType[] argTypes = qualifierCall.getArgumentList().getExpressionTypes();
            if (argTypes.length == 1 && (argType = argTypes[0]) instanceof PsiArrayType) {
                return argType.getCanonicalText();
            }
            return null;
        }
    }

    private static class ReplaceWithStreamOfFix
    extends ReplaceCollectionStreamFix {
        private ReplaceWithStreamOfFix(String qualifierCall) {
            super(qualifierCall, "java.util.stream.Stream", SimplifyStreamApiCallChainsInspection.OF_METHOD);
        }
    }

    private static abstract class ReplaceCollectionStreamFix
    implements CallChainFix {
        private final String myClassName;
        private final String myMethodName;
        private final String myQualifierCall;

        private ReplaceCollectionStreamFix(String qualifierCall, String className, String methodName) {
            this.myQualifierCall = qualifierCall;
            this.myClassName = className;
            this.myMethodName = methodName;
        }

        @NotNull
        public String getMessage() {
            String string = this.myQualifierCall + ".stream() can be replaced with " + ClassUtil.extractClassName(this.myClassName) + "." + this.myMethodName + "()";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectionStreamFix", "getMessage"));
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = "Replace " + this.myQualifierCall + ".stream() with " + ClassUtil.extractClassName(this.myClassName) + "." + this.myMethodName + "()";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectionStreamFix", "getName"));
            }
            return string;
        }

        @Nullable
        protected String getTypeParameter(@NotNull PsiMethodCallExpression qualifierCall) {
            if (qualifierCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierCall", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectionStreamFix", "getTypeParameter"));
            }
            PsiType[] parameters = qualifierCall.getMethodExpression().getTypeParameters();
            return parameters.length == 1 ? parameters[0].getCanonicalText() : null;
        }

        @Override
        public void applyFix(@NotNull Project project, PsiElement element) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectionStreamFix", "applyFix"));
            }
            if (!(element instanceof PsiMethodCallExpression)) {
                return;
            }
            this.simplify((PsiMethodCallExpression)element);
        }

        @Nullable
        private PsiElement simplify(PsiMethodCallExpression streamCall) {
            PsiMethodCallExpression collectionCall = SimplifyStreamApiCallChainsInspection.getQualifierMethodCall(streamCall);
            if (collectionCall == null) {
                return null;
            }
            streamCall.getArgumentList().replace(collectionCall.getArgumentList());
            String typeParameter = this.getTypeParameter(collectionCall);
            String replacement = typeParameter != null ? this.myClassName + ".<" + typeParameter + ">" + this.myMethodName : this.myClassName + "." + this.myMethodName;
            Project project = streamCall.getProject();
            PsiExpression newMethodExpression = JavaPsiFacade.getElementFactory(project).createExpressionFromText(replacement, streamCall);
            return JavaCodeStyleManager.getInstance(project).shortenClassReferences(streamCall.getMethodExpression().replace(newMethodExpression));
        }
    }

    private static class SimplifyCallChainFix
    implements LocalQuickFix {
        private final CallChainFix myFix;

        SimplifyCallChainFix(CallChainFix fix) {
            this.myFix = fix;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = this.myFix.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$SimplifyCallChainFix", "getName"));
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Simplify stream call chain" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$SimplifyCallChainFix", "getFamilyName"));
            }
            return "Simplify stream call chain";
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$SimplifyCallChainFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$SimplifyCallChainFix", "applyFix"));
            }
            this.myFix.applyFix(project, descriptor.getStartElement());
        }
    }

    static interface CallChainFix {
        public String getName();

        public void applyFix(@NotNull Project var1, PsiElement var2);
    }
}

