/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.ContractInferenceIndexKt;
import com.intellij.codeInspection.dataFlow.InferenceFromSourceUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.MethodData;
import com.intellij.codeInspection.dataFlow.PreContract;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ContractInference {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.dataFlow.ContractInferenceInterpreter");
    public static final int MAX_CONTRACT_COUNT = 10;

    @NotNull
    public static List<MethodContract> inferContracts(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/ContractInference", "inferContracts"));
        }
        if (!InferenceFromSourceUtil.shouldInferFromSource(method)) {
            List<MethodContract> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInference", "inferContracts"));
            }
            return list;
        }
        List list = (List)CachedValuesManager.getCachedValue(method, () -> {
            MethodData data;
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/ContractInference", "lambda$inferContracts$1"));
            }
            List<Object> preContracts = (data = ContractInferenceIndexKt.getIndexedData(method)) == null ? Collections.emptyList() : data.getContracts();
            List result = RecursionManager.doPreventingRecursion(method, true, () -> {
                if (method == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/ContractInference", "lambda$null$0"));
                }
                return ContractInference.postProcessContracts(method, data, preContracts);
            });
            if (result == null) {
                result = Collections.emptyList();
            }
            return CachedValueProvider.Result.create(result, method, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInference", "inferContracts"));
        }
        return list;
    }

    @NotNull
    private static List<MethodContract> postProcessContracts(@NotNull PsiMethod method, MethodData data, List<PreContract> rawContracts) {
        List<MethodContract> compatible;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/ContractInference", "postProcessContracts"));
        }
        List<MethodContract> contracts2 = ContainerUtil.concat(rawContracts, c -> {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/ContractInference", "lambda$postProcessContracts$2"));
            }
            return c.toContracts(method, data.methodBody(method));
        });
        if (contracts2.isEmpty()) {
            List<MethodContract> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInference", "postProcessContracts"));
            }
            return list;
        }
        PsiType returnType = method.getReturnType();
        if (returnType != null && !(returnType instanceof PsiPrimitiveType)) {
            contracts2 = ContractInference.boxReturnValues(contracts2);
        }
        if ((compatible = ContainerUtil.filter(contracts2, contract -> {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/ContractInference", "lambda$postProcessContracts$3"));
            }
            for (int i2 = 0; i2 < contract.arguments.length; ++i2) {
                if (contract.arguments[i2] != MethodContract.ValueConstraint.NULL_VALUE || !NullableNotNullManager.isNotNull(method.getParameterList().getParameters()[i2])) continue;
                return false;
            }
            if ((contract.returnValue == MethodContract.ValueConstraint.NOT_NULL_VALUE || contract.returnValue == MethodContract.ValueConstraint.NULL_VALUE) && NullableNotNullManager.getInstance(method.getProject()).isNotNull(method, false)) {
                return false;
            }
            return InferenceFromSourceUtil.isReturnTypeCompatible(returnType, contract.returnValue);
        })).size() > 10) {
            LOG.debug("Too many contracts for " + PsiUtil.getMemberQualifiedName(method) + ", shrinking the list");
            List<MethodContract> list = compatible.subList(0, 10);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInference", "postProcessContracts"));
            }
            return list;
        }
        List<MethodContract> list = compatible;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInference", "postProcessContracts"));
        }
        return list;
    }

    @NotNull
    private static List<MethodContract> boxReturnValues(List<MethodContract> contracts2) {
        List<MethodContract> list = ContainerUtil.mapNotNull(contracts2, contract -> {
            if (contract.returnValue == MethodContract.ValueConstraint.FALSE_VALUE || contract.returnValue == MethodContract.ValueConstraint.TRUE_VALUE) {
                return new MethodContract(contract.arguments, MethodContract.ValueConstraint.NOT_NULL_VALUE);
            }
            return contract;
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInference", "boxReturnValues"));
        }
        return list;
    }
}

