/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.instructions.FlushVariableInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiVariable;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ControlFlow {
    private final List<Instruction> myInstructions = new ArrayList<Instruction>();
    private final TObjectIntHashMap<PsiElement> myElementToStartOffsetMap = new TObjectIntHashMap();
    private final TObjectIntHashMap<PsiElement> myElementToEndOffsetMap = new TObjectIntHashMap();
    private final DfaValueFactory myFactory;

    public ControlFlow(DfaValueFactory factory) {
        this.myFactory = factory;
    }

    public Instruction[] getInstructions() {
        return this.myInstructions.toArray(new Instruction[this.myInstructions.size()]);
    }

    public int getInstructionCount() {
        return this.myInstructions.size();
    }

    public ControlFlowOffset getNextOffset() {
        final int currentSize = this.myInstructions.size();
        return new ControlFlowOffset(){

            @Override
            public int getInstructionOffset() {
                return currentSize;
            }
        };
    }

    public void startElement(PsiElement psiElement) {
        this.myElementToStartOffsetMap.put((Object)psiElement, this.myInstructions.size());
    }

    public void finishElement(PsiElement psiElement) {
        this.myElementToEndOffsetMap.put((Object)psiElement, this.myInstructions.size());
    }

    public void addInstruction(Instruction instruction) {
        instruction.setIndex(this.myInstructions.size());
        this.myInstructions.add(instruction);
    }

    public void removeVariable(@Nullable PsiVariable variable) {
        if (variable == null) {
            return;
        }
        this.addInstruction(new FlushVariableInstruction(this.myFactory.getVarFactory().createVariableValue(variable, false)));
    }

    public ControlFlowOffset getStartOffset(final PsiElement element) {
        return new ControlFlowOffset(){

            @Override
            public int getInstructionOffset() {
                return ControlFlow.this.myElementToStartOffsetMap.get((Object)element);
            }

            public String toString() {
                return String.valueOf(ControlFlow.this.myElementToStartOffsetMap.get((Object)element));
            }
        };
    }

    public ControlFlowOffset getEndOffset(final PsiElement element) {
        return new ControlFlowOffset(){

            @Override
            public int getInstructionOffset() {
                return ControlFlow.this.myElementToEndOffsetMap.get((Object)element);
            }

            public String toString() {
                return String.valueOf(ControlFlow.this.myElementToEndOffsetMap.get((Object)element));
            }
        };
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        List<Instruction> instructions = this.myInstructions;
        for (int i2 = 0; i2 < instructions.size(); ++i2) {
            Instruction instruction = instructions.get(i2);
            result.append(Integer.toString(i2)).append(": ").append(instruction.toString());
            result.append("\n");
        }
        return result.toString();
    }

    static ControlFlowOffset deltaOffset(final ControlFlowOffset delegate, final int delta) {
        return new ControlFlowOffset(){

            @Override
            public int getInstructionOffset() {
                return delegate.getInstructionOffset() + delta;
            }
        };
    }

    public static interface ControlFlowOffset {
        public int getInstructionOffset();
    }
}

