/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.core.CoreModuleScopeProvider;
import com.intellij.mock.MockComponentManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.impl.ModulePathMacroManager;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.module.impl.ModuleScopeProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.ModuleFileIndexImpl;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreModule
extends MockComponentManager
implements ModuleEx {
    private final String myPath;
    @NotNull
    private final Disposable myLifetime;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ModuleScopeProvider myModuleScopeProvider;

    public CoreModule(@NotNull Disposable parentDisposable, @NotNull Project project, String moduleFilePath) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/core/CoreModule", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/core/CoreModule", "<init>"));
        }
        super(project.getPicoContainer(), parentDisposable);
        this.myLifetime = parentDisposable;
        this.myProject = project;
        this.myPath = moduleFilePath;
        Extensions.instantiateArea("IDEA_MODULE", this, null);
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                Extensions.disposeArea(CoreModule.this);
            }
        });
        this.initModuleExtensions();
        ModuleRootManagerImpl moduleRootManager = new ModuleRootManagerImpl(this, ProjectRootManagerImpl.getInstanceImpl(project), VirtualFilePointerManager.getInstance()){

            @Override
            public void loadState(ModuleRootManagerImpl.ModuleRootManagerState object) {
                this.loadState(object, false);
            }
        };
        Disposer.register(parentDisposable, moduleRootManager);
        this.getPicoContainer().registerComponentInstance(ModuleRootManager.class, (Object)moduleRootManager);
        this.getPicoContainer().registerComponentInstance(PathMacroManager.class, (Object)this.createModulePathMacroManager(project));
        this.getPicoContainer().registerComponentInstance(ModuleFileIndex.class, (Object)this.createModuleFileIndex(project));
        this.myModuleScopeProvider = this.createModuleScopeProvider();
    }

    protected void initModuleExtensions() {
    }

    protected <T> void addModuleExtension(ExtensionPointName<T> name, final T extension) {
        final ExtensionPoint<T> extensionPoint = Extensions.getArea(this).getExtensionPoint(name);
        extensionPoint.registerExtension(extension);
        Disposer.register(this.myLifetime, new Disposable(){

            @Override
            public void dispose() {
                extensionPoint.unregisterExtension(extension);
            }
        });
    }

    protected ModuleScopeProvider createModuleScopeProvider() {
        return new CoreModuleScopeProvider();
    }

    protected PathMacroManager createModulePathMacroManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/core/CoreModule", "createModulePathMacroManager"));
        }
        return new ModulePathMacroManager(PathMacros.getInstance(), this);
    }

    protected ModuleFileIndex createModuleFileIndex(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/core/CoreModule", "createModuleFileIndex"));
        }
        return new ModuleFileIndexImpl(this, DirectoryIndex.getInstance(project));
    }

    @Override
    public void init(@NotNull String path, @Nullable Runnable beforeComponentCreation) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/core/CoreModule", "init"));
        }
    }

    @Override
    public void moduleAdded() {
    }

    @Override
    public void projectOpened() {
    }

    @Override
    public void projectClosed() {
    }

    @Override
    public void rename(String newName) {
    }

    @Override
    public void clearScopesCache() {
        this.myModuleScopeProvider.clearCache();
    }

    @Override
    public VirtualFile getModuleFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public String getModuleFilePath() {
        String string = this.myPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreModule", "getModuleFilePath"));
        }
        return string;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreModule", "getProject"));
        }
        return project;
    }

    @Override
    @NotNull
    public String getName() {
        String string = StringUtil.trimEnd(PathUtil.getFileName(this.myPath), ".iml");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreModule", "getName"));
        }
        return string;
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public void setOption(@NotNull String optionName, @NotNull String optionValue) {
        if (optionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionName", "com/intellij/core/CoreModule", "setOption"));
        }
        if (optionValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionValue", "com/intellij/core/CoreModule", "setOption"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearOption(@NotNull String optionName) {
        if (optionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionName", "com/intellij/core/CoreModule", "clearOption"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public String getOptionValue(@NotNull String optionName) {
        if (optionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionName", "com/intellij/core/CoreModule", "getOptionValue"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreModule", "getModuleScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleScope(boolean includeTests) {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleScope(includeTests);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreModule", "getModuleScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleWithLibrariesScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleWithLibrariesScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreModule", "getModuleWithLibrariesScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleWithDependenciesScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleWithDependenciesScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreModule", "getModuleWithDependenciesScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleContentScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleContentScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreModule", "getModuleContentScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleContentWithDependenciesScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleContentWithDependenciesScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreModule", "getModuleContentWithDependenciesScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleWithDependenciesAndLibrariesScope(boolean includeTests) {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleWithDependenciesAndLibrariesScope(includeTests);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreModule", "getModuleWithDependenciesAndLibrariesScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleWithDependentsScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleWithDependentsScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreModule", "getModuleWithDependentsScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleTestsWithDependentsScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleTestsWithDependentsScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreModule", "getModuleTestsWithDependentsScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleRuntimeScope(boolean includeTests) {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleRuntimeScope(includeTests);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreModule", "getModuleRuntimeScope"));
        }
        return globalSearchScope;
    }
}

